/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

#ifdef	PROTO_OSPF


/******************************************************************************
 *
 *				MIB SUPPORT ROUTINES
 *
 ******************************************************************************/

/*
 * Compare LSAs
 */
int
ls_cmp(dbA,dbB)
struct LSDB **dbA, **dbB;
{
	if (ntohl((*dbA)->key[0]) < ntohl((*dbB)->key[0]))
		return(-1);
	if (ntohl((*dbA)->key[0]) > ntohl((*dbB)->key[0]))
		return(1);
	if (ntohl((*dbA)->key[1]) < ntohl((*dbB)->key[1]))
		return(-1);
	if (ntohl((*dbA)->key[1]) > ntohl((*dbB)->key[1]))
		return(1);
	return(0);
}


/*
 * Compare interfaces
 */
int
intf_cmp(ifA,ifB)
struct IF_SB *ifA, *ifB;
{
    if ( (ntohl(ifA->addr)) < (ntohl(ifB->addr)) )
	return(-1);
    if ( (ntohl(ifA->addr)) > (ntohl(ifB->addr)) )
	return(1);
    return( 0 );
}

/*
 * Compare Virtual links
 */
int
virt_intf_cmp(ifA,ifB)
struct IF_SB *ifA, *ifB;
{
	if (ntohl((ifA)->area_id) < ntohl((ifB)->area_id))
		return(-1);
	if (ntohl((ifA)->area_id) > ntohl((ifB)->area_id))
		return(1);
	if (ntohl((ifA)->addr) < ntohl((ifB)->addr))
		return(-1);
	if (ntohl((ifA)->addr) > ntohl((ifB)->addr))
		return(1);
	return(0);
}

/*
 * Compare neighbor entries
 */
int
nbr_cmp(nbrA,nbrB)
struct NBR **nbrA, **nbrB;
{
    if ( (ntohl((*nbrA)->nbrip_addr)) < (ntohl((*nbrB)->nbrip_addr)) )
	return(-1);
    if ( (ntohl((*nbrA)->nbrip_addr)) > (ntohl((*nbrB)->nbrip_addr)) )
	return(1);
    return( 0 );
}


/*
 * General sorting routines for MIB sorts
 */
void
heap_restore(heap,first,last,compar,temp,width)
char *heap;
int first,last,width;
int (*compar)();
char *temp;
{
    int i, j;

    i = first;
    while (i <= (last/2)) 
    {
	/* find greatest child */
	if ( ((2 * i) < last) && 
	     (compar(&heap[((2 * i) - 1) * width],
		     &heap[(2 * i) * width]) < 0) )
	    j = (2 * i) + 1;
	else 
	    j = 2 * i;

	/* heap[j -1] is the larger son */
	if (compar(&heap[(i-1) * width],
		   &heap[(j-1) * width]) < 0)
	{ 
	    /* the ol' swapola */
	    B_COPY(&heap[(i-1) * width],temp,width);
	    B_COPY(&heap[(j-1) * width],&heap[(i-1) * width],width);
	    B_COPY(temp,&heap[(j-1) * width],width);
	    i = j;
	}
            else i = last;
    }
}
 

/*
 * Heapsort for MIB
 */
void
heapsort(heap,nel,width,compar)
char *heap;
int nel, width;
int (*compar)();
{
	int i;
 	char temp[200];

 	/* build heap */
 	for(i=(nel/2);i>=1;i--)
		heap_restore(heap,i,nel,compar,temp,width);

 	for(i=nel;i>1;i--) { /* swap */
         	B_COPY(&heap[(i-1) * width],temp,width);
         	B_COPY(heap,&heap[(i-1) * width],width);
         	B_COPY(temp,heap,width);
         	heap_restore(heap,1,i-1,compar,temp,width);
         }
	 /*
	 ZAP(temp,OMEM_TMP);
	 */
}

/*
 * Binary search for get nexts
 */
int
bsrch(list,nel,elt,width,compar)
char *list;
int nel;
char *elt;
int width;
int (*compar)();
{
	int mid, first = 0, last = nel - 1;
	int cmp;


	for( (mid = ((first + last) / 2));
	     ((cmp = compar(elt,&list[mid * width])) != 0) && (first <= last);
	     (mid = ((first + last) / 2)) )
	{
	    if (cmp < 0)
		last = mid-1;
	    else
		first = mid+1;
	}
	if (!compar(elt,&list[mid * width]))
		return(mid);
	return(nel+1);
}


/*
 * Get next area in lexical order
 */
int
get_next_area_ptr(area)
struct AREA **area;
{
	struct AREA *newA, *tmpA = AREANULL;

	if (!*area) {
		*area = FirstArea;
		return(TRUE);
	} 

	for( newA = FirstArea; newA < &ospf.area[ospf.acnt]; newA++ )
	    if (ntohl(newA->area_id) > ntohl(*area)->area_id)
	    {
		tmpA = newA;
		break;
	    }

	if (!tmpA)
	    return(FALSE);

	for( newA = FirstArea; newA < &ospf.area[ospf.acnt]; newA++ )
	    if ( (ntohl(newA->area_id) > ntohl(*area)->area_id) &&
	    	 (ntohl(newA->area_id) < ntohl(tmpA)->area_id) )
		tmpA = newA;

	(*area) = tmpA;

	return(TRUE);
}

int
locate_this_area(area_id,area)
u_long32 area_id;
struct AREA **area;
{

	for(*area = FirstArea;*area < &ospf.area[ospf.acnt];(*area)++)
		if ((area_id) == ntohl((*area)->area_id))
			return(TRUE);

	return(FALSE);
}

/*
 * locate next area in lexical order
 */
int
locate_next_area(area_id,area)
u_long32 area_id;
struct AREA **area;
{
	struct AREA *tmpA = AREANULL, *newA = AREANULL;

	if (!locate_this_area(area_id,area))
		return(FALSE);

	for(tmpA = FirstArea;tmpA < &ospf.area[ospf.acnt];tmpA++)
		if (ntohl(tmpA->area_id) > ntohl(area_id)) {
		    if (!newA)
			newA = tmpA;
		    else if (ntohl(newA->area_id) > ntohl(tmpA->area_id))
			newA = tmpA;
		}
	if ((*area = newA) == AREANULL)
	    return(FALSE);
	return(TRUE);
}

/*
 * Determine the maximum size of the LSDB sort block and allocate
 * a new block if one is needed
 */
void
get_sb()
{
	struct AREA *a;
	int size = MaxSortBufSize;
	int type;

    	for (a = FirstArea; a < &ospf.area[ospf.acnt]; a++) {
	    for (type = LS_STUB; type < LS_ASE; type++)
    		size = (a->db_cnts[type] > size) ? a->db_cnts[type] : size;
	}
    	size = (ospf.db_ase_cnt > size) ? ospf.db_ase_cnt : size;

	if (!ospf.ls_sb) {
		ospf.sb_size = size;
		LS_SB_ALLOC(ospf.ls_sb,size);
	} else if (size  > ospf.sb_size) {
		ospf.sb_size = size;
		MORE_LS_SB_ALLOC(ospf.ls_sb,size);
	}
}



/*
 * This doesn't deal with unnumbered ptop links
 */
int
locate_intf(action,intf,ifipaddr)
int action;
struct INTF **intf;
u_long32 ifipaddr;
{
    int i,ndx;
    struct IF_SB tmp; 
    struct IF_SB *tmp_p = &tmp;

    tmp.addr = ifipaddr;

    if (!ospf.if_sb) {
	ospf.if_sb_nel = 0;
	IF_SB_ALLOC(ospf.if_sb,ospf.nintf);
	if (!ospf.if_sb)
		return(FALSE);
	for(i = 0;i < ospf.nintf;i++) {
	    if (NDX_IP_ADDR(i)) {
		ospf.if_sb[i].intf = &ifspfIF(i);
		ospf.if_sb[i].addr = NDX_IP_ADDR(i);
		ospf.if_sb_nel++;
	    }
	}
	if (!ospf.if_sb_nel)
	    return(FALSE);
	if (ospf.if_sb_nel > 1)
	    heapsort(ospf.if_sb,ospf.if_sb_nel,sizeof(struct IF_SB),intf_cmp);
    }

    if (action == GET_FIRST) {
	*intf = ospf.if_sb[0].intf;
	return(TRUE);
    }
    if (ospf.if_sb_nel > 1)
    	ndx = 
	  bsrch(ospf.if_sb,ospf.if_sb_nel,tmp_p,sizeof(struct IF_SB),intf_cmp);
    else ndx = 0;

    if (ndx > ospf.if_sb_nel)
	return(FALSE);

    switch(action) {
	case GET_THIS:
	    *intf = ospf.if_sb[ndx].intf;
	    return(TRUE);

	case GET_NEXT:
	    if (++ndx == ospf.if_sb_nel)
		return(FALSE);
	    *intf = ospf.if_sb[ndx].intf;
	    return(TRUE);
    }
}

int
locate_virt_intf(action,intf,area_id,nbr_addr)
int action;
struct INTF **intf;
u_long32 nbr_addr, area_id;
{
    int i,ndx;
    struct IF_SB tmp; 
    struct IF_SB *tmp_p = &tmp; 

    tmp.addr = nbr_addr;
    tmp.area_id = area_id;

    if (!ospf.virt_if_sb) {
	ospf.virt_if_sb_nel = 0;
	IF_SB_ALLOC(ospf.virt_if_sb,ospf.vcnt);
	if (!ospf.virt_if_sb)
		return(FALSE);
	for(i = 0;i < ospf.vcnt;i++) {
		ospf.virt_if_sb[i].intf = &ospf.vl[i];
		ospf.virt_if_sb[i].addr = ospf.vl[i].nbr.nbr_id;
		ospf.virt_if_sb[i].area_id = 
			ospf.area[ospf.vl[i].transarea].area_id;
		ospf.virt_if_sb_nel++;
	}
	if (!ospf.virt_if_sb_nel)
	    return(FALSE);

	if (ospf.virt_if_sb_nel > 1)
		heapsort(ospf.virt_if_sb,
		 	 ospf.virt_if_sb_nel,
		 	 sizeof(struct IF_SB),
		 	 virt_intf_cmp);
    }

    if (action == GET_FIRST) {
	*intf = ospf.virt_if_sb[0].intf;
	return(TRUE);
    }

    if (ospf.virt_if_sb_nel > 1)
    	ndx = bsrch(ospf.virt_if_sb,
	    	    ospf.virt_if_sb_nel,
		    tmp_p,
		    sizeof(struct IF_SB),
		    virt_intf_cmp);
    else ndx = 0;

    if (ndx > ospf.virt_if_sb_nel)
	return(FALSE);

    switch(action) {
	case GET_THIS:
	    *intf = ospf.virt_if_sb[ndx].intf;
	    return(TRUE);

	case GET_NEXT:
	    if (++ndx == ospf.virt_if_sb_nel)
		return(FALSE);
	    *intf = ospf.virt_if_sb[ndx].intf;
	    return(TRUE);
    }
}

int 
locate_host_entry(h_addr,ohost,action)
u_long32 h_addr;
struct OSPF_HOSTS **ohost;
int	action;
{
    struct AREA *area = AREANULL;
    int next_one = FALSE;

    while(get_next_area_ptr(&area))
    {
	if (area->hostcnt) {
	    *ohost = area->hosts.ptr[NEXT];
	    if (action == GET_FIRST && area->hostcnt)
		return(TRUE);

	    if ((next_one) && (*ohost))
		return(TRUE);

	    while(*ohost) {
		if (h_addr == ntohl((*ohost)->if_addr)) {
		    if (action == GET_THIS)
			return(TRUE);
		    else next_one = TRUE;
		}
		*ohost = (*ohost)->ptr[NEXT];

	    	if ((next_one) && (*ohost))
		    return(TRUE);
	    }
	}
    }
    return(FALSE);
}


/******************************************************************************
 *
 *				MIB ACCESS ROUTINES
 *
 ******************************************************************************/

int
get_ospf_general(action,mp)
int action;
struct OspfGeneralGroup **mp;
{
    if (action == GET_NEXT)
	return(FALSE);

    (*mp)->ospfRouterId = MY_ID;
    (*mp)->ospfAdminStat = MIB_VALID;
    (*mp)->ospfVersionNumber = OSPF_VERSION;
    (*mp)->ospfAreaBdrRtrStatus = (IAmBorderRtr) ? MIB_ENABLED : MIB_DISABLED;
    (*mp)->ospfASBdrRtrStatus = (IAmASBorderRtr) ? MIB_ENABLED : MIB_DISABLED;
    (*mp)->ospfExternLSACount = ospf.db_ase_cnt;
    (*mp)->ospfExternLSACksumSum = ospf.db_chksumsum;
    (*mp)->ospfTOSSupport = 0;
    (*mp)->ospfOriginateNewLsa = ospf.orig_new_lsa;
    (*mp)->ospfRxNewLSA = ospf.rx_new_lsa;
    return(TRUE);
}

int
get_area_entry(action,mp)
int action;
struct OspfAreaEntry **mp;
{
    u_long32 area_id = (*mp)->ospfAreaId;
    struct AREA *area;

    switch(action) {
	case GET_FIRST:
		area = FirstArea;
		break;

	case GET_THIS:
		if (!locate_this_area(area_id,&area))
			return(FALSE);
		break;

	case GET_NEXT:
		if (!locate_next_area(area_id,&area))
			return(FALSE);
		break;
    }

    (*mp)->ospfAreaId = area->area_id;
    (*mp)->ospfAuthType = area->authtype;
    (*mp)->ospfImportASExtern = 
	(area->ext_option == EXT_OPT_NORMAL) ? MIB_TRUE : MIB_FALSE;
    (*mp)->ospfSpfRuns = area->spfcnt;
    (*mp)->ospfAreaBdrRtrCount = area->abr_cnt;
    (*mp)->ospfASBdrRtrCount = area->asbr_cnt;
    (*mp)->ospfLSACount = area->db_int_cnt;
    (*mp)->ospfAreaLSACksumSum = area->db_chksumsum;
    return(TRUE);
}

int
get_stub_metric(action,mp)
int action;
struct OspfStubAreaEntry **mp;
{
    u_long32 area_id = (*mp)->ospfStubAreaID;
    struct AREA *area;

    if ((*mp)->ospfStubTOS)
	return(FALSE);

    switch(action) {
	case GET_FIRST:
		area = FirstArea;
		break;

	case GET_THIS:
		if (!locate_this_area(area_id,&area))
			return(FALSE);
		break;

	case GET_NEXT:
		if (!locate_next_area(area_id,&area))
			return(FALSE);
		break;
    }

    /* MODIFIED 11/22 */
    (*mp)->ospfStubAreaID = area->area_id;
    if (area->ext_option == EXT_OPT_NORMAL) {
	(*mp)->ospfStubMetric = area->dflt_metric;
	(*mp)->ospfStubStatus = MIB_VALID;
	return(TRUE);
    } else if (area->ext_option == EXT_OPT_STUB) {
	(*mp)->ospfStubMetric = -1;
	(*mp)->ospfStubStatus = MIB_VALID;
	return(TRUE);
    }
    return(FALSE);
}

int
get_lsdb_entry(action,mp)
int action;
struct	OspfLsdbEntry **mp;
{
    struct AREA *a, *area = AREANULL;
    struct LSDB *db, *hp, **sb, tmp, *res = LSDBNULL;
    struct LSDB *tmp_p = &tmp;
    time_t sec = ospf_get_time();	/* for correct current age */
    int ndx = 0;
    int type = (*mp)->ospfLsdbType;
    u_long32 area_id = (*mp)->ospfLsdbAreaId;
    u_long32 ls_id = (*mp)->ospfLsdbLSID;
    u_long32 adv_rtr = (*mp)->ospfLsdbRouterId;

    if (action != GET_FIRST && (type < 1 || type > 5))
	return(FALSE);


    if (action == GET_FIRST)
    {
    	area = FirstArea;
	type = LS_RTR;
    } else if (!locate_this_area(area_id,&area))
	return(FALSE);

    try_again:
    /*
     * Check sort buf to see if we have the LSDB partition already
     */
    if ( (!ospf.ls_sb) ||
	 (action == GET_FIRST) ||
	 (ospf.sb_area_ndx != area->area_ndx) ||
    	 (ospf.sb_ls_type != type) ||
    	 (ospf.sb_not_valid) )
    {
	/* 
	 * get whatever is next 
	 */
	while (TRUE) {
	    if (type == LS_ASE) {
		if (!ospf.db_ase_cnt)
		    return(FALSE);
		area = FirstArea;
		break;
	    }

	    if (area->db_cnts[type]) {
		break;
	    } else {
		if (type == LS_SUM_ASB) {
		    /* if there isn't a next area next type is ASE */
		    if (get_next_area_ptr(&area))
			type = LS_RTR;
		    else type = LS_ASE;
		} else {
		    type++;
		}
	    }
	}

    	get_sb();
	if (!ospf.ls_sb) {
		return;
	}
	sb = ospf.ls_sb;
	ospf.sb_not_valid = FALSE;
    	ospf.sb_nel = 0;
	ospf.sb_area_ndx = area->area_ndx;
	ospf.sb_ls_type = type;

	/* 
	 * load up sort buf 
	 */
	for (hp = area->htbl[type]; hp < &(area->htbl[type][HTBLSIZE]); hp++) 
	{
	    for (db = hp; (DB_NEXT(db) != LSDBNULL); db = DB_NEXT(db)) 
	    {
	        /* check to see if it is valid */
		if (NO_GUTS(DB_NEXT(db)))
		    continue;
		*sb = DB_NEXT(db);
		sb++;
		ospf.sb_nel++;
	    }
	 }
	 if (ospf.sb_nel > 1)
	     heapsort(ospf.ls_sb,ospf.sb_nel,sizeof(struct LSDB *),ls_cmp);
    }

    if (action == GET_FIRST) {
	res = ospf.ls_sb[0];
	goto done;
    }

    tmp.key[0] = ls_id;
    tmp.key[1] = adv_rtr;
    if (ospf.sb_nel > 1)
    	ndx = bsrch(ospf.ls_sb,ospf.sb_nel,&tmp_p,sizeof(struct LSDB *),ls_cmp);
    else ndx = 0;

    /* 
     * If get next and at the end of this buf go to next type or area 
     */
    if (action == GET_NEXT) 
    {
 	if (ndx == ospf.sb_nel - 1) 
	{
	    adv_rtr = 0;
	    ls_id = 0;
	    if (type == LS_SUM_ASB) {
	    /* if there isn't a next area next type is ASE */
	   	if (get_next_area_ptr(&area))
		    type = LS_RTR;
		else type = LS_ASE;
	    } else if (type == LS_ASE)
	 	return(FALSE);
	    else type++;

	    ospf.sb_not_valid = TRUE;
	    ndx = 0;
	    action = GET_FIRST;
	    goto try_again;
	}
    	ndx++;
    } else {	/* GET_THIS */
 	if (ndx > ospf.sb_nel) 
	    return(FALSE);
    }
    res = ospf.ls_sb[ndx];

    done:

    (*mp)->ospfLsdbAreaId = area->area_id;
    (*mp)->ospfLsdbLSID = LS_ID(res);
    (*mp)->ospfLsdbRouterId = ADV_RTR(res);
    (*mp)->ospfLsdbSequence = LS_SEQ(res);
    (*mp)->ospfLsdbAge = 
	(ADV_AGE(res, sec) < MaxAge) ? (ADV_AGE(res, sec)) : MaxAge;
    (*mp)->ospfLsdbChecksum = LS_CKS(res);
    (*mp)->ospfLsdbType = LS_TYPE(res);
    (*mp)->adv_len = LS_LEN(res);
    ADV_COPY(DB_RTR(res),(*mp)->ospfLsdbAdvertisement,LS_LEN(res));

    return(TRUE);
}

int
get_address_range(action,mp)
int action;
struct OspfAreaRangeEntry **mp;
{
    struct AREA *area;
    struct NET_RANGE *nr = NRNULL;
    int is_next = FALSE;

    switch(action) {
	case GET_FIRST:
		area = FirstArea;
    		if (!area->nrcnt)
		    return(FALSE);
    		nr = area->nr.ptr[NEXT];
		break;

	case GET_THIS:
    		if (!locate_this_area((*mp)->ospfAreaRangeAreaID,&area))
		    return(FALSE);

    		if (!area->nrcnt) 
		    return(FALSE);

    		for(nr = area->nr.ptr[NEXT];
		    nr != NRNULL;
		    nr = nr->ptr[NEXT])
		    if (nr->net == (*mp)->ospfAreaRangeNet)
			goto got_range;

		return(FALSE);

	case GET_NEXT:

    		if (!locate_this_area((*mp)->ospfAreaRangeAreaID,&area))
		    return(FALSE);

		do {
    		    if (area->nrcnt) {
			nr = area->nr.ptr[NEXT];
			if (is_next)
			    goto got_range;
		    	while(nr) {
		    	    if (nr == NRNULL)
				break;
		    	    if (nr->net == (*mp)->ospfAreaRangeNet) {
			        if ((nr = nr->ptr[NEXT]) == NRNULL) {
				    is_next = TRUE;
				    break;
				}
			        goto got_range;
		    	    }
		    	    nr = nr->ptr[NEXT];
			}
		    }
		} while (locate_next_area(area->area_id,&area));
		return(FALSE);
    }

    if (!nr)
	return(FALSE);

    got_range:
    (*mp)->ospfAreaRangeAreaID = area->area_id;
    (*mp)->ospfAreaRangeNet = nr->net;
    (*mp)->ospfAreaRangeMask = nr->mask;
    (*mp)->ospfAreaRangeStatus = MIB_VALID;

    return(TRUE);
}

int
get_host_entry(action,mp)
int action;
struct OspfHostEntry **mp;
{
    struct OSPF_HOSTS *ohost;

    if ((*mp)->ospfHostTOS)
	return(FALSE);

    if (!locate_host_entry((*mp)->ospfHostIpAddress,&ohost,action))
	return(FALSE);

    (*mp)->ospfHostIpAddress = ohost->if_addr;
    (*mp)->ospfHostCost = ohost->cost;
    (*mp)->ospfHostStatus = MIB_VALID;

    return(TRUE);
}


int
get_intf_entry(action,mp)
int action;
struct OspfIfEntry **mp;
{
    struct INTF *intf;

    if (!locate_intf(action,&intf,(*mp)->ospfIfIpAddress))
	return(FALSE);

    (*mp)->ospfIfIpAddress = NDX_IP_ADDR(intf->ifspfndx);
    (*mp)->ospfAddressLessIf = 0;
    (*mp)->ospfIfAreaId = ifspfAREA(intf->ifspfndx).area_id;
    (*mp)->ospfIfType = intf->type;
    (*mp)->ospfIfAdminStat =
    		(intf->admstat == OSPF_INTF_ENABLE) ? MIB_VALID : MIB_INVALID;
    (*mp)->ospfIfRtrPriority = intf->pri;
    (*mp)->ospfIfTransitDelay = intf->transdly;
    (*mp)->ospfIfRetransInterval = intf->retrans_timer;
    (*mp)->ospfIfHelloInterval = intf->hello_timer;
    (*mp)->ospfIfPollInterval = intf->poll_timer;
    (*mp)->ospfIfRtrDeadInterval = intf->dead_timer;
    (*mp)->ospfIfState = intf->state;
    (*mp)->ospfIfDesignatedRouter =
		    (intf->dr) ? intf->dr->nbrip_addr : 0;
    (*mp)->ospfIfBackupDesignatedRouter =
		    (intf->bdr) ? (intf->bdr->nbrip_addr) : 0;

    (*mp)->ospfIfEvents = intf->events;
    CLEAR_BUF((*mp)->ospfIfAuthKey,8);

    return(TRUE);
}

int
get_if_metric(action,mp)
int action;
struct OspfIfMetricEntry **mp;
{
    struct INTF *intf;

    if ((*mp)->ospfIfMetricTOS) {
	return(FALSE);
    }

    if (!locate_intf(action,&intf,(*mp)->ospfIfMetricIpAddress)) {
	return(FALSE);
    }

    (*mp)->ospfIfMetricIpAddress = NDX_IP_ADDR(intf->ifspfndx);
    (*mp)->ospfIfMetricAddressLessIf = 0;
    (*mp)->ospfIfMetricCost = intf->cost;
    (*mp)->ospfIfMetricStatus =
    		(intf->admstat == OSPF_INTF_ENABLE) ? MIB_VALID : MIB_INVALID;

    return(TRUE);
}

int
get_virt_intf_entry(action,mp)
int action;
struct OspfVirtIfEntry	**mp;
{
    struct INTF *intf;


    if (!ospf.vcnt)
	return(FALSE);

    if (!locate_virt_intf(action,
		     	  &intf,
		     	  (*mp)->ospfVirtIfAreaID,
    		     	  (*mp)->ospfVirtIfNeighbor))
	return(FALSE);

    (*mp)->ospfVirtIfAreaID = ospf.area[intf->transarea].area_id;
    (*mp)->ospfVirtIfNeighbor = intf->nbr.nbr_id;

    (*mp)->ospfVirtIfTransitDelay = intf->transdly;
    (*mp)->ospfVirtIfRetransInterval = intf->retrans_timer;
    (*mp)->ospfVirtIfHelloInterval = intf->hello_timer;
    (*mp)->ospfVirtIfRtrDeadInterval = intf->dead_timer;
    (*mp)->ospfVirtIfState = intf->state;
    (*mp)->ospfVirtIfEvents = intf->events;
    CLEAR_BUF((*mp)->ospfVirtIfAuthKey,8);
    (*mp)->ospfVirtIfStatus =
	(intf->admstat == OSPF_INTF_ENABLE) ? MIB_VALID : MIB_INVALID;
    return(TRUE);
}


int
get_nbr_entry(action,mp)
int action;
struct	OspfNbrEntry **mp;
{
    struct INTF *intf;
    struct NBR *nbr, **sb, tmp;
    struct NBR *tmp_p = &tmp;
    struct AREA *a;
    int ndx, i;


    if (!ospf.nbrcnt) {
	return(FALSE);
    }

    if (!ospf.nbr_sb || ospf.nbr_sb_not_valid) {
	if (ospf.nbr_sb && 
	    ospf.nbr_sb_not_valid && 
	    ospf.nbr_sb_size < ospf.nbrcnt) {
		ospf.nbr_sb_size = ospf.nbrcnt + 10;
		MORE_NBR_SB_ALLOC(ospf.nbr_sb,ospf.nbr_sb_size);
		if (!ospf.nbr_sb) {
			return(FALSE);
		}
	    } else if (!ospf.nbr_sb) {
		ospf.nbr_sb_size = ospf.nbrcnt + 10;
		NBR_SB_ALLOC(ospf.nbr_sb,ospf.nbr_sb_size);
		if (!ospf.nbr_sb) {
			return(FALSE);
		}
 	    }
	ospf.nbr_sb_not_valid = FALSE;
	ospf.nbr_sb_nel = 0;
	sb = ospf.nbr_sb;
    	for (a = FirstArea; a < &(ospf.area[ospf.acnt]); a++) {
	    for (i = 0; i < a->ifcnt; i++) {
	    	intf = &a->intf[i];
	    	for (nbr = FirstNbr(intf); nbr != NBRNULL; nbr = nbr->next)
    	    	{
		    if (!nbr->nbrip_addr)
			continue;
		    (*sb) = nbr;
		    ospf.nbr_sb_nel++;
		    sb++;
    	    	}
	    }
    	}
	if (!ospf.nbr_sb_nel) {
	    return(FALSE);
	}

	if (ospf.nbr_sb_nel > 1)
	    heapsort(ospf.nbr_sb,ospf.nbr_sb_nel,sizeof(struct NBR *),nbr_cmp);
    }


    if (action == GET_FIRST) {
	nbr = ospf.nbr_sb[0];
	goto got_nbr;
    }


    if ((tmp.nbrip_addr = (*mp)->ospfNbrIpAddr) == 0) {
	return(FALSE);
    }

    ndx = bsrch(ospf.nbr_sb,
		ospf.nbr_sb_nel,
		&tmp_p,
		sizeof(struct NBR *),
		nbr_cmp);

    if (action == GET_NEXT)
	ndx++;

    if (ndx >= ospf.nbr_sb_nel)
	return(FALSE);
    nbr = ospf.nbr_sb[ndx];


    got_nbr:

    (*mp)->ospfNbrIpAddr = nbr->nbrip_addr;
    (*mp)->ospfNbrAddressLessIndex = 0;
    (*mp)->ospfNbrRtrId = nbr->nbr_id;
    (*mp)->ospfNbrOptions = 
		(ifspfAREA(nbr->ifspfndx).ext_option == EXT_OPT_NORMAL);
    (*mp)->ospfNbrPriority = nbr->pri;
    (*mp)->ospfNbrState = nbr->state;
    (*mp)->ospfNbrEvents = nbr->events;
    (*mp)->ospfNbrLSRetransQLen = nbr->dbcnt + nbr->reqcnt + nbr->rtcnt;
    (*mp)->ospfNBMANbrStatus = MIB_VALID;
    return(TRUE);
}

int
get_virt_nbr_entry(action,mp)
int action;
struct	OspfVirtNbrEntry **mp;
{
    struct INTF *intf;
    struct NBR *nbr;
    int ndx;

    if (!ospf.vcnt)
	return(FALSE);

    if (!locate_virt_intf(action,
		     	  &intf,
		     	  (*mp)->ospfVirtNbrArea,
    		     	  (*mp)->ospfVirtNbrRtrId))
	return(FALSE);

    nbr = &(intf->nbr);

    (*mp)->ospfVirtNbrArea = ospf.area[intf->transarea].area_id;
    (*mp)->ospfVirtNbrRtrId = nbr->nbr_id;
    (*mp)->ospfVirtNbrIpAddr = nbr->nbrip_addr;
    (*mp)->ospfVirtNbrOptions =
		(ifspfAREA(nbr->ifspfndx).ext_option == EXT_OPT_NORMAL);
    (*mp)->ospfVirtNbrState = nbr->state;
    (*mp)->ospfVirtNbrEvent = nbr->events;
    (*mp)->ospfVirtNbrLSRetransQLen = nbr->dbcnt + nbr->reqcnt + nbr->rtcnt;

    return(TRUE);
}

#endif				/* PROTO_OSPF */
