/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

/*
 *	Routines for adding and deleting external routes
 */
void
ase_import(e)
OSPF_ASE_BLOCK *e;
{
    int foundlsa;
    struct ASE_LA_HDR *as_hdr;
    struct LSDB *db;
    struct LSDB_LIST *ll, *txq = LLNULL;
    struct AREA *a = FirstArea;
    OROUTE *r;
    u_long32 new_seq, age = 0;
    int i, etype;


#ifdef DBG
    sprintf(_ospf_prt_buf,"In ase import count = %d\n", e->count);
    DBG_LOG(_ospf_prt_buf);
#endif

    for (i = 0; i < e->count; i++) {

	/* Check for hosedness */
	if ((r = e->ce[i].route) == ROUTENULL)
	    continue;
    	if (!QueueChk(LS_ASE,0))
	    goto no_bufs;
	db = RT_OSPF_EXT_DB(r);
	etype = e->ce[i].etype;

	switch (e->ce[i].action) {
	    case E_DELETE:
		/* long since gone? */
		if (db == LSDBNULL)
		    break;
		RT_OSPF_EXT_DB(r) = LSDBNULL;
		if (DB_GUTS(db) == DBGUTSNULL)
		    break;
		DB_TIME(db) = ospf_get_time();

		/* adjust update ptr for tqLsaAse */
		if (ospf.cur_ase == db) {
		    ospf.cur_ase = DB_PTR(db)[NEXT];
		    if (ospf.cur_ase == LSDBNULL)   /* removed last on lst? */
			ospf.cur_ase = DB_PTR(&ospf.my_ase_list)[NEXT];
		}
		LS_AGE(db) = 0;
    		ospf.db_chksumsum -= LS_CKS(db);
		fletch(DB_ASE(db), ASE_LA_HDR_SIZE);
    		ospf.db_chksumsum += LS_CKS(db);
		LS_AGE(db) = MaxAge;
		if (DB_WHERE(db) == ON_ASE_LIST)
		    DEL_DBQ(db);
		DB_WHERE(db) = ON_ASE_INFINITY;
		if (DB_FREEME(db) != TRUE) {
		    DB_FREEME(db) = TRUE;
		    ADD_DBQ(&ospf.db_free_list, db);
		}
		LL_ALLOC(ll);
		ll->lsdb = db;
		EN_Q(txq, ll);
		e->ce[i].done = TRUE;
		break;

	    case E_NEW:
	    case E_METRIC:
	    case E_NEXTHOP:

#ifdef NOTYETDEF
   		/* MODIFIED 1/22/92 */
		/* If in overflow mode, don't import any new routes */
		if (ospf.lsdb_overflow)
		    break;
#endif
		DBG_LOG("Here in E_NEW");
		foundlsa = FALSE;
		/* check if (metric > ASELSInfinity) */
		if (db != LSDBNULL) {
		    foundlsa = TRUE;
		} else {
		    foundlsa = AddLSA(&db, a, RT_DEST(r), MY_ID, 0, LS_ASE);
		    /* Bind route to db */
		    RT_OSPF_EXT_DB(r) = db;
		}

		if (foundlsa) {
		    /* had one around */
		    if (DB_FREEME(db) != FALSE) {
			DEL_DBQ(db);
			DB_FREEME(db) = FALSE;
		    }
		    as_hdr = DB_ASE(db);
    		    ospf.db_chksumsum -= LS_CKS(db);
		    if ((!(DB_SEQ_MAX(db))) && LS_SEQ(db) == MaxSeqNum) {
			/* Flush from everyone's db */
			age = MaxAge;
			new_seq = MaxSeqNum;
			DB_SEQ_MAX(db) = TRUE;
		    } else {
			new_seq = NEXTNSEQ(as_hdr->ls_hdr.ls_seq);
		    }
		} else {
		    new_seq = FirstSeq;
		    ASE_HDR_ALLOC(as_hdr, ASE_LA_HDR_SIZE);
		    if (!as_hdr)
			goto no_bufs;
		    DB_ASE(db) = as_hdr;
		}

		if (DB_FREEME(db) == TRUE) {
		    DB_FREEME(db) = FALSE;
		    DEL_DBQ(db);	/* remove from db_free_list */
		}
		if (DB_WHERE(db) != ON_ASE_LIST) {
		    DEL_DBQ(db);	/* remove from db_free_list */
		    ADD_DBQ(&ospf.my_ase_list, db);
		    DB_WHERE(db) = ON_ASE_LIST;
		}
		LS_SEQ(db) = new_seq;
		as_hdr->ls_hdr.ls_type = LS_ASE;
		as_hdr->ls_hdr.ls_age = 0;
		as_hdr->ls_hdr.adv_rtr = MY_ID;
		as_hdr->ls_hdr.ls_seq = new_seq;
		as_hdr->ls_hdr.length = htons(ASE_LA_HDR_SIZE);
		as_hdr->ls_hdr.ls_id = RT_DEST(r);
		as_hdr->net_mask = RT_MASK(r);
		/* PORT
		 * The AS of the importing route is usually stuffed here
		 */
		as_hdr->tos0.ExtRtTag = e->ce[i].tag;
		/* PORT
 		 * Have to add EGP or RIP Peer's IP address here
		 * - Address is of the owner of the route
		 * - Must be on a net advertised as an OSPF internal net
		 */
		as_hdr->tos0.ForwardAddr = e->ce[i].faddr;
		as_hdr->tos0.tos_metric = e->ce[i].metric;
		if (etype)
		    as_hdr->tos0.tos_metric |= ASE_bit_E;
		as_hdr->tos0.tos_metric = htonl(as_hdr->tos0.tos_metric);
		printf("Setting metric to %x\n", ntohl(as_hdr->tos0.tos_metric));
		fletch(as_hdr, ASE_LA_HDR_SIZE);
    		ospf.db_chksumsum += LS_CKS(db);
		as_hdr->ls_hdr.ls_age = htonl(e->ce[i].age);

		if ((e->ce[i].age >= MaxAge) && (DB_FREEME(db) != TRUE)) {
		    RT_OSPF_EXT_DB(r) = LSDBNULL;
		    DEL_DBQ(db);	/* remove from ase list */
		    DB_FREEME(db) = TRUE;
		    ADD_DBQ(&ospf.db_free_list, db);
		}
		DB_TIME(db) = ospf_get_time();
		LL_ALLOC(ll);
		ll->lsdb = db;
		EN_Q(txq, ll);
		e->ce[i].done = TRUE;
		break;
	}
	/*
	 * Count of originated LSAs for MIBness
	 */
    	ospf.orig_new_lsa++;
	ASE_IMPORT_LOG(e->ce[i]);
    }

    no_bufs:

    if (txq != LLNULL) {		/* new self originated ls_ase */
	for (a = FirstArea; a < &(ospf.area[ospf.acnt]); a++)
	{
#ifdef DBG
	    sprintf(_ospf_prt_buf,"Area %s ext_opt %d",
		lntoa(a->area_id),a->ext_option);
	    DBG_LOG(_ospf_prt_buf);
#endif
	    if (a->ext_option == EXT_OPT_NORMAL)
		self_orig_area_flood(a, txq, LS_ASE);
	}
	freeq(&txq, OMEM_LL);
    }
}
