/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/*
 * dbsum_alloc() - allocate a link up whose data portion is a db_hdr
 *			called by build_dbsum
 */
struct LSDB_SUM *
dbsum_alloc(len)
int len;
{
    struct LSDB_SUM *ds;

    DBS_ALLOC(ds);
    OSPF_PKT_ALLOC(ds->dbpkt, len);
    if (ds->dbpkt != OSPF_HDR_NULL)
	return (ds);
    else {
	ZAP(ds, OMEM_DBSUM);
	return (LSDB_SUM_NULL);
    }
}

/*
 * build_dbsum - build dbsum packets which includes the lsdb for this rtr
 *			put packets on the nbrs dbsum list
 *	       - called by RxDbDescr going into next state
 */
int
build_dbsum(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    struct DB_HDR *dbh;
    struct LS_HDR *dbp;
    struct LSDB *e, *hp;
    struct AREA *a = AREA_PTR(intf);
    struct LSDB_SUM *ds = LSDB_SUM_NULL;
    struct LSDB_SUM *lastds = LSDB_SUM_NULL;
    int len = (OSPF_HDR_SIZE + DB_HDR_SIZE);
    int type;
    time_t sec = ospf_get_time();
    int intf_mtu = INTF_MTU(intf);

    /* 
     * Don't include LS_ASE if stub area also it's a bozo no-no
     * to send LS_ASE over virtual links 
     */
    int hi_type = ( ((a->ext_option == EXT_OPT_NORMAL) && 
		     (intf->type != VIRTUAL_LINK)) ) ? LS_ASE : LS_SUM_ASB;

    freeDbSum(nbr);			/* summary of area db */
    freeLsReq(nbr);			/* request list for this nbr */

    ds = (struct LSDB_SUM *) dbsum_alloc(intf_mtu);
    if (ds == LSDB_SUM_NULL)
	return (FLAG_NO_BUFS);
    dbh = &(ds->dbpkt->un.database);
    dbp = &(dbh->dbp);
    nbr->dbsum = ds;

    /* 
     * grab all of the links 
     */
    for (type = LS_RTR; type <= hi_type; type++) {
	for (hp = a->htbl[type]; hp < &(a->htbl[type][HTBLSIZE]); hp++) {
	    for (e = DB_NEXT(hp); e != LSDBNULL; e = DB_NEXT(e)) {
		/* Too far gone ... */
		if (NO_GUTS(e))
		    continue;
		if (ADV_AGE(e, sec) >= MaxAge) {
		    if (!QueueChk(QDbSum,a)) {
			freeDbSum(nbr);
			if (nbr->retrans != DBRTNULL)
			    rem_nbr_retrans(nbr);
			return (FLAG_NO_BUFS);
		    }
		    add_nbr_retrans(nbr, e);
		    add_db_retrans(e, nbr);
		    continue;
		}
		if (len + DB_PIECE_SIZE >= intf_mtu) {
		    /* 
 		     * finish off this pkt and assume more for now
		     */
		    dbh->I_M_MS = bit_M;
		    ds->len = len;
		    lastds = ds;
		    /* 
		     * alloc another 
		     */
		    lastds->next = (ds = dbsum_alloc(intf_mtu));
		    if (ds == LSDB_SUM_NULL) {
			freeDbSum(nbr);
			if (nbr->retrans != DBRTNULL)
			    rem_nbr_retrans(nbr);
			return (FLAG_NO_BUFS);
		    }
		    len = (OSPF_HDR_SIZE + DB_HDR_SIZE);
		    dbh = &(ds->dbpkt->un.database);
		    dbp = &(dbh->dbp);
		}
		(*dbp) = DB_LS_HDR(e);
		dbp->ls_age = htons((ADV_AGE(e, sec)));
		len += DB_PIECE_SIZE;
		nbr->dbcnt += 1;
		ds->cnt += 1;
		dbp++;
	    }
	}
    }

    /* 
     * slave transitions first so master is first to have M bit off 
     */
    if (len == OSPF_HDR_SIZE + DB_HDR_SIZE) {	/* check for empty pkt */
	/* 
	 * will always have one dd with at least this rtr's lsa in pkt 
	 */
	if (ds == nbr->dbsum)
	    nbr->dbsum = LSDB_SUM_NULL;
	DB_ZAP_PKT(ds);
	ZAP(ds, OMEM_DBSUM);
	if (lastds) {
	    lastds->next = LSDB_SUM_NULL;
	    /* turn off more */
	    lastds->dbpkt->un.database.I_M_MS = 0;
	}
    } else {
	/* 
      	 * leave on more bit if MASTER 
	 */
	if (nbr->mode == SLAVE)
	    ds->dbpkt->un.database.I_M_MS = 0;	/* turn off more */
	ds->next = LSDB_SUM_NULL;
	ds->len = len;
    }

    return (FLAG_NO_PROBLEM);
}

#endif				/* PROTO_OSPF */
