;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Copyright (c) 1993, 1994 by William M. Perry (wmperry@spry.com)
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Variable definitions for w3
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defconst w3-version-number
  (let ((x "$State: p2-1-54 $"))
    (string-match "State:[ \\\t\\\n]+.\\([^ \\\t\\\n]+\\)" x)
    (mapconcat
     (function (lambda (x) (if (= x ?-) "." (char-to-string x))))
     (substring x (match-beginning 1) (match-end 1)) ""))
  "Version # of w3-mode")

(defconst w3-version-date (let ((x "$Date: 1994/08/21 03:30:18 $"))
			    (string-match "Date: \\([^ \\\t\\\n]+\\)" x)
			    (substring x (match-beginning 1) (match-end 1)))
  "Date this version of w3-mode was released.")


(defconst w3-version
  (format "WWW %s %s" w3-version-number w3-version-date)
  "More descriptive version of w3-version-number.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; General configuration variables
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-annotation-mode 'html-mode
  "*A symbol specifying the major mode to enter when doing annotations.")

(defvar w3-annotation-position 'bottom
  "*A symbol specifying where personal annotations should appear in a buffer.
Can be one of the symbols 'top or 'bottom.  If the symbol is eq to 'top, then
the annotations will appear at the top of the buffer.  If 'bottom, will appear
at the end of the buffer.")

(defvar w3-cache-size 5 "*Size of the document cache.")

(defvar w3-default-configuration-file nil
  "*Where per-user customizations of w3 are kept.")

(defvar w3-confirmation-func 'yes-or-no-p
  "*What function to use for asking yes or no functions.  Possible
values are 'yes-or-no-p or 'y-or-n-p, or any function that takes a
single argument (the prompt), and returns t only if a positive answer
is gotten.")

(defvar w3-default-action 'w3-prepare-buffer
  "*A lisp symbol specifying what action to take for files with
extensions that are not in the w3-mime-extensions assoc list.
This is useful in case you ever run across files with weird extensions
(.foo, .README, .READMEFIRST, etc).  This should not be required
anymore.

Possible values: any lisp symbol.  Should be a function that takes no
arguments.  The return value does not matter, it is ignored.  Some examples
are:

Action			Value
----------------------------------------------
Parse as HTML		'w3-prepare-buffer
View as text		'indented-text-mode
")

(defvar w3-default-homepage nil
  "*The url to open at startup.  It can be any valid URL.  This will
default to the environment variable WWW_HOME if you do not set it in
your .emacs file. If WWW_HOME is undefined, then it will default to
the hypertext documentation for W3 at Indiana University.")

(defvar w3-documents-menu-file nil
  "*Where the Mosaic documents-menu file is located.  This is a file
that has extra menus for the 'Navigate' menu.  This should be in the same
format as the Mosaic extra documents.menu")

(defvar w3-dump-to-disk nil
  "*If non-nil, all W3 pages loaded will be dumped to disk.")

(defvar w3-emacs19-hack-faces-p nil
  "Whether emacs19 should try to emulate bold/underline faces when running
on a dumb terminal.")

(defvar w3-horizontal-rule-char ?-
  "*The character to use to create a horizontal rule.
Must be the character's code, not a string.  This character is
replicated across the screen to create a division.")

(defvar w3-hotlist-file nil
  "*Hotlist filename.
This should be the name of a file that is stored in NCSA's Mosaic/X
format (ncsa-mosaic-hotlist-format-1).  It is used to keep a listing
of commonly accessed URL's without having to go through 20 levels of
menus to get to them.")

(defvar w3-html2latex-args "-s -"
  "*Args to pass w3-html2latex-prog.  This should send the LaTeX source
to standard output.")

(defvar w3-html2latex-prog "html2latex"
  "*Program to convert html to latex.")

(defvar w3-icon-directory-list
  '("http://cs.indiana.edu/elisp/w3/icons/")
  "*A list of directorys to look in for the w3 standard icons...
must end in a /!")

(defvar w3-keep-old-buffers t
  "*Whether to keep old buffers around when following links.")

(defvar w3-latex-docstyle "[psfig]{article}"
  "*The documentstyle to use when printing/mailing converted HTML
files in LaTeX.  Good defaults are:
{article}, [psfig,twocolumn]{article}, etc.")

(defvar w3-link-delimiter-info nil
  "*A function to call to get extra information about a link and
include it in a buffer.  Will be placed after the link and any other
delimiters.")

(defvar w3-mail-command 'mail
  "*This function will be called whenever w3 needs to send mail.  It should
enter a mail-mode-like buffer in the current window.
w3-mail-other-window-command will be used if w3-mutable-windows is t.
The commands mail-to and mail-subject should still work in this
buffer, and it should use mail-header-separator if possible.")

(defvar w3-mail-other-window-command 'mail-other-window
  "*This function will be called whenever w3 needs to send mail in
another window.  It should enter a mail-mode-like buffer in a
different window.  The commands mail-to and mail-subject should still
work in this buffer, and it should use mail-header-separator if
possible.")

(defvar w3-max-inlined-image-size nil
  "*The maximum byte size of a file to transfer as an inlined image.
If an image is being retrieved and exceeds this size, then it will be
cancelled.  This works best on HTTP/1.0 servers that send a
Content-length header, otherwise the image is retrieved up until the
max number of bytes is retrieved, then killed.")

(defvar w3-max-menu-length 35
  "*The maximum length of a pulldown menu before it will be split into
smaller chunks, with the first part as a submenu, followed by the rest
of the menu.")

(defvar w3-mule-attribute 1
  "*How to highlight items in Mule (Multi-Linugual Emacs).  1 is underline,
2 is reverse video.")

(defvar w3-mule-retrieval-coding-system (if (boundp 'MULE) *euc-japan*
					  nil)
  "Coding system for retrieval, used before hexified")

(defvar w3-mutable-windows nil
  "*Controls how new WWW documents are displayed.  If this is set to
non-nil and pop-up-windows is non-nil, then new buffers will be shown
in another window.  If either is nil, then it will replace the document
in the current window.")

(defvar w3-personal-annotation-directory nil
  "*Directory where w3 looks for personal annotations.
This is a directory that should hold the personal annotations stored in
a Mosaic-compatible format. (ncsa-mosaic-personal-annotation-log-format-1)")

(defvar w3-ppmtoxbm-command "ppmtopgm | pgmtopbm | pbmtoxbm"
  "*The command used to convert from the portable-pixmap graphics format
to an x bitmap.  This will only ever be used if lemacs doesn't have support
for XPM.")

(defvar w3-ppmtoxpm-command "ppmtoxpm"
  "*The command used to convert from the portable-pixmap graphics format
to XPM.  The XPM _MUST_ be in version 3 format.")

(defvar w3-print-command "lpr -h -d"
  "*Print command for dvi files.
This is usually lpr -h -d to send it to a postscript printer, but you can set
it up so that it is any command that takes a dvi file as its last argument.")

(defvar w3-reuse-buffers nil
  "What to do when following a link will re-fetch a document that has
already been fetched into a W3 buffer.  Possible values are: nil,
'yes, and 'no.  Nil means ask the user if we should reuse the buffer
(this is the default value).  A value of 'yes means assume the user
wants us to reuse the buffer.  A value of 'no means assume the user
wants us to re-fetch the document.")

(defvar w3-right-border 2
  "*Amount of space to leave on right margin of WWW buffers.
This amount is subtracted from (window-width) for each new WWW buffer
and used as the new fill-column.")

(defvar w3-show-headers nil
  "*This is a list of regexps that match HTTP/1.0 headers to show at
the end of a buffer.  All the headers being matched against will be
in lowercase.  All matching headers will be inserted at the end of the
buffer in a <UL> list.")

(defvar w3-show-http2-transfer t
  "*Whether to show the total # of bytes, size of file, and percentage
transferred when retrieving a document over HTTP/1.0 and it returns a
valid content-length header.  This can mess up some people behind
gateways.")

(defvar w3-show-status t
  "*Whether to show a running total of bytes transferred.  Can cause a
large hit if using a remote X display over a slow link, or a terminal
with a slow modem.")

(defvar w3-starting-documents
  '(("Internet Starting Points"  "http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/StartingPoints/NetworkStartingPoints.html")
    ("Internet Resources Meta-index"  "http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/MetaIndex.html")
    ("NCSA's What's New"  "http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/whats-new.html"))
  "*An assoc list of titles and URLs for quick access.  These are just
defaults so that new users have somewhere to go.")

(defvar w3-temporary-directory "/tmp" "*Where temporary files go.")

(defvar w3-track-mouse t
  "*Whether to track the mouse and message the url under the mouse.
This also changes the mouse cursor to be the cursor specified by
w3-link-cursor.")

(defvar w3-use-forms-index t
  "*Non-nil means translate <ISINDEX> tags into a hypertext form.
A single text entry box will be drawn where the ISINDEX tag appears.
If t, the isindex handling will be the same as Mosaic for X.")

(defvar w3-use-html2latex nil
  "*This controls how HTML is converted into LaTeX for printing or mailing.
If nil, the w3-convert-html-to-latex function is used instead of the
html2latex in a subprocess.  The lisp function gives slightly better
formatting in my biased opinion.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Gateway information
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-gateway-method 'native
  "*The type of gateway support to use.
Should be a symbol specifying how we are to get a connection off of the
local machine.

Currently supported methods:
'program	:: Run a program in a subprocess to connect
                   (examples are itelnet, an expect script, etc)
'host     	:: You need to log into a different machine, then
		   are able to telnet out
'native		:: Use the native open-network-stream in emacs
'tcp            :: Use the excellent tcp.el package from gnus.
                   This simply does a (require 'tcp), then sets
                   w3-gateway-method to be 'native.
")

(defvar w3-gateway-program-interactive nil
  "*Whether w3 needs to hand-hold the login program on the remote machine")

(defvar w3-gateway-handholding-login-regexp "ogin:"
  "*Regexp for when to send the username to the remote process")

(defvar w3-gateway-handholding-password-regexp "ord:"
  "*Regexp for when to send the password to the remote process")

(defvar w3-gateway-host-prompt-pattern "^[^#$%>;]*[#$%>;] *"
  "*Regexp used to detect when the login is finished on the remote host.")

(defvar w3-gateway-host nil
  "*Name of your gateway host when using the w3-gateway-method 'host")

(defvar w3-gateway-host-username nil
  "*Username to use to log into the host specified by w3-gateway-host when
using w3-gateway-method 'host")

(defvar w3-gateway-host-password nil
  "*Password to use to log into the host specified by w3-gateway-host when
using w3-gateway-method 'host")

(defvar w3-gateway-host-process nil
  "The process currently communicating with the w3-gateway-host")

(defvar w3-gateway-buffer " *GATEWAY*"
  "Buffer used temporarily when using gateways.")

(defvar w3-gateway-host-program "telnet"
  "*The name of the program on the remote host that acts like telnet.")

(defvar w3-gateway-host-program-ready-regexp "Escape character is .*"
  "*A regular expression that signifies the program on the remote host is
ready to accept input and send it to the remote host.")

(defvar w3-gateway-telnet-ready-regexp "Escape character is .*"
  "*A regular expression that signifies w3-gateway-telnet-program is
ready to accept input")

(defvar w3-local-telnet-prog "telnet"
  "*Program for local telnet connections")

(defvar w3-remote-telnet-prog "itelnet"
  "*Program for remote telnet connections")  

(defvar w3-gateway-telnet-program "itelnet"
  "*Program to run in a subprocess when using gateway-method 'program")

(defvar w3-gateway-local-host-regexp nil
  "*If a host being connected to matches this regexp then the
connection is done natively, otherwise the process is started on
`w3-gateway-host' instead.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Hook Variables
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-load-hooks nil "*Hooks to be run after loading w3")
(defvar w3-mode-hooks nil "*Hooks to be run after entering w3-mode")
(defvar w3-file-prepare-hooks nil "*Hooks to be run before preparing a buffer")
(defvar w3-file-done-hooks nil "*Hooks to be run after preparing a buffer")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Figure out what flavor of emacs we are running
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-running-epoch (and (boundp 'epoch::version)
			      (symbol-value 'epoch::version))
  "*In Epoch")

(defvar w3-running-lemacs (string-match "Lucid" emacs-version)
  "*In new release of Lucid emacs?")

(defvar w3-running-FSF19 (and (string-match "^19" emacs-version)
			      (not w3-running-lemacs))
  "*In FSF v19 emacs?")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Link delimiting
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-delimit-emphasis 'guess
  "*Whether to use characters at the start and end of each bold/italic
region.  Types of characters are specified in w3-style-chars-assoc.")

(defvar w3-link-start-delimiter '("[[" . "{{")
  "*Put this at front of link if w3-delimit-links is t")

(defvar w3-link-end-delimiter '("]]" . "}}")
  "*Put this at end of link if w3-delimit-links is t")

(defvar w3-delimit-links 'guess
  "*Put brackets around links?  If this variable is eq to 'linkname, then
it will put the link # in brackets after the link text.  If it is nil, then
it will not put anything.  If it is non-nil and not eq to 'linkname, then
it will put [[ & ]] around the entire text of the link.  Is initially set
to be t iff in normal emacs.  Nil if in epoch or lucid emacs, since links
should be in different colors/fonts.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; embedded document variables
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-mpeg-size 150 "*The height and width of an mpeg window")
(defvar w3-mpeg-args '("-loop") "*Arguments to mpeg_play")
(defvar w3-mpeg-program "mpeg_play" "*The mpeg_play executable")
(defvar w3-delayed-movies nil "A list of mpeg movies for this buffer")
  
(defvar w3-embedded-data-converters
  '(("application/eqn" . w3-embed-eqn)
    ("application/postscript" . w3-embed-postscript)
    ("text/plain". w3-embed-text)
    ("text/html" . w3-embed-text)
    ("image/.*"  . w3-embed-image))
  "An assoc list of regular expressions to match against MIME content-types
for embedded data in HTML documents.  The cdr is a function to be passed
to 'funcall', with the embedded data and content-type as the sole arguments
passed to the function.")

(if (and w3-running-lemacs (boundp 'emacs-minor-version)
	 (>= emacs-minor-version 10))
    (progn
      (require 'annotations)
      (setq w3-embedded-data-converters
	    (cons (cons "video/mpeg" 'w3-embed-mpeg)
		  w3-embedded-data-converters))))
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Graphics parsing stuff
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-graphics-always-show-entities t
  "*Set to t to always show graphic entities, regardless of the value of
w3-delay-image-loads.  Useful if you keep the entities locally and aren't
worried about the transfer time on something that small.")

(defvar w3-graphics-list nil
  "*List of graphics already read in.")

(defvar w3-delay-image-loads nil
  "*Delay loading images for w3 or not?")

(defvar w3-delayed-images nil
  "* A buffer-local variable holding positions and urls of images within
the buffer")

(defvar w3-delay-mpeg-loads t
  "*Whether to delay loading mpegs or not.")

(defvar w3-graphic-converter-alist
  '(
    ("image/x-xbitmap"        . "cat ")
    ("image/xbitmap"          . "cat ")
    ("image/xbm"              . "cat ")
    ("image/gif"              . "giftopnm  | %s")
    ("image/x-fax"            . "g3topbm   | %s")
    ("image/x-raster"         . "rasttoppm | %s")
    ("image/windowdump"       . "xwdtoppm  | %s")
    ("image/x-icon"           . "icontopbm | %s")
    ("image/portable-graymap" . "pgmtoppm  | %s")
    ("image/portable-pixmap"  . "cat ")
    ("image/x-pixmap"         . "cat ")
    ("image/x-xpixmap"        . "cat ")
    ("image/pict"             . "picttoppm | %s")
    ("image/x-macpaint"       . "macptopbm | %s")
    ("image/x-targa"          . "tgatoppm  | %s")
    ("image/tiff"             . "tifftopgm | pgmtoppm | %s")
    ) "*How to convert graphics into xpixmaps")

(defvar w3-color-use-reducing t
  "*Whether to use ppmquant/ppmdither to do color reducing for inlined images.
If you are using a 24bit display, you should set this to nil.")

(defvar w3-color-max-red 4
  "*Max # of red cells to allocate for inlined images.")

(defvar w3-color-max-green 4
  "*Max # of green cells to allocate for inlined images.")

(defvar w3-color-max-blue 4
  "*Max # of blue cells to allocate for inlined images.")

(defvar w3-color-filter 'ppmdither
  "*How to do color reducing on inlined images.
This should be a symbol, either ppmdither or ppmquant.
This variable only has any meaning if w3-color-use-reducing is non-nil.
Possible values are:

ppmquant    :== Use the ppmquant program to reduce colors.  The product
                of w3-color-max-[red|green|blue] is used as the maximum
                number of colors.
ppmdither   :== Use the ppmdither program to reduce colors.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; How to look up styles
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-style-regexp nil "*Regular expression that matches style tags")

(defvar w3-style-assoc
  '(
    ("ABBREV" . w3-tt-style)
    ("ADDRESS" . w3-address-style)
    ("ABSTRACT" . w3-tt-style)
    ("ACRONYM" . w3-tt-style)
    ("ADDED" . w3-bold-style)
    ("ARG" . w3-italic-style)
    ("B" . w3-bold-style)
    ("BYLINE" . w3-italic-style)
    ("CITE" . w3-underline-style)
    ("CMD" . w3-bold-style)
    ("CODE" . w3-tt-style)
    ("DFN" . w3-bold-style)
    ("EM" . w3-italic-style)
    ("I" . w3-italic-style)
    ("KBD" . w3-tt-style)
    ("PERSON" . w3-default-style)
    ("Q" . w3-italic-style)
    ("REMOVED" . w3-strikethru-style)
    ("S" . w3-strikethru-style)
    ("SAMP" . w3-tt-style)
    ("STRONG" . w3-bold-style)
    ("SUB" . w3-subscript-style)
    ("SUP" . w3-superscript-style)
    ("TT" . w3-tt-style)
    ("U" . w3-underline-style)
    ("VAR" . w3-tt-style)
    )
  "*An assoc list of emphasis tags and their corresponding styles.")

(defvar w3-style-chars-assoc
  '(
    ("B"       . ("*" . "*"))
    ("ADDRESS" . ("*" . "*"))
    ("BYLINE"  . ("_" . "_"))
    ("CITE"    . ("_" . "_"))
    ("CMD"     . ("*" . "*"))
    ("DFN"     . ("*" . "*"))
    ("EM"      . ("~" . "~"))
    ("I"       . ("~" . "~"))
    ("Q"       . ("\"" . "\""))
    ("REMOVED" . ("" . ""))
    ("S"       . ("" . ""))
    ("STRONG"  . ("*" . "*"))
    ("SUB"     . ("" . ""))
    ("SUP"     . ("" . ""))
    ("U"       . ("_" . "_"))
    )
  "*An assoc list of emphasis tags and their corresponding
begin and end characters.")

(defvar w3-header-chars-assoc
  '(
    ("1" . (?* ?* w3-upcase-region))
    ("2" . (?* ?* w3-upcase-region))
    ("3" . (?- ?- w3-upcase-region))
    ("4" . (nil ?= nil))
    ("5" . (nil ?= nil))
    ("6" . (nil ?: nil)))
  "*An assoc list of header tags and a list of formatting instructions.
This list consists of 3 items - the first item is a character that is
inserted before the header X number of times, where X is the length of
the header.  A <BR> is automatically inserted after this.
The second item is the character to insert after the header.  A <BR>
is inserted before and after this string. And the third is a function
to call on the region between the start and end of the header.  This
will be called with 2 arguments, the buffer positions of the start and
end of the headers.")

(defvar w3-list-chars-assoc 
  '(
    ("UL" . ("o" "*" "+" "&gt;"))
    ("OL" . ("." ")" "]" ":"))
    ("DL" . ("o" "*" "+" "&gt;")))
  "An assoc list of characters to put at the front of list items.  It is
keyed on the type of list, followed by a list of items.  Each item should
be placed in the nth position of the list, where n is the nesting level it
should be used for.  n starts at 1.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Styles for emphasis, bold, etc
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(cond
 ((or w3-running-epoch w3-running-FSF19 w3-running-lemacs)
  (defvar w3-tt-style 'w3-tt-style "Face used for fixed-width text")
  (defvar w3-bold-style 'w3-bold-style "Face used for bold text")
  (defvar w3-italic-style 'w3-italic-style "Face used for italicized text")
  (defvar w3-underline-style 'w3-underline-style "Face for underlined text")
  (defvar w3-node-style 'w3-node-style "Face used for hypertext links")
  (defvar w3-visited-node-style 'w3-visited-node-style "Visited links")
  (defvar w3-header-style 'w3-header-style "Face used for all headers")
  (defvar w3-address-style 'w3-address-style "Face used for address tags")
  (defvar w3-superscript-style 'w3-superscript-style "Face for superscripts")
  (defvar w3-subscript-style 'w3-subscript-style "Face for subscripts")
  (defvar w3-strikethru-style 'w3-strikethru-style "Face for strikethru")
  (defvar w3-default-style 'w3-default-style "Face used for all text"))
 (t
  (defvar w3-node-style nil)
  (defvar w3-visited-node-style nil)
  (defvar w3-header-style nil)
  (defvar w3-address-style nil)
  (defvar w3-tt-style nil)
  (defvar w3-bold-style nil)
  (defvar w3-italic-style nil)
  (defvar w3-underline-style nil)
  (defvar w3-superscript-style nil)
  (defvar w3-subscript-style nil)
  (defvar w3-strikethru-style nil)
  (defvar w3-default-style nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Entities table
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-html-entities
  '(
    ("&AElig;"      . "")
    ("&Aacute;"     . "")
    ("&Acirc;"      . "")
    ("&Agrave;"     . "")
    ("&Aring;"      . "")
    ("&Atilde;"     . "")
    ("&Auml;"       . "")
    ("&Ccedil;"     . "")
    ("&ETH;"        . "")
    ("&Eacute;"     . "")
    ("&Ecirc;"      . "")
    ("&Egrave;"     . "")
    ("&Euml;"       . "")
    ("&Iacute;"     . "")
    ("&Icirc;"      . "")
    ("&Igrave;"     . "")
    ("&Iuml;"       . "")
    ("&Ntilde;"     . "")
    ("&Oacute;"     . "")
    ("&Ocirc;"      . "")
    ("&Ograve;"     . "")
    ("&Oslash;"     . "")
    ("&Otilde;"     . "")
    ("&Ouml;"       . "")
    ("&THORN;"      . "")
    ("&Uacute;"     . "")
    ("&Ucirc;"      . "")
    ("&Ugrave;"     . "")
    ("&Uuml;"       . "")
    ("&Yacute;"     . "")
    ("&acute;"      . "")
    ("&aacute;"     . "")
    ("&acirc;"      . "")
    ("&acute;"      . "")
    ("&aelig;"      . "")
    ("&agrave;"     . "")
    ("&apos;"       . "'")
    ("&aring;"      . "")
    ("&ast;"        . "*")
    ("&atilde;"     . "")
    ("&auml;"       . "")
    ("&brvbar;"     . "")
    ("&cedil;"      . "")
    ("&ccedil;"     . "")
    ("&cent;"       . "")
    ("&colon;"      . ":")
    ("&comma;"      . ",")
    ("&commat;"     . "@") ; Commercial at sign
    ("&copy;"       . "")
    ("&curren;"     . "$") ; General currency sign
    ("&deg;"        . "")
    ("&die;"        . "")
    ("&divide;"     . "")
    ("&dollar;"     . "$")
    ("&eacute;"     . "")
    ("&ecirc;"      . "")
    ("&egrave;"     . "")
    ("&emsp;"       . "  ")
    ("&ensp;"       . " ")
    ("&equals;"     . "=")
    ("&eth;"        . "")
    ("&euml;"       . "")
    ("&excl;"       . "!")
    ("&frac12;"     . "")
    ("&frac14;"     . "")
    ("&frac34;"     . "")
    ("&frac18;"     . "1/8")
    ("&frac38;"     . "3/8")
    ("&frac58;"     . "5/8")
    ("&frac78;"     . "7/8")
    ("&grave;"      . "`")
    ("&gt;"         . ">")
    ("&gt"          . ">")
    ("&half;"       . "")
    ("&hellip;"     . ". . .")
    ("&hibar;"      . "")
    ("&horbar;"     . "-")
    ("&hyphen;"     . "-")
    ("&iacute;"     . "")
    ("&icirc;"      . "")
    ("&iexcl;"      . "")
    ("&igrave;"     . "")
    ("&iquest;"     . "")
    ("&iuml;"       . "")
    ("&larr;"       . "<--")
    ("&laquo;"      . "")
    ("&lcub;"       . "{")
    ("&ldquo;"      . "\"") ; Double quotation mark, left
    ("&lowbar;"     . "_")
    ("&lpar;"       . "(")
    ("&lsqb;"       . "[")
    ("&lsquo;"      . "`") ; singe quotation mark, left 
    ("&lt;"         . "<")
    ("&lt"          . "<")
    ("&macr;"       . "")
    ("&mdash;"      . "--")
    ("&micro;"      . "")
    ("&middot;"     . "")
    ("&nbsp;"       . " ")
    ("&ndash;"      . "-")
    ("&not;"        . "")
    ("&ntilde;"     . "")
    ("&num;"        . "#") ; Number sign
    ("&oacute;"     . "")
    ("&ocirc;"      . "")
    ("&ograve;"     . "")
    ("&ordf;"       . "")
    ("&ordm;"       . "")
    ("&oslash;"     . "")
    ("&otilde;"     . "")
    ("&ouml;"       . "")
    ("&para;"       . "")
    ("&percnt;"     . "%")
    ("&period;"     . ".")
    ("&plus;"       . "+")
    ("&plusmn;"     . "")
    ("&pound;"      . "")
    ("&quest;"      . "?")
    ("&quot;"       . "\"")
    ("&raquo;"      . "")
    ("&rarr;"       . "-->") ; Right arrow
    ("&rcub;"       . "}")
    ("&rdquo;"      . "\"") ; Right double quote
    ("&reg;"        . "")
    ("&rpar;"       . ")")
    ("&rsqb;"       . "]")
    ("&rsquo;"      . "'") ; Single quotatoin mark, right
    ("&sect;"       . "")
    ("&semi;"       . ";")
    ("&shy;"        . "")
    ("&sup1;"       . "")
    ("&sup2;"       . "")
    ("&sup3;"       . "")
    ("&szlig;"      . "")
    ("&thorn;"      . "")
    ("&tilde;"      . "~")
    ("&times;"      . "*") ; Multiplication sign
    ("&trade;"      . "(TM)")
    ("&uacute;"     . "")
    ("&uarr;"       . "^") ; Up arrow
    ("&ucirc;"      . "")
    ("&ugrave;"     . "")
    ("&uml;"        . "")
    ("&uuml;"       . "")
    ("&yacute;"     . "")
    ("&yen;"        . "")
    ("&yuml;"       . "")
    ("&verbar;"     . "|")
    ("&amp;"        . "&")
    )
  "*An assoc list of entity names and how to actually display them.")

(defvar w3-graphics-entities-alist
  '(
    ("&archive;"             . ("archive.xbm"))
    ("&audio;"               . ("audio.xbm"))
    ("&binary.document;"     . ("binary.document.xbm"))
    ("&binhex.document;"     . ("binhex.document.xbm"))
    ("&caution;"             . ("caution.xbm" . "[CAUTION]"))
    ("&clock;"               . ("clock.xbm"))
    ("&compressed.document;" . ("compressed.document.xbm"))
    ("&disk.drive;"          . ("disk.drive.xbm"))
    ("&diskette;"            . ("diskette.xbm"))
    ("&display;"             . ("display.xbm"))
    ("&document;"            . ("unknown.document.xbm"))
    ("&fax;"                 . ("fax.xbm"))
    ("&filing.cabinet;"      . ("filing.cabinet.xbm"))
    ("&film;"                . ("film.xbm"))
    ("&fixed.disk;"          . ("fixed.disk.xbm"))
    ("&folder;"              . ("folder.xbm"))
    ("&form;"                . ("form.xbm")) ; draw one
    ("&ftp;"                 . ("ftp.xbm"))
    ("&glossary;"            . ("glossary.xbm" . "[glossary]"))
    ("&home;"                . ("home.xbm" . "[HOME]"))
    ("&image;"               . ("image.xbm"))
    ("&index;"               . ("index.xbm" . "[index]"))
    ("&keyboard;"            . ("keyboard.xbm"))
    ("&mail;"                . ("mail.xbm"))
    ("&mail.in;"             . ("mail.in.xbm"))
    ("&mail.out;"            . ("mail.out.xbm"))
    ("&map;"                 . ("map.xbm"))
    ("&mouse;"               . ("mouse.xbm"))
    ("&network;"             . ("network.xbm"))
    ("&next;"                . ("next.xbm" . "[next]"))
    ("&notebook;"            . ("notebook.xbm"))
    ("&parent;"              . ("parent.xbm" . "[parent]")) ; draw one
    ("&previous;"            . ("previous.xbm" . "[previous]")) ; draw one
    ("&printer;"             . ("printer.xbm"))
    ("&scheduler;"           . ("scheduler.xbm"))
    ("&stop;"                . ("stop.xbm" . "[STOP]"))
    ("&summary;"             . ("summary.xbm")) ; draw one
    ("&symlink;"             . ("symlink.xbm"))
    ("&telephone;"           . ("telephone.xbm"))
    ("&telnet;"              . ("telnet.xbm"))
    ("&text.document;"       . ("unknown.document.xbm"))
    ("&tn3270;"              . ("tn3270.xbm"))
    ("&toc;"                 . ("toc.xbm" . "[Table Of Contents]")); Draw one!
    ("&trash;"               . ("trash.xbm"))
    ("&unknown.document;"    . ("unknown.document.xbm"))
    ("&uuencoded.document;"  . ("uuencoded.document.xbm"))
    ("&workstation;"         . ("workstation.xbm"))
    )
    "*An assoc list of entity nams and the names of bitmaps to
display them. The car is the entity name, the cdr is a list of the
form (bitmapfile . alttag), where bitmapfile is a filename that
specifies a bitmap file - w3-icon-directory is prepended to this
automatically.  Alttag is the text to use if the bitmap is
unavailable.  If nil, no text is used.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Menu definitions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-main-menu 
  '("WWW Browser"
    ["Open Local File" w3-open-local t]
    ["Open URL" w3-fetch t]
    ["Show document's address" url-view-url t]
    ["Copy document's address into cut buffer" w3-save-url t]
    "---"
    ["View Source" w3-source-document t]
    ["Edit Document Source" w3-find-this-file t]
    ["Reload Current Document" w3-reload-document t]
    "---"
    ["Mail Formatted Document " w3-mail-current-document t]
    ["Print Current Document" w3-print-this-url t]
    "---"
    ["Add annotation" w3-annotation-add t]
    "---"
    ["Leave & Bury Buffer" w3-leave-buffer t]
    ["Leave & Kill Buffer" w3-quit t]
    )
  "The main w3 menu"
  )

(defvar w3-popup-menu
  '("WWW Browser"
    ["Open Local File" w3-open-local t]
    ["Open URL" w3-fetch t]
    ["Load Delayed Images" w3-load-delayed-images w3-delayed-images]
    ["Load Delayed MPEGs" w3-load-delayed-mpegs w3-delayed-movies]
    "---"
    ["Add annotation" w3-annotation-add t]
    "---"
    ["Leave & Bury Buffer" w3-leave-buffer t]
    ["Leave & Kill Buffer" w3-quit t]
    )
  "The shorter popup menu")

(defvar w3-documentation-root "http://www.cs.indiana.edu/elisp/w3/"
  "*Where the w3 documentation lives.  This MUST end in a slash.")

(defvar w3-help-menu
  (list
   "Help"
   (vector "About"
	   (list 'w3-fetch (concat w3-documentation-root "docs.html")) t)
   (vector "Manual"
	   (list 'w3-fetch (concat w3-documentation-root "w3_toc.html")) t)
   "---"
   (vector (concat "Help on v" w3-version-number)
	   (list 'w3-fetch (concat w3-documentation-root "help_on_" 
				   w3-version-number ".html")) t)
   (vector "On Window" (list 'w3-fetch (concat w3-documentation-root
					       "window-help.html")) t)
   (vector "On FAQ" (list 'w3-fetch (concat w3-documentation-root
					    "FAQ.html")) t)
   "---"
   ["On HTML" (w3-fetch "http://www.ncsa.uiuc.edu/General/Internet/WWW/HTMLPrimer.html") t]
   ["On URLs" (w3-fetch "http://www.ncsa.uiuc.edu/demoweb/url-primer.html") t]
   ["Mail Developer(s)" w3-submit-bug t])
  "The help menu for w3")

(defvar w3-navigate-menu
  '("Navigate"
    ["Back" w3-backward-in-history t]
    ["Forward" w3-forward-in-history t]
    "---"
    ["Goto Home Document" w3 t]
    ["Show History" w3-show-history-list url-keep-history]
    ["Show Hotlist" w3-show-hotlist w3-hotlist]
    ("Hotlist Maintenance"
     ["Add this document to hotlist" w3-hotlist-add-document t]
     ["Delete item from hotlist" w3-hotlist-delete t]
     ["Rename item in hotlist" w3-hotlist-rename-entry t]
     ["Append new hotlist file" w3-hotlist-append t])
    "---")
    "The navigation menu")

(defvar w3-graphlink-menu
  '(("View headers"  . url-popup-info)
    ("Dump to disk"  . w3-download-url)
    ("Copy URL"      . w3-save-url)
    ("Get image"     . w3-fetch))
  "An assoc list of function names and labels.  These will be displayed
in a popup menu when the mouse is pressed on a hyperlink.  Format is
( (label . function)), function is called with one argument, the URL of
the link.")  

(defvar w3-hyperlink-menu
  '(("View headers"  . w3-popup-info)
    ("Dump to disk"  . w3-download-url)
    ("Mail document" . w3-mail-current-document)
    ("Copy URL"      . w3-save-url)
    ("View source"   . w3-source-document)
    ("Print"         . w3-print-this-url)
    )
  "An assoc list of function names and labels.  These will be displayed
in a popup menu when the mouse is pressed on a hyperlink.  Format is
( (label . function)), function is called with one argument, the URL of
the link.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Variables internal to W3, you should not change any of these
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-acceptable-protocols-alist
  '(("Gopher"                           . "gopher")
    ("TN3270 (IBM Mainframe emulation)" . "tn3270")
    ("Interactive Telnet Session"       . "telnet")
    ("Local file or file over ftp"      . "file")
    ("File on an http server"           . "http")
    ("Usenet newsgroup/article"         . "news")
    ("Mail session"                     . "mailto"))
  "An assoc list of descriptive labels and the corresponding URL stub.")
(defvar w3-annotation-marker "<ncsa-annotation-format-1>")
(defvar w3-annotation-minor-mode nil "Whether we are in the minor mode.")
(defvar w3-annotation-minor-mode-map (make-keymap) "Keymap for annotation.")
(defconst w3-bug-address "wmperry@spry.com" "Address of current maintainer")
(defconst w3-color-display nil "Is this display color or not?")
(defconst w3-color-planes nil "How many bits of color can this display show?")
(defvar w3-continuation '(url-uncompress w3-clean-text)
  "List of functions to call to process a document completely.")
(defvar w3-current-annotation nil "URL of document we are annotating...")
(defvar w3-current-isindex nil "Is the current document a searchable index?")
(defvar w3-current-last-buffer nil "Last W3 buffer seen before this one")
(defvar w3-current-links nil "An assoc list of <LINK> tags for this doc.")
(defvar w3-current-source nil "Source of current document")
(defconst w3-default-continuation '(url-uncompress w3-clean-text) 
  "Default action to start with - cleans text and uncompresses if necessary")
(defvar w3-editing-annotation nil "Are we editing an annotation or not?")
(defvar w3-find-this-link nil "Link to go to within a document")
(defvar w3-global-history-completion-list nil
  "Assoc-list of for global history completion")
(defvar w3-hidden-forms nil "List of hidden form areas and their info")
(defvar w3-hotlist nil "Default hotlist")
(defvar w3-icon-path-cache nil "Cache of where we found icons for entities.")
(defvar w3-link-begin-regexp "<A[ \t\n]+\\([^>]*\\)>"
  "*The beginning of a url")
(defvar w3-link-end-regexp   "</A>" "*The end of a url")
(defvar w3-mode-map (make-keymap) "*Keymap to use in w3-mode")
(defvar w3-old-kill-emacs-hook nil "Old value of kill-emacs-hook, if any")
(defvar w3-personal-annotations nil "Assoc list of personal annotations")
(defvar w3-pre-data nil "Data extracted from <PRE> regions")
(defvar w3-pre-data-count 0 "# of items from <PRE> regions")
(defvar w3-print-next nil "Should we latex & print the next doc?")
(defvar w3-roman-characters "ivxLCDMVX" "Roman numerals")
(defvar w3-setup-done nil "Have we been through setup code yet?")
(defvar w3-source nil "Should we source the next document or not?")
(defvar w3-strict-width nil
  "*This variable will control how wide emacs thinks the current window is.
This is useful when working in batch mode, and (window-width) returns the
wrong value.  If the value is nil, it will use the value (window-width)
returns.")
(defvar w3-using-proxy nil "Whether we are currently using a proxy gateway.")
(defvar w3-working-buffer " *W3*" "The buffer to do all the processing in.")
(defvar w3-xmp-data nil "Data extracted from <XMP> regions")
(defvar w3-xmp-data-count 0 "# of items from <XMP> regions")
(defvar w3-zones-list nil "*List of 'zones' in a dumb emacs buffer")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; buffer-local variables to keep around when going into w3-mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-persistent-variables
  '(
    tab-stop-list
    tab-width
    url-current-content-length
    url-current-file
    url-current-mime-encoding
    url-current-mime-headers
    url-current-mime-type
    url-current-mime-viewer
    url-current-port
    url-current-server
    url-current-type
    url-current-user
    w3-current-annotation
    w3-current-isindex
    w3-current-last-buffer
    w3-current-links
    w3-current-source
    w3-delayed-images
    w3-delayed-movies
    w3-hidden-forms
    w3-zones-list
    )
  "A list of variables that should be preserved when entering w3-mode.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Syntax stuff
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar w3-parse-args-syntax-table
  (copy-syntax-table emacs-lisp-mode-syntax-table)
  "A syntax table for parsing sgml attributes")

(modify-syntax-entry ?' "\"" w3-parse-args-syntax-table)
(modify-syntax-entry ?` "\"" w3-parse-args-syntax-table)
(modify-syntax-entry ?< "(>" w3-parse-args-syntax-table)
(modify-syntax-entry ?> ")<" w3-parse-args-syntax-table)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Startup items
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(mapcar 'make-variable-buffer-local w3-persistent-variables)
(make-variable-buffer-local 'w3-annotation-minor-mode)
 
(suppress-keymap w3-mode-map)
(define-key w3-mode-map " "	   'scroll-up)
(define-key w3-mode-map "<"        'w3-start-of-document)
(define-key w3-mode-map ">"        'w3-end-of-document)
(define-key w3-mode-map "?"        'w3-help)
(define-key w3-mode-map "A"        'w3-hotlist-add-document-at-point)
(define-key w3-mode-map "B"        'w3-backward-in-history)
(define-key w3-mode-map "F"        'w3-forward-in-history)
(define-key w3-mode-map "H"	   'w3-show-hotlist)
(define-key w3-mode-map "K"        'w3-save-this-url)
(define-key w3-mode-map "P"        'w3-print-url-under-point)
(define-key w3-mode-map "Q"        'w3-leave-buffer)
(define-key w3-mode-map "S"        'w3-source-document-at-point)
(define-key w3-mode-map "U"        'w3-use-links)
(define-key w3-mode-map "V"        'w3-view-this-url)
(define-key w3-mode-map "\C-?"     'scroll-down)
(define-key w3-mode-map "\C-c\C-b" 'w3-show-history-list)
(define-key w3-mode-map "\C-c\C-v" 'w3-version)
(define-key w3-mode-map "\C-k"     'w3-save-url)
(define-key w3-mode-map "\C-o"     'w3-fetch)
(define-key w3-mode-map "\M-M"     'w3-mail-document-under-point)
(define-key w3-mode-map "\M-\C-i"  'w3-insert-this-url)
(define-key w3-mode-map "\M-m"	   'w3-mail-current-document)
(define-key w3-mode-map "\M-s"	   'w3-search)
(define-key w3-mode-map "\M-\r"    'w3-follow-inlined-image)
(define-key w3-mode-map "\r"       'w3-follow-link)
(define-key w3-mode-map "\t"       'w3-forward-link)
(define-key w3-mode-map "a"	   'w3-hotlist-add-document)
(define-key w3-mode-map "b"	   'w3-back-link)
(define-key w3-mode-map "d"        'w3-hotlist-delete)
(define-key w3-mode-map "f"	   'w3-forward-link)
(define-key w3-mode-map "g"        'w3-reload-document)
(define-key w3-mode-map "h"        'w3-use-hotlist)
(define-key w3-mode-map "k"        'w3-save-url)
(define-key w3-mode-map "l"        'w3-goto-last-buffer)
(define-key w3-mode-map "m"        'w3-complete-link)
(define-key w3-mode-map "n"        'w3-forward-link)
(define-key w3-mode-map "o"	   'w3-open-local)
(define-key w3-mode-map "p"        'w3-print-this-url)
(define-key w3-mode-map "q"	   'w3-quit)
(define-key w3-mode-map "r"        'w3-reload-document)
(define-key w3-mode-map "s"        'w3-source-document)
(define-key w3-mode-map "u"        'w3-leave-buffer)
(define-key w3-mode-map "v"	   'url-view-url)
(define-key w3-mode-map "w"        'w3-submit-bug)

(define-key w3-annotation-minor-mode-map "\C-c\C-c"
  'w3-personal-annotation-finish)

(provide 'w3-vars)
