/****************************************
 * stresc.c : translate escape sequences
 *
 * Copyright (C) 1992 Jouni Leppjrvi
 ****************************************/

#include <ctype.h>

#include "system.h"
#include "stresc.h"

#if SYS_PROTOS
static int HexCh(char c);
#endif

static int HexCh(c)
char c;
{
    static char hex[] = "0123456789abcdef";
    int i;

    if (isupper(c))
        c = tolower(c);

    for (i = 0; i < sizeof(hex) ;i++)
        if (c == hex[i])
            return(i);

    return(-1);
}

int StrEsc(s)
char *s;
{
    char *t = s;
    int i;

    while (*s)
    {
        if (*s == '\\')
        {
            s++;
            switch(*s)
            {
                case '\\':
                    s++;
                    *t++ = '\\';
                break;

                case 'n':
                    s++;
                    *t++ = '\n';
                break;

                case 'r':
                    s++;
                    *t++ = '\r';
                break;

                case 't':
                    s++;
                    *t++ = '\t';
                break;

                case 'x':
                    i = HexCh(s[1]);
                    if (i < 0)
                        return(-1);

                    *((unsigned char *) t) = i << 4;

                    i = HexCh(s[2]);
                    if (i < 0)
                        return(-1);

                    *((unsigned char *) t) += i;

                    t++;
                    s = &s[3];
                break;

                default:
                    *t++ = *s++;
            }
        }
        else if (*s == '^')
        {
            s++;
            *t++ = *s - 64;
            s++;
        }
        else
            *t++ = *s++;
    }

    *t = '\0';

    return(0);
}
