/**************************************
 * sleep.c : "short sleep"
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 *
 * A timer is used instead of (u)sleep
 * to include the processing time to
 * the wakeup interval. This might be
 * crucial with high communication speeds
 * when packet size is bigger than the
 * tty driver's output buffer, which 
 * results in blocking in tty write.
 **************************************/

#include <signal.h>
#include <sys/time.h>

#define SLEEP_INTERVAL 100

static void SigAlrm()
{
  signal(SIGALRM,SigAlrm);
}

void Sleep()
{
  static int initFlg = 0;
  struct itimerval timer;

  signal(SIGALRM,SigAlrm);

  if (!initFlg)
    {
      initFlg = 1;

      timer.it_value.tv_sec     = 0L;
      timer.it_value.tv_usec    = SLEEP_INTERVAL * 1000L;
      timer.it_interval.tv_sec  = 0L;
      timer.it_interval.tv_usec = SLEEP_INTERVAL * 1000L;
      setitimer(ITIMER_REAL,&timer,(void *) 0);  
    }
  else
    pause();

  signal(SIGALRM,SIG_IGN); /* we don't want to interrupt any syscalls .. */
}
