/**************************************
 * parse.c : config file line parser
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 **************************************/

#include <ctype.h>
#include <string.h>

#define SYS_INCL_STDLIB
#include "system.h"
#include "parse.h"

#if SYS_PROTOS
static int KwSearch(char *kw,KEYWORD *kwTbl);
#else
static int KwSearch();
#endif

static int KwSearch(kw,kwTbl)
char *kw;
KEYWORD *kwTbl;
{
    int i;

    for (i = 0; kwTbl[i].c != NULL ;i++)
        if (!stricmp(kwTbl[i].c,kw))
            return(kwTbl[i].i);

    return(-1);
}

int ParseLine(line,kwTbl,itemTbl,n)
char *line;
KEYWORD *kwTbl;
PARSE_ITEM *itemTbl;
int n;
{
    char *p;
    int i;

    p = strtok(line," \t");

    for (i = 0; p != NULL && i < n ;i++)
    {
        itemTbl[i].str = p;

        if (isdigit(p[0]))
            itemTbl[i].i = atoi(p);
        else
            itemTbl[i].i = KwSearch(p,kwTbl);

        p = strtok(NULL," \t");
    }

    return(i);
}
