/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.StandardScreenConfig;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class FinishedScreen
extends InstallerScreen {
    private JCheckBox chkLaunch;

    public FinishedScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
    }

    public void activate() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (Installer.getInstance().isRebootAfterFinish() || !ComponentConfig.isIncludedInSelectedComponents(installerConfig.getLaunchExecutable())) {
            this.chkLaunch.setSelected(false);
            this.chkLaunch.setVisible(false);
        }
        super.activate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnForward) {
            this.getWizardBase().finish();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public boolean isLaunchApplication() {
        return this.chkLaunch.isSelected();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        boolean bl = InstallerUtil.isWindows() || InstallerUtil.isMacOS();
        String string = bl ? MessageFormat.format(this.messages.getString("FinishedLabel"), this.getApplicationName()) : MessageFormat.format(this.messages.getString("FinishedLabelUnix"), this.getApplicationName());
        String string2 = this.messages.getString("ClickFinish");
        this.addDisplayTextArea(string + "\n\n" + string2, jPanel, gridBagConstraints);
        if (bl) {
            this.chkLaunch.setBackground(jPanel.getBackground());
            if (InstallerConfig.getCurrentInstance().isAllowUserStartAfterFinish()) {
                this.chkLaunch.setSelected(true);
                jPanel.add((Component)this.chkLaunch, gridBagConstraints);
            }
        }
    }

    protected String getTitle() {
        return MessageFormat.format(this.messages.getString("FinishedHeadingLabel"), this.getApplicationName());
    }

    protected String getSubTitle() {
        return "";
    }

    protected boolean isBannerPainted() {
        return true;
    }

    protected String getBannerIconFileName() {
        return "finished.png";
    }

    protected Color getBannerBackground() {
        StandardScreenConfig standardScreenConfig = InstallerConfig.getCurrentInstance().getScreenForId("finished");
        return ColorUtil.parseColor(standardScreenConfig.getBannerBackground());
    }

    protected void setupControls() {
        super.setupControls();
        String string = MessageFormat.format(this.messages.getString("RunEntryExec"), this.getApplicationName());
        this.chkLaunch = new JCheckBox(string);
        this.btnPrevious.setVisible(false);
        this.btnCancel.setEnabled(false);
        this.btnForward.setText(this.messages.getString("ButtonFinish"));
    }
}

