/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.fileinst;

import com.install4j.runtime.installer.fileinst.BackupPair;
import com.install4j.runtime.installer.fileinst.InstallFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import nanoxml.XMLElement;

public class FileLogger {
    private SortedSet createdDirs = new TreeSet(new ReverseComparator());
    private Set createdFiles = new HashSet();
    private Set replacedFiles = new HashSet();
    private static final String ELEMENT_FILELOG = "fileLog";
    private static final String ELEMENT_CREATED_FILES = "createdFiles";
    private static final String ELEMENT_CREATED_DIRS = "createdDirs";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_SHARED = "shared";
    private static final String ATTRIBUTE_DONT_UNINSTALL = "dontUninstall";

    public void write(File file, FileLogger fileLogger) throws IOException {
        Object object;
        Object object2 = fileLogger.getCreatedFilesIterator();
        while (object2.hasNext()) {
            object = (InstallFile)object2.next();
            this.addCreatedFile((InstallFile)object);
        }
        object2 = fileLogger.getCreatedDirsIterator();
        while (object2.hasNext()) {
            object = (InstallFile)object2.next();
            this.addCreatedDir((InstallFile)object);
        }
        object2 = new XMLElement();
        ((XMLElement)object2).setName(ELEMENT_FILELOG);
        object = new XMLElement();
        ((XMLElement)object).setName(ELEMENT_CREATED_FILES);
        ((XMLElement)object2).addChild((XMLElement)object);
        this.addEntries((XMLElement)object, this.createdFiles);
        XMLElement xMLElement = new XMLElement();
        xMLElement.setName(ELEMENT_CREATED_DIRS);
        ((XMLElement)object2).addChild(xMLElement);
        this.addEntries(xMLElement, this.createdDirs);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        ((XMLElement)object2).write(outputStreamWriter);
        outputStreamWriter.close();
    }

    private void addEntries(XMLElement xMLElement, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.addEntry(xMLElement, file);
        }
    }

    private void addEntry(XMLElement xMLElement, File file) {
        XMLElement xMLElement2 = new XMLElement();
        xMLElement2.setName(ELEMENT_ENTRY);
        xMLElement2.setAttribute(ATTRIBUTE_NAME, file.getAbsolutePath());
        boolean bl = false;
        boolean bl2 = false;
        if (file instanceof InstallFile) {
            InstallFile installFile = (InstallFile)file;
            bl2 = installFile.isDontUninstall();
            bl = installFile.isShared();
        }
        xMLElement2.setAttribute(ATTRIBUTE_DONT_UNINSTALL, String.valueOf(bl2));
        xMLElement2.setAttribute(ATTRIBUTE_SHARED, String.valueOf(bl));
        xMLElement.addChild(xMLElement2);
    }

    public void read(File file) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(inputStreamReader);
        inputStreamReader.close();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            if (xMLElement2.getName().equals(ELEMENT_CREATED_FILES)) {
                this.readEntries(xMLElement2, this.createdFiles);
                continue;
            }
            if (!xMLElement2.getName().equals(ELEMENT_CREATED_DIRS)) continue;
            this.readEntries(xMLElement2, this.createdDirs);
        }
    }

    private void readEntries(XMLElement xMLElement, Collection collection) {
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            collection.add(new InstallFile(xMLElement2.getStringAttribute(ATTRIBUTE_NAME), (boolean)Boolean.valueOf(xMLElement2.getStringAttribute(ATTRIBUTE_SHARED, "false")), (boolean)Boolean.valueOf(xMLElement2.getStringAttribute(ATTRIBUTE_DONT_UNINSTALL, "false"))));
        }
    }

    public Iterator getCreatedDirsIterator() {
        return this.createdDirs.iterator();
    }

    public Iterator getCreatedFilesIterator() {
        return this.createdFiles.iterator();
    }

    public Iterator getReplacedFilesIterator() {
        return this.replacedFiles.iterator();
    }

    public int getCreatedDirsSize() {
        return this.createdDirs.size();
    }

    public int getCreatedFilesSize() {
        return this.createdFiles.size();
    }

    public int getReplacedFilesSize() {
        return this.replacedFiles.size();
    }

    public void addCreatedDir(InstallFile installFile) {
        installFile = new InstallFile(installFile.getAbsoluteFile(), installFile.isShared(), installFile.isDontUninstall());
        this.createdDirs.add(installFile);
    }

    public void addCreatedFile(InstallFile installFile) {
        installFile = new InstallFile(installFile.getAbsoluteFile(), installFile.isShared(), installFile.isDontUninstall());
        this.createdFiles.add(installFile);
    }

    public void addReplacedFile(BackupPair backupPair) {
        this.replacedFiles.add(backupPair);
    }

    public boolean containsCreatedFile(File file) {
        return this.createdFiles.contains(file.getAbsoluteFile());
    }

    public boolean containsCreatedDir(File file) {
        return this.createdDirs.contains(file.getAbsoluteFile());
    }

    private static class ReverseComparator
    implements Comparator {
        private ReverseComparator() {
        }

        public int compare(Object object, Object object2) {
            return -((Comparable)object).compareTo(object2);
        }
    }
}

