/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.runtime.installer.InstallationProperties;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MenuEntryConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.platform.UserInfo;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.util.FileResourceBundle;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

class Common {
    Common() {
    }

    public static boolean checkAdmin() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig.isAdminRequired() && !UserInfo.isAdminUser()) {
            GUIHelper.showMessage(null, Messages.getMessages().getString("AdminPrivilegesRequired"), 0);
            return false;
        }
        return true;
    }

    public static boolean checkRunningProcesses(InstallationProperties installationProperties, boolean bl, String string) {
        FileResourceBundle fileResourceBundle;
        String string2;
        int n;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        do {
            List list;
            if ((list = Common.getRunningProcesses(installationProperties)).size() == 0) {
                return true;
            }
            if (bl) {
                return false;
            }
            fileResourceBundle = Messages.getMessages();
            string2 = MessageFormat.format(fileResourceBundle.getString(string), InstallerConfig.getCurrentInstance().getApplicationName());
        } while ((n = GUIHelper.showOptionDialog(null, string2, new String[]{fileResourceBundle.getString("ButtonOK"), fileResourceBundle.getString("ButtonCancel")}, 2)) != 1);
        return false;
    }

    private static List getRunningProcesses(InstallationProperties installationProperties) {
        ArrayList<File> arrayList;
        block9: {
            Object object;
            arrayList = new ArrayList<File>();
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            ArrayList arrayList2 = new ArrayList(installerConfig.getFileOptionsConfig().getLaunchers());
            Object object2 = installerConfig.getServices().iterator();
            while (object2.hasNext()) {
                object = (ServiceConfig)object2.next();
                arrayList2.remove(((MenuEntryConfig)object).getFile());
            }
            try {
                String[] stringArray;
                object2 = installationProperties.getCanonicalFilePropertySet("launcher");
                object = new RunningProcessThread();
                ((Thread)object).start();
                try {
                    ((Thread)object).join(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (((Thread)object).isAlive()) {
                    ((Thread)object).stop();
                }
                if ((stringArray = ((RunningProcessThread)object).getModules()) == null) break block9;
                for (int i = 0; i < stringArray.length; ++i) {
                    File file;
                    try {
                        file = new File(stringArray[i]).getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    if (!object2.contains(file)) continue;
                    arrayList.add(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static class RunningProcessThread
    extends Thread {
        private String[] modules = null;

        public RunningProcessThread() {
            super("running-process-thread");
            this.setDaemon(true);
            this.setPriority(3);
        }

        public String[] getModules() {
            return this.modules;
        }

        public void run() {
            this.modules = Misc.getRunningUserProcesses();
        }
    }
}

