/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.jmx;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpServer;
import org.mortbay.http.jmx.HttpServerMBean;
import org.mortbay.jetty.Server;
import org.mortbay.log.LogFactory;

public class ServerMBean
extends HttpServerMBean {
    private static Log log = LogFactory.getLog((Class)ServerMBean.class);
    private Server _jettyServer;
    private String _configuration;

    public ServerMBean(Server server) throws MBeanException, InstanceNotFoundException {
        super((HttpServer)server);
    }

    public ServerMBean() throws MBeanException, InstanceNotFoundException {
        this(new Server());
    }

    public ServerMBean(String string) throws IOException, MBeanException, InstanceNotFoundException {
        this(new Server());
        this._configuration = string;
    }

    protected ObjectName newObjectName(MBeanServer mBeanServer) {
        return this.uniqueObjectName(mBeanServer, ServerMBean.getDefaultDomain() + ":Server=");
    }

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("configuration");
        this.defineAttribute("rootWebApp");
        this.defineAttribute("webApplicationConfigurationClassNames");
        this.defineOperation("addWebApplication", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("addWebApplication", new String[]{"java.lang.String", "java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("addWebApplications", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this._jettyServer = (Server)this.getManagedResource();
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
        if (bl.booleanValue() && this._configuration != null) {
            try {
                this._jettyServer.configure(this._configuration);
                this._jettyServer.start();
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeregister() {
        this._configuration = null;
        try {
            if (null != this._jettyServer) {
                this._jettyServer.stop();
            }
        }
        catch (Exception exception) {
            log.warn((Object)exception);
        }
        finally {
            super.postDeregister();
        }
    }
}

