/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.util.URI;

public class URLResource
extends Resource {
    private static Log log = LogFactory.getLog(URLResource.class);
    protected URL _url;
    protected String _urlString;
    protected transient URLConnection _connection;
    protected transient InputStream _in = null;

    protected URLResource(URL uRL, URLConnection uRLConnection) {
        this._url = uRL;
        this._urlString = this._url.toString();
        this._connection = uRLConnection;
    }

    protected synchronized boolean checkConnection() {
        if (this._connection == null) {
            try {
                this._connection = this._url.openConnection();
            }
            catch (IOException iOException) {
                LogSupport.ignore(log, iOException);
            }
        }
        return this._connection != null;
    }

    public synchronized void release() {
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException iOException) {
                LogSupport.ignore(log, iOException);
            }
            this._in = null;
        }
        if (this._connection != null) {
            this._connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        try {
            URLResource uRLResource = this;
            synchronized (uRLResource) {
                if (this.checkConnection() && this._in == null) {
                    this._in = this._connection.getInputStream();
                }
            }
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
        }
        return this._in != null;
    }

    public boolean isDirectory() {
        return this.exists() && this._url.toString().endsWith("/");
    }

    public long lastModified() {
        if (this.checkConnection()) {
            return this._connection.getLastModified();
        }
        return -1L;
    }

    public long length() {
        if (this.checkConnection()) {
            return this._connection.getContentLength();
        }
        return -1L;
    }

    public URL getURL() {
        return this._url;
    }

    public File getFile() throws IOException {
        Permission permission;
        if (this.checkConnection() && (permission = this._connection.getPermission()) instanceof FilePermission) {
            return new File(permission.getName());
        }
        try {
            return new File(this._url.getFile());
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
            return null;
        }
    }

    public String getName() {
        return this._url.toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.checkConnection()) {
            throw new IOException("Invalid resource");
        }
        try {
            if (this._in != null) {
                InputStream inputStream = this._in;
                this._in = null;
                InputStream inputStream2 = inputStream;
                return inputStream2;
            }
            InputStream inputStream = this._connection.getInputStream();
            return inputStream;
        }
        finally {
            this._connection = null;
        }
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        throw new IOException("Output not supported");
    }

    public boolean delete() throws SecurityException {
        throw new SecurityException("Delete not supported");
    }

    public boolean renameTo(Resource resource) throws SecurityException {
        throw new SecurityException("RenameTo not supported");
    }

    public String[] list() {
        return null;
    }

    public Resource addPath(String string) throws IOException, MalformedURLException {
        if (string == null) {
            return null;
        }
        string = URI.canonicalPath(string);
        return URLResource.newResource(URI.addPaths(this._url.toExternalForm(), string));
    }

    public String toString() {
        return this._urlString;
    }

    public int hashCode() {
        return this._url.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof URLResource && this._url.equals(((URLResource)object)._url);
    }
}

