/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LogSupport;
import org.mortbay.util.ThreadPool;

public abstract class ThreadedServer
extends ThreadPool {
    private static Log log = LogFactory.getLog(ThreadedServer.class);
    private InetAddrPort _address = null;
    private int _soTimeOut = -1;
    private int _lingerTimeSecs = 30;
    private boolean _tcpNoDelay = true;
    private int _acceptQueueSize = 0;
    private int _acceptors = 1;
    private transient Acceptor[] _acceptor;
    private transient ServerSocket _listen = null;
    private transient boolean _running = false;

    public ThreadedServer() {
    }

    public ServerSocket getServerSocket() {
        return this._listen;
    }

    public ThreadedServer(int n) {
        this.setInetAddrPort(new InetAddrPort(n));
    }

    public ThreadedServer(InetAddress inetAddress, int n) {
        this.setInetAddrPort(new InetAddrPort(inetAddress, n));
    }

    public ThreadedServer(String string, int n) throws UnknownHostException {
        this.setInetAddrPort(new InetAddrPort(string, n));
    }

    public ThreadedServer(InetAddrPort inetAddrPort) {
        this.setInetAddrPort(inetAddrPort);
    }

    public synchronized void setInetAddrPort(InetAddrPort inetAddrPort) {
        if (this._address != null && this._address.equals(inetAddrPort)) {
            return;
        }
        if (this.isStarted()) {
            log.warn((Object)(this + " is started"));
        }
        this._address = inetAddrPort;
    }

    public InetAddrPort getInetAddrPort() {
        if (this._address == null) {
            return null;
        }
        return new InetAddrPort(this._address);
    }

    public synchronized void setHost(String string) throws UnknownHostException {
        if (this._address != null && this._address.getHost() != null && this._address.getHost().equals(string)) {
            return;
        }
        if (this.isStarted()) {
            log.warn((Object)(this + " is started"));
        }
        if (this._address == null) {
            this._address = new InetAddrPort(string, 0);
        } else {
            this._address.setHost(string);
        }
    }

    public String getHost() {
        if (this._address == null || this._address.getInetAddress() == null) {
            return null;
        }
        return this._address.getHost();
    }

    public synchronized void setInetAddress(InetAddress inetAddress) {
        if (this._address != null && this._address.getInetAddress() != null && this._address.getInetAddress().equals(inetAddress)) {
            return;
        }
        if (this.isStarted()) {
            log.warn((Object)(this + " is started"));
        }
        if (this._address == null) {
            this._address = new InetAddrPort(inetAddress, 0);
        } else {
            this._address.setInetAddress(inetAddress);
        }
    }

    public InetAddress getInetAddress() {
        if (this._address == null) {
            return null;
        }
        return this._address.getInetAddress();
    }

    public synchronized void setPort(int n) {
        if (this._address != null && this._address.getPort() == n) {
            return;
        }
        if (this.isStarted()) {
            log.warn((Object)(this + " is started"));
        }
        if (this._address == null) {
            this._address = new InetAddrPort(n);
        } else {
            this._address.setPort(n);
        }
    }

    public int getPort() {
        if (this._address == null) {
            return 0;
        }
        return this._address.getPort();
    }

    public void setMaxReadTimeMs(int n) {
        log.warn((Object)"setMaxReadTimeMs is deprecated. Use setMaxIdleTimeMs()");
    }

    public int getMaxReadTimeMs() {
        return this.getMaxIdleTimeMs();
    }

    public void setLingerTimeSecs(int n) {
        this._lingerTimeSecs = n;
    }

    public int getLingerTimeSecs() {
        return this._lingerTimeSecs;
    }

    public void setTcpNoDelay(boolean bl) {
        this._tcpNoDelay = bl;
    }

    public boolean getTcpNoDelay() {
        return this._tcpNoDelay;
    }

    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int n) {
        this._acceptQueueSize = n;
    }

    public void setAcceptorThreads(int n) {
        this._acceptors = n;
    }

    public int getAcceptorThreads() {
        return this._acceptors;
    }

    protected void handleConnection(InputStream inputStream, OutputStream outputStream) {
        throw new Error("Either handlerConnection must be overridden");
    }

    protected void handleConnection(Socket socket) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handle " + socket));
        }
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        this.handleConnection(inputStream, outputStream);
        outputStream.flush();
        inputStream = null;
        outputStream = null;
        socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle(Object object) {
        block9: {
            Socket socket = (Socket)object;
            if (this._tcpNoDelay) {
                socket.setTcpNoDelay(true);
            }
            this.handleConnection(socket);
            Object var5_3 = null;
            try {
                socket.close();
            }
            catch (Exception exception) {
                log.debug((Object)"Connection problem", (Throwable)exception);
            }
            break block9;
            {
                catch (Exception exception) {
                    log.debug((Object)"Connection problem", (Throwable)exception);
                    Object var5_4 = null;
                    try {
                        socket.close();
                    }
                    catch (Exception exception2) {
                        log.debug((Object)"Connection problem", (Throwable)exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    log.debug((Object)"Connection problem", (Throwable)exception);
                }
                throw throwable;
            }
        }
    }

    protected ServerSocket newServerSocket(InetAddrPort inetAddrPort, int n) throws IOException {
        if (inetAddrPort == null) {
            return new ServerSocket(0, n);
        }
        return new ServerSocket(inetAddrPort.getPort(), n, inetAddrPort.getInetAddress());
    }

    protected Socket acceptSocket(ServerSocket serverSocket, int n) {
        return this.acceptSocket(n);
    }

    protected Socket acceptSocket(int n) {
        try {
            Socket socket = null;
            if (this._listen != null) {
                if (this._soTimeOut != n) {
                    this._soTimeOut = n;
                    this._listen.setSoTimeout(this._soTimeOut);
                }
                socket = this._listen.accept();
                try {
                    if (this.getMaxIdleTimeMs() >= 0) {
                        socket.setSoTimeout(this.getMaxIdleTimeMs());
                    }
                    if (this._lingerTimeSecs >= 0) {
                        socket.setSoLinger(true, this._lingerTimeSecs);
                    } else {
                        socket.setSoLinger(false, 0);
                    }
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
            }
            return socket;
        }
        catch (SocketException socketException) {
            LogSupport.ignore(log, socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            LogSupport.ignore(log, interruptedIOException);
        }
        catch (IOException iOException) {
            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
        }
        return null;
    }

    public void open() throws IOException {
        if (this._listen == null) {
            this._listen = this.newServerSocket(this._address, this._acceptQueueSize);
            if (this._address == null) {
                this._address = new InetAddrPort(this._listen.getInetAddress(), this._listen.getLocalPort());
            } else {
                if (this._address.getInetAddress() == null) {
                    this._address.setInetAddress(this._listen.getInetAddress());
                }
                if (this._address.getPort() == 0) {
                    this._address.setPort(this._listen.getLocalPort());
                }
            }
            this._soTimeOut = this.getMaxIdleTimeMs();
            if (this._soTimeOut >= 0) {
                this._listen.setSoTimeout(this._soTimeOut);
            }
        }
    }

    public synchronized void start() throws Exception {
        try {
            if (this.isStarted()) {
                return;
            }
            this.open();
            this._running = true;
            this._acceptor = new Acceptor[this._acceptors];
            for (int i = 0; i < this._acceptor.length; ++i) {
                this._acceptor[i] = new Acceptor();
                this._acceptor[i].setDaemon(this.isDaemon());
                this._acceptor[i].start();
            }
            super.start();
        }
        catch (Exception exception) {
            log.warn((Object)("Failed to start: " + this));
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws InterruptedException {
        ThreadedServer threadedServer;
        ThreadedServer threadedServer2 = this;
        synchronized (threadedServer2) {
            Acceptor acceptor;
            int n;
            this._running = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("closing " + this._listen));
            }
            try {
                if (this._listen != null) {
                    this._listen.close();
                }
                this._listen = null;
            }
            catch (IOException iOException) {
                log.warn((Object)"EXCEPTION ", (Throwable)iOException);
            }
            Thread.yield();
            for (n = 0; this._acceptor != null && n < this._acceptor.length; ++n) {
                acceptor = this._acceptor[n];
                if (acceptor == null) continue;
                acceptor.interrupt();
            }
            Thread.sleep(100L);
            for (n = 0; this._acceptor != null && n < this._acceptor.length; ++n) {
                acceptor = this._acceptor[n];
                if (acceptor == null) continue;
                acceptor.forceStop();
                this._acceptor[n] = null;
            }
        }
        try {
            try {
                super.stop();
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                Object var6_7 = null;
                ThreadedServer threadedServer3 = this;
                synchronized (threadedServer3) {
                    this._acceptor = null;
                    return;
                }
            }
            Object var6_6 = null;
            threadedServer = this;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ThreadedServer threadedServer4 = this;
            synchronized (threadedServer4) {
                this._acceptor = null;
                throw throwable;
            }
        }
        synchronized (threadedServer) {
            this._acceptor = null;
            return;
        }
    }

    protected void stopJob(Thread thread, Object object) {
        if (object instanceof Socket) {
            try {
                ((Socket)object).close();
            }
            catch (Exception exception) {
                LogSupport.ignore(log, exception);
            }
        }
        super.stopJob(thread, object);
    }

    public String toString() {
        if (this._address == null) {
            return this.getName() + "@0.0.0.0:0";
        }
        if (this._listen != null) {
            return this.getName() + "@" + this._listen.getInetAddress().getHostAddress() + ":" + this._listen.getLocalPort();
        }
        return this.getName() + "@" + this.getInetAddrPort();
    }

    private class Acceptor
    extends Thread {
        private Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadedServer threadedServer = ThreadedServer.this;
            try {
                this.setName("Acceptor " + ThreadedServer.this._listen);
                while (ThreadedServer.this._running) {
                    try {
                        Socket socket = ThreadedServer.this.acceptSocket(ThreadedServer.this._soTimeOut);
                        if (socket == null) continue;
                        if (ThreadedServer.this._running) {
                            threadedServer.run(socket);
                            continue;
                        }
                        socket.close();
                    }
                    catch (Throwable throwable) {
                        if (ThreadedServer.this._running) {
                            log.warn((Object)"EXCEPTION ", throwable);
                            continue;
                        }
                        log.debug((Object)"EXCEPTION ", throwable);
                    }
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (ThreadedServer.this._running) {
                    log.warn((Object)("Stopping " + this.getName()));
                } else {
                    log.info((Object)("Stopping " + this.getName()));
                }
                ThreadedServer threadedServer2 = threadedServer;
                synchronized (threadedServer2) {
                    if (ThreadedServer.this._acceptor != null) {
                        for (int i = 0; i < ThreadedServer.this._acceptor.length; ++i) {
                            if (ThreadedServer.this._acceptor[i] != this) continue;
                            ((ThreadedServer)ThreadedServer.this)._acceptor[i] = null;
                        }
                    }
                    threadedServer.notifyAll();
                }
                throw throwable;
            }
            if (ThreadedServer.this._running) {
                log.warn((Object)("Stopping " + this.getName()));
            } else {
                log.info((Object)("Stopping " + this.getName()));
            }
            ThreadedServer threadedServer3 = threadedServer;
            synchronized (threadedServer3) {
                if (ThreadedServer.this._acceptor != null) {
                    for (int i = 0; i < ThreadedServer.this._acceptor.length; ++i) {
                        if (ThreadedServer.this._acceptor[i] != this) continue;
                        ((ThreadedServer)ThreadedServer.this)._acceptor[i] = null;
                    }
                }
                threadedServer.notifyAll();
            }
        }

        void forceStop() {
            block5: {
                if (ThreadedServer.this._listen != null && ThreadedServer.this._address != null) {
                    InetAddress inetAddress = ThreadedServer.this._address.getInetAddress();
                    try {
                        if (inetAddress == null || inetAddress.toString().startsWith("0.0.0.0")) {
                            inetAddress = InetAddress.getByName("127.0.0.1");
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Self connect to close listener " + inetAddress + ":" + ThreadedServer.this._address.getPort()));
                        }
                        Socket socket = new Socket(inetAddress, ThreadedServer.this._address.getPort());
                        Thread.yield();
                        socket.close();
                        Thread.yield();
                    }
                    catch (IOException iOException) {
                        if (!log.isDebugEnabled()) break block5;
                        log.debug((Object)("problem stopping acceptor " + inetAddress + ": "), (Throwable)iOException);
                    }
                }
            }
        }
    }
}

