/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class TempByteHolder {
    byte[] _memory_buffer = null;
    boolean _file_mode = false;
    int _window_size = 0;
    int _window_low = 0;
    int _window_high = 0;
    int _file_high = 0;
    int _write_pos = 0;
    int _read_pos = 0;
    int _file_pos = -1;
    int _mark_pos = 0;
    OutputStream _output_stream = new OutputStream();
    InputStream _input_stream = null;
    File _temp_directory = null;
    File _tempfilef = null;
    RandomAccessFile _tempfile = null;

    public TempByteHolder(int n) {
        this(new byte[n], 0, 0);
    }

    public TempByteHolder(byte[] byArray) {
        this(byArray, 0, 0);
    }

    public TempByteHolder(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this._window_size = byArray.length;
        if (n < 0 || n > this._window_size) {
            throw new IllegalArgumentException("Bad prefilled data offset");
        }
        if (n + n2 > this._window_size || n2 < 0) {
            throw new IllegalArgumentException("Bad prefilled data size");
        }
        this._memory_buffer = byArray;
        this._write_pos = n2;
        this._window_low = -n;
        this._window_high = this._window_size - n;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void clear() {
        this._file_mode = false;
        this._write_pos = 0;
        this._read_pos = 0;
        this._window_low = 0;
        this._window_high = this._window_size;
        this._file_high = 0;
        this._mark_pos = 0;
    }

    public void close() throws IOException {
        this.clear();
        if (this._tempfile != null) {
            this._tempfile.close();
            this._tempfile = null;
            this._tempfilef.delete();
            this._tempfilef = null;
        }
    }

    public void seek(int n) throws IOException {
        if (n > this._write_pos || n < 0) {
            throw new IOException("bad seek offset");
        }
        this._read_pos = n;
    }

    public void truncate(int n) throws IOException {
        if (n < 0 || n > this._write_pos) {
            throw new IOException("bad truncate offset");
        }
        if (this._read_pos > n) {
            this._read_pos = n;
        }
        if (this._mark_pos > n) {
            this._mark_pos = n;
        }
        this._write_pos = n;
        if (this._file_high > n) {
            this._file_high = n;
        }
        this.moveWindow(this._write_pos);
    }

    public void setTempDirectory(File file) throws IOException {
        File file2 = file.getCanonicalFile();
        if (file2.isDirectory()) {
            this._temp_directory = file2;
        }
    }

    public int getLength() {
        return this._write_pos;
    }

    public boolean isLarge() {
        return this._file_mode;
    }

    public byte[] getBytes() {
        if (this._file_mode) {
            throw new IllegalStateException("data too large");
        }
        return this._memory_buffer;
    }

    public String getString(String string) throws UnsupportedEncodingException {
        if (this._file_mode) {
            throw new IllegalStateException("data too large");
        }
        return new String(this._memory_buffer, 0, this._write_pos, string);
    }

    public java.io.OutputStream getOutputStream() {
        return this._output_stream;
    }

    public java.io.InputStream getInputStream() {
        if (this._input_stream == null) {
            this._input_stream = new InputStream();
        }
        return this._input_stream;
    }

    public void writeTo(java.io.OutputStream outputStream) throws IOException {
        this.writeTo(outputStream, 0, this.getLength());
    }

    public void writeTo(java.io.OutputStream outputStream, int n, int n2) throws IOException {
        int n3 = TempByteHolder.min(n2, this._write_pos - n);
        int n4 = n;
        if (n3 > 0) {
            while (n3 >= this._window_size) {
                this.moveWindow(n4);
                outputStream.write(this._memory_buffer, 0, this._window_size);
                n3 -= this._window_size;
                n4 += this._window_size;
            }
            if (n3 > 0) {
                this.moveWindow(n4);
                outputStream.write(this._memory_buffer, 0, n3);
            }
        }
    }

    public void readFrom(java.io.InputStream inputStream) throws IOException {
        int n = 0;
        do {
            this._write_pos += n;
            this.moveWindow(this._write_pos);
        } while ((n = inputStream.read(this._memory_buffer)) != -1);
    }

    private void createTempFile() throws IOException {
        this._tempfilef = File.createTempFile("org.mortbay.util.TempByteHolder-", ".tmp", this._temp_directory).getCanonicalFile();
        this._tempfilef.deleteOnExit();
        this._tempfile = new RandomAccessFile(this._tempfilef, "rw");
    }

    private void writeToTempFile(int n, byte[] byArray, int n2, int n3) throws IOException {
        if (this._tempfile == null) {
            this.createTempFile();
            this._file_pos = -1;
        }
        this._file_mode = true;
        if (n != this._file_pos) {
            this._tempfile.seek(n);
        }
        this._tempfile.write(byArray, n2, n3);
        this._file_pos = n + n3;
        this._file_high = TempByteHolder.max(this._file_high, this._file_pos);
    }

    private void readFromTempFile(int n, byte[] byArray, int n2, int n3) throws IOException {
        if (this._file_pos != n) {
            this._tempfile.seek(n);
        }
        this._tempfile.readFully(byArray, n2, n3);
        this._file_pos = n + n3;
    }

    private void moveWindow(int n) throws IOException {
        if (n != this._window_low) {
            int n2;
            int n3;
            int n4;
            int n5 = n + this._window_size;
            int n6 = this._file_high;
            int n7 = this._write_pos;
            int n8 = this._write_pos - this._file_high;
            if (n8 > 0 && (n6 < n || n7 > n5)) {
                this.writeToTempFile(n6, this._memory_buffer, n6 - this._window_low, n8);
            }
            int n9 = TempByteHolder.max(n, this._window_low);
            int n10 = TempByteHolder.min(this._write_pos, this._window_high, n5);
            int n11 = n10 - n9;
            if (n11 > 0) {
                System.arraycopy(this._memory_buffer, n9 - this._window_low, this._memory_buffer, n9 - n, n11);
            }
            if (n9 > n) {
                n4 = n;
                n3 = TempByteHolder.min(n9, n5);
                n2 = n3 - n4;
                if (n2 > 0) {
                    this.readFromTempFile(n4, this._memory_buffer, n4 - n, n2);
                }
            }
            if (n10 < n5) {
                n4 = TempByteHolder.max(n10, n);
                n3 = TempByteHolder.min(n5, this._file_high);
                n2 = n3 - n4;
                if (n2 > 0) {
                    this.readFromTempFile(n4, this._memory_buffer, n4 - n, n2);
                }
            }
            this._window_low = n;
            this._window_high = n5;
        }
    }

    private static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static int min(int n, int n2, int n3) {
        int n4 = n;
        if (n4 > n2) {
            n4 = n2;
        }
        if (n4 > n3) {
            n4 = n3;
        }
        return n4;
    }

    private static boolean contained(int n, int n2, int n3, int n4) {
        return n >= n3 && n2 <= n4;
    }

    class InputStream
    extends java.io.InputStream {
        InputStream() {
        }

        public int read() throws IOException {
            int n = -1;
            if (!TempByteHolder.contained(TempByteHolder.this._read_pos, TempByteHolder.this._read_pos + 1, TempByteHolder.this._window_low, TempByteHolder.this._window_high)) {
                TempByteHolder.this.moveWindow(TempByteHolder.this._read_pos);
            }
            if (TempByteHolder.this._write_pos > TempByteHolder.this._read_pos) {
                n = TempByteHolder.this._memory_buffer[TempByteHolder.this._read_pos - TempByteHolder.this._window_low] & 0xFF;
                ++TempByteHolder.this._read_pos;
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = TempByteHolder.min(n2, TempByteHolder.this._write_pos - TempByteHolder.this._read_pos);
            if (n3 > 0) {
                if (n3 >= TempByteHolder.this._window_size) {
                    TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                    TempByteHolder.this.readFromTempFile(TempByteHolder.this._read_pos, byArray, n, n3);
                } else {
                    int n4 = TempByteHolder.this._read_pos;
                    int n5 = n4 + n3;
                    if (!TempByteHolder.contained(n4, n5, TempByteHolder.this._window_low, TempByteHolder.this._window_high)) {
                        TempByteHolder.this.moveWindow(TempByteHolder.this._read_pos);
                    }
                    System.arraycopy(TempByteHolder.this._memory_buffer, TempByteHolder.this._read_pos - TempByteHolder.this._window_low, byArray, n, n3);
                }
                TempByteHolder.this._read_pos += n3;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            if (l < 0L || l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            int n = (int)l;
            if (n + TempByteHolder.this._read_pos > TempByteHolder.this._write_pos) {
                n = TempByteHolder.this._write_pos - TempByteHolder.this._read_pos;
            }
            TempByteHolder.this._read_pos += n;
            TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
            return n;
        }

        public int available() throws IOException {
            return TempByteHolder.this._write_pos - TempByteHolder.this._read_pos;
        }

        public void mark(int n) {
            TempByteHolder.this._mark_pos = TempByteHolder.this._read_pos;
        }

        public void reset() throws IOException {
            TempByteHolder.this._read_pos = TempByteHolder.this._mark_pos;
        }

        public boolean markSupported() {
            return true;
        }
    }

    class OutputStream
    extends java.io.OutputStream {
        OutputStream() {
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            boolean bl;
            boolean bl2;
            int n3 = TempByteHolder.this._write_pos + n2;
            boolean bl3 = bl2 = TempByteHolder.this._write_pos >= TempByteHolder.this._window_low && TempByteHolder.this._write_pos < TempByteHolder.this._window_high;
            if (!bl2) {
                TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
            }
            boolean bl4 = bl = n3 <= TempByteHolder.this._window_high;
            if (bl) {
                System.arraycopy(byArray, n, TempByteHolder.this._memory_buffer, TempByteHolder.this._write_pos - TempByteHolder.this._window_low, n2);
                TempByteHolder.this._write_pos = n3;
            } else {
                int n4 = n3 - TempByteHolder.this._window_high;
                if (n4 < TempByteHolder.this._window_size) {
                    int n5 = TempByteHolder.this._window_high - TempByteHolder.this._write_pos;
                    int n6 = n2 - n5;
                    System.arraycopy(byArray, n, TempByteHolder.this._memory_buffer, TempByteHolder.this._write_pos - TempByteHolder.this._window_low, n5);
                    TempByteHolder.this._write_pos = TempByteHolder.this._window_high;
                    TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                    System.arraycopy(byArray, n + n5, TempByteHolder.this._memory_buffer, 0, n6);
                    TempByteHolder.this._write_pos = n3;
                } else {
                    int n7 = TempByteHolder.this._window_high - TempByteHolder.this._write_pos;
                    int n8 = n2 - n7;
                    if (n7 == TempByteHolder.this._window_size) {
                        TempByteHolder.this.writeToTempFile(TempByteHolder.this._write_pos, byArray, n, n2);
                        TempByteHolder.this._write_pos = n3;
                        TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                    } else {
                        if (n7 > 0) {
                            System.arraycopy(byArray, n, TempByteHolder.this._memory_buffer, TempByteHolder.this._write_pos - TempByteHolder.this._window_low, n7);
                            TempByteHolder.this._write_pos += n7;
                            TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                        }
                        TempByteHolder.this.writeToTempFile(TempByteHolder.this._write_pos, byArray, n + n7, n8);
                        TempByteHolder.this._write_pos = n3;
                        TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                    }
                }
            }
        }

        public void write(int n) throws IOException {
            if (TempByteHolder.this._write_pos >= TempByteHolder.this._window_high || TempByteHolder.this._write_pos < TempByteHolder.this._window_low) {
                TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
            }
            TempByteHolder.this._memory_buffer[TempByteHolder.this._write_pos - TempByteHolder.this._window_low] = (byte)(n & 0xFF);
            ++TempByteHolder.this._write_pos;
        }

        public void flush() throws IOException {
            TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
        }

        public void close() throws IOException {
        }
    }
}

