/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.JarResource;
import org.mortbay.util.LogSupport;

class JarFileResource
extends JarResource {
    private static Log log = LogFactory.getLog(JarFileResource.class);
    transient JarFile _jarFile;
    transient File _file;
    transient String[] _list;
    transient JarEntry _entry;
    transient boolean _directory;
    transient String _jarUrl;
    transient String _path;
    transient boolean _exists;

    JarFileResource(URL uRL) {
        super(uRL);
    }

    public synchronized void release() {
        this._list = null;
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnection() {
        try {
            super.checkConnection();
            Object var2_1 = null;
            if (this._jarConnection == null) {
                this._entry = null;
                this._file = null;
                this._jarFile = null;
                this._list = null;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this._jarConnection == null) {
                this._entry = null;
                this._file = null;
                this._jarFile = null;
                this._list = null;
            }
            throw throwable;
        }
        return this._jarFile != null;
    }

    protected void newConnection() throws IOException {
        super.newConnection();
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        this._list = null;
        int n = this._urlString.indexOf("!/");
        this._jarUrl = this._urlString.substring(0, n + 2);
        this._path = this._urlString.substring(n + 2);
        if (this._path.length() == 0) {
            this._path = null;
        }
        this._jarFile = this._jarConnection.getJarFile();
        this._file = new File(this._jarFile.getName());
    }

    public boolean exists() {
        if (this._exists) {
            return true;
        }
        if (this._urlString.endsWith("!/")) {
            String string = this._urlString.substring(4, this._urlString.length() - 2);
            try {
                return JarFileResource.newResource(string).exists();
            }
            catch (Exception exception) {
                LogSupport.ignore(log, exception);
                return false;
            }
        }
        boolean bl = this.checkConnection();
        if (this._jarUrl != null && this._path == null) {
            this._directory = bl;
            return true;
        }
        JarFile jarFile = null;
        if (bl) {
            jarFile = this._jarFile;
        } else {
            try {
                jarFile = ((JarURLConnection)new URL(this._jarUrl).openConnection()).getJarFile();
            }
            catch (Exception exception) {
                LogSupport.ignore(log, exception);
            }
        }
        if (jarFile != null && this._entry == null && !this._directory) {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName().replace('\\', '/');
                if (string.equals(this._path)) {
                    this._entry = jarEntry;
                    this._directory = this._path.endsWith("/");
                    break;
                }
                if (this._path.endsWith("/")) {
                    if (!string.startsWith(this._path)) continue;
                    this._directory = true;
                    break;
                }
                if (!string.startsWith(this._path) || string.length() <= this._path.length() || string.charAt(this._path.length()) != '/') continue;
                this._directory = true;
                break;
            }
        }
        this._exists = this._directory || this._entry != null;
        return this._exists;
    }

    public boolean isDirectory() {
        return this._urlString.endsWith("/") || this.exists() && this._directory;
    }

    public long lastModified() {
        if (this.checkConnection() && this._file != null) {
            return this._file.lastModified();
        }
        return -1L;
    }

    public synchronized String[] list() {
        if (this.isDirectory() && this._list == null) {
            ArrayList<String> arrayList = new ArrayList<String>(32);
            this.checkConnection();
            JarFile jarFile = this._jarFile;
            if (jarFile == null) {
                try {
                    jarFile = ((JarURLConnection)new URL(this._jarUrl).openConnection()).getJarFile();
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            String string = this._urlString.substring(this._urlString.indexOf("!/") + 2);
            while (enumeration.hasMoreElements()) {
                String string2;
                int n;
                JarEntry jarEntry = enumeration.nextElement();
                String string3 = jarEntry.getName().replace('\\', '/');
                if (!string3.startsWith(string) || string3.length() == string.length() || (n = (string2 = string3.substring(string.length())).indexOf(47)) >= 0 && arrayList.contains(string2 = string2.substring(0, n + 1))) continue;
                arrayList.add(string2);
            }
            this._list = new String[arrayList.size()];
            arrayList.toArray(this._list);
        }
        return this._list;
    }

    public long length() {
        if (this.isDirectory()) {
            return -1L;
        }
        if (this._entry != null) {
            return this._entry.getSize();
        }
        return -1L;
    }

    public String encode(String string) {
        return string;
    }
}

