/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

public class BlockingQueue {
    Object[] elements;
    Object lock;
    int maxSize;
    int size = 0;
    int head = 0;
    int tail = 0;

    public BlockingQueue(int n) {
        this(null, n);
    }

    public BlockingQueue(Object objectArray, int n) {
        this.maxSize = n;
        if (n == 0) {
            this.maxSize = 255;
        }
        this.elements = new Object[this.maxSize];
        this.lock = objectArray == null ? this.elements : objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.size = 0;
            this.head = 0;
            this.tail = 0;
        }
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws InterruptedException {
        Object object2 = this.lock;
        synchronized (object2) {
            while (this.size == this.maxSize) {
                this.lock.wait();
            }
            this.elements[this.tail] = object;
            if (++this.tail == this.maxSize) {
                this.tail = 0;
            }
            ++this.size;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object, int n) throws InterruptedException {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.size == this.maxSize) {
                this.lock.wait(n);
                if (this.size == this.maxSize) {
                    throw new InterruptedException("Timed out");
                }
            }
            this.elements[this.tail] = object;
            if (++this.tail == this.maxSize) {
                this.tail = 0;
            }
            ++this.size;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size == 0) {
                this.lock.wait();
            }
            Object object2 = this.elements[this.head];
            this.elements[this.head] = null;
            if (++this.head == this.maxSize) {
                this.head = 0;
            }
            if (this.size == this.maxSize) {
                this.lock.notifyAll();
            }
            --this.size;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size == 0 && n != 0) {
                this.lock.wait(n);
            }
            if (this.size == 0) {
                return null;
            }
            Object object2 = this.elements[this.head];
            this.elements[this.head] = null;
            if (++this.head == this.maxSize) {
                this.head = 0;
            }
            if (this.size == this.maxSize) {
                this.lock.notifyAll();
            }
            --this.size;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size == 0) {
                this.lock.wait();
            }
            if (this.size == 0) {
                return null;
            }
            Object object2 = this.elements[this.head];
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(int n) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size == 0) {
                this.lock.wait(n);
            }
            if (this.size == 0) {
                return null;
            }
            Object object2 = this.elements[this.head];
            return object2;
        }
    }
}

