/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.Iterator;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.ClientCertAuthenticator;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.jetty.servlet.BasicAuthenticator;
import org.mortbay.jetty.servlet.DigestAuthenticator;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FormAuthenticator;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlParser;

public class XMLConfiguration
implements WebApplicationContext.Configuration {
    private static Log log = LogFactory.getLog(XMLConfiguration.class);
    private WebApplicationContext _context;
    protected XmlParser xmlParser = XMLConfiguration.webXmlParser();

    public static XmlParser webXmlParser() {
        XmlParser xmlParser = new XmlParser();
        URL uRL = WebApplicationContext.class.getResource("/javax/servlet/resources/web-app_2_2.dtd");
        URL uRL2 = WebApplicationContext.class.getResource("/javax/servlet/resources/web-app_2_3.dtd");
        URL uRL3 = WebApplicationContext.class.getResource("/javax/servlet/resources/jsp_2_0.xsd");
        URL uRL4 = WebApplicationContext.class.getResource("/javax/servlet/resources/j2ee_1_4.xsd");
        URL uRL5 = WebApplicationContext.class.getResource("/javax/servlet/resources/web-app_2_4.xsd");
        URL uRL6 = WebApplicationContext.class.getResource("/javax/servlet/resources/XMLSchema.dtd");
        URL uRL7 = WebApplicationContext.class.getResource("/javax/servlet/resources/xml.xsd");
        URL uRL8 = WebApplicationContext.class.getResource("/javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
        URL uRL9 = WebApplicationContext.class.getResource("/javax/servlet/resources/j2ee_web_services_1_1.xsd");
        URL uRL10 = WebApplicationContext.class.getResource("/javax/servlet/resources/datatypes.dtd");
        xmlParser.redirectEntity("web-app_2_2.dtd", uRL);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", uRL);
        xmlParser.redirectEntity("web.dtd", uRL2);
        xmlParser.redirectEntity("web-app_2_3.dtd", uRL2);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", uRL2);
        xmlParser.redirectEntity("XMLSchema.dtd", uRL6);
        xmlParser.redirectEntity("http://www.w3.org/2001/XMLSchema.dtd", uRL6);
        xmlParser.redirectEntity("-//W3C//DTD XMLSCHEMA 200102//EN", uRL6);
        xmlParser.redirectEntity("jsp_2_0.xsd", uRL3);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", uRL3);
        xmlParser.redirectEntity("j2ee_1_4.xsd", uRL4);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", uRL4);
        xmlParser.redirectEntity("web-app_2_4.xsd", uRL5);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", uRL5);
        xmlParser.redirectEntity("xml.xsd", uRL7);
        xmlParser.redirectEntity("http://www.w3.org/2001/xml.xsd", uRL7);
        xmlParser.redirectEntity("datatypes.dtd", uRL10);
        xmlParser.redirectEntity("http://www.w3.org/2001/datatypes.dtd", uRL10);
        xmlParser.redirectEntity("j2ee_web_services_client_1_1.xsd", uRL9);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", uRL9);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", uRL8);
        return xmlParser;
    }

    public void setWebApplicationContext(WebApplicationContext webApplicationContext) {
        this._context = webApplicationContext;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this._context;
    }

    public WebApplicationHandler getWebApplicationHandler() {
        return this._context.getWebApplicationHandler();
    }

    public void configureClassPath() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        Resource resource = this._context.getWebInf();
        if (resource != null && resource.isDirectory()) {
            Resource resource2 = resource.addPath("classes/");
            if (resource2.exists()) {
                this._context.setClassPath(resource2.toString());
            } else {
                this._context.setClassPath(null);
            }
            Resource resource3 = resource.addPath("lib/");
            this._context.addClassPaths(resource3);
        }
    }

    public void configureDefaults() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        this.getWebApplicationContext().setWelcomeFiles(null);
        String string = this.getWebApplicationContext().getDefaultsDescriptor();
        if (string != null && string.length() > 0) {
            Resource resource = Resource.newSystemResource(string);
            if (resource == null) {
                resource = Resource.newResource(string);
            }
            XmlParser.Node node = this.xmlParser.parse(resource.getURL());
            this.initialize(node);
        }
    }

    public void configureWebApp() throws Exception {
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        Resource resource = this.getWebApplicationContext().getWebInf();
        if (resource != null && resource.isDirectory()) {
            Resource resource2 = resource.addPath("web.xml");
            if (!resource2.exists()) {
                log.info((Object)("No WEB-INF/web.xml in " + this.getWebApplicationContext().getWAR() + ". Serving files and default/dynamic servlets only"));
            } else {
                XmlParser.Node node = null;
                node = this.xmlParser.parse(resource2.getURL());
                this.initialize(node);
            }
        }
    }

    protected void initialize(XmlParser.Node node) throws ClassNotFoundException, UnavailableException {
        Iterator iterator = node.iterator();
        XmlParser.Node node2 = null;
        while (iterator.hasNext()) {
            try {
                Object e = iterator.next();
                if (!(e instanceof XmlParser.Node)) continue;
                node2 = (XmlParser.Node)e;
                String string = node2.getTag();
                this.initWebXmlElement(string, node2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Exception exception) {
                log.warn((Object)("Configuration problem at " + node2), (Throwable)exception);
                throw new UnavailableException("Configuration problem");
            }
        }
    }

    protected void initWebXmlElement(String string, XmlParser.Node node) throws Exception {
        if ("display-name".equals(string)) {
            this.initDisplayName(node);
        } else if (!"description".equals(string)) {
            if ("context-param".equals(string)) {
                this.initContextParam(node);
            } else if ("servlet".equals(string)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(string)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(string)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(string)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(string)) {
                this.initWelcomeFileList(node);
            } else if ("locale-encoding-mapping-list".equals(string)) {
                this.initLocaleEncodingList(node);
            } else if ("error-page".equals(string)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(string)) {
                this.initTagLib(node);
            } else if ("jsp-config".equals(string)) {
                this.initJspConfig(node);
            } else if ("resource-ref".equals(string)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No implementation: " + node));
                }
            } else if ("security-constraint".equals(string)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(string)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(string)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(string)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(string)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(string)) {
                this.initListener(node);
            } else if ("distributable".equals(string)) {
                this.initDistributable(node);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Element " + string + " not handled in " + this));
                log.debug((Object)node);
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this.getWebApplicationContext().setDisplayName(node.toString(false, true));
    }

    protected void initContextParam(XmlParser.Node node) {
        String string = node.getString("param-name", false, true);
        String string2 = node.getString("param-value", false, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ContextParam: " + string + "=" + string2));
        }
        this.getWebApplicationContext().setInitParameter(string, string2);
    }

    protected void initFilter(XmlParser.Node node) throws ClassNotFoundException, UnavailableException {
        String string = node.getString("filter-name", false, true);
        String string2 = node.getString("filter-class", false, true);
        if (string2 == null) {
            log.warn((Object)("Missing filter-class in " + node));
            return;
        }
        if (string == null) {
            string = string2;
        }
        FilterHolder filterHolder = this.getWebApplicationHandler().defineFilter(string, string2);
        Iterator iterator = node.iterator("init-param");
        while (iterator.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)iterator.next();
            String string3 = node2.getString("param-name", false, true);
            String string4 = node2.getString("param-value", false, true);
            filterHolder.put(string3, string4);
        }
    }

    protected void initFilterMapping(XmlParser.Node node) {
        Object object;
        String string = node.getString("filter-name", false, true);
        String string2 = node.getString("url-pattern", false, true);
        String string3 = node.getString("servlet-name", false, true);
        int n = 0;
        Iterator iterator = node.iterator("dispatcher");
        while (iterator.hasNext()) {
            object = ((XmlParser.Node)iterator.next()).toString(false, true);
            n |= Dispatcher.type((String)object);
        }
        object = string3 != null ? this.getWebApplicationHandler().addFilterServletMapping(string3, string, n) : this.getWebApplicationHandler().addFilterPathMapping(string2, string, n);
    }

    protected void initServlet(XmlParser.Node node) throws ClassNotFoundException, UnavailableException, IOException, MalformedURLException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = node.getString("servlet-name", false, true);
        String string3 = node.getString("servlet-class", false, true);
        String string4 = null;
        Holder holder = null;
        if (string3 == null) {
            string4 = node.getString("jsp-file", false, true);
            if (string4 != null && (object4 = this.getWebApplicationHandler().getHolderEntry(string4)) != null) {
                holder = (Holder)object4.getValue();
                string3 = holder.getClassName();
            }
            if (string3 == null) {
                log.warn((Object)("Missing servlet-class|jsp-file in " + node));
                return;
            }
        }
        if (string2 == null) {
            string2 = string3;
        }
        object4 = this.getWebApplicationHandler().newServletHolder(string2, string3, string4);
        if (string4 != null) {
            object3 = holder.getInitParameterNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                ((Holder)object4).setInitParameter((String)object2, holder.getInitParameter((String)object2));
            }
            if (((Holder)object4).getInitParameter("classpath") == null) {
                ((Holder)object4).setInitParameter("classpath", this.getWebApplicationContext().getFileClassPath());
            }
        }
        object3 = node.iterator("init-param");
        while (object3.hasNext()) {
            object2 = (XmlParser.Node)object3.next();
            object = ((XmlParser.Node)object2).getString("param-name", false, true);
            String string5 = ((XmlParser.Node)object2).getString("param-value", false, true);
            ((Holder)object4).put(object, string5);
        }
        object2 = node.get("load-on-startup");
        if (object2 != null) {
            object = ((XmlParser.Node)object2).toString(false, true).toLowerCase();
            if (((String)object).startsWith("t")) {
                log.warn((Object)"Deprecated boolean load-on-startup.  Please use integer");
                ((ServletHolder)object4).setInitOrder(1);
            } else {
                int n = 0;
                try {
                    if (object != null && ((String)object).trim().length() > 0) {
                        n = Integer.parseInt((String)object);
                    }
                }
                catch (Exception exception) {
                    log.warn((Object)("Cannot parse load-on-startup " + (String)object + ". Please use integer"));
                    LogSupport.ignore(log, exception);
                }
                ((ServletHolder)object4).setInitOrder(n);
            }
        }
        object = node.iterator("security-role-ref");
        while (object.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)object.next();
            string = node2.getString("role-name", false, true);
            String string6 = node2.getString("role-link", false, true);
            if (string != null && string.length() > 0 && string6 != null && string6.length() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("link role " + string + " to " + string6 + " for " + this));
                }
                ((ServletHolder)object4).setUserRoleLink(string, string6);
                continue;
            }
            log.warn((Object)("Ignored invalid security-role-ref element: servlet-name=" + string2 + ", " + node2));
        }
        XmlParser.Node node3 = node.get("run-as");
        if (node3 != null && (string = node3.getString("role-name", false, true)) != null) {
            ((ServletHolder)object4).setRunAs(string);
        }
    }

    protected void initServletMapping(XmlParser.Node node) {
        String string = node.getString("servlet-name", false, true);
        String string2 = node.getString("url-pattern", false, true);
        this.getWebApplicationHandler().mapPathToServlet(string2, string);
    }

    protected void initListener(XmlParser.Node node) {
        String string = node.getString("listener-class", false, true);
        Object var3_3 = null;
        try {
            Class clazz = this.getWebApplicationContext().loadClass(string);
            var3_3 = clazz.newInstance();
        }
        catch (Exception exception) {
            log.warn((Object)("Could not instantiate listener " + string), (Throwable)exception);
            return;
        }
        if (!(var3_3 instanceof EventListener)) {
            log.warn((Object)("Not an EventListener: " + var3_3));
            return;
        }
        boolean bl = false;
        try {
            this.getWebApplicationContext().addEventListener(var3_3);
            bl = true;
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
        }
        try {
            this.getWebApplicationHandler().addEventListener(var3_3);
            bl = true;
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
        }
        if (!bl) {
            log.warn((Object)("Unknown: " + var3_3));
        }
    }

    protected void initDistributable(XmlParser.Node node) {
        WebApplicationContext webApplicationContext = this.getWebApplicationContext();
        if (!webApplicationContext.isDistributable()) {
            webApplicationContext.setDistributable(true);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node node2 = node.get("session-timeout");
        if (node2 != null) {
            int n = Integer.parseInt(node2.toString(false, true));
            this.getWebApplicationHandler().setSessionInactiveInterval(n * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String string = node.getString("extension", false, true);
        if (string != null && string.startsWith(".")) {
            string = string.substring(1);
        }
        String string2 = node.getString("mime-type", false, true);
        this.getWebApplicationContext().setMimeMapping(string, string2);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        Iterator iterator = node.iterator("welcome-file");
        while (iterator.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)iterator.next();
            String string = node2.toString(false, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Index: " + string));
            }
            this.getWebApplicationContext().addWelcomeFile(string);
        }
    }

    protected void initLocaleEncodingList(XmlParser.Node node) {
        Iterator iterator = node.iterator("locale-encoding-mapping");
        while (iterator.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)iterator.next();
            String string = node2.getString("locale", false, true);
            String string2 = node2.getString("encoding", false, true);
            this.getWebApplicationContext().addLocaleEncoding(string, string2);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String string = node.getString("error-code", false, true);
        if (string == null || string.length() == 0) {
            string = node.getString("exception-type", false, true);
        }
        String string2 = node.getString("location", false, true);
        this.getWebApplicationContext().setErrorPage(string, string2);
    }

    protected void initTagLib(XmlParser.Node node) {
        String string = node.getString("taglib-uri", false, true);
        String string2 = node.getString("taglib-location", false, true);
        this.getWebApplicationContext().setResourceAlias(string, string2);
    }

    protected void initJspConfig(XmlParser.Node node) {
        for (int i = 0; i < node.size(); ++i) {
            Object object = node.get(i);
            if (!(object instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)object).getTag())) continue;
            this.initTagLib((XmlParser.Node)object);
        }
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        try {
            Object object;
            Object object2;
            SecurityConstraint securityConstraint = new SecurityConstraint();
            XmlParser.Node node2 = node.get("auth-constraint");
            if (node2 != null) {
                securityConstraint.setAuthenticate(true);
                object2 = node2.iterator("role-name");
                while (object2.hasNext()) {
                    object = ((XmlParser.Node)object2.next()).toString(false, true);
                    securityConstraint.addRole((String)object);
                }
            }
            if ((object2 = node.get("user-data-constraint")) != null) {
                object = ((XmlParser.Node)(object2 = ((XmlParser.Node)object2).get("transport-guarantee"))).toString(false, true).toUpperCase();
                if (object == null || ((String)object).length() == 0 || "NONE".equals(object)) {
                    securityConstraint.setDataConstraint(0);
                } else if ("INTEGRAL".equals(object)) {
                    securityConstraint.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(object)) {
                    securityConstraint.setDataConstraint(2);
                } else {
                    log.warn((Object)("Unknown user-data-constraint:" + (String)object));
                    securityConstraint.setDataConstraint(2);
                }
            }
            object = node.iterator("web-resource-collection");
            while (object.hasNext()) {
                XmlParser.Node node3 = (XmlParser.Node)object.next();
                String string = node3.getString("web-resource-name", false, true);
                SecurityConstraint securityConstraint2 = (SecurityConstraint)securityConstraint.clone();
                securityConstraint2.setName(string);
                Iterator iterator = node3.iterator("http-method");
                while (iterator.hasNext()) {
                    securityConstraint2.addMethod(((XmlParser.Node)iterator.next()).toString(false, true));
                }
                iterator = node3.iterator("url-pattern");
                while (iterator.hasNext()) {
                    String string2 = ((XmlParser.Node)iterator.next()).toString(false, true);
                    this.getWebApplicationContext().addSecurityConstraint(string2, securityConstraint2);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.fatal((Object)cloneNotSupportedException);
        }
    }

    protected void initLoginConfig(XmlParser.Node node) {
        Object object;
        Object object2;
        XmlParser.Node node2 = node.get("auth-method");
        FormAuthenticator formAuthenticator = null;
        if (node2 != null) {
            object2 = null;
            object = node2.toString(false, true);
            if ("FORM".equals(object)) {
                formAuthenticator = new FormAuthenticator();
                object2 = formAuthenticator;
            } else if ("BASIC".equals(object)) {
                object2 = new BasicAuthenticator();
            } else if ("DIGEST".equals(object)) {
                object2 = new DigestAuthenticator();
            } else if ("CLIENT_CERT".equals(object)) {
                object2 = new ClientCertAuthenticator();
            } else if ("CLIENT-CERT".equals(object)) {
                object2 = new ClientCertAuthenticator();
            } else {
                log.warn((Object)("UNKNOWN AUTH METHOD: " + (String)object));
            }
            this.getWebApplicationContext().setAuthenticator((Authenticator)object2);
        }
        if ((object2 = node.get("realm-name")) != null) {
            this.getWebApplicationContext().setRealmName(((XmlParser.Node)object2).toString(false, true));
        }
        if ((object = node.get("form-login-config")) != null) {
            if (formAuthenticator == null) {
                log.warn((Object)"FORM Authentication miss-configured");
            } else {
                XmlParser.Node node3;
                XmlParser.Node node4 = ((XmlParser.Node)object).get("form-login-page");
                if (node4 != null) {
                    formAuthenticator.setLoginPage(node4.toString(false, true));
                }
                if ((node3 = ((XmlParser.Node)object).get("form-error-page")) != null) {
                    String string = node3.toString(false, true);
                    formAuthenticator.setErrorPage(string);
                }
            }
        }
    }

    protected void initSecurityRole(XmlParser.Node node) {
    }
}

