/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpInputStream;
import org.mortbay.http.HttpRequest;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpResponse;
import org.mortbay.jetty.servlet.ServletIn;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;

public class ServletHttpRequest
implements HttpServletRequest {
    private static Log log = LogFactory.getLog(ServletHttpRequest.class);
    public static final String __SESSIONID_NOT_CHECKED = "not checked";
    public static final String __SESSIONID_URL = "url";
    public static final String __SESSIONID_COOKIE = "cookie";
    public static final String __SESSIONID_NONE = "none";
    private static final Enumeration __emptyEnum = Collections.enumeration(Collections.EMPTY_LIST);
    private static final Collection __defaultLocale = Collections.singleton(Locale.getDefault());
    private ServletHandler _servletHandler;
    private HttpRequest _httpRequest;
    private ServletHttpResponse _servletHttpResponse;
    private String _contextPath = null;
    private String _servletPath = null;
    private String _pathInfo = null;
    private String _query = null;
    private String _pathTranslated = null;
    private String _requestedSessionId = null;
    private HttpSession _session = null;
    private String _sessionIdState = "not checked";
    private ServletIn _in = null;
    private BufferedReader _reader = null;
    private int _inputState = 0;
    private ServletHolder _servletHolder;
    private String _pathInContext;

    public ServletHttpRequest(ServletHandler servletHandler, String string, HttpRequest httpRequest) {
        this._servletHandler = servletHandler;
        this._pathInContext = string;
        this._contextPath = this._servletHandler.getHttpContext().getContextPath();
        if (this._contextPath.length() <= 1) {
            this._contextPath = "";
        }
        this._httpRequest = httpRequest;
    }

    void recycle(ServletHandler servletHandler, String string) {
        this._servletHandler = servletHandler;
        this._pathInContext = string;
        this._servletPath = null;
        this._pathInfo = null;
        this._query = null;
        this._pathTranslated = null;
        this._requestedSessionId = null;
        this._session = null;
        this._sessionIdState = __SESSIONID_NOT_CHECKED;
        this._in = null;
        this._reader = null;
        this._inputState = 0;
        this._servletHolder = null;
        if (servletHandler != null) {
            this._contextPath = this._servletHandler.getHttpContext().getContextPath();
        }
        if (this._contextPath != null && this._contextPath.length() <= 1) {
            this._contextPath = "";
        }
    }

    ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    void setServletHandler(ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    void setServletPaths(String string, String string2, ServletHolder servletHolder) {
        this._servletPath = string;
        this._pathInfo = string2;
        this._servletHolder = servletHolder;
    }

    ServletHolder getServletHolder() {
        return this._servletHolder;
    }

    String getPathInContext() {
        return this._pathInContext;
    }

    HttpRequest getHttpRequest() {
        return this._httpRequest;
    }

    public ServletHttpResponse getServletHttpResponse() {
        return this._servletHttpResponse;
    }

    void setServletHttpResponse(ServletHttpResponse servletHttpResponse) {
        this._servletHttpResponse = servletHttpResponse;
    }

    public Locale getLocale() {
        Enumeration enumeration = this._httpRequest.getFieldValues("Accept-Language", ", \t");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Locale.getDefault();
        }
        List list = HttpFields.qualityList(enumeration);
        if (list.size() == 0) {
            return Locale.getDefault();
        }
        int n = 0;
        int n2 = list.size();
        if (n < n2) {
            String string = (String)list.get(n);
            string = HttpFields.valueParameters(string, null);
            String string2 = "";
            int n3 = string.indexOf(45);
            if (n3 > -1) {
                string2 = string.substring(n3 + 1).trim();
                string = string.substring(0, n3).trim();
            }
            return new Locale(string, string2);
        }
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        Enumeration enumeration = this._httpRequest.getFieldValues("Accept-Language", ", \t");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List list = HttpFields.qualityList(enumeration);
        if (list.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        Object object = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            string = HttpFields.valueParameters(string, null);
            String string2 = "";
            int n2 = string.indexOf(45);
            if (n2 > -1) {
                string2 = string.substring(n2 + 1).trim();
                string = string.substring(0, n2).trim();
            }
            object = LazyList.ensureSize(object, n);
            object = LazyList.add(object, new Locale(string, string2));
        }
        if (LazyList.size(object) == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(LazyList.getList(object));
    }

    public boolean isSecure() {
        return this._httpRequest.isConfidential();
    }

    public Cookie[] getCookies() {
        Cookie[] cookieArray = this._httpRequest.getCookies();
        if (cookieArray.length == 0) {
            return null;
        }
        return cookieArray;
    }

    public long getDateHeader(String string) {
        return this._httpRequest.getDateField(string);
    }

    public Enumeration getHeaderNames() {
        return this._httpRequest.getFieldNames();
    }

    public String getHeader(String string) {
        return this._httpRequest.getField(string);
    }

    public Enumeration getHeaders(String string) {
        Enumeration enumeration = this._httpRequest.getFieldValues(string);
        if (enumeration == null) {
            return __emptyEnum;
        }
        return enumeration;
    }

    public int getIntHeader(String string) throws NumberFormatException {
        return this._httpRequest.getIntField(string);
    }

    public String getMethod() {
        return this._httpRequest.getMethod();
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getPathInfo() {
        if (this._servletPath == null) {
            return null;
        }
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._pathInfo.length() == 0) {
            return null;
        }
        if (this._pathTranslated == null) {
            Resource resource = this._servletHandler.getHttpContext().getBaseResource();
            if (resource == null) {
                return null;
            }
            try {
                resource = resource.addPath(this._pathInfo);
                File file = resource.getFile();
                if (file == null) {
                    return null;
                }
                this._pathTranslated = file.getAbsolutePath();
            }
            catch (Exception exception) {
                log.debug((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        return this._pathTranslated;
    }

    public String getQueryString() {
        if (this._query == null) {
            this._query = this._httpRequest.getQuery();
        }
        return this._query;
    }

    public String getAuthType() {
        String string = this._httpRequest.getAuthType();
        if (string == "BASIC") {
            return "BASIC";
        }
        if (string == "FORM") {
            return "FORM";
        }
        if (string == "DIGEST") {
            return "DIGEST";
        }
        if (string == "CLIENT_CERT") {
            return "CLIENT_CERT";
        }
        if (string == "CLIENT-CERT") {
            return "CLIENT_CERT";
        }
        return string;
    }

    public String getRemoteUser() {
        return this._httpRequest.getAuthUser();
    }

    public boolean isUserInRole(String string) {
        if (this._servletHolder != null) {
            string = this._servletHolder.getUserRoleLink(string);
        }
        return this._httpRequest.isUserInRole(string);
    }

    public Principal getUserPrincipal() {
        return this._httpRequest.getUserPrincipal();
    }

    void setRequestedSessionId(String string) {
        Object object;
        this._requestedSessionId = null;
        if (this._servletHandler.isUsingCookies() && (object = this._httpRequest.getCookies()) != null && ((Cookie[])object).length > 0) {
            for (int i = 0; i < ((Cookie[])object).length; ++i) {
                if (!SessionManager.__SessionCookie.equalsIgnoreCase(object[i].getName())) continue;
                if (this._requestedSessionId != null) {
                    SessionManager sessionManager = this._servletHandler.getSessionManager();
                    if (sessionManager != null && sessionManager.getHttpSession(this._requestedSessionId) != null) break;
                    log.debug((Object)"multiple session cookies");
                }
                this._requestedSessionId = object[i].getValue();
                this._sessionIdState = __SESSIONID_COOKIE;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Got Session " + this._requestedSessionId + " from cookie"));
            }
        }
        if (string != null && string.startsWith(SessionManager.__SessionURL)) {
            object = string.substring(SessionManager.__SessionURL.length() + 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got Session " + (String)object + " from URL"));
            }
            if (this._requestedSessionId == null) {
                this._requestedSessionId = object;
                this._sessionIdState = __SESSIONID_URL;
            } else if (!((String)object).equals(this._requestedSessionId)) {
                log.debug((Object)"Mismatched session IDs");
            }
        }
        if (this._requestedSessionId == null) {
            this._sessionIdState = __SESSIONID_NONE;
        }
    }

    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    public String getRequestURI() {
        return this._httpRequest.getEncodedPath();
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = this._httpRequest.getRootURL();
        stringBuffer.append(this.getRequestURI());
        return stringBuffer;
    }

    public String getServletPath() {
        if (this._servletPath == null) {
            return this._pathInContext;
        }
        return this._servletPath;
    }

    public HttpSession getSession(boolean bl) {
        if (this._session != null && ((SessionManager.Session)this._session).isValid()) {
            return this._session;
        }
        this._session = null;
        String string = this.getRequestedSessionId();
        if (string != null) {
            this._session = this._servletHandler.getHttpSession(string);
            if (this._session == null && !bl) {
                return null;
            }
        }
        if (this._session == null && bl) {
            this._session = this.newSession();
        }
        return this._session;
    }

    HttpSession newSession() {
        HttpSession httpSession = this._servletHandler.newHttpSession(this);
        Cookie cookie = this._servletHandler.getSessionManager().getSessionCookie(httpSession, this.isSecure());
        if (cookie != null) {
            this._servletHttpResponse.getHttpResponse().addSetCookie(cookie);
        }
        return httpSession;
    }

    public HttpSession getSession() {
        HttpSession httpSession = this.getSession(true);
        return httpSession;
    }

    public boolean isRequestedSessionIdValid() {
        return this._requestedSessionId != null && this.getSession(false) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._sessionIdState == __SESSIONID_COOKIE;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._sessionIdState == __SESSIONID_URL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Enumeration getAttributeNames() {
        return this._httpRequest.getAttributeNames();
    }

    public Object getAttribute(String string) {
        return this._httpRequest.getAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this._httpRequest.setAttribute(string, object);
    }

    public void removeAttribute(String string) {
        this._httpRequest.removeAttribute(string);
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            throw new IllegalStateException("getReader() or getInputStream() called");
        }
        "".getBytes(string);
        this._httpRequest.setCharacterEncoding(string, false);
    }

    public String getCharacterEncoding() {
        return this._httpRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this._httpRequest.getContentLength();
    }

    public String getContentType() {
        return this._httpRequest.getContentType();
    }

    public ServletInputStream getInputStream() {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException();
        }
        if (this._in == null) {
            this._in = new ServletIn((HttpInputStream)this._httpRequest.getInputStream());
        }
        this._inputState = 1;
        this._reader = null;
        return this._in;
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this._httpRequest.getParameterStringArrayMap());
    }

    public String getParameter(String string) {
        return this._httpRequest.getParameter(string);
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this._httpRequest.getParameterNames());
    }

    public String[] getParameterValues(String string) {
        List list = this._httpRequest.getParameterValues(string);
        if (list == null) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        return list.toArray(stringArray);
    }

    public String getProtocol() {
        return this._httpRequest.getVersion();
    }

    public String getScheme() {
        return this._httpRequest.getScheme();
    }

    public String getServerName() {
        return this._httpRequest.getHost();
    }

    public int getServerPort() {
        int n = this._httpRequest.getPort();
        if (n == 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return n;
    }

    public int getRemotePort() {
        HttpConnection httpConnection = this._httpRequest.getHttpConnection();
        if (httpConnection != null) {
            return httpConnection.getRemotePort();
        }
        return 0;
    }

    public String getLocalName() {
        HttpConnection httpConnection = this._httpRequest.getHttpConnection();
        if (httpConnection != null) {
            return httpConnection.getServerName();
        }
        return null;
    }

    public String getLocalAddr() {
        HttpConnection httpConnection = this._httpRequest.getHttpConnection();
        if (httpConnection != null) {
            return httpConnection.getServerAddr();
        }
        return null;
    }

    public int getLocalPort() {
        HttpConnection httpConnection = this._httpRequest.getHttpConnection();
        if (httpConnection != null) {
            return httpConnection.getServerPort();
        }
        return 0;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException();
        }
        if (this._reader == null) {
            String string = this.getCharacterEncoding();
            if (string == null) {
                string = StringUtil.__ISO_8859_1;
            }
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), string));
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRemoteAddr() {
        return this._httpRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this._httpRequest.getHttpConnection() == null) {
            return null;
        }
        return this._httpRequest.getRemoteHost();
    }

    public String getRealPath(String string) {
        return this._servletHandler.getServletContext().getRealPath(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            String string2 = URI.addPaths(this._servletPath, this._pathInfo);
            int n = string2.lastIndexOf("/");
            string2 = n > 1 ? string2.substring(0, n + 1) : "/";
            string = URI.addPaths(string2, string);
        }
        return this._servletHandler.getServletContext().getRequestDispatcher(string);
    }

    public String toString() {
        return this.getContextPath() + "+" + this.getServletPath() + "+" + this.getPathInfo() + "\n" + this._httpRequest.toString();
    }

    public static ServletHttpRequest unwrap(ServletRequest servletRequest) {
        while (!(servletRequest instanceof ServletHttpRequest)) {
            if (servletRequest instanceof ServletRequestWrapper) {
                ServletRequestWrapper servletRequestWrapper = (ServletRequestWrapper)servletRequest;
                servletRequest = servletRequestWrapper.getRequest();
                continue;
            }
            throw new IllegalArgumentException("Does not wrap ServletHttpRequest");
        }
        return (ServletHttpRequest)servletRequest;
    }
}

