/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.LogFactory;
import org.mortbay.util.URI;

public class Invoker
extends HttpServlet {
    private static Log log = LogFactory.getLog(Invoker.class);
    private ServletHandler _servletHandler;
    private Map.Entry _invokerEntry;
    private Map _parameters;
    private boolean _nonContextServlets;
    private boolean _verbose;

    public void init() {
        ServletContext servletContext = this.getServletContext();
        this._servletHandler = ((ServletHandler.Context)servletContext).getServletHandler();
        Enumeration enumeration = this.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getInitParameter(string);
            String string3 = string2.toLowerCase();
            if ("nonContextServlets".equals(string)) {
                boolean bl = this._nonContextServlets = string2.length() > 0 && string3.startsWith("t");
            }
            if ("verbose".equals(string)) {
                this._verbose = string2.length() > 0 && string3.startsWith("t");
                continue;
            }
            if (this._parameters == null) {
                this._parameters = new HashMap();
            }
            this._parameters.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        boolean bl = false;
        String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (string2 == null) {
            string2 = httpServletRequest.getServletPath();
        } else {
            bl = true;
        }
        String string3 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        if (string3 == null) {
            string3 = httpServletRequest.getPathInfo();
        }
        if ((string = string3) == null || string.length() <= 1) {
            httpServletResponse.sendError(404);
            return;
        }
        int n = string.charAt(0) == '/' ? 1 : 0;
        int n2 = string.indexOf(47, n);
        ServletHolder servletHolder = this._servletHandler.getServletHolder(string = n2 < 0 ? string.substring(n) : string.substring(n, n2));
        if (servletHolder != null) {
            this._servletHandler.addServletHolder(servletHolder);
            this._servletHandler.mapPathToServlet(URI.addPaths(string2, string) + "/*", servletHolder.getName());
        } else {
            if (string.endsWith(".class")) {
                string = string.substring(0, string.length() - 6);
            }
            if (string == null || string.length() == 0) {
                httpServletResponse.sendError(404);
                return;
            }
            ServletHandler servletHandler = this._servletHandler;
            synchronized (servletHandler) {
                String string4;
                Map.Entry entry;
                if (this._invokerEntry == null) {
                    this._invokerEntry = this._servletHandler.getHolderEntry(string2);
                }
                if ((entry = this._servletHandler.getHolderEntry(string4 = URI.addPaths(string2, string))) != null && entry != this._invokerEntry) {
                    servletHolder = (ServletHolder)entry.getValue();
                } else {
                    servletHolder = new ServletHolder(this._servletHandler, string, string);
                    if (this._parameters != null) {
                        servletHolder.putAll(this._parameters);
                    }
                    try {
                        servletHolder.start();
                    }
                    catch (Exception exception) {
                        log.debug((Object)"EXCEPTION ", (Throwable)exception);
                        throw new UnavailableException(exception.toString());
                    }
                    if (!this._nonContextServlets) {
                        Servlet servlet = servletHolder.getServlet();
                        if (this._servletHandler.getClassLoader() != servlet.getClass().getClassLoader()) {
                            servletHolder.stop();
                            log.warn((Object)("Dynamic servlet " + servlet + " not loaded from context " + httpServletRequest.getContextPath()));
                            throw new UnavailableException("Not in context");
                        }
                    }
                    if (this._verbose) {
                        this.log("Dynamic load '" + string + "' at " + string4);
                    }
                    this._servletHandler.addServletHolder(servletHolder);
                    this._servletHandler.mapPathToServlet(string4 + "/*", servletHolder.getName());
                    this._servletHandler.mapPathToServlet(string4 + ".class/*", servletHolder.getName());
                }
            }
        }
        if (servletHolder != null) {
            servletHolder.handle((ServletRequest)new Request(httpServletRequest, bl, string, string2, string3), (ServletResponse)httpServletResponse);
        } else {
            httpServletResponse.sendError(404);
        }
    }

    class Request
    extends HttpServletRequestWrapper {
        String _servletPath;
        String _pathInfo;
        boolean _included;

        Request(HttpServletRequest httpServletRequest, boolean bl, String string, String string2, String string3) {
            super(httpServletRequest);
            this._included = bl;
            this._servletPath = URI.addPaths(string2, string);
            this._pathInfo = string3.substring(string.length() + 1);
            if (this._pathInfo.length() == 0) {
                this._pathInfo = null;
            }
        }

        public String getServletPath() {
            if (this._included) {
                return super.getServletPath();
            }
            return this._servletPath;
        }

        public String getPathInfo() {
            if (this._included) {
                return super.getPathInfo();
            }
            return this._pathInfo;
        }

        public Object getAttribute(String string) {
            if (this._included) {
                if (string.equals("javax.servlet.include.request_uri")) {
                    return URI.addPaths(URI.addPaths(this.getContextPath(), this._servletPath), this._pathInfo);
                }
                if (string.equals("javax.servlet.include.path_info")) {
                    return this._pathInfo;
                }
                if (string.equals("javax.servlet.include.servlet_path")) {
                    return this._servletPath;
                }
            }
            return super.getAttribute(string);
        }
    }
}

