/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpOnlyCookie;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionContext;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;

public abstract class AbstractSessionManager
implements SessionManager {
    private static Log log = LogFactory.getLog(AbstractSessionManager.class);
    public static final int __distantFuture = 628992000;
    private static final String __NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    protected static MultiMap __allSessions = new MultiMap();
    private int _dftMaxIdleSecs = -1;
    private int _scavengePeriodMs = 30000;
    private String _workerName;
    protected transient ArrayList _sessionListeners = new ArrayList();
    protected transient ArrayList _sessionAttributeListeners = new ArrayList();
    protected transient Map _sessions;
    protected transient Random _random;
    protected transient ServletHandler _handler;
    protected int _minSessions = 0;
    protected int _maxSessions = 0;
    protected boolean _crossContextSessionIDs = false;
    protected boolean _secureCookies = false;
    protected boolean _httpOnly = false;
    protected boolean _invalidateGlobal = true;
    private transient SessionScavenger _scavenger = null;

    public AbstractSessionManager() {
        this(null);
    }

    public AbstractSessionManager(Random random) {
        this._random = random;
    }

    public boolean getUseRequestedId() {
        return this._crossContextSessionIDs;
    }

    public void setUseRequestedId(boolean bl) {
        this._crossContextSessionIDs = bl;
    }

    public boolean getCrossContextSessionIDs() {
        return this._crossContextSessionIDs;
    }

    public void setCrossContextSessionIDs(boolean bl) {
        this._crossContextSessionIDs = bl;
    }

    public void initialize(ServletHandler servletHandler) {
        this._handler = servletHandler;
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        return this._sessions.size();
    }

    public int getMinSessions() {
        return this._minSessions;
    }

    public int getMaxSessions() {
        return this._maxSessions;
    }

    public void resetStats() {
        this._minSessions = this._sessions.size();
        this._maxSessions = this._sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newSessionId(HttpServletRequest httpServletRequest, long l) {
        MultiMap multiMap = __allSessions;
        synchronized (multiMap) {
            String string;
            if (this._crossContextSessionIDs) {
                string = (String)httpServletRequest.getAttribute(__NEW_SESSION_ID);
                if (string == null) {
                    string = httpServletRequest.getRequestedSessionId();
                }
                if (string != null && string != null && __allSessions.containsKey(string) && !this._sessions.containsKey(string)) {
                    return string;
                }
            }
            string = null;
            while (string == null || string.length() == 0 || __allSessions.containsKey(string)) {
                long l2 = this._random.nextLong();
                if (l2 < 0L) {
                    l2 = -l2;
                }
                string = Long.toString(l2, 30 + (int)(l % 7L));
                String string2 = (String)httpServletRequest.getAttribute("org.mortbay.http.ajp.JVMRoute");
                if (string2 != null) {
                    string = string + "." + string2;
                    continue;
                }
                if (this._workerName == null) continue;
                string = string + "." + this._workerName;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getHttpSession(String string) {
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            return (HttpSession)this._sessions.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession newHttpSession(HttpServletRequest httpServletRequest) {
        Session session = this.newSession(httpServletRequest);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        MultiMap multiMap = __allSessions;
        synchronized (multiMap) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._sessions.put(session.getId(), session);
                __allSessions.add(session.getId(), session);
                if (this._sessions.size() > this._maxSessions) {
                    this._maxSessions = this._sessions.size();
                }
            }
        }
        multiMap = new HttpSessionEvent((HttpSession)session);
        for (int i = 0; i < this._sessionListeners.size(); ++i) {
            ((HttpSessionListener)this._sessionListeners.get(i)).sessionCreated((HttpSessionEvent)multiMap);
        }
        if (this.getCrossContextSessionIDs()) {
            httpServletRequest.setAttribute(__NEW_SESSION_ID, (Object)session.getId());
        }
        return session;
    }

    public Cookie getSessionCookie(HttpSession httpSession, boolean bl) {
        if (this._handler.isUsingCookies()) {
            HttpOnlyCookie httpOnlyCookie = this._handler.getSessionManager().getHttpOnly() ? new HttpOnlyCookie(SessionManager.__SessionCookie, httpSession.getId()) : new Cookie(SessionManager.__SessionCookie, httpSession.getId());
            String string = this._handler.getServletContext().getInitParameter("org.mortbay.jetty.servlet.SessionDomain");
            String string2 = this._handler.getServletContext().getInitParameter("org.mortbay.jetty.servlet.MaxAge");
            String string3 = this._handler.getServletContext().getInitParameter("org.mortbay.jetty.servlet.SessionPath");
            if (string3 == null) {
                String string4 = string3 = this.getCrossContextSessionIDs() ? "/" : this._handler.getHttpContext().getContextPath();
            }
            if (string3 == null || string3.length() == 0) {
                string3 = "/";
            }
            if (string != null) {
                httpOnlyCookie.setDomain(string);
            }
            if (string2 != null) {
                httpOnlyCookie.setMaxAge(Integer.parseInt(string2));
            } else {
                httpOnlyCookie.setMaxAge(-1);
            }
            httpOnlyCookie.setSecure(bl && this.getSecureCookies());
            httpOnlyCookie.setPath(string3);
            return httpOnlyCookie;
        }
        return null;
    }

    protected abstract Session newSession(HttpServletRequest var1);

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String string) {
        this._workerName = string;
    }

    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    public void setMaxInactiveInterval(int n) {
        this._dftMaxIdleSecs = n;
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 100) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int n) {
        if (n == 0) {
            n = 60;
        }
        int n2 = this._scavengePeriodMs;
        int n3 = n * 1000;
        if (n3 > 60000) {
            n3 = 60000;
        }
        if (n3 < 1000) {
            n3 = 1000;
        }
        if (n3 != n2) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._scavengePeriodMs = n3;
                if (this._scavenger != null) {
                    this._scavenger.interrupt();
                }
            }
        }
    }

    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    public void setHttpOnly(boolean bl) {
        this._httpOnly = bl;
    }

    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public void setSecureCookies(boolean bl) {
        this._secureCookies = bl;
    }

    public boolean isInvalidateGlobal() {
        return this._invalidateGlobal;
    }

    public void setInvalidateGlobal(boolean bl) {
        this._invalidateGlobal = bl;
    }

    public void addEventListener(EventListener eventListener) throws IllegalArgumentException {
        if (eventListener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.add(eventListener);
        }
        if (eventListener instanceof HttpSessionListener) {
            this._sessionListeners.add(eventListener);
        }
    }

    public void removeEventListener(EventListener eventListener) {
        if (eventListener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.remove(eventListener);
        }
        if (eventListener instanceof HttpSessionListener) {
            this._sessionListeners.remove(eventListener);
        }
    }

    public boolean isStarted() {
        return this._scavenger != null;
    }

    public void start() throws Exception {
        if (this._random == null) {
            log.debug((Object)"New random session seed");
            this._random = new Random();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing random session key: " + this._random));
        }
        this._random.nextLong();
        if (this._sessions == null) {
            this._sessions = new HashMap();
        }
        if (this._scavenger == null) {
            this._scavenger = new SessionScavenger();
            this._scavenger.start();
        }
    }

    public void stop() {
        ArrayList arrayList = new ArrayList(this._sessions.values());
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Session session = (Session)object.next();
            session.invalidate();
        }
        this._sessions.clear();
        object = this._scavenger;
        this._scavenger = null;
        if (object != null) {
            ((Thread)object).interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            Object object;
            if (this._handler == null) {
                return;
            }
            ClassLoader classLoader2 = this._handler.getClassLoader();
            if (classLoader2 != null) {
                thread.setContextClassLoader(classLoader2);
            }
            long l = System.currentTimeMillis();
            Object object2 = null;
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                object = this._sessions.values().iterator();
                while (object.hasNext()) {
                    Session session = (Session)object.next();
                    long l2 = session._maxIdleMs;
                    if (l2 <= 0L || session._accessed + l2 >= l) continue;
                    object2 = LazyList.add(object2, session);
                }
            }
            int n = LazyList.size(object2);
            while (n-- > 0) {
                object = (Session)LazyList.get(object2, n);
                long l3 = ((Session)object)._maxIdleMs;
                if (l3 <= 0L || ((Session)object)._accessed + l3 >= System.currentTimeMillis()) continue;
                ((Session)object).invalidate();
                int n2 = this._sessions.size();
                if (n2 >= this._minSessions) continue;
                this._minSessions = n2;
            }
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    public abstract class Session
    implements SessionManager.Session {
        Map _values;
        boolean _invalid = false;
        boolean _newSession = true;
        long _created;
        long _accessed = this._created = System.currentTimeMillis();
        long _maxIdleMs = AbstractSessionManager.access$400(AbstractSessionManager.this) * 1000;
        String _id;

        protected Session(HttpServletRequest httpServletRequest) {
            this._id = AbstractSessionManager.this.newSessionId(httpServletRequest, this._created);
            if (AbstractSessionManager.this._dftMaxIdleSecs >= 0) {
                this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            }
        }

        protected abstract Map newAttributeMap();

        public void access() {
            this._newSession = false;
            this._accessed = System.currentTimeMillis();
        }

        public boolean isValid() {
            return !this._invalid;
        }

        public ServletContext getServletContext() {
            return AbstractSessionManager.this._handler.getServletContext();
        }

        public String getId() throws IllegalStateException {
            return this._id;
        }

        public long getCreationTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._accessed;
        }

        public int getMaxInactiveInterval() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return SessionContext.NULL_IMPL;
        }

        public void setMaxInactiveInterval(int n) {
            this._maxIdleMs = (long)n * 1000L;
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)AbstractSessionManager.this._scavengePeriodMs) {
                AbstractSessionManager.this.setScavengePeriod((n + 9) / 10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() throws IllegalStateException {
            MultiMap multiMap;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalidate session " + this.getId() + " in " + AbstractSessionManager.this._handler.getHttpContext()));
            }
            try {
                Session session = this;
                synchronized (session) {
                    Object object;
                    if (this._invalid) {
                        throw new IllegalStateException();
                    }
                    if (AbstractSessionManager.this._sessionListeners != null) {
                        object = new HttpSessionEvent((HttpSession)this);
                        for (int i = 0; i < AbstractSessionManager.this._sessionListeners.size(); ++i) {
                            ((HttpSessionListener)AbstractSessionManager.this._sessionListeners.get(i)).sessionDestroyed((HttpSessionEvent)object);
                        }
                    }
                    if (this._values != null) {
                        object = this._values.keySet().iterator();
                        while (object.hasNext()) {
                            String string = (String)object.next();
                            Object v = this._values.get(string);
                            object.remove();
                            this.unbindValue(string, v);
                            if (AbstractSessionManager.this._sessionAttributeListeners.size() <= 0) continue;
                            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, v);
                            for (int i = 0; i < AbstractSessionManager.this._sessionAttributeListeners.size(); ++i) {
                                ((HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i)).attributeRemoved(httpSessionBindingEvent);
                            }
                        }
                    }
                }
                Object var9_9 = null;
                multiMap = __allSessions;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                MultiMap multiMap2 = __allSessions;
                synchronized (multiMap2) {
                    Map map = AbstractSessionManager.this._sessions;
                    synchronized (map) {
                        this._invalid = true;
                        AbstractSessionManager.this._sessions.remove(this.getId());
                        __allSessions.removeValue(this.getId(), this);
                        if (AbstractSessionManager.this.isInvalidateGlobal()) {
                            while (__allSessions.containsKey(this.getId())) {
                                Session session = (Session)__allSessions.getValue(this.getId(), 0);
                                session.invalidate();
                            }
                        }
                    }
                }
                throw throwable;
            }
            synchronized (multiMap) {
                Map map = AbstractSessionManager.this._sessions;
                synchronized (map) {
                    this._invalid = true;
                    AbstractSessionManager.this._sessions.remove(this.getId());
                    __allSessions.removeValue(this.getId(), this);
                    if (AbstractSessionManager.this.isInvalidateGlobal()) {
                        while (__allSessions.containsKey(this.getId())) {
                            Session session = (Session)__allSessions.getValue(this.getId(), 0);
                            session.invalidate();
                        }
                    }
                }
            }
        }

        public boolean isNew() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        public synchronized Object getAttribute(String string) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return null;
            }
            return this._values.get(string);
        }

        public synchronized Enumeration getAttributeNames() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            List<Object> list = this._values == null ? Collections.EMPTY_LIST : new ArrayList(this._values.keySet());
            return Collections.enumeration(list);
        }

        public synchronized void setAttribute(String string, Object object) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                this._values = this.newAttributeMap();
            }
            Object object2 = this._values.put(string, object);
            if (object == null || !object.equals(object2)) {
                this.unbindValue(string, object2);
                this.bindValue(string, object);
                if (AbstractSessionManager.this._sessionAttributeListeners.size() > 0) {
                    HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object2 == null ? object : object2);
                    for (int i = 0; i < AbstractSessionManager.this._sessionAttributeListeners.size(); ++i) {
                        HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i);
                        if (object2 == null) {
                            httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
                            continue;
                        }
                        if (object == null) {
                            httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
                            continue;
                        }
                        httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
                    }
                }
            }
        }

        public synchronized void removeAttribute(String string) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return;
            }
            Object v = this._values.remove(string);
            if (v != null) {
                this.unbindValue(string, v);
                if (AbstractSessionManager.this._sessionAttributeListeners.size() > 0) {
                    HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, v);
                    for (int i = 0; i < AbstractSessionManager.this._sessionAttributeListeners.size(); ++i) {
                        HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i);
                        httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
                    }
                }
            }
        }

        public Object getValue(String string) throws IllegalStateException {
            return this.getAttribute(string);
        }

        public synchronized String[] getValueNames() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] stringArray = new String[this._values.size()];
            return this._values.keySet().toArray(stringArray);
        }

        public void putValue(String string, Object object) throws IllegalStateException {
            this.setAttribute(string, object);
        }

        public void removeValue(String string) throws IllegalStateException {
            this.removeAttribute(string);
        }

        private void bindValue(String string, Object object) {
            if (object != null && object instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
            }
        }

        private void unbindValue(String string, Object object) {
            if (object != null && object instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
            }
        }
    }

    class SessionScavenger
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = -1;
            try {
                while (AbstractSessionManager.this.isStarted()) {
                    try {
                        if (n != AbstractSessionManager.this._scavengePeriodMs) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Session scavenger period = " + AbstractSessionManager.this._scavengePeriodMs / 1000 + "s"));
                            }
                            n = AbstractSessionManager.this._scavengePeriodMs;
                        }
                        SessionScavenger.sleep(n > 1000 ? (long)n : 1000L);
                        AbstractSessionManager.this.scavenge();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Error error) {
                        log.warn((Object)"EXCEPTION ", (Throwable)error);
                    }
                    catch (Exception exception) {
                        log.warn((Object)"EXCEPTION ", (Throwable)exception);
                    }
                }
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                AbstractSessionManager.this._scavenger = null;
                log.debug((Object)"Session scavenger exited");
                throw throwable;
            }
            AbstractSessionManager.this._scavenger = null;
            log.debug((Object)"Session scavenger exited");
        }

        SessionScavenger() {
            super("SessionScavenger");
            this.setDaemon(true);
        }
    }
}

