/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlConfiguration;

public class Server
extends HttpServer {
    static Log log = LogFactory.getLog(Server.class);
    private String[] _webAppConfigurationClassNames = new String[]{"org.mortbay.jetty.servlet.XMLConfiguration", "org.mortbay.jetty.servlet.JettyWebConfiguration"};
    private String _configuration;
    private String _rootWebApp;
    private static ShutdownHookThread hookThread = new ShutdownHookThread();
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public Server() {
    }

    public Server(String string) throws IOException {
        this(Resource.newResource(string).getURL());
    }

    public Server(Resource resource) throws IOException {
        this(resource.getURL());
    }

    public Server(URL uRL) throws IOException {
        this._configuration = uRL.toString();
        hookThread.add(this);
        try {
            XmlConfiguration xmlConfiguration = new XmlConfiguration(uRL);
            xmlConfiguration.configure(this);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (InvocationTargetException invocationTargetException) {
            log.warn((Object)"EXCEPTION ", invocationTargetException.getTargetException());
            throw new IOException("Jetty configuration problem: " + invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IOException("Jetty configuration problem: " + exception);
        }
    }

    public boolean getStopAtShutdown() {
        return hookThread.contains(this);
    }

    public void setStopAtShutdown(boolean bl) {
        if (bl) {
            hookThread.add(this);
        } else {
            hookThread.remove(this);
        }
    }

    public String getRootWebApp() {
        return this._rootWebApp;
    }

    public void setRootWebApp(String string) {
        this._rootWebApp = string;
    }

    public void configure(String string) throws IOException {
        URL uRL = Resource.newResource(string).getURL();
        if (this._configuration != null && this._configuration.equals(uRL.toString())) {
            return;
        }
        if (this._configuration != null) {
            throw new IllegalStateException("Already configured with " + this._configuration);
        }
        try {
            XmlConfiguration xmlConfiguration = new XmlConfiguration(uRL);
            this._configuration = uRL.toString();
            xmlConfiguration.configure(this);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IOException("Jetty configuration problem: " + exception);
        }
    }

    public String getConfiguration() {
        return this._configuration;
    }

    protected HttpContext newHttpContext() {
        return new ServletHttpContext();
    }

    protected WebApplicationContext newWebApplicationContext(String string) {
        return new WebApplicationContext(string);
    }

    public WebApplicationContext addWebApplication(String string, String string2) throws IOException {
        return this.addWebApplication(null, string, string2);
    }

    public WebApplicationContext addWebApplication(String string, String string2, String string3) throws IOException {
        WebApplicationContext webApplicationContext = this.newWebApplicationContext(string3);
        webApplicationContext.setContextPath(string2);
        this.addContext(string, webApplicationContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Web Application " + webApplicationContext + " added"));
        }
        return webApplicationContext;
    }

    public WebApplicationContext[] addWebApplications(String string) throws IOException {
        return this.addWebApplications(null, string, null, false);
    }

    public WebApplicationContext[] addWebApplications(String string, String string2) throws IOException {
        return this.addWebApplications(string, string2, null, false);
    }

    public WebApplicationContext[] addWebApplications(String string, String string2, boolean bl) throws IOException {
        return this.addWebApplications(string, string2, null, bl);
    }

    public WebApplicationContext[] addWebApplications(String string, String string2, String string3, boolean bl) throws IOException {
        return this.addWebApplications(string, string2, string3, bl, true);
    }

    public WebApplicationContext[] addWebApplications(String string, String string2, String string3, boolean bl, boolean bl2) throws IOException {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        Resource resource = Resource.newResource(string2);
        if (!resource.exists()) {
            throw new IllegalArgumentException("No such webapps resource " + resource);
        }
        if (!resource.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + resource);
        }
        String[] stringArray = resource.list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            Serializable serializable;
            String string4 = stringArray[i];
            if (string4.equalsIgnoreCase("CVS/") || string4.equalsIgnoreCase("CVS") || string4.startsWith(".")) continue;
            String string5 = resource.addPath(resource.encode(stringArray[i])).toString();
            if ((string4.toLowerCase().endsWith(".war") || string4.toLowerCase().endsWith(".jar")) && (serializable = resource.addPath(string4 = string4.substring(0, string4.length() - 4))) != null && ((Resource)serializable).exists() && ((Resource)serializable).isDirectory()) continue;
            string4 = this._rootWebApp != null && (string4.equals(this._rootWebApp) || string4.equals(this._rootWebApp + "/")) ? "/" : "/" + string4;
            serializable = this.addWebApplication(string, string4, string5);
            ((WebApplicationContext)serializable).setExtractWAR(bl);
            ((HttpContext)serializable).setClassLoaderJava2Compliant(bl2);
            if (string3 != null) {
                if (string3.length() == 0) {
                    ((WebApplicationContext)serializable).setDefaultsDescriptor(null);
                } else {
                    ((WebApplicationContext)serializable).setDefaultsDescriptor(string3);
                }
            }
            arrayList.add(serializable);
        }
        return arrayList.toArray(new WebApplicationContext[arrayList.size()]);
    }

    public void setWebApplicationConfigurationClassNames(String[] stringArray) {
        if (stringArray != null) {
            this._webAppConfigurationClassNames = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this._webAppConfigurationClassNames, 0, stringArray.length);
        }
    }

    public String[] getWebApplicationConfigurationClassNames() {
        return this._webAppConfigurationClassNames;
    }

    public static void main(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[]{"etc/jetty.xml"};
        if (stringArray.length == 0) {
            log.info((Object)"Using default configuration: etc/jetty.xml");
            stringArray = stringArray2;
        }
        Server[] serverArray = new Server[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            try {
                serverArray[n] = new Server(stringArray[n]);
                serverArray[n].setStopAtShutdown(true);
                serverArray[n].start();
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            try {
                serverArray[n].join();
                continue;
            }
            catch (Exception exception) {
                LogSupport.ignore(log, exception);
            }
        }
    }

    private static class ShutdownHookThread
    extends Thread {
        private boolean hooked = false;
        private ArrayList servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            block3: {
                if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked) {
                    try {
                        Method method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Server.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = Server.class$("java.lang.Thread")) : class$java$lang$Thread);
                        method.invoke((Object)Runtime.getRuntime(), this);
                        this.hooked = true;
                    }
                    catch (Exception exception) {
                        if (!log.isDebugEnabled()) break block3;
                        log.debug((Object)"No shutdown hook in JVM ", (Throwable)exception);
                    }
                }
            }
        }

        public boolean add(Server server) {
            this.createShutdownHook();
            return this.servers.add(server);
        }

        public boolean contains(Server server) {
            return this.servers.contains(server);
        }

        public boolean addAll(Collection collection) {
            this.createShutdownHook();
            return this.servers.addAll(collection);
        }

        public void clear() {
            this.createShutdownHook();
            this.servers.clear();
        }

        public boolean remove(Server server) {
            this.createShutdownHook();
            return this.servers.remove(server);
        }

        public boolean removeAll(Collection collection) {
            this.createShutdownHook();
            return this.servers.removeAll(collection);
        }

        public void run() {
            this.setName("Shutdown");
            log.info((Object)"Shutdown hook executing");
            Iterator iterator = this.servers.iterator();
            while (iterator.hasNext()) {
                Server server = (Server)iterator.next();
                if (server == null) continue;
                try {
                    server.stop();
                }
                catch (Exception exception) {
                    log.warn((Object)"EXCEPTION ", (Throwable)exception);
                }
                log.info((Object)"Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    log.warn((Object)"EXCEPTION ", (Throwable)exception);
                }
            }
        }
    }
}

