/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;

public class SocketChannelOutputStream
extends OutputStream {
    private static Log log = LogFactory.getLog(SocketChannelOutputStream.class);
    ByteBuffer _buffer;
    ByteBuffer _flush;
    SocketChannel _channel;
    Selector _selector;

    public SocketChannelOutputStream(SocketChannel socketChannel, int n) {
        this._channel = socketChannel;
        this._buffer = ByteBuffer.allocateDirect(n);
    }

    public void write(int n) throws IOException {
        this._buffer.clear();
        this._buffer.put((byte)n);
        this._buffer.flip();
        this._flush = this._buffer;
        this.flushBuffer();
    }

    public void close() throws IOException {
        this._channel.close();
    }

    public void flush() throws IOException {
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > this._buffer.capacity()) {
            this._flush = ByteBuffer.wrap(byArray, n, n2);
        } else {
            this._buffer.clear();
            this._buffer.put(byArray, n, n2);
            this._buffer.flip();
            this._flush = this._buffer;
        }
        this.flushBuffer();
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray.length > this._buffer.capacity()) {
            this._flush = ByteBuffer.wrap(byArray);
        } else {
            this._buffer.clear();
            this._buffer.put(byArray);
            this._buffer.flip();
            this._flush = this._buffer;
        }
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        while (this._flush.hasRemaining()) {
            int n = this._channel.write(this._flush);
            if (n < 0) {
                throw new IOException("EOF");
            }
            if (n != 0) continue;
            Thread.yield();
            n = this._channel.write(this._flush);
            if (n < 0) {
                throw new IOException("EOF");
            }
            if (n != 0) continue;
            if (this._selector == null) {
                this._selector = Selector.open();
                this._channel.register(this._selector, 4);
            }
            this._selector.select();
        }
    }

    public void destroy() {
        if (this._selector != null) {
            try {
                this._selector.close();
            }
            catch (IOException iOException) {
                LogSupport.ignore(log, iOException);
            }
            this._selector = null;
            this._buffer = null;
            this._flush = null;
            this._channel = null;
        }
    }
}

