/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpServer;
import org.mortbay.http.nio.ByteBufferInputStream;
import org.mortbay.http.nio.SocketChannelOutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.ThreadPool;

public class SocketChannelListener
extends ThreadPool
implements HttpListener {
    private static Log log = LogFactory.getLog(SocketChannelListener.class);
    private InetSocketAddress _address;
    private int _bufferSize = 4096;
    private int _bufferReserve = 512;
    private int _sslPort;
    private int _lingerTimeSecs = 5;
    private HttpHandler _handler;
    private transient HttpServer _server;
    private transient ServerSocketChannel _acceptChannel;
    private transient Selector _selector;
    private transient SelectorThread _selectorThread;
    private transient boolean _isLow = false;
    private transient boolean _isOut = false;
    private transient long _warned = 0L;

    public void setHttpServer(HttpServer httpServer) {
        this._server = httpServer;
    }

    public HttpServer getHttpServer() {
        return this._server;
    }

    public void setHost(String string) throws UnknownHostException {
        this._address = new InetSocketAddress(string, this._address == null ? 0 : this._address.getPort());
    }

    public String getHost() {
        if (this._address == null || this._address.getAddress() == null) {
            return null;
        }
        return this._address.getHostName();
    }

    public void setPort(int n) {
        this._address = this._address == null || this._address.getHostName() == null ? new InetSocketAddress(n) : new InetSocketAddress(this._address.getHostName(), n);
    }

    public int getPort() {
        if (this._address == null) {
            return 0;
        }
        return this._address.getPort();
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferReserve(int n) {
        this._bufferReserve = n;
    }

    public int getBufferReserve() {
        return this._bufferReserve;
    }

    public String getDefaultScheme() {
        return "http";
    }

    public void customizeRequest(HttpConnection httpConnection, HttpRequest httpRequest) {
    }

    public void persistConnection(HttpConnection httpConnection) {
    }

    public boolean isLowOnResources() {
        boolean bl;
        boolean bl2 = bl = this.getMaxThreads() - this.getThreads() + this.getIdleThreads() < this.getMinThreads();
        if (bl && !this._isLow) {
            log.info((Object)("LOW ON THREADS ((" + this.getMaxThreads() + "-" + this.getThreads() + "+" + this.getIdleThreads() + ")<" + this.getMinThreads() + ") on " + this));
            this._warned = System.currentTimeMillis();
            this._isLow = true;
        } else if (!bl && this._isLow && System.currentTimeMillis() - this._warned > 1000L) {
            this._isOut = false;
            this._isLow = false;
        }
        return bl;
    }

    public boolean isOutOfResources() {
        boolean bl;
        boolean bl2 = bl = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (bl && !this._isOut) {
            log.warn((Object)("OUT OF THREADS: " + this));
            this._warned = System.currentTimeMillis();
            this._isLow = true;
            this._isOut = true;
        }
        return bl;
    }

    public int getSslPort() {
        return this._sslPort;
    }

    public void setSslPort(int n) {
        this._sslPort = n;
    }

    public boolean isIntegral(HttpConnection httpConnection) {
        return false;
    }

    public String getIntegralScheme() {
        return "https";
    }

    public int getIntegralPort() {
        return this._sslPort;
    }

    public boolean isConfidential(HttpConnection httpConnection) {
        return false;
    }

    public String getConfidentialScheme() {
        return "https";
    }

    public int getConfidentialPort() {
        return this._sslPort;
    }

    public void setLingerTimeSecs(int n) {
        this._lingerTimeSecs = n;
    }

    public int getLingerTimeSecs() {
        return this._lingerTimeSecs;
    }

    public void setHttpHandler(HttpHandler httpHandler) {
        this._handler = httpHandler;
    }

    public HttpHandler getHttpHandler() {
        return this._handler;
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(false);
        this._acceptChannel.socket().bind(this._address);
        this._address = (InetSocketAddress)this._acceptChannel.socket().getLocalSocketAddress();
        this._selector = Selector.open();
        this._acceptChannel.register(this._selector, 16);
        this._selectorThread = new SelectorThread();
        this._selectorThread.start();
        super.start();
        log.info((Object)("Started SocketChannelListener on " + this.getHost() + ":" + this.getPort()));
    }

    public void stop() throws InterruptedException {
        if (this._selectorThread != null) {
            this._selectorThread.doStop();
        }
        super.stop();
        log.info((Object)("Stopped SocketChannelListener on " + this.getHost() + ":" + this.getPort()));
    }

    private static class Connection
    extends HttpConnection
    implements Runnable {
        boolean _idle = true;
        SocketChannel _channel;
        SelectionKey _key;
        ByteBufferInputStream _in;
        SocketChannelOutputStream _out;
        SocketChannelListener _listener;

        Connection(SocketChannel socketChannel, SelectionKey selectionKey, SocketChannelListener socketChannelListener) {
            super(socketChannelListener, socketChannel.socket().getInetAddress(), new ByteBufferInputStream(socketChannelListener.getBufferSize()), new SocketChannelOutputStream(socketChannel, socketChannelListener.getBufferSize()), socketChannel);
            this._channel = socketChannel;
            this._key = selectionKey;
            this._listener = socketChannelListener;
            this._in = (ByteBufferInputStream)((LineInput)this.getInputStream().getInputStream()).getInputStream();
            this._out = (SocketChannelOutputStream)this.getOutputStream().getOutputStream();
            this._in.setTimeout(socketChannelListener.getMaxIdleTimeMs());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(ByteBuffer byteBuffer) {
            if (!this._idle) {
                this._in.write(byteBuffer);
            } else {
                boolean bl = false;
                for (int i = byteBuffer.position(); i < byteBuffer.limit(); ++i) {
                    byte by = byteBuffer.get(i);
                    if (by <= 32) continue;
                    byteBuffer.position(i);
                    try {
                        bl = true;
                        this._in.write(byteBuffer);
                        this._listener.run(this);
                        this._idle = false;
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        LogSupport.ignore(log, interruptedException);
                        continue;
                    }
                    finally {
                        i = byteBuffer.limit();
                    }
                }
                if (!bl) {
                    this._in.recycle(byteBuffer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.associateThread();
                while (this._in != null && this._in.available() > 0 && this._listener.isStarted()) {
                    if (this.handleNext()) {
                        this.recycle();
                        continue;
                    }
                    this.destroy();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)iOException.toString());
                log.debug((Object)iOException);
                this.destroy();
            }
            finally {
                this._idle = true;
                this.disassociateThread();
            }
        }

        public synchronized void close() throws IOException {
            this._out.close();
            this._in.close();
            if (!this._channel.isOpen()) {
                return;
            }
            this._key.cancel();
            this._channel.socket().shutdownOutput();
            this._channel.close();
            this._channel.socket().close();
            super.close();
            this._channel.close();
        }

        public void destroy() {
            super.destroy();
            if (this._in != null) {
                this._in.destroy();
            }
            this._in = null;
            if (this._out != null) {
                this._out.destroy();
            }
            this._out = null;
            this._channel = null;
            this._key = null;
            this._listener = null;
        }
    }

    private class SelectorThread
    extends Thread {
        boolean _running = false;

        private SelectorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block20: {
                try {
                    this._running = true;
                    while (this._running) {
                        SelectionKey selectionKey = null;
                        try {
                            SocketChannelListener.this._selector.select();
                            Iterator<SelectionKey> iterator = SocketChannelListener.this._selector.selectedKeys().iterator();
                            while (iterator.hasNext()) {
                                selectionKey = iterator.next();
                                if (selectionKey.isAcceptable()) {
                                    this.doAccept(selectionKey);
                                }
                                if (selectionKey.isReadable()) {
                                    this.doRead(selectionKey);
                                }
                                selectionKey = null;
                                iterator.remove();
                            }
                        }
                        catch (Exception exception) {
                            if (this._running) {
                                log.warn((Object)"selector", (Throwable)exception);
                            }
                            if (selectionKey == null) continue;
                            selectionKey.cancel();
                        }
                    }
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    log.info((Object)("Stopping " + this.getName()));
                    try {
                        if (SocketChannelListener.this._acceptChannel != null) {
                            SocketChannelListener.this._acceptChannel.close();
                        }
                    }
                    catch (IOException iOException) {
                        LogSupport.ignore(log, iOException);
                    }
                    try {
                        if (SocketChannelListener.this._selector != null) {
                            SocketChannelListener.this._selector.close();
                        }
                    }
                    catch (IOException iOException) {
                        LogSupport.ignore(log, iOException);
                    }
                    SocketChannelListener.this._selector = null;
                    SocketChannelListener.this._acceptChannel = null;
                    SocketChannelListener.this._selectorThread = null;
                    throw throwable;
                }
                log.info((Object)("Stopping " + this.getName()));
                try {
                    if (SocketChannelListener.this._acceptChannel != null) {
                        SocketChannelListener.this._acceptChannel.close();
                    }
                }
                catch (IOException iOException) {
                    LogSupport.ignore(log, iOException);
                }
                try {
                    if (SocketChannelListener.this._selector != null) {
                        SocketChannelListener.this._selector.close();
                    }
                    break block20;
                }
                catch (IOException iOException) {
                    LogSupport.ignore(log, iOException);
                }
                {
                }
            }
            SocketChannelListener.this._selector = null;
            SocketChannelListener.this._acceptChannel = null;
            SocketChannelListener.this._selectorThread = null;
        }

        void doAccept(SelectionKey selectionKey) throws IOException, InterruptedException {
            if (SocketChannelListener.this.isLowOnResources()) {
                return;
            }
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
            SocketChannel socketChannel = serverSocketChannel.accept();
            socketChannel.configureBlocking(false);
            SelectionKey selectionKey2 = socketChannel.register(SocketChannelListener.this._selector, 1);
            Socket socket = socketChannel.socket();
            try {
                if (SocketChannelListener.this.getMaxIdleTimeMs() >= 0) {
                    socket.setSoTimeout(SocketChannelListener.this.getMaxIdleTimeMs());
                }
                if (SocketChannelListener.this._lingerTimeSecs >= 0) {
                    socket.setSoLinger(true, SocketChannelListener.this._lingerTimeSecs);
                } else {
                    socket.setSoLinger(false, 0);
                }
            }
            catch (Exception exception) {
                LogSupport.ignore(log, exception);
            }
            Connection connection = new Connection(socketChannel, selectionKey2, SocketChannelListener.this);
            selectionKey2.attach(connection);
        }

        void doRead(SelectionKey selectionKey) throws IOException {
            Connection connection = (Connection)selectionKey.attachment();
            if (connection._idle && SocketChannelListener.this.isOutOfResources()) {
                return;
            }
            ByteBuffer byteBuffer = connection._in.getBuffer();
            int n = ((SocketChannel)selectionKey.channel()).read(byteBuffer);
            if (n < 0) {
                connection.close();
            } else {
                byteBuffer.flip();
                connection.write(byteBuffer);
            }
        }

        void doStop() {
            this._running = false;
            SocketChannelListener.this._selector.wakeup();
            Thread.yield();
        }
    }
}

