/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpServer;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LogSupport;
import org.mortbay.util.ThreadedServer;

public class SocketListener
extends ThreadedServer
implements HttpListener {
    private static Log log = LogFactory.getLog(SocketListener.class);
    private int _lowResourcePersistTimeMs = 2000;
    private String _scheme = "http";
    private String _integralScheme = "https";
    private String _confidentialScheme = "https";
    private int _integralPort = 0;
    private int _confidentialPort = 0;
    private boolean _identifyListener = false;
    private int _bufferSize = 8192;
    private int _bufferReserve = 512;
    private HttpHandler _handler;
    private int _lowResources;
    private transient HttpServer _server;
    private transient boolean _isLow = false;
    private transient boolean _isOut = false;
    private transient long _warned = 0L;

    public SocketListener() {
    }

    public SocketListener(InetAddrPort inetAddrPort) {
        super(inetAddrPort);
    }

    public HttpServer getHttpServer() {
        return this._server;
    }

    public void setHttpServer(HttpServer httpServer) {
        if (httpServer != null && this._server != null && this._server != httpServer) {
            throw new IllegalStateException("Cannot share listeners");
        }
        this._server = httpServer;
    }

    public HttpHandler getHttpHandler() {
        return this._handler;
    }

    public void setHttpHandler(HttpHandler httpHandler) {
        this._handler = httpHandler;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public int getBufferReserve() {
        return this._bufferReserve;
    }

    public void setBufferReserve(int n) {
        this._bufferReserve = n;
    }

    public boolean getIdentifyListener() {
        return this._identifyListener;
    }

    public void setIdentifyListener(boolean bl) {
        this._identifyListener = bl;
    }

    public void setDefaultScheme(String string) {
        this._scheme = string;
    }

    public String getDefaultScheme() {
        return this._scheme;
    }

    public int getLowResources() {
        return this._lowResources;
    }

    public void setLowResources(int n) {
        this._lowResources = n;
    }

    public int getLowResourcePersistTimeMs() {
        return this._lowResourcePersistTimeMs;
    }

    public void setLowResourcePersistTimeMs(int n) {
        this._lowResourcePersistTimeMs = n;
    }

    public void start() throws Exception {
        super.start();
        log.info((Object)("Started SocketListener on " + this.getInetAddrPort()));
    }

    public void stop() throws InterruptedException {
        super.stop();
        log.info((Object)("Stopped SocketListener on " + this.getInetAddrPort()));
    }

    public void handleConnection(Socket socket) throws IOException {
        HttpConnection httpConnection = this.createConnection(socket);
        try {
            if (this._lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                socket.setSoTimeout(this._lowResourcePersistTimeMs);
                httpConnection.setThrottled(true);
            } else {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
                httpConnection.setThrottled(false);
            }
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
        httpConnection.handle();
    }

    protected HttpConnection createConnection(Socket socket) throws IOException {
        HttpConnection httpConnection = new HttpConnection(this, socket.getInetAddress(), socket.getInputStream(), socket.getOutputStream(), socket);
        return httpConnection;
    }

    public void customizeRequest(HttpConnection httpConnection, HttpRequest httpRequest) {
        if (this._identifyListener) {
            httpRequest.setAttribute("org.mortbay.http.HttpListener", this.getName());
        }
        Socket socket = (Socket)httpConnection.getConnection();
        this.customizeRequest(socket, httpRequest);
    }

    protected void customizeRequest(Socket socket, HttpRequest httpRequest) {
        try {
            if (httpRequest.getHttpConnection().isThrottled()) {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
                httpRequest.getHttpConnection().setThrottled(false);
            }
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
        }
    }

    public void persistConnection(HttpConnection httpConnection) {
        try {
            Socket socket = (Socket)httpConnection.getConnection();
            if (this._lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                socket.setSoTimeout(this._lowResourcePersistTimeMs);
                httpConnection.setThrottled(true);
            } else {
                httpConnection.setThrottled(false);
            }
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
        }
    }

    public boolean isLowOnResources() {
        boolean bl;
        int n = this.getMaxThreads() - this.getThreads();
        int n2 = this._lowResources > 0 ? this._lowResources : this.getMinThreads();
        boolean bl2 = bl = n + this.getIdleThreads() < n2;
        if (bl && !this._isLow) {
            log.info((Object)("LOW ON THREADS ((" + this.getMaxThreads() + "-" + this.getThreads() + "+" + this.getIdleThreads() + ")<" + this.getMinThreads() + ") on " + this));
            this._warned = System.currentTimeMillis();
            this._isLow = true;
        } else if (!bl && this._isLow && System.currentTimeMillis() - this._warned > 1000L) {
            this._isOut = false;
            this._isLow = false;
        }
        return bl;
    }

    public boolean isOutOfResources() {
        boolean bl;
        boolean bl2 = bl = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (bl && !this._isOut) {
            log.warn((Object)("OUT OF THREADS: " + this));
            this._warned = System.currentTimeMillis();
            this._isLow = true;
            this._isOut = true;
        }
        return bl;
    }

    public boolean isIntegral(HttpConnection httpConnection) {
        return false;
    }

    public boolean isConfidential(HttpConnection httpConnection) {
        return false;
    }

    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public void setIntegralScheme(String string) {
        this._integralScheme = string;
    }

    public int getIntegralPort() {
        return this._integralPort;
    }

    public void setIntegralPort(int n) {
        this._integralPort = n;
    }

    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public void setConfidentialScheme(String string) {
        this._confidentialScheme = string;
    }

    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public void setConfidentialPort(int n) {
        this._confidentialPort = n;
    }
}

