/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.SingletonList;
import org.mortbay.util.StringMap;

public class PathMap
extends HashMap
implements Externalizable {
    private static Log log = LogFactory.getLog(PathMap.class);
    private static String __pathSpecSeparators = System.getProperty("org.mortbay.http.PathMap.separators", ":,");
    StringMap _prefixMap = new StringMap();
    StringMap _suffixMap = new StringMap();
    StringMap _exactMap = new StringMap();
    List _defaultSingletonList = null;
    Map.Entry _prefixDefault = null;
    Map.Entry _default = null;
    Set _entrySet;
    boolean _nodefault = false;

    public static void setPathSpecSeparators(String string) {
        __pathSpecSeparators = string;
    }

    public PathMap() {
        super(11);
        this._entrySet = this.entrySet();
    }

    public PathMap(boolean bl) {
        super(11);
        this._entrySet = this.entrySet();
        this._nodefault = bl;
    }

    public PathMap(int n) {
        super(n);
        this._entrySet = this.entrySet();
    }

    public PathMap(Map map) {
        this.putAll(map);
        this._entrySet = this.entrySet();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        HashMap hashMap = new HashMap(this);
        objectOutput.writeObject(hashMap);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        HashMap hashMap = (HashMap)objectInput.readObject();
        this.putAll(hashMap);
    }

    public synchronized Object put(Object object, Object object2) {
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), __pathSpecSeparators);
        Object object3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!string.startsWith("/") && !string.startsWith("*.")) {
                log.warn((Object)("PathSpec " + string + ". must start with '/' or '*.'"));
                string = "/" + string;
            }
            object3 = super.put(string, object2);
            Entry entry = new Entry(string, object2);
            if (!entry.getKey().equals(string)) continue;
            if (string.equals("/*")) {
                this._prefixDefault = entry;
                continue;
            }
            if (string.endsWith("/*")) {
                this._prefixMap.put(string.substring(0, string.length() - 2), (Object)entry);
                this._exactMap.put(string.substring(0, string.length() - 1), (Object)entry);
                this._exactMap.put(string.substring(0, string.length() - 2), (Object)entry);
                continue;
            }
            if (string.startsWith("*.")) {
                this._suffixMap.put(string.substring(2), (Object)entry);
                continue;
            }
            if (string.equals("/")) {
                if (this._nodefault) {
                    this._exactMap.put(string, (Object)entry);
                    continue;
                }
                this._default = entry;
                this._defaultSingletonList = SingletonList.newSingletonList(this._default);
                continue;
            }
            this._exactMap.put(string, (Object)entry);
        }
        return object3;
    }

    public Object match(String string) {
        Map.Entry entry = this.getMatch(string);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry getMatch(String string) {
        Map.Entry entry;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n < 0 && (n = string.indexOf(63)) < 0) {
            n = string.length();
        }
        if ((entry = this._exactMap.getEntry(string, 0, n)) != null) {
            return (Map.Entry)entry.getValue();
        }
        int n2 = n;
        while ((n2 = string.lastIndexOf(47, n2 - 1)) >= 0) {
            entry = this._prefixMap.getEntry(string, 0, n2);
            if (entry == null) continue;
            return (Map.Entry)entry.getValue();
        }
        if (this._prefixDefault != null) {
            return this._prefixDefault;
        }
        n2 = 0;
        while ((n2 = string.indexOf(46, n2 + 1)) > 0) {
            entry = this._suffixMap.getEntry(string, n2 + 1, n - n2 - 1);
            if (entry == null) continue;
            return (Map.Entry)entry.getValue();
        }
        return this._default;
    }

    public List getMatches(String string) {
        Map.Entry entry;
        Object object = null;
        if (string == null) {
            return LazyList.getList(object);
        }
        int n = string.indexOf(59);
        if (n < 0 && (n = string.indexOf(63)) < 0) {
            n = string.length();
        }
        if ((entry = this._exactMap.getEntry(string, 0, n)) != null) {
            object = LazyList.add(object, entry.getValue());
        }
        int n2 = n - 1;
        while ((n2 = string.lastIndexOf(47, n2 - 1)) >= 0) {
            entry = this._prefixMap.getEntry(string, 0, n2);
            if (entry == null) continue;
            object = LazyList.add(object, entry.getValue());
        }
        if (this._prefixDefault != null) {
            object = LazyList.add(object, this._prefixDefault);
        }
        n2 = 0;
        while ((n2 = string.indexOf(46, n2 + 1)) > 0) {
            entry = this._suffixMap.getEntry(string, n2 + 1, n - n2 - 1);
            if (entry == null) continue;
            object = LazyList.add(object, entry.getValue());
        }
        if (this._default != null) {
            if (object == null) {
                return this._defaultSingletonList;
            }
            object = LazyList.add(object, this._default);
        }
        return LazyList.getList(object);
    }

    public synchronized Object remove(Object object) {
        if (object != null) {
            String string = (String)object;
            if (string.equals("/*")) {
                this._prefixDefault = null;
            } else if (string.endsWith("/*")) {
                this._prefixMap.remove(string.substring(0, string.length() - 2));
                this._exactMap.remove(string.substring(0, string.length() - 1));
                this._exactMap.remove(string.substring(0, string.length() - 2));
            } else if (string.startsWith("*.")) {
                this._suffixMap.remove(string.substring(2));
            } else if (string.equals("/")) {
                this._default = null;
                this._defaultSingletonList = null;
            } else {
                this._exactMap.remove(string);
            }
        }
        return super.remove(object);
    }

    public void clear() {
        this._exactMap = new StringMap();
        this._prefixMap = new StringMap();
        this._suffixMap = new StringMap();
        this._default = null;
        this._defaultSingletonList = null;
        super.clear();
    }

    public static boolean match(String string, String string2) throws IllegalArgumentException {
        char c = string.charAt(0);
        if (c == '/') {
            if (string.length() == 1 || string.equals(string2)) {
                return true;
            }
            if (string.endsWith("/*") && string.regionMatches(0, string2, 0, string.length() - 2)) {
                return true;
            }
            if (string2.startsWith(string) && string2.charAt(string.length()) == ';') {
                return true;
            }
        } else if (c == '*') {
            return string2.regionMatches(string2.length() - string.length() + 1, string, 1, string.length() - 1);
        }
        return false;
    }

    public static boolean match(String string, String string2, boolean bl) throws IllegalArgumentException {
        char c = string.charAt(0);
        if (c == '/') {
            if (!bl && string.length() == 1 || string.equals(string2)) {
                return true;
            }
            if (string.endsWith("/*") && string.regionMatches(0, string2, 0, string.length() - 2)) {
                return true;
            }
            if (string2.startsWith(string) && string2.charAt(string.length()) == ';') {
                return true;
            }
        } else if (c == '*') {
            return string2.regionMatches(string2.length() - string.length() + 1, string, 1, string.length() - 1);
        }
        return false;
    }

    public static String pathMatch(String string, String string2) {
        char c = string.charAt(0);
        if (c == '/') {
            if (string.length() == 1) {
                return string2;
            }
            if (string.equals(string2)) {
                return string2;
            }
            if (string.endsWith("/*") && string.regionMatches(0, string2, 0, string.length() - 2)) {
                return string2.substring(0, string.length() - 2);
            }
            if (string2.startsWith(string) && string2.charAt(string.length()) == ';') {
                return string2;
            }
        } else if (c == '*' && string2.regionMatches(string2.length() - (string.length() - 1), string, 1, string.length() - 1)) {
            return string2;
        }
        return null;
    }

    public static String pathInfo(String string, String string2) {
        char c = string.charAt(0);
        if (c == '/') {
            if (string.length() == 1) {
                return null;
            }
            if (string.equals(string2)) {
                return null;
            }
            if (string.endsWith("/*") && string.regionMatches(0, string2, 0, string.length() - 2)) {
                if (string2.length() == string.length() - 2) {
                    return null;
                }
                return string2.substring(string.length() - 2);
            }
        }
        return null;
    }

    public static String relativePath(String string, String string2, String string3) {
        String string4 = PathMap.pathInfo(string2, string3);
        if (string4 == null) {
            string4 = string3;
        }
        if (string4.startsWith("./")) {
            string4 = string4.substring(2);
        }
        string3 = string.endsWith("/") ? (string4.startsWith("/") ? string + string4.substring(1) : string + string4) : (string4.startsWith("/") ? string + string4 : string + "/" + string4);
        return string3;
    }

    private static class Entry
    implements Map.Entry {
        private Object key;
        private Object value;
        private transient String string;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            if (this.string == null) {
                this.string = this.key + "=" + this.value;
            }
            return this.string;
        }
    }
}

