/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletSSL;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;

public abstract class JsseListener
extends SocketListener {
    private static Log log = LogFactory.getLog(JsseListener.class);
    public static final String KEYSTORE_PROPERTY = "jetty.ssl.keystore";
    public static final String KEYSTORE_TYPE_PROPERTY = "jetty.ssl.keystore.type";
    public static final String DEFAULT_KEYSTORE_TYPE = System.getProperty("jetty.ssl.keystore.type", KeyStore.getDefaultType());
    public static final String KEYSTORE_PROVIDER_NAME_PROPERTY = "jetty.ssl.keystore.provider.name";
    public static final String KEYSTORE_PROVIDER_CLASS_PROPERTY = "jetty.ssl.keystore.provider.class";
    public static final String DEFAULT_KEYSTORE_PROVIDER_CLASS = System.getProperty("jetty.ssl.keystore.provider.class");
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String DEFAULT_KEYSTORE_PROVIDER_NAME = System.getProperty("jetty.ssl.keystore.provider.name");
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private boolean _needClientAuth = false;

    public JsseListener() {
        this.setDefaultScheme("https");
    }

    public JsseListener(InetAddrPort inetAddrPort) {
        super(inetAddrPort);
        if (inetAddrPort.getPort() == 0) {
            inetAddrPort.setPort(443);
            this.setPort(443);
        }
        this.setDefaultScheme("https");
    }

    public void setNeedClientAuth(boolean bl) {
        this._needClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public boolean isIntegral(HttpConnection httpConnection) {
        int n = this.getIntegralPort();
        return n == 0 || n == this.getPort();
    }

    public boolean isConfidential(HttpConnection httpConnection) {
        int n = this.getConfidentialPort();
        return n == 0 || n == this.getPort();
    }

    protected abstract SSLServerSocketFactory createFactory() throws Exception;

    protected ServerSocket newServerSocket(InetAddrPort inetAddrPort, int n) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory = null;
        SSLServerSocket sSLServerSocket = null;
        try {
            sSLServerSocketFactory = this.createFactory();
            sSLServerSocket = inetAddrPort == null ? (SSLServerSocket)sSLServerSocketFactory.createServerSocket(0, n) : (SSLServerSocket)sSLServerSocketFactory.createServerSocket(inetAddrPort.getPort(), n, inetAddrPort.getInetAddress());
            sSLServerSocket.setNeedClientAuth(this._needClientAuth);
            log.info((Object)("JsseListener.needClientAuth=" + this._needClientAuth));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IOException("Could not create JsseListener: " + exception.toString());
        }
        return sSLServerSocket;
    }

    protected Socket accept(ServerSocket serverSocket) throws IOException {
        try {
            SSLSocket sSLSocket = (SSLSocket)serverSocket.accept();
            if (this.getMaxIdleTimeMs() > 0) {
                sSLSocket.setSoTimeout(this.getMaxIdleTimeMs());
            }
            sSLSocket.startHandshake();
            return sSLSocket;
        }
        catch (SSLException sSLException) {
            log.warn((Object)"EXCEPTION ", (Throwable)sSLException);
            throw new IOException(sSLException.getMessage());
        }
    }

    protected void customizeRequest(Socket socket, HttpRequest httpRequest) {
        super.customizeRequest(socket, httpRequest);
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        try {
            java.security.cert.X509Certificate[] x509CertificateArray;
            Integer n;
            SSLSocket sSLSocket = (SSLSocket)socket;
            SSLSession sSLSession = sSLSocket.getSession();
            String string = sSLSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sSLSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                n = cachedInfo.getKeySize();
                x509CertificateArray = cachedInfo.getCerts();
            } else {
                n = new Integer(ServletSSL.deduceKeyLength(string));
                x509CertificateArray = JsseListener.getCertChain(sSLSession);
                cachedInfo = new CachedInfo(n, x509CertificateArray);
                sSLSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (x509CertificateArray != null) {
                httpRequest.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
            } else if (this._needClientAuth) {
                throw new HttpException(403);
            }
            httpRequest.setAttribute("javax.servlet.request.cipher_suite", string);
            httpRequest.setAttribute("javax.servlet.request.key_size", n);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sSLSession) {
        try {
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                return null;
            }
            int n = x509CertificateArray.length;
            java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[n];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < n; ++i) {
                byte[] byArray = x509CertificateArray[i].getEncoded();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                x509CertificateArray2[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            }
            return x509CertificateArray2;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            return null;
        }
    }

    private class CachedInfo {
        private Integer _keySize;
        private java.security.cert.X509Certificate[] _certs;

        CachedInfo(Integer n, java.security.cert.X509Certificate[] x509CertificateArray) {
            this._keySize = n;
            this._certs = x509CertificateArray;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }
    }
}

