/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpOnlyCookie;
import org.mortbay.log.LogFactory;
import org.mortbay.util.DateCache;
import org.mortbay.util.LazyList;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;

public class HttpFields {
    private static Log log = LogFactory.getLog(HttpFields.class);
    public static final String __CacheControl = "Cache-Control";
    public static final String __Connection = "Connection";
    public static final String __Date = "Date";
    public static final String __Pragma = "Pragma";
    public static final String __ProxyConnection = "Proxy-Connection";
    public static final String __Trailer = "Trailer";
    public static final String __TransferEncoding = "Transfer-Encoding";
    public static final String __Upgrade = "Upgrade";
    public static final String __Via = "Via";
    public static final String __Warning = "Warning";
    public static final String __Allow = "Allow";
    public static final String __ContentEncoding = "Content-Encoding";
    public static final String __ContentLanguage = "Content-Language";
    public static final String __ContentLength = "Content-Length";
    public static final String __ContentLocation = "Content-Location";
    public static final String __ContentMD5 = "Content-MD5";
    public static final String __ContentRange = "Content-Range";
    public static final String __ContentType = "Content-Type";
    public static final String __Expires = "Expires";
    public static final String __LastModified = "Last-Modified";
    public static final String __Accept = "Accept";
    public static final String __AcceptCharset = "Accept-Charset";
    public static final String __AcceptEncoding = "Accept-Encoding";
    public static final String __AcceptLanguage = "Accept-Language";
    public static final String __Authorization = "Authorization";
    public static final String __Expect = "Expect";
    public static final String __Forwarded = "Forwarded";
    public static final String __From = "From";
    public static final String __Host = "Host";
    public static final String __IfMatch = "If-Match";
    public static final String __IfModifiedSince = "If-Modified-Since";
    public static final String __IfNoneMatch = "If-None-Match";
    public static final String __IfRange = "If-Range";
    public static final String __IfUnmodifiedSince = "If-Unmodified-Since";
    public static final String __KeepAlive = "keep-alive";
    public static final String __MaxForwards = "Max-Forwards";
    public static final String __ProxyAuthorization = "Proxy-Authorization";
    public static final String __Range = "Range";
    public static final String __RequestRange = "Request-Range";
    public static final String __Referer = "Referer";
    public static final String __TE = "TE";
    public static final String __UserAgent = "User-Agent";
    public static final String __XForwardedFor = "X-Forwarded-For";
    public static final String __AcceptRanges = "Accept-Ranges";
    public static final String __Age = "Age";
    public static final String __ETag = "ETag";
    public static final String __Location = "Location";
    public static final String __ProxyAuthenticate = "Proxy-Authenticate";
    public static final String __RetryAfter = "Retry-After";
    public static final String __Server = "Server";
    public static final String __ServletEngine = "Servlet-Engine";
    public static final String __Vary = "Vary";
    public static final String __WwwAuthenticate = "WWW-Authenticate";
    public static final String __Cookie = "Cookie";
    public static final String __SetCookie = "Set-Cookie";
    public static final String __SetCookie2 = "Set-Cookie2";
    public static final String __MimeVersion = "MIME-Version";
    public static final String __Identity = "identity";
    public static final String __SoapAction = "SOAPAction";
    private static final StringMap __info = new StringMap(true);
    private static final StringMap __values = new StringMap(true);
    private static final int __maxCacheSize = 128;
    public static final String __Chunked = "chunked";
    public static final String __Close = "close";
    public static final String __TextHtml = "text/html";
    public static final String __MessageHttp = "message/http";
    public static final String __WwwFormUrlEncode = "application/x-www-form-urlencoded";
    public static final String __ExpectContinue = "100-continue";
    public static final String __separators = ", \t";
    public static final char[] __CRLF;
    public static final char[] __COLON;
    private static String[] DAYS;
    private static String[] MONTHS;
    private static TimeZone __GMT;
    public static final DateCache __dateCache;
    private static final String[] __dateReceiveFmt;
    public static SimpleDateFormat[] __dateReceiveSource;
    public static final ThreadLocal __dateReceiveCache;
    public static final String __01Jan1970;
    private static Float __one;
    private static Float __zero;
    private static StringMap __qualities;
    private ArrayList _fields = new ArrayList(15);
    private int[] _index = new int[128];
    private int _version;
    private SimpleDateFormat[] _dateReceive;
    private StringBuffer _dateBuffer;
    private HttpCal _calendar;
    static /* synthetic */ Class class$org$mortbay$http$HttpFields$FieldInfo;

    private static FieldInfo getFieldInfo(String string) {
        FieldInfo fieldInfo = (FieldInfo)__info.get(string);
        if (fieldInfo == null) {
            fieldInfo = new FieldInfo(string, false);
        }
        return fieldInfo;
    }

    private static FieldInfo getFieldInfo(char[] cArray, int n, int n2) {
        Map.Entry entry = __info.getEntry(cArray, n, n2);
        if (entry == null) {
            return new FieldInfo(new String(cArray, n, n2), false);
        }
        return (FieldInfo)entry.getValue();
    }

    public static String formatDate(long l, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(32);
        HttpCal httpCal = new HttpCal();
        httpCal.setTimeInMillis(l);
        HttpFields.formatDate(stringBuffer, httpCal, bl);
        return stringBuffer.toString();
    }

    public static String formatDate(Calendar calendar, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(32);
        HttpFields.formatDate(stringBuffer, calendar, bl);
        return stringBuffer.toString();
    }

    public static String formatDate(StringBuffer stringBuffer, long l, boolean bl) {
        HttpCal httpCal = new HttpCal();
        httpCal.setTimeInMillis(l);
        HttpFields.formatDate(stringBuffer, httpCal, bl);
        return stringBuffer.toString();
    }

    public static void formatDate(StringBuffer stringBuffer, Calendar calendar, boolean bl) {
        int n = calendar.get(7);
        int n2 = calendar.get(5);
        int n3 = calendar.get(2);
        int n4 = calendar.get(1);
        int n5 = n4 / 100;
        n4 %= 100;
        long l = calendar instanceof HttpCal ? ((HttpCal)calendar).getTimeInMillis() : calendar.getTime().getTime();
        int n6 = (int)(l / 1000L % 86400L);
        int n7 = n6 % 60;
        int n8 = (n6 /= 60) % 60;
        int n9 = n6 / 60;
        stringBuffer.append(DAYS[n]);
        stringBuffer.append(',');
        stringBuffer.append(' ');
        StringUtil.append2digits(stringBuffer, n2);
        if (bl) {
            stringBuffer.append('-');
            stringBuffer.append(MONTHS[n3]);
            stringBuffer.append('-');
            StringUtil.append2digits(stringBuffer, n4);
        } else {
            stringBuffer.append(' ');
            stringBuffer.append(MONTHS[n3]);
            stringBuffer.append(' ');
            StringUtil.append2digits(stringBuffer, n5);
            StringUtil.append2digits(stringBuffer, n4);
        }
        stringBuffer.append(' ');
        StringUtil.append2digits(stringBuffer, n9);
        stringBuffer.append(':');
        StringUtil.append2digits(stringBuffer, n8);
        stringBuffer.append(':');
        StringUtil.append2digits(stringBuffer, n7);
        stringBuffer.append(" GMT");
    }

    public HttpFields() {
        Arrays.fill(this._index, -1);
    }

    public int size() {
        return this._fields.size();
    }

    public Enumeration getFieldNames() {
        return new Enumeration(){
            int i = 0;
            Field field = null;

            public boolean hasMoreElements() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this._fields.size()) {
                    Field field = (Field)HttpFields.this._fields.get(this.i++);
                    if (field == null || field._version != HttpFields.this._version || field._prev != null) continue;
                    this.field = field;
                    return true;
                }
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.field != null || this.hasMoreElements()) {
                    String string = this.field._info._name;
                    this.field = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    Field getField(String string) {
        FieldInfo fieldInfo = HttpFields.getFieldInfo(string);
        return this.getField(fieldInfo, true);
    }

    Field getField(FieldInfo fieldInfo, boolean bl) {
        int n = fieldInfo.hashCode();
        if (n < this._index.length) {
            if (this._index[n] >= 0) {
                Field field = (Field)this._fields.get(this._index[n]);
                return field != null && (!bl || field._version == this._version) ? field : null;
            }
        } else {
            for (int i = 0; i < this._fields.size(); ++i) {
                Field field = (Field)this._fields.get(i);
                if (!fieldInfo.equals(field._info) || bl && field._version != this._version) continue;
                return field;
            }
        }
        return null;
    }

    public boolean containsKey(String string) {
        FieldInfo fieldInfo = HttpFields.getFieldInfo(string);
        return this.getField(fieldInfo, true) != null;
    }

    public String get(String string) {
        FieldInfo fieldInfo = HttpFields.getFieldInfo(string);
        Field field = this.getField(fieldInfo, true);
        if (field != null) {
            return field._value;
        }
        return null;
    }

    public Enumeration getValues(String string) {
        FieldInfo fieldInfo = HttpFields.getFieldInfo(string);
        final Field field = this.getField(fieldInfo, true);
        if (field != null) {
            return new Enumeration(){
                Field f;
                {
                    this.f = field;
                }

                public boolean hasMoreElements() {
                    while (this.f != null && this.f._version != HttpFields.this._version) {
                        this.f = this.f._next;
                    }
                    return this.f != null;
                }

                public Object nextElement() throws NoSuchElementException {
                    if (this.f == null) {
                        throw new NoSuchElementException();
                    }
                    Field field2 = this.f;
                    do {
                        this.f = this.f._next;
                    } while (this.f != null && this.f._version != HttpFields.this._version);
                    return field2._value;
                }
            };
        }
        return null;
    }

    public Enumeration getValues(String string, final String string2) {
        final Enumeration enumeration = this.getValues(string);
        if (enumeration == null) {
            return null;
        }
        return new Enumeration(){
            QuotedStringTokenizer tok = null;

            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.tok = new QuotedStringTokenizer(string, string2, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = (String)this.tok.nextElement();
                if (string != null) {
                    string = string.trim();
                }
                return string;
            }
        };
    }

    public String put(String string, String string2) {
        if (string2 == null) {
            return this.remove(string);
        }
        FieldInfo fieldInfo = HttpFields.getFieldInfo(string);
        Field field = this.getField(fieldInfo, false);
        if (field != null) {
            String string3 = field._version == this._version ? field._value : null;
            field.reset(string2, this._version);
            field = field._next;
            while (field != null) {
                field.clear();
                field = field._next;
            }
            return string3;
        }
        field = new Field(fieldInfo, string2, this._version);
        int n = fieldInfo.hashCode();
        if (n < this._index.length) {
            this._index[n] = this._fields.size();
        }
        this._fields.add(field);
        return null;
    }

    public void put(String string, List list) {
        if (list == null || list.size() == 0) {
            this.remove(string);
            return;
        }
        Object e = list.get(0);
        if (e != null) {
            this.put(string, e.toString());
        } else {
            this.remove(string);
        }
        if (list.size() > 1) {
            Iterator iterator = list.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (e == null) continue;
                this.add(string, e.toString());
            }
        }
    }

    public void add(String string, String string2) throws IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException("null value");
        }
        FieldInfo fieldInfo = HttpFields.getFieldInfo(string);
        Field field = this.getField(fieldInfo, false);
        Field field2 = null;
        if (field != null) {
            while (field != null && field._version == this._version) {
                field2 = field;
                field = field._next;
            }
        }
        if (field != null) {
            field.reset(string2, this._version);
        } else {
            field = new Field(fieldInfo, string2, this._version);
            if (field2 != null) {
                field._prev = field2;
                field2._next = field;
            } else if (fieldInfo.hashCode() < this._index.length) {
                this._index[fieldInfo.hashCode()] = this._fields.size();
            }
            this._fields.add(field);
        }
    }

    public String remove(String string) {
        String string2 = null;
        FieldInfo fieldInfo = HttpFields.getFieldInfo(string);
        Field field = this.getField(fieldInfo, true);
        if (field != null) {
            string2 = field._value;
            while (field != null) {
                field.clear();
                field = field._next;
            }
        }
        return string2;
    }

    public int getIntField(String string) throws NumberFormatException {
        String string2 = HttpFields.valueParameters(this.get(string), null);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return -1;
    }

    public long getDateField(String string) {
        int n;
        String string2 = HttpFields.valueParameters(this.get(string), null);
        if (string2 == null) {
            return -1L;
        }
        if (this._dateReceive == null) {
            this._dateReceive = (SimpleDateFormat[])__dateReceiveCache.get();
            if (this._dateReceive == null) {
                this._dateReceive = new SimpleDateFormat[__dateReceiveSource.length];
                __dateReceiveCache.set(this._dateReceive);
            }
        }
        for (n = 0; n < this._dateReceive.length; ++n) {
            if (this._dateReceive[n] == null) {
                this._dateReceive[n] = (SimpleDateFormat)__dateReceiveSource[n].clone();
            }
            try {
                Date date = (Date)this._dateReceive[n].parseObject(string2);
                return date.getTime();
            }
            catch (Exception exception) {
                LogSupport.ignore(log, exception);
                continue;
            }
        }
        if (string2.endsWith(" GMT")) {
            string2 = string2.substring(0, string2.length() - 4);
            for (n = 0; n < this._dateReceive.length; ++n) {
                try {
                    Date date = (Date)this._dateReceive[n].parseObject(string2);
                    return date.getTime();
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                    continue;
                }
            }
        }
        throw new IllegalArgumentException(string2);
    }

    public void putIntField(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public void putDateField(String string, Date date) {
        this.putDateField(string, date.getTime());
    }

    public void addDateField(String string, Date date) {
        this.addDateField(string, date.getTime());
    }

    public void addDateField(String string, long l) {
        if (this._dateBuffer == null) {
            this._dateBuffer = new StringBuffer(32);
            this._calendar = new HttpCal();
        }
        this._dateBuffer.setLength(0);
        this._calendar.setTimeInMillis(l);
        HttpFields.formatDate(this._dateBuffer, this._calendar, false);
        this.add(string, this._dateBuffer.toString());
    }

    public void putDateField(String string, long l) {
        if (this._dateBuffer == null) {
            this._dateBuffer = new StringBuffer(32);
            this._calendar = new HttpCal();
        }
        this._dateBuffer.setLength(0);
        this._calendar.setTimeInMillis(l);
        HttpFields.formatDate(this._dateBuffer, this._calendar, false);
        this.put(string, this._dateBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(LineInput lineInput) throws IOException {
        Field field = null;
        char[] cArray = null;
        int n = 0;
        LineInput lineInput2 = lineInput;
        synchronized (lineInput2) {
            LineInput.LineBuffer lineBuffer;
            while ((lineBuffer = lineInput.readLineBuffer()) != null) {
                cArray = lineBuffer.buffer;
                n = lineBuffer.size;
                if (n == 0) break;
                int n2 = -1;
                int n3 = -1;
                int n4 = 0;
                int n5 = 0;
                char c = cArray[0];
                if (c != ' ' && c != '\t') {
                    n3 = 0;
                    for (n5 = 1; n5 < n; ++n5) {
                        c = cArray[n5];
                        if (c == ':') {
                            n4 = n3 + 1;
                            break;
                        }
                        if (c == ' ' || c == '\t') continue;
                        n3 = n5;
                    }
                }
                ++n5;
                while (n5 < n) {
                    c = cArray[n5];
                    if (c != ' ' && c != '\t') {
                        n2 = n5;
                        n3 = n5 - 1;
                        break;
                    }
                    ++n5;
                }
                n5 = n;
                while (n5-- > n2 && n5 >= 0) {
                    c = cArray[n5];
                    if (c == ' ' || c == '\t') continue;
                    n3 = n5;
                    break;
                }
                if (n4 <= 0) {
                    if (n2 <= 0 || field == null) continue;
                    field._value = field._value + ' ' + new String(cArray, n2, n3 - n2 + 1);
                    continue;
                }
                FieldInfo fieldInfo = HttpFields.getFieldInfo(cArray, 0, n4);
                Field field2 = this.getField(fieldInfo, false);
                field = null;
                if (field2 != null) {
                    while (field2 != null && field2._version == this._version) {
                        field = field2;
                        field2 = field2._next;
                    }
                }
                if (field2 != null) {
                    if (n2 >= 0) {
                        field2.reset(cArray, n2, n3 - n2 + 1, this._version);
                    } else {
                        field2.reset("", this._version);
                    }
                } else {
                    field2 = n2 >= 0 ? new Field(fieldInfo, cArray, n2, n3 - n2 + 1, this._version) : new Field(fieldInfo, "", this._version);
                    if (field != null) {
                        field2._prev = field;
                        field._next = field2;
                    } else if (fieldInfo.hashCode() < this._index.length) {
                        this._index[fieldInfo.hashCode()] = this._fields.size();
                    }
                    this._fields.add(field2);
                }
                field = field2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer) throws IOException {
        Writer writer2 = writer;
        synchronized (writer2) {
            for (int i = 0; i < this._fields.size(); ++i) {
                Field field = (Field)this._fields.get(i);
                if (field == null) continue;
                field.write(writer, this._version);
            }
            writer.write(__CRLF);
        }
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clear() {
        ++this._version;
        if (this._version > 1000) {
            this._version = 0;
            int n = this._fields.size();
            while (n-- > 0) {
                Field field = (Field)this._fields.get(n);
                if (field == null) continue;
                field.clear();
            }
        }
    }

    public void destroy() {
        int n = this._fields.size();
        while (n-- > 0) {
            Field field = (Field)this._fields.get(n);
            if (field == null) continue;
            field.destroy();
        }
        this._fields = null;
        this._index = null;
        this._dateBuffer = null;
        this._calendar = null;
        this._dateReceive = null;
    }

    public static String valueParameters(String string, Map map) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            return string;
        }
        if (map == null) {
            return string.substring(0, n).trim();
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(n), ";", false, true);
        while (((StringTokenizer)quotedStringTokenizer).hasMoreTokens()) {
            String string2 = ((StringTokenizer)quotedStringTokenizer).nextToken();
            QuotedStringTokenizer quotedStringTokenizer2 = new QuotedStringTokenizer(string2, "= ");
            if (!((StringTokenizer)quotedStringTokenizer2).hasMoreTokens()) continue;
            String string3 = ((StringTokenizer)quotedStringTokenizer2).nextToken();
            String string4 = null;
            if (((StringTokenizer)quotedStringTokenizer2).hasMoreTokens()) {
                string4 = ((StringTokenizer)quotedStringTokenizer2).nextToken();
            }
            map.put(string3, string4);
        }
        return string.substring(0, n).trim();
    }

    public static Float getQuality(String string) {
        Object object;
        if (string == null) {
            return __zero;
        }
        int n = string.indexOf(";");
        if (n++ < 0 || n == string.length()) {
            return __one;
        }
        if (string.charAt(n++) == 'q' && (object = __qualities.getEntry(string, ++n, string.length() - n)) != null) {
            return (Float)object.getValue();
        }
        object = new HashMap(3);
        HttpFields.valueParameters(string, object);
        String string2 = (String)((HashMap)object).get("q");
        Float f = (Float)__qualities.get(string2);
        if (f == null) {
            try {
                f = new Float(string2);
            }
            catch (Exception exception) {
                f = __one;
            }
        }
        return f;
    }

    public static List qualityList(Enumeration enumeration) {
        Object object;
        Object object2;
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.EMPTY_LIST;
        }
        Object object3 = null;
        Object object4 = null;
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement().toString();
            object = HttpFields.getQuality((String)object2);
            if (!((double)((Float)object).floatValue() >= 0.001)) continue;
            object3 = LazyList.add(object3, object2);
            object4 = LazyList.add(object4, object);
        }
        object2 = LazyList.getList(object3, false);
        if (object2.size() < 2) {
            return object2;
        }
        object = LazyList.getList(object4, false);
        Float f = __zero;
        int n = object2.size();
        while (n-- > 0) {
            Float f2 = (Float)object.get(n);
            if (f.compareTo(f2) > 0) {
                Object e = object2.get(n);
                object2.set(n, object2.get(n + 1));
                object2.set(n + 1, e);
                object.set(n, object.get(n + 1));
                object.set(n + 1, f2);
                f = __zero;
                n = object2.size();
                continue;
            }
            f = f2;
        }
        object.clear();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSetCookie(Cookie cookie) {
        String string = cookie.getName();
        String string2 = cookie.getValue();
        int n = cookie.getVersion();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        String string3 = null;
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            long l;
            String string4;
            String string5;
            stringBuffer.append(string);
            stringBuffer.append('=');
            if (string2 != null && string2.length() > 0) {
                if (n == 0) {
                    URI.encodeString(stringBuffer, string2, "\";, ");
                } else {
                    stringBuffer.append(QuotedStringTokenizer.quote(string2, "\";, "));
                }
            }
            if (n > 0) {
                stringBuffer.append(";Version=");
                stringBuffer.append(n);
                string5 = cookie.getComment();
                if (string5 != null && string5.length() > 0) {
                    stringBuffer.append(";Comment=");
                    QuotedStringTokenizer.quote(stringBuffer, string5);
                }
            }
            if ((string5 = cookie.getPath()) != null && string5.length() > 0) {
                stringBuffer.append(";Path=");
                stringBuffer.append(string5);
            }
            if ((string4 = cookie.getDomain()) != null && string4.length() > 0) {
                stringBuffer.append(";Domain=");
                stringBuffer.append(string4.toLowerCase());
            }
            if ((l = (long)cookie.getMaxAge()) >= 0L) {
                if (n == 0) {
                    stringBuffer.append(";Expires=");
                    if (l == 0L) {
                        stringBuffer.append(__01Jan1970);
                    } else {
                        HttpFields.formatDate(stringBuffer, System.currentTimeMillis() + 1000L * l, true);
                    }
                } else {
                    stringBuffer.append(";Max-Age=");
                    stringBuffer.append(cookie.getMaxAge());
                }
            } else if (n > 0) {
                stringBuffer.append(";Discard");
            }
            if (cookie.getSecure()) {
                stringBuffer.append(";Secure");
            }
            if (cookie instanceof HttpOnlyCookie) {
                stringBuffer.append(";HttpOnly");
            }
            string3 = stringBuffer.toString();
        }
        this.put(__Expires, __01Jan1970);
        this.add(__SetCookie, string3);
    }

    public void add(HttpFields httpFields) {
        if (httpFields == null) {
            return;
        }
        Enumeration enumeration = httpFields.getFieldNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = httpFields.getValues(string);
            while (enumeration2.hasMoreElements()) {
                this.add(string, (String)enumeration2.nextElement());
            }
        }
    }

    public Iterator iterator() {
        return new EntryIterator();
    }

    static {
        new FieldInfo(__Host, false);
        new FieldInfo(__KeepAlive, false);
        new FieldInfo(__Connection, false);
        new FieldInfo(__Cookie, false);
        new FieldInfo(__Accept, false);
        new FieldInfo(__AcceptLanguage, false);
        new FieldInfo(__AcceptEncoding, false);
        new FieldInfo(__AcceptCharset, false);
        new FieldInfo(__CacheControl, false);
        new FieldInfo(__SetCookie, false);
        new FieldInfo(__SetCookie2, false);
        new FieldInfo(__Date, false);
        new FieldInfo(__TransferEncoding, true);
        new FieldInfo(__ContentEncoding, true);
        new FieldInfo(__ContentLength, false);
        new FieldInfo(__Expires, false);
        new FieldInfo(__Expect, false);
        new FieldInfo(__Referer, false);
        new FieldInfo(__TE, false);
        new FieldInfo(__UserAgent, false);
        new FieldInfo(__IfModifiedSince, false);
        new FieldInfo(__IfRange, false);
        new FieldInfo(__IfUnmodifiedSince, false);
        new FieldInfo(__Location, false);
        new FieldInfo(__Server, false);
        new FieldInfo(__ServletEngine, false);
        new FieldInfo(__AcceptRanges, false);
        new FieldInfo(__Range, false);
        new FieldInfo(__RequestRange, false);
        new FieldInfo(__SoapAction, false);
        new FieldInfo(__ContentLocation, false);
        new FieldInfo(__ContentMD5, false);
        new FieldInfo(__ContentRange, false);
        new FieldInfo(__ContentType, false);
        new FieldInfo(__LastModified, false);
        new FieldInfo(__Authorization, false);
        new FieldInfo(__From, false);
        new FieldInfo(__MaxForwards, false);
        new FieldInfo(__ProxyAuthenticate, false);
        new FieldInfo(__Age, false);
        new FieldInfo(__ETag, false);
        new FieldInfo(__RetryAfter, false);
        __values.put(__KeepAlive, (Object)__KeepAlive);
        __values.put(__Chunked, (Object)__Chunked);
        __values.put(__Close, (Object)__Close);
        __values.put(__TextHtml, (Object)__TextHtml);
        __values.put(__MessageHttp, (Object)__MessageHttp);
        __values.put(__WwwFormUrlEncode, (Object)__WwwFormUrlEncode);
        __values.put(__ExpectContinue, (Object)__ExpectContinue);
        __values.put("max-age=0", (Object)"max-age=0");
        __values.put("no-cache", (Object)"no-cache");
        __values.put("300", (Object)"300");
        __values.put("ISO-8859-1, utf-8;q=0.66, *;q=0.66", (Object)"ISO-8859-1, utf-8;q=0.66, *;q=0.66");
        __CRLF = new char[]{'\r', '\n'};
        __COLON = new char[]{':', ' '};
        DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
        __GMT = TimeZone.getTimeZone("GMT");
        __dateCache = new DateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss"};
        __dateReceiveCache = new ThreadLocal();
        __GMT.setID("GMT");
        __dateCache.setTimeZone(__GMT);
        __dateReceiveSource = new SimpleDateFormat[__dateReceiveFmt.length];
        for (int i = 0; i < __dateReceiveSource.length; ++i) {
            HttpFields.__dateReceiveSource[i] = new SimpleDateFormat(__dateReceiveFmt[i], Locale.US);
            __dateReceiveSource[i].setTimeZone(__GMT);
        }
        __01Jan1970 = HttpFields.formatDate(0L, false);
        __one = new Float("1.0");
        __zero = new Float("0.0");
        __qualities = new StringMap();
        __qualities.put(null, (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    private static class HttpCal
    extends GregorianCalendar {
        HttpCal() {
            super(__GMT);
        }

        public void setTimeInMillis(long l) {
            super.setTimeInMillis(l);
        }

        public long getTimeInMillis() {
            return super.getTimeInMillis();
        }
    }

    private class EntryIterator
    implements Iterator {
        protected int _i = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this._i < HttpFields.this._fields.size();
        }

        public Object next() throws NoSuchElementException {
            return new Entry(this._i++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Entry {
        protected int _i;

        Entry(int n) {
            this._i = n;
        }

        public String getKey() {
            return ((Field)HttpFields.this._fields.get(this._i)).getDisplayName();
        }

        public String getValue() {
            return ((Field)((HttpFields)HttpFields.this)._fields.get((int)this._i))._value;
        }
    }

    private static final class Field {
        FieldInfo _info;
        String _value;
        Field _next;
        Field _prev;
        int _version;

        Field(FieldInfo fieldInfo, String string, int n) {
            this._info = fieldInfo;
            this._value = string;
            this._next = null;
            this._prev = null;
            this._version = n;
        }

        Field(FieldInfo fieldInfo, char[] cArray, int n, int n2, int n3) {
            Map.Entry entry = __values.getEntry(cArray, n, n2);
            String string = null;
            string = entry != null ? (String)entry.getKey() : new String(cArray, n, n2);
            this._info = fieldInfo;
            this._value = string;
            this._next = null;
            this._prev = null;
            this._version = n3;
        }

        public boolean equals(Object object) {
            return object instanceof Field && object == this && this._version == ((Field)object)._version;
        }

        public int hashCode() {
            return this._info.hashCode() * this._version;
        }

        void clear() {
            this._version = -1;
        }

        void destroy() {
            this._info = null;
            this._value = null;
            this._next = null;
            this._prev = null;
            this._version = -1;
        }

        void reset(String string, int n) {
            this._value = string;
            this._version = n;
        }

        void reset(char[] cArray, int n, int n2, int n3) {
            this._version = n3;
            if (!StringUtil.equals(this._value, cArray, n, n2)) {
                Map.Entry entry = __values.getEntry(cArray, n, n2);
                String string = null;
                string = entry != null ? (String)entry.getKey() : new String(cArray, n, n2);
                this._value = string;
            }
        }

        void write(Writer writer, int n) throws IOException {
            if (this._info == null || this._version != n) {
                return;
            }
            if (this._info._inlineValues) {
                if (this._prev != null) {
                    return;
                }
                writer.write(this._info._name);
                writer.write(__COLON);
                Field field = this;
                while (true) {
                    writer.write(QuotedStringTokenizer.quote(field._value, HttpFields.__separators));
                    field = field._next;
                    if (field == null) break;
                    writer.write(",");
                }
                writer.write(__CRLF);
            } else {
                writer.write(this._info._name);
                writer.write(__COLON);
                writer.write(this._value);
                writer.write(__CRLF);
            }
        }

        String getDisplayName() {
            return this._info._name;
        }

        public String toString() {
            return "[" + (this._prev == null ? "" : "<-") + this.getDisplayName() + "=" + this._value + (this._next == null ? "" : "->") + "]";
        }
    }

    private static final class FieldInfo {
        String _name;
        String _lname;
        boolean _inlineValues;
        int _hashCode;
        static int __hashCode;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldInfo(String string, boolean bl) {
            Class clazz = class$org$mortbay$http$HttpFields$FieldInfo == null ? (class$org$mortbay$http$HttpFields$FieldInfo = HttpFields.class$("org.mortbay.http.HttpFields$FieldInfo")) : class$org$mortbay$http$HttpFields$FieldInfo;
            synchronized (clazz) {
                this._name = string;
                this._lname = StringUtil.asciiToLowerCase(string);
                this._inlineValues = bl;
                this._hashCode = __hashCode++;
                if (__hashCode < 128) {
                    FieldInfo fieldInfo = (FieldInfo)__info.get(string);
                    if (fieldInfo == null) {
                        __info.put(string, (Object)this);
                        if (!string.equals(this._lname)) {
                            __info.put(this._lname, (Object)this);
                        }
                    } else {
                        this._hashCode = fieldInfo._hashCode;
                    }
                }
            }
        }

        public String toString() {
            return "[" + this._name + "," + this._hashCode + "," + this._inlineValues + "]";
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof FieldInfo)) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)object;
            return fieldInfo == this || fieldInfo._hashCode == this._hashCode || fieldInfo._name.equals(this._name);
        }
    }
}

