/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.ContextLoader;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.PathMap;
import org.mortbay.http.RequestLog;
import org.mortbay.http.ResourceCache;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.http.handler.ErrorPageHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Container;
import org.mortbay.util.EventProvider;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;
import org.mortbay.util.URI;

public class HttpContext
extends Container
implements LifeCycle,
HttpHandler,
EventProvider,
Serializable {
    private static Log log = LogFactory.getLog(HttpContext.class);
    public static final String __fileClassPathAttr = "org.mortbay.http.HttpContext.FileClassPathAttribute";
    public static final String __ErrorHandler = "org.mortbay.http.ErrorHandler";
    private String _contextPath;
    private List _vhosts = new ArrayList(2);
    private List _hosts = new ArrayList(2);
    private List _handlers = new ArrayList(3);
    private Map _attributes = new HashMap(3);
    private boolean _redirectNullPath = true;
    private boolean _statsOn = false;
    private PermissionCollection _permissions;
    private boolean _classLoaderJava2Compliant = true;
    private ResourceCache _resources;
    private String[] _systemClasses = new String[]{"java.", "javax.servlet.", "javax.xml.", "org.mortbay.", "org.xml.", "org.w3c.", "org.apache.commons.logging."};
    private String[] _serverClasses = new String[]{"-org.mortbay.http.PathMap", "-org.mortbay.jetty.servlet.Invoker", "-org.mortbay.jetty.servlet.JSR154Filter", "-org.mortbay.jetty.servlet.Default", "org.mortbay.jetty.Server", "org.mortbay.http.", "org.mortbay.start.", "org.mortbay.stop."};
    private String _contextName;
    private String _classPath;
    private Map _initParams = new HashMap(11);
    private UserRealm _userRealm;
    private String _realmName;
    private PathMap _constraintMap = new PathMap();
    private Authenticator _authenticator;
    private RequestLog _requestLog;
    private String[] _welcomes = new String[]{"welcome.html", "index.html", "index.htm", "index.jsp"};
    private transient boolean _gracefulStop;
    private transient ClassLoader _parent;
    private transient ClassLoader _loader;
    private transient HttpServer _httpServer;
    private transient File _tmpDir;
    private transient HttpHandler[] _handlersArray;
    private transient String[] _vhostsArray;
    transient Object _statsLock = new Object[0];
    transient long _statsStartedAt;
    transient int _requests;
    transient int _requestsActive;
    transient int _requestsActiveMax;
    transient int _responses1xx;
    transient int _responses2xx;
    transient int _responses3xx;
    transient int _responses4xx;
    transient int _responses5xx;

    public HttpContext() {
        this.setAttribute(__ErrorHandler, new ErrorPageHandler());
        this._resources = new ResourceCache();
        this.addComponent(this._resources);
    }

    public HttpContext(HttpServer httpServer, String string) {
        this();
        this.setHttpServer(httpServer);
        this.setContextPath(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._statsLock = new Object[0];
        this.getHandlers();
        for (int i = 0; i < this._handlersArray.length; ++i) {
            this._handlersArray[i].initialize(this);
        }
    }

    public HttpConnection getHttpConnection() {
        return HttpConnection.getHttpConnection();
    }

    void setHttpServer(HttpServer httpServer) {
        this._httpServer = httpServer;
        this._contextName = null;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public void setStopGracefully(boolean bl) {
        this._gracefulStop = bl;
    }

    public boolean getStopGracefully() {
        return this._gracefulStop;
    }

    public static String canonicalContextPathSpec(String string) {
        if (string == null || string.indexOf(44) >= 0 || string.startsWith("*")) {
            throw new IllegalArgumentException("Illegal context spec:" + string);
        }
        if (!string.startsWith("/")) {
            string = '/' + string;
        }
        if (string.length() > 1) {
            if (string.endsWith("/")) {
                string = string + "*";
            } else if (!string.endsWith("/*")) {
                string = string + "/*";
            }
        }
        return string;
    }

    public void setContextPath(String string) {
        if (this._httpServer != null) {
            this._httpServer.removeMappings(this);
        }
        this._contextPath = (string = HttpContext.canonicalContextPathSpec(string)).length() > 1 ? string.substring(0, string.length() - 2) : "/";
        this._contextName = null;
        if (this._httpServer != null) {
            this._httpServer.addMappings(this);
        }
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public void addVirtualHost(String string) {
        if (!this._vhosts.contains(string)) {
            this._vhosts.add(string);
            this._contextName = null;
            if (this._httpServer != null) {
                if (this._vhosts.size() == 1) {
                    this._httpServer.removeMapping(null, this);
                }
                this._httpServer.addMapping(string, this);
            }
            this._vhostsArray = null;
        }
    }

    public void removeVirtualHost(String string) {
        if (this._vhosts.remove(string)) {
            this._contextName = null;
            if (this._httpServer != null) {
                this._httpServer.removeMapping(string, this);
                if (this._vhosts.size() == 0) {
                    this._httpServer.addMapping(null, this);
                }
            }
            this._vhostsArray = null;
        }
    }

    public void setVirtualHosts(String[] stringArray) {
        int n;
        ArrayList arrayList = new ArrayList(this._vhosts);
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                boolean bl = arrayList.remove(stringArray[n]);
                if (bl) continue;
                this.addVirtualHost(stringArray[n]);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.removeVirtualHost((String)arrayList.get(n));
        }
    }

    public String[] getVirtualHosts() {
        if (this._vhostsArray != null) {
            return this._vhostsArray;
        }
        if (this._vhosts == null) {
            this._vhostsArray = new String[0];
        } else {
            this._vhostsArray = new String[this._vhosts.size()];
            this._vhostsArray = this._vhosts.toArray(this._vhostsArray);
        }
        return this._vhostsArray;
    }

    public void setHosts(String[] stringArray) throws UnknownHostException {
        if (stringArray == null || stringArray.length == 0) {
            this._hosts = null;
        } else {
            this._hosts = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this._hosts.add(InetAddress.getByName(stringArray[i]));
            }
        }
    }

    public String[] getHosts() {
        if (this._hosts == null || this._hosts.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this._hosts.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            InetAddress inetAddress = (InetAddress)this._hosts.get(i);
            if (inetAddress == null) continue;
            stringArray[i] = inetAddress.getHostName();
        }
        return stringArray;
    }

    public void setSystemClasses(String[] stringArray) {
        this._systemClasses = stringArray;
    }

    public String[] getSystemClasses() {
        return this._systemClasses;
    }

    public void setServerClasses(String[] stringArray) {
        this._serverClasses = stringArray;
    }

    public String[] getServerClasses() {
        return this._serverClasses;
    }

    public void setHandlers(HttpHandler[] httpHandlerArray) {
        int n;
        ArrayList arrayList = new ArrayList(this._handlers);
        if (httpHandlerArray != null) {
            for (n = 0; n < httpHandlerArray.length; ++n) {
                boolean bl = arrayList.remove(httpHandlerArray[n]);
                if (bl) continue;
                this.addHandler(httpHandlerArray[n]);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.removeHandler((HttpHandler)arrayList.get(n));
        }
    }

    public HttpHandler[] getHandlers() {
        if (this._handlersArray != null) {
            return this._handlersArray;
        }
        if (this._handlers == null) {
            this._handlersArray = new HttpHandler[0];
        } else {
            this._handlersArray = new HttpHandler[this._handlers.size()];
            this._handlersArray = this._handlers.toArray(this._handlersArray);
        }
        return this._handlersArray;
    }

    public synchronized void addHandler(int n, HttpHandler httpHandler) {
        this._handlers.add(n, httpHandler);
        this._handlersArray = null;
        HttpContext httpContext = httpHandler.getHttpContext();
        if (httpContext == null) {
            httpHandler.initialize(this);
        } else if (httpContext != this) {
            throw new IllegalArgumentException("Handler in another HttpContext");
        }
        this.addComponent(httpHandler);
    }

    public synchronized void addHandler(HttpHandler httpHandler) {
        this.addHandler(this._handlers.size(), httpHandler);
    }

    public int getHandlerIndex(HttpHandler httpHandler) {
        for (int i = 0; i < this._handlers.size(); ++i) {
            if (httpHandler != this._handlers.get(i)) continue;
            return i;
        }
        return -1;
    }

    public synchronized HttpHandler getHandler(Class clazz) {
        for (int i = 0; i < this._handlers.size(); ++i) {
            HttpHandler httpHandler = (HttpHandler)this._handlers.get(i);
            if (!clazz.isInstance(httpHandler)) continue;
            return httpHandler;
        }
        return null;
    }

    public synchronized HttpHandler removeHandler(int n) {
        HttpHandler httpHandler = this._handlersArray[n];
        if (httpHandler.isStarted()) {
            try {
                httpHandler.stop();
            }
            catch (InterruptedException interruptedException) {
                log.warn((Object)"EXCEPTION ", (Throwable)interruptedException);
            }
        }
        this._handlers.remove(n);
        this._handlersArray = null;
        this.removeComponent(httpHandler);
        return httpHandler;
    }

    public synchronized void removeHandler(HttpHandler httpHandler) {
        if (httpHandler.isStarted()) {
            try {
                httpHandler.stop();
            }
            catch (InterruptedException interruptedException) {
                log.warn((Object)"EXCEPTION ", (Throwable)interruptedException);
            }
        }
        this._handlers.remove(httpHandler);
        this.removeComponent(httpHandler);
        this._handlersArray = null;
    }

    public void setInitParameter(String string, String string2) {
        this._initParams.put(string, string2);
    }

    public String getInitParameter(String string) {
        return (String)this._initParams.get(string);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public synchronized void setAttribute(String string, Object object) {
        this._attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this._attributes.get(string);
    }

    public Map getAttributes() {
        return this._attributes;
    }

    public void setAttributes(Map map) {
        this._attributes = map;
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public synchronized void removeAttribute(String string) {
        this._attributes.remove(string);
    }

    public void flushCache() {
        this._resources.flushCache();
    }

    public String[] getWelcomeFiles() {
        return this._welcomes;
    }

    public void setWelcomeFiles(String[] stringArray) {
        this._welcomes = stringArray == null ? new String[0] : stringArray;
    }

    public void addWelcomeFile(String string) {
        if (string.startsWith("/") || string.startsWith(File.separator) || string.endsWith("/") || string.endsWith(File.separator)) {
            log.warn((Object)("Invalid welcome file: " + string));
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this._welcomes));
        arrayList.add(string);
        this._welcomes = arrayList.toArray(this._welcomes);
    }

    public void removeWelcomeFile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this._welcomes));
        arrayList.remove(string);
        this._welcomes = arrayList.toArray(this._welcomes);
    }

    public String getWelcomeFile(Resource resource) throws IOException {
        if (!resource.isDirectory()) {
            return null;
        }
        for (int i = 0; i < this._welcomes.length; ++i) {
            Resource resource2 = resource.addPath(this._welcomes[i]);
            if (!resource2.exists()) continue;
            return this._welcomes[i];
        }
        return null;
    }

    public String getClassPath() {
        return this._classPath;
    }

    public String getFileClassPath() throws IllegalStateException {
        URL[] uRLArray;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Context classloader not initialized");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<ClassLoader> linkedList2 = new LinkedList<ClassLoader>();
        while (classLoader != null) {
            linkedList2.add(0, classLoader);
            classLoader = classLoader.getParent();
        }
        classLoader = this.getClassLoader();
        if (classLoader instanceof ContextLoader && !((ContextLoader)classLoader).isJava2Compliant()) {
            linkedList2.remove(classLoader);
            linkedList2.add(0, classLoader);
        }
        for (int i = 0; i < linkedList2.size(); ++i) {
            classLoader = (ClassLoader)linkedList2.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("extract paths from " + classLoader));
            }
            if (!(classLoader instanceof URLClassLoader)) continue;
            uRLArray = ((URLClassLoader)classLoader).getURLs();
            for (int j = 0; uRLArray != null && j < uRLArray.length; ++j) {
                try {
                    File file;
                    Resource resource = Resource.newResource(uRLArray[j]);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("path " + resource));
                    }
                    if ((file = resource.getFile()) == null) continue;
                    linkedList.add(file.getAbsolutePath());
                    continue;
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
            }
        }
        String string = System.getProperty("java.class.path");
        if (string != null) {
            uRLArray = new StringTokenizer(string, File.pathSeparator);
            while (uRLArray.hasMoreTokens()) {
                String string2 = uRLArray.nextToken();
                if (!linkedList.contains(string2)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("PATH=" + string2));
                    }
                    linkedList.add(string2);
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("done=" + string2));
            }
        }
        uRLArray = new StringBuffer();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            if (uRLArray.length() > 0) {
                uRLArray.append(File.pathSeparator);
            }
            uRLArray.append(iterator.next().toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fileClassPath=" + uRLArray));
        }
        return uRLArray.toString();
    }

    public void setClassPath(String string) {
        this._classPath = string;
        if (this.isStarted()) {
            log.warn((Object)"classpath set while started");
        }
    }

    public void addClassPath(String string) {
        this._classPath = this._classPath == null || this._classPath.length() == 0 ? string : this._classPath + "," + string;
        if (this.isStarted()) {
            log.warn((Object)"classpath set while started");
        }
    }

    public void addClassPaths(Resource resource) {
        if (this.isStarted()) {
            log.warn((Object)"classpaths set while started");
        }
        if (resource.exists() && resource.isDirectory()) {
            String[] stringArray = resource.list();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                try {
                    Resource resource2 = resource.addPath(stringArray[i]);
                    String string = resource2.getName().toLowerCase();
                    if (!string.endsWith(".jar") && !string.endsWith(".zip")) continue;
                    this.addClassPath(resource2.toString());
                    continue;
                }
                catch (Exception exception) {
                    log.warn((Object)"EXCEPTION ", (Throwable)exception);
                }
            }
        }
    }

    public boolean isClassLoaderJava2Compliant() {
        return this._classLoaderJava2Compliant;
    }

    public void setClassLoaderJava2Compliant(boolean bl) {
        this._classLoaderJava2Compliant = bl;
        if (this._loader != null && this._loader instanceof ContextLoader) {
            ((ContextLoader)this._loader).setJava2Compliant(bl);
        }
    }

    public void setTempDirectory(File file) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (file != null) {
            try {
                file = new File(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                log.warn((Object)"EXCEPTION ", (Throwable)iOException);
            }
        }
        if (file != null && !file.exists()) {
            file.mkdir();
            file.deleteOnExit();
        }
        if (!(file == null || file.exists() && file.isDirectory() && file.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + file);
        }
        this._tmpDir = file;
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
    }

    public File getTempDirectory() {
        if (this._tmpDir != null) {
            return this._tmpDir;
        }
        Object object = this.getAttribute("javax.servlet.context.tempdir");
        if (object != null && object instanceof File) {
            this._tmpDir = (File)object;
            if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                return this._tmpDir;
            }
        }
        if (object != null && object instanceof String) {
            try {
                this._tmpDir = new File((String)object);
                if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Converted to File " + this._tmpDir + " for " + this));
                    }
                    this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
                    return this._tmpDir;
                }
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        File file = null;
        try {
            file = new File(System.getProperty("jetty.home"), "work");
            if (!(file.exists() && file.canWrite() && file.isDirectory())) {
                file = null;
            }
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
        }
        try {
            HttpListener httpListener = this._httpServer.getListeners()[0];
            String string = null;
            for (int i = 0; string == null && this._vhosts != null && i < this._vhosts.size(); ++i) {
                string = (String)this._vhosts.get(i);
            }
            String string2 = httpListener.getHost();
            String string3 = "Jetty_" + System.currentTimeMillis() + "_" + (string2 == null ? "" : string2) + "_" + httpListener.getPort() + "_" + (string == null ? "" : string) + this.getContextPath();
            string3 = string3.replace('/', '_');
            string3 = string3.replace('.', '_');
            string3 = string3.replace('\\', '_');
            if (file != null) {
                this._tmpDir = new File(file, string3);
            } else {
                this._tmpDir = new File(System.getProperty("java.io.tmpdir"), string3);
                if (this._tmpDir.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete existing temp dir " + this._tmpDir + " for " + this));
                    }
                    if (!IO.delete(this._tmpDir) && log.isDebugEnabled()) {
                        log.debug((Object)("Failed to delete temp dir " + this._tmpDir));
                    }
                    if (this._tmpDir.exists()) {
                        String string4 = this._tmpDir.toString();
                        this._tmpDir = File.createTempFile(string3 + "_", "");
                        if (this._tmpDir.exists()) {
                            this._tmpDir.delete();
                        }
                        log.warn((Object)("Can't reuse " + string4 + ", using " + this._tmpDir));
                    }
                }
            }
            if (!this._tmpDir.exists()) {
                this._tmpDir.mkdir();
            }
            if (file == null) {
                this._tmpDir.deleteOnExit();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created temp dir " + this._tmpDir + " for " + this));
            }
        }
        catch (Exception exception) {
            this._tmpDir = null;
            LogSupport.ignore(log, exception);
        }
        if (this._tmpDir == null) {
            try {
                this._tmpDir = File.createTempFile("JettyContext", "");
                if (this._tmpDir.exists()) {
                    this._tmpDir.delete();
                }
                this._tmpDir.mkdir();
                this._tmpDir.deleteOnExit();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created temp dir " + this._tmpDir + " for " + this));
                }
            }
            catch (IOException iOException) {
                log.fatal((Object)iOException);
                System.exit(1);
            }
        }
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
        return this._tmpDir;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._loader = classLoader;
    }

    public synchronized ClassLoader getClassLoader() {
        return this._loader;
    }

    public synchronized void setParentClassLoader(ClassLoader classLoader) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._parent = classLoader;
    }

    public ClassLoader getParentClassLoader() {
        return this._parent;
    }

    protected void initClassLoader(boolean bl) throws MalformedURLException, IOException {
        ClassLoader classLoader = this._parent;
        if (this._loader == null) {
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Init classloader from " + this._classPath + ", " + classLoader + " for " + this));
            }
            if (bl || this._classPath != null || this._permissions != null) {
                ContextLoader contextLoader = new ContextLoader(this, this._classPath, classLoader, this._permissions);
                contextLoader.setJava2Compliant(this._classLoaderJava2Compliant);
                this._loader = contextLoader;
            } else {
                this._loader = classLoader;
            }
        }
    }

    public synchronized Class loadClass(String string) throws ClassNotFoundException {
        if (this._loader == null) {
            try {
                this.initClassLoader(false);
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                return null;
            }
        }
        if (string == null) {
            return null;
        }
        if (this._loader == null) {
            return Class.forName(string);
        }
        return this._loader.loadClass(string);
    }

    public void setRealmName(String string) {
        this._realmName = string;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public void setRealm(UserRealm userRealm) {
        this._userRealm = userRealm;
    }

    public UserRealm getRealm() {
        return this._userRealm;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public void addSecurityConstraint(String string, SecurityConstraint securityConstraint) {
        Object object = this._constraintMap.get(string);
        object = LazyList.add(object, securityConstraint);
        this._constraintMap.put(string, object);
        if (log.isDebugEnabled()) {
            log.debug((Object)("added " + securityConstraint + " at " + string));
        }
    }

    public void clearSecurityConstraints() {
        this._constraintMap.clear();
    }

    public boolean checkSecurityConstraints(String string, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        UserRealm userRealm = this.getRealm();
        List list = this._constraintMap.getMatches(string);
        String string2 = null;
        if (list != null && list.size() > 0) {
            Object object = null;
            block0: for (int i = 0; i < list.size(); ++i) {
                Map.Entry entry = (Map.Entry)list.get(i);
                Object v = entry.getValue();
                String string3 = (String)entry.getKey();
                for (int j = 0; j < LazyList.size(v); ++j) {
                    SecurityConstraint securityConstraint = (SecurityConstraint)LazyList.get(v, j);
                    if (!securityConstraint.forMethod(httpRequest.getMethod())) continue;
                    if (string2 != null && !string2.equals(string3)) break block0;
                    string2 = string3;
                    object = LazyList.add(object, securityConstraint);
                }
            }
            return SecurityConstraint.check(LazyList.getList(object), this._authenticator, userRealm, string, httpRequest, httpResponse);
        }
        httpRequest.setUserPrincipal(HttpRequest.__NOT_CHECKED);
        return true;
    }

    public void setRedirectNullPath(boolean bl) {
        this._redirectNullPath = bl;
    }

    public boolean isRedirectNullPath() {
        return this._redirectNullPath;
    }

    public void setPermissions(PermissionCollection permissionCollection) {
        this._permissions = permissionCollection;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public void addPermission(Permission permission) {
        if (this._permissions == null) {
            this._permissions = new Permissions();
        }
        this._permissions.add(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        Object object;
        Object object2;
        if (!this.isStarted() || this._gracefulStop) {
            return;
        }
        if (this._hosts != null && this._hosts.size() > 0 && (object2 = httpRequest.getHttpConnection().getConnection()) instanceof Socket && !this._hosts.contains(((Socket)(object = (Socket)object2)).getLocalAddress())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(((Socket)object).getLocalAddress() + " not in " + this._hosts));
            }
            return;
        }
        if (this._statsOn) {
            object2 = this._statsLock;
            synchronized (object2) {
                ++this._requests;
                ++this._requestsActive;
                if (this._requestsActive > this._requestsActiveMax) {
                    this._requestsActiveMax = this._requestsActive;
                }
            }
        }
        if ((object2 = URI.canonicalPath(httpRequest.getPath())) == null) {
            throw new HttpException(400);
        }
        if (this._contextPath.length() > 1) {
            object2 = ((String)object2).substring(this._contextPath.length());
        }
        if (this._redirectNullPath && (object2 == null || ((String)object2).length() == 0)) {
            object = httpRequest.getRequestURL();
            ((StringBuffer)object).append("/");
            String string = httpRequest.getQuery();
            if (string != null && string.length() != 0) {
                ((StringBuffer)object).append("?" + string);
            }
            httpResponse.sendRedirect(((StringBuffer)object).toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " consumed all of path " + httpRequest.getPath() + ", redirect to " + ((StringBuffer)object).toString()));
            }
            return;
        }
        object = null;
        int n = ((String)object2).lastIndexOf(59);
        if (n >= 0) {
            int n2 = ((String)object2).length() - n;
            String string = httpRequest.getEncodedPath();
            if (';' == string.charAt(string.length() - n2)) {
                object = ((String)object2).substring(n + 1);
                object2 = ((String)object2).substring(0, n);
            }
        }
        try {
            this.handle((String)object2, (String)object, httpRequest, httpResponse);
            Object var9_10 = null;
            if (this._userRealm != null && httpRequest.hasUserPrincipal()) {
                this._userRealm.disassociate(httpRequest.getUserPrincipal());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this._userRealm != null && httpRequest.hasUserPrincipal()) {
                this._userRealm.disassociate(httpRequest.getUserPrincipal());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        Object object = null;
        try {
            object = this.enterContextScope(httpRequest, httpResponse);
            HttpHandler[] httpHandlerArray = this.getHandlers();
            for (int i = 0; i < httpHandlerArray.length; ++i) {
                HttpHandler httpHandler = httpHandlerArray[i];
                if (httpHandler == null) {
                    httpHandlerArray = this.getHandlers();
                    i = -1;
                    continue;
                }
                if (!httpHandler.isStarted()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(httpHandler + " not started in " + this));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handler " + httpHandler));
                }
                httpHandler.handle(string, string2, httpRequest, httpResponse);
                if (!httpRequest.isHandled()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handled by " + httpHandler));
                }
                return;
            }
            return;
        }
        finally {
            this.leaveContextScope(httpRequest, httpResponse, object);
        }
    }

    public Object enterContextScope(HttpRequest httpRequest, HttpResponse httpResponse) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        HttpContext httpContext = httpResponse.getHttpContext();
        Scope scope = null;
        if (classLoader != HttpContext.class.getClassLoader() || httpContext != null) {
            scope = new Scope();
            scope._classLoader = classLoader;
            scope._httpContext = httpContext;
        }
        if (this._loader != null) {
            thread.setContextClassLoader(this._loader);
        }
        httpResponse.setHttpContext(this);
        return scope;
    }

    public void leaveContextScope(HttpRequest httpRequest, HttpResponse httpResponse, Object object) {
        if (object == null) {
            Thread.currentThread().setContextClassLoader(HttpContext.class.getClassLoader());
            httpResponse.setHttpContext(null);
        } else {
            Scope scope = (Scope)object;
            Thread.currentThread().setContextClassLoader(scope._classLoader);
            httpResponse.setHttpContext(scope._httpContext);
        }
    }

    public String getHttpContextName() {
        if (this._contextName == null) {
            this._contextName = (this._vhosts.size() > 1 ? this._vhosts.toString() + ":" : "") + this._contextPath;
        }
        return this._contextName;
    }

    public void setHttpContextName(String string) {
        this._contextName = string;
    }

    public String toString() {
        return "HttpContext[" + this.getContextPath() + "," + this.getHttpContextName() + "]";
    }

    public String toString(boolean bl) {
        return "HttpContext[" + this.getContextPath() + "," + this.getHttpContextName() + "]" + (bl ? "=" + this._handlers : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doStart() throws Exception {
        if (this.isStarted()) {
            return;
        }
        if (this._httpServer.getServerClasses() != null) {
            this._serverClasses = this._httpServer.getServerClasses();
        }
        if (this._httpServer.getSystemClasses() != null) {
            this._systemClasses = this._httpServer.getSystemClasses();
        }
        this._resources.start();
        this.statsReset();
        if (this._httpServer == null) {
            throw new IllegalStateException("No server for " + this);
        }
        this._resources.getMimeMap();
        this._resources.getEncodingMap();
        if (this._userRealm == null && this._authenticator != null) {
            this._userRealm = this._httpServer.getRealm(this._realmName);
            if (this._userRealm == null) {
                log.warn((Object)("No Realm: " + this._realmName));
            }
        }
        this.initClassLoader(false);
        String string = this.getInitParameter(__fileClassPathAttr);
        if (string != null && string.length() > 0) {
            this.setAttribute(string, this.getFileClassPath());
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            if (this._requestLog != null) {
                this._requestLog.start();
            }
            this.startHandlers();
        }
        finally {
            thread.setContextClassLoader(classLoader);
            this.getHandlers();
        }
    }

    protected void startHandlers() throws Exception {
        MultiException multiException = new MultiException();
        Iterator iterator = this._handlers.iterator();
        while (iterator.hasNext()) {
            HttpHandler httpHandler = (HttpHandler)iterator.next();
            if (httpHandler.isStarted()) continue;
            try {
                httpHandler.start();
            }
            catch (Exception exception) {
                multiException.add(exception);
            }
        }
        multiException.ifExceptionThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl) throws InterruptedException {
        boolean bl2 = this._gracefulStop;
        try {
            this._gracefulStop = true;
            while (bl && this._statsOn && this._requestsActive > 0 && this._httpServer != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
            }
            this.stop();
        }
        finally {
            this._gracefulStop = bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        if (this._httpServer == null) {
            throw new InterruptedException("Destroy called");
        }
        HttpContext httpContext = this;
        synchronized (httpContext) {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            try {
                if (this._loader != null) {
                    thread.setContextClassLoader(this._loader);
                }
                Iterator iterator = this._handlers.iterator();
                while (iterator.hasNext()) {
                    HttpHandler httpHandler = (HttpHandler)iterator.next();
                    if (!httpHandler.isStarted()) continue;
                    try {
                        httpHandler.stop();
                    }
                    catch (Exception exception) {
                        log.warn((Object)"EXCEPTION ", (Throwable)exception);
                    }
                }
                if (this._requestLog != null) {
                    this._requestLog.stop();
                }
            }
            finally {
                thread.setContextClassLoader(classLoader);
            }
            if (this._loader instanceof ContextLoader) {
                ((ContextLoader)this._loader).destroy();
                LogFactory.release(this._loader);
            }
            this._loader = null;
        }
        this._resources.flushCache();
        this._resources.stop();
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._httpServer != null) {
            this._httpServer.removeContext(this);
        }
        this._httpServer = null;
        if (this._handlers != null) {
            this._handlers.clear();
        }
        this._handlers = null;
        this._parent = null;
        this._loader = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._attributes = null;
        if (this._initParams != null) {
            this._initParams.clear();
        }
        this._initParams = null;
        if (this._vhosts != null) {
            this._vhosts.clear();
        }
        this._vhosts = null;
        this._hosts = null;
        this._tmpDir = null;
        this._permissions = null;
        this.removeComponent(this._resources);
        if (this._resources != null) {
            this._resources.flushCache();
            if (this._resources.isStarted()) {
                try {
                    this._resources.stop();
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
            }
            this._resources.destroy();
        }
        this._resources = null;
        super.destroy();
    }

    public void setRequestLog(RequestLog requestLog) {
        this._requestLog = requestLog;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public void sendError(HttpResponse httpResponse, int n, String string) throws IOException {
        httpResponse.sendError(n, string);
    }

    public static void sendContextError(HttpResponse httpResponse, int n, String string) throws IOException {
        HttpContext httpContext = httpResponse.getHttpContext();
        if (httpContext != null) {
            httpContext.sendError(httpResponse, n, string);
        } else {
            httpResponse.sendError(n, string);
        }
    }

    public void setStatsOn(boolean bl) {
        log.info((Object)("setStatsOn " + bl + " for " + this));
        this._statsOn = bl;
        this.statsReset();
    }

    public boolean getStatsOn() {
        return this._statsOn;
    }

    public long getStatsOnMs() {
        return this._statsOn ? System.currentTimeMillis() - this._statsStartedAt : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statsReset() {
        Object object = this._statsLock;
        synchronized (object) {
            if (this._statsOn) {
                this._statsStartedAt = System.currentTimeMillis();
            }
            this._requests = 0;
            this._requestsActiveMax = this._requestsActive;
            this._responses1xx = 0;
            this._responses2xx = 0;
            this._responses3xx = 0;
            this._responses4xx = 0;
            this._responses5xx = 0;
        }
    }

    public int getRequests() {
        return this._requests;
    }

    public int getRequestsActive() {
        return this._requestsActive;
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax;
    }

    public int getResponses1xx() {
        return this._responses1xx;
    }

    public int getResponses2xx() {
        return this._responses2xx;
    }

    public int getResponses3xx() {
        return this._responses3xx;
    }

    public int getResponses4xx() {
        return this._responses4xx;
    }

    public int getResponses5xx() {
        return this._responses5xx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(HttpRequest httpRequest, HttpResponse httpResponse, int n) {
        if (this._statsOn) {
            Object object = this._statsLock;
            synchronized (object) {
                if (--this._requestsActive < 0) {
                    this._requestsActive = 0;
                }
                if (httpResponse != null) {
                    switch (httpResponse.getStatus() / 100) {
                        case 1: {
                            ++this._responses1xx;
                            break;
                        }
                        case 2: {
                            ++this._responses2xx;
                            break;
                        }
                        case 3: {
                            ++this._responses3xx;
                            break;
                        }
                        case 4: {
                            ++this._responses4xx;
                            break;
                        }
                        case 5: {
                            ++this._responses5xx;
                        }
                    }
                }
            }
        }
        if (this._requestLog != null && httpRequest != null && httpResponse != null) {
            this._requestLog.log(httpRequest, httpResponse, n);
        } else if (this._httpServer != null) {
            this._httpServer.log(httpRequest, httpResponse, n);
        }
    }

    public String getName() {
        return this.getContextPath();
    }

    public HttpContext getHttpContext() {
        return this;
    }

    public void initialize(HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public Resource getBaseResource() {
        return this._resources.getBaseResource();
    }

    public String getEncodingByMimeType(String string) {
        return this._resources.getEncodingByMimeType(string);
    }

    public Map getEncodingMap() {
        return this._resources.getEncodingMap();
    }

    public int getMaxCachedFileSize() {
        return this._resources.getMaxCachedFileSize();
    }

    public int getMaxCacheSize() {
        return this._resources.getMaxCacheSize();
    }

    public String getMimeByExtension(String string) {
        return this._resources.getMimeByExtension(string);
    }

    public Map getMimeMap() {
        return this._resources.getMimeMap();
    }

    public Resource getResource(String string) throws IOException {
        return this._resources.getResource(string);
    }

    public String getResourceBase() {
        return this._resources.getResourceBase();
    }

    public ResourceCache.ResourceMetaData getResourceMetaData(Resource resource) {
        return this._resources.getResourceMetaData(resource);
    }

    public void setBaseResource(Resource resource) {
        this._resources.setBaseResource(resource);
    }

    public void setEncodingMap(Map map) {
        this._resources.setEncodingMap(map);
    }

    public void setMaxCachedFileSize(int n) {
        this._resources.setMaxCachedFileSize(n);
    }

    public void setMaxCacheSize(int n) {
        this._resources.setMaxCacheSize(n);
    }

    public void setMimeMap(Map map) {
        this._resources.setMimeMap(map);
    }

    public void setMimeMapping(String string, String string2) {
        this._resources.setMimeMapping(string, string2);
    }

    public void setResourceBase(String string) {
        this._resources.setResourceBase(string);
    }

    public void setTypeEncoding(String string, String string2) {
        this._resources.setTypeEncoding(string, string2);
    }

    private static class Scope {
        ClassLoader _classLoader;
        HttpContext _httpContext;

        private Scope() {
        }
    }
}

