/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpInputStream;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.HttpTunnel;
import org.mortbay.http.Version;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.OutputObserver;
import org.mortbay.util.StringUtil;

public class HttpConnection
implements OutputObserver {
    private static Log log = LogFactory.getLog(HttpConnection.class);
    private static ThreadLocal __threadConnection = new ThreadLocal();
    private static boolean __2068_Continues = Boolean.getBoolean("org.mortbay.http.HttpConnection.2068Continue");
    protected HttpRequest _request;
    protected HttpResponse _response;
    protected boolean _persistent;
    protected boolean _keepAlive;
    protected int _dotVersion;
    private HttpListener _listener;
    private HttpInputStream _inputStream;
    private HttpOutputStream _outputStream;
    private boolean _close;
    private boolean _firstWrite;
    private boolean _completing;
    private Thread _handlingThread;
    private InetAddress _remoteInetAddress;
    private String _remoteAddr;
    private String _remoteHost;
    private HttpServer _httpServer;
    private Object _connection;
    private boolean _throttled;
    private boolean _statsOn;
    private long _tmpTime;
    private long _openTime;
    private long _reqTime;
    private int _requests;
    private Object _object;
    private HttpTunnel _tunnel;
    private boolean _resolveRemoteHost;

    public HttpConnection(HttpListener httpListener, InetAddress inetAddress, InputStream inputStream, OutputStream outputStream, Object object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("new HttpConnection: " + object));
        }
        this._listener = httpListener;
        this._remoteInetAddress = inetAddress;
        int n = httpListener == null ? 4096 : httpListener.getBufferSize();
        int n2 = httpListener == null ? 512 : httpListener.getBufferReserve();
        this._inputStream = new HttpInputStream(inputStream, n);
        this._outputStream = new HttpOutputStream(outputStream, n, n2);
        this._outputStream.addObserver(this);
        this._firstWrite = false;
        if (this._listener != null) {
            this._httpServer = this._listener.getHttpServer();
        }
        this._connection = object;
        boolean bl = this._statsOn = this._httpServer != null && this._httpServer.getStatsOn();
        if (this._statsOn) {
            this._openTime = System.currentTimeMillis();
            this._httpServer.statsOpenConnection();
        }
        this._reqTime = 0L;
        this._requests = 0;
        this._request = new HttpRequest(this);
        this._response = new HttpResponse(this);
        this._resolveRemoteHost = this._listener != null && this._listener.getHttpServer() != null && this._listener.getHttpServer().getResolveRemoteHost();
    }

    static HttpConnection getHttpConnection() {
        return (HttpConnection)__threadConnection.get();
    }

    public InetAddress getRemoteInetAddress() {
        return this._remoteInetAddress;
    }

    public String getRemoteAddr() {
        if (this._remoteAddr == null) {
            if (this._remoteInetAddress == null) {
                return "127.0.0.1";
            }
            this._remoteAddr = this._remoteInetAddress.getHostAddress();
        }
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        if (this._remoteHost == null) {
            if (this._resolveRemoteHost) {
                if (this._remoteInetAddress == null) {
                    return "localhost";
                }
                this._remoteHost = this._remoteInetAddress.getHostName();
            } else {
                if (this._remoteInetAddress == null) {
                    return "127.0.0.1";
                }
                this._remoteHost = this.getRemoteAddr();
            }
        }
        return this._remoteHost;
    }

    public HttpInputStream getInputStream() {
        return this._inputStream;
    }

    public HttpOutputStream getOutputStream() {
        return this._outputStream;
    }

    public Object getConnection() {
        return this._connection;
    }

    public HttpRequest getRequest() {
        return this._request;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public void forceClose() {
        this._persistent = false;
        this._close = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this._completing = true;
            if (this._connection instanceof Socket && !(this._connection instanceof SSLSocket)) {
                ((Socket)this._connection).shutdownOutput();
            }
            this._outputStream.close();
            this._inputStream.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this._handlingThread != null && Thread.currentThread() != this._handlingThread) {
                this._handlingThread.interrupt();
            }
            throw throwable;
        }
        if (this._handlingThread != null && Thread.currentThread() != this._handlingThread) {
            this._handlingThread.interrupt();
        }
    }

    public HttpListener getListener() {
        return this._listener;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public String getDefaultScheme() {
        return this._listener.getDefaultScheme();
    }

    public String getServerName() {
        String string = this._listener.getHost();
        if ("0.0.0.0".equals(string) && this._connection instanceof Socket) {
            string = ((Socket)this._connection).getLocalAddress().getHostName();
        }
        return string;
    }

    public String getServerAddr() {
        if (this._connection instanceof Socket) {
            return ((Socket)this._connection).getLocalAddress().getHostAddress();
        }
        return this._listener.getHost();
    }

    public int getServerPort() {
        return this._listener.getPort();
    }

    public int getRemotePort() {
        if (this._connection instanceof Socket) {
            return ((Socket)this._connection).getPort();
        }
        return 0;
    }

    public boolean isThrottled() {
        return this._throttled;
    }

    public void setThrottled(boolean bl) {
        this._throttled = bl;
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object object) {
        this._object = object;
    }

    public HttpTunnel getHttpTunnel() {
        return this._tunnel;
    }

    public void setHttpTunnel(HttpTunnel httpTunnel) {
        this._tunnel = httpTunnel;
    }

    private void verifyHTTP_1_0() {
        int n = this._request.getIntField("Content-Length");
        if (n >= 0) {
            this._inputStream.setContentLength(n);
        } else if (n < 0) {
            this._inputStream.setContentLength(0);
        }
        if (!this._keepAlive && "keep-alive".equalsIgnoreCase(this._request.getField("Proxy-Connection"))) {
            this._keepAlive = true;
        }
        this._persistent = this._keepAlive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyHTTP_1_1() throws HttpException, IOException {
        String string;
        String string2 = this._request.getField("Host");
        if (string2 == null) {
            throw new HttpException(400);
        }
        String string3 = this._request.getField("Transfer-Encoding");
        if (string3 != null && string3.length() > 0) {
            if (string3.equalsIgnoreCase("chunked") || StringUtil.endsWithIgnoreCase(string3, "chunked")) {
                this._inputStream.setChunking();
            } else if (StringUtil.asciiToLowerCase(string3).indexOf("chunked") >= 0) {
                throw new HttpException(400);
            }
        }
        int n = this._request.getIntField("Content-Length");
        String string4 = this._request.getField("Content-Type");
        if (!this._inputStream.isChunking()) {
            if (n >= 0) {
                this._inputStream.setContentLength(n);
            } else if (string4 == null || string4.length() == 0) {
                this._inputStream.setContentLength(0);
            } else {
                this._inputStream.setContentLength(0);
            }
        }
        if ((string = this._request.getField("Expect")) != null && string.length() > 0) {
            if (!StringUtil.asciiToLowerCase(string).equals("100-continue")) throw new HttpException(417);
            this._inputStream.setExpectContinues(this._outputStream.getOutputStream());
        } else if (__2068_Continues && this._inputStream.available() <= 0 && ("PUT".equals(this._request.getMethod()) || "POST".equals(this._request.getMethod()))) {
            OutputStream outputStream = this._outputStream.getOutputStream();
            outputStream.write(HttpResponse.__Continue);
            outputStream.flush();
        }
        this._persistent = !this._close;
    }

    public void outputNotify(OutputStream outputStream, int n, Object object) throws IOException {
        if (this._response == null) {
            return;
        }
        switch (n) {
            case 0: {
                if (this._firstWrite) break;
                this.firstWrite();
                this._firstWrite = true;
                break;
            }
            case 1: {
                this.resetBuffer();
                break;
            }
            case 2: {
                this.commit();
                break;
            }
            case 4: {
                if (this._response == null) break;
                this.completing();
                if (this._response.isCommitted() || this._request.getState() != 2) break;
                this.commit();
                break;
            }
        }
    }

    protected void firstWrite() throws IOException {
        int n;
        if (this._response.isCommitted()) {
            return;
        }
        if ("HEAD".equals(this._request.getMethod())) {
            this._outputStream.nullOutput();
        }
        if ((n = this._response.getIntField("Content-Length")) >= 0) {
            this._outputStream.setContentLength(n);
        }
    }

    private void resetBuffer() {
    }

    void completing() {
        this._completing = true;
    }

    protected void commit() throws IOException {
        if (this._response.isCommitted()) {
            return;
        }
        int n = this._response.getStatus();
        int n2 = -1;
        if (this._inputStream.getExpectContinues() != null) {
            this._inputStream.setExpectContinues(null);
            this._inputStream.unsafeSetContentLength(0);
        }
        boolean bl = "close".equals(this._response.getField("Connection"));
        if (!this._persistent || this._close || this._listener != null && (!this._listener.isStarted() || this._listener.isOutOfResources())) {
            this._close = true;
            if (!bl) {
                this._response.setField("Connection", "close");
            }
            bl = true;
        }
        if (this._close) {
            this._persistent = false;
        }
        if (this._persistent) {
            switch (this._dotVersion) {
                case 1: {
                    String string = this._response.getField("Transfer-Encoding");
                    if (string == null || string.length() == 0 || "identity".equalsIgnoreCase(string)) {
                        if (n == 304 || n == 204 || this._response.getField("Content-Length") != null) break;
                        if (this._completing) {
                            n2 = this._outputStream.getBytesWritten();
                            this._response.setContentLength(n2);
                            break;
                        }
                        this._response.setField("Transfer-Encoding", "chunked");
                        this._outputStream.setChunking();
                        break;
                    }
                    this._response.removeField("Content-Length");
                    this._outputStream.setChunking();
                    if ("chunked".equalsIgnoreCase(string)) break;
                    List list = this._request.getAcceptableTransferCodings();
                    Enumeration enumeration = this._response.getFieldValues("Transfer-Encoding", ", \t");
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if ("identity".equalsIgnoreCase(string2) || "chunked".equalsIgnoreCase(string2) || list != null && list.contains(string2)) continue;
                        throw new HttpException(501, string2);
                    }
                    break;
                }
                case 0: {
                    this._response.removeField("Transfer-Encoding");
                    if (this._keepAlive) {
                        if (n != 304 && n != 204 && this._response.getField("Content-Length") == null) {
                            if (this._completing) {
                                n2 = this._outputStream.getBytesWritten();
                                this._response.setContentLength(n2);
                                this._response.setField("Connection", "keep-alive");
                                break;
                            }
                            this._response.setField("Connection", "close");
                            this._close = true;
                            bl = true;
                            this._persistent = false;
                            break;
                        }
                        this._response.setField("Connection", "keep-alive");
                        break;
                    }
                    if (bl) break;
                    this._response.setField("Connection", "close");
                    break;
                }
                default: {
                    this._close = true;
                    this._persistent = false;
                    this._keepAlive = false;
                }
            }
        }
        this._request.setHandled(true);
        this._outputStream.writeHeader(this._response);
        this._outputStream.flush();
    }

    private void exception(Throwable throwable) {
        try {
            this._persistent = false;
            int n = 500;
            if (throwable instanceof HttpException) {
                n = ((HttpException)throwable).getCode();
                if (this._request == null) {
                    log.warn((Object)throwable.toString());
                } else {
                    log.warn((Object)(this._request.getRequestLine() + " " + throwable.toString()));
                }
                log.debug((Object)"EXCEPTION ", throwable);
            } else {
                if (throwable instanceof EOFException) {
                    LogSupport.ignore(log, throwable);
                    return;
                }
                this._request.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
                this._request.setAttribute("javax.servlet.error.exception", throwable);
                if (this._request == null) {
                    log.warn((Object)"EXCEPTION ", throwable);
                } else {
                    log.warn((Object)this._request.getRequestLine(), throwable);
                }
            }
            if (this._response != null && !this._response.isCommitted()) {
                this._response.reset();
                this._response.removeField("Transfer-Encoding");
                this._response.setField("Connection", "close");
                this._response.sendError(n);
            }
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
        }
    }

    protected HttpContext service(HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        if (this._httpServer == null) {
            throw new HttpException(503);
        }
        return this._httpServer.service(httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle() {
        try {
            this.associateThread();
            while (this._listener.isStarted() && this.handleNext()) {
                this.recycle();
            }
        }
        finally {
            this.disassociateThread();
            this.destroy();
        }
    }

    protected void associateThread() {
        __threadConnection.set(this);
        this._handlingThread = Thread.currentThread();
    }

    protected void disassociateThread() {
        this._handlingThread = null;
        __threadConnection.set(null);
    }

    protected void readRequest() throws IOException {
        this._request.readHeader((LineInput)this._inputStream.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean handleNext() {
        block204: {
            int n;
            int n2;
            Throwable throwable222;
            boolean bl;
            HttpContext httpContext;
            block205: {
                block203: {
                    boolean bl2;
                    int n3;
                    int n4;
                    block201: {
                        block198: {
                            boolean bl3;
                            int n5;
                            int n6;
                            block196: {
                                block193: {
                                    boolean bl4;
                                    int n7;
                                    int n8;
                                    block191: {
                                        block188: {
                                            boolean bl5;
                                            int n9;
                                            int n10;
                                            block186: {
                                                block183: {
                                                    boolean bl6;
                                                    int n11;
                                                    block178: {
                                                        Enumeration enumeration;
                                                        block173: {
                                                            int n12;
                                                            if (this._tunnel != null) {
                                                                if (log.isDebugEnabled()) {
                                                                    log.debug((Object)("Tunnel: " + this._tunnel));
                                                                }
                                                                this._outputStream.resetObservers();
                                                                this._tunnel.handle(this._inputStream.getInputStream(), this._outputStream.getOutputStream());
                                                                return false;
                                                            }
                                                            httpContext = null;
                                                            bl = false;
                                                            this._persistent = false;
                                                            this._close = false;
                                                            this._keepAlive = false;
                                                            this._firstWrite = false;
                                                            this._completing = false;
                                                            this._dotVersion = 0;
                                                            this.readRequest();
                                                            if (this._listener != null && this._listener.isStarted()) break block173;
                                                            this._response.destroy();
                                                            this._response = null;
                                                            this._persistent = false;
                                                            boolean bl7 = false;
                                                            Object var6_9 = null;
                                                            int n13 = 0;
                                                            int n14 = n12 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                            if (this._persistent) {
                                                                boolean bl8 = false;
                                                                try {
                                                                    if (this._inputStream.getExpectContinues() != null) {
                                                                        this._inputStream.setExpectContinues(null);
                                                                        bl8 = true;
                                                                    } else {
                                                                        int n15 = this._inputStream.getContentLength();
                                                                        if (n15 != 0) {
                                                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                catch (IOException iOException) {
                                                                    if (this._inputStream.getContentLength() > 0) {
                                                                        this._inputStream.setContentLength(0);
                                                                    }
                                                                    this._persistent = false;
                                                                    LogSupport.ignore(log, iOException);
                                                                    this.exception(new HttpException(400, "Missing Content"));
                                                                }
                                                                if (!bl8 && this._inputStream.getContentLength() > 0) {
                                                                    this._inputStream.setContentLength(0);
                                                                    this._persistent = false;
                                                                    this.exception(new HttpException(400, "Missing Content"));
                                                                }
                                                                try {
                                                                    this._outputStream.close();
                                                                    n13 = this._outputStream.getBytesWritten();
                                                                    this._outputStream.resetStream();
                                                                    this._outputStream.addObserver(this);
                                                                    this._inputStream.resetStream();
                                                                }
                                                                catch (IOException iOException) {
                                                                    this.exception(iOException);
                                                                }
                                                            } else if (this._response != null) {
                                                                try {
                                                                    if (this._inputStream.getContentLength() > 0) {
                                                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                        }
                                                                    }
                                                                    this._inputStream.resetStream();
                                                                }
                                                                catch (IOException iOException) {
                                                                    LogSupport.ignore(log, iOException);
                                                                }
                                                                try {
                                                                    this._outputStream.flush();
                                                                    this._response.commit();
                                                                    n13 = this._outputStream.getBytesWritten();
                                                                    this._outputStream.close();
                                                                    this._outputStream.resetStream();
                                                                }
                                                                catch (IOException iOException) {
                                                                    this.exception(iOException);
                                                                }
                                                            }
                                                            if (this._response != null) {
                                                                if (log.isDebugEnabled()) {
                                                                    log.debug((Object)("RESPONSE:\n" + this._response));
                                                                }
                                                                if (this._persistent && n12 >= 0 && n13 > 0 && n12 != n13) {
                                                                    log.warn((Object)("Invalid length: Content-Length=" + n12 + " written=" + n13 + " for " + this._request.getRequestURL()));
                                                                    this._persistent = false;
                                                                    try {
                                                                        this._outputStream.close();
                                                                    }
                                                                    catch (IOException iOException) {
                                                                        log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                                                                    }
                                                                }
                                                            }
                                                            if (bl) {
                                                                this.statsRequestEnd();
                                                            }
                                                            if (httpContext != null) {
                                                                httpContext.log(this._request, this._response, n13);
                                                            }
                                                            return bl7;
                                                        }
                                                        this._listener.customizeRequest(this, this._request);
                                                        if (this._request.getState() != 2) {
                                                            throw new HttpException(400);
                                                        }
                                                        this.statsRequestStart();
                                                        bl = true;
                                                        this._dotVersion = this._request.getDotVersion();
                                                        if (this._dotVersion > 1) {
                                                            this._dotVersion = 1;
                                                        }
                                                        this._response.setVersion("HTTP/1.1");
                                                        this._response.setField("Date", this._request.getTimeStampStr());
                                                        if (!Version.isParanoid()) {
                                                            this._response.setField("Server", Version.getDetail());
                                                        }
                                                        if ((enumeration = this._request.getFieldValues("Connection", ", \t")) != null) {
                                                            while (enumeration.hasMoreElements()) {
                                                                String string = enumeration.nextElement().toString();
                                                                if (string.equalsIgnoreCase("close")) {
                                                                    this._close = true;
                                                                    this._response.setField("Connection", "close");
                                                                } else if (string.equalsIgnoreCase("keep-alive") && this._dotVersion == 0) {
                                                                    this._keepAlive = true;
                                                                }
                                                                if (this._dotVersion != 0) continue;
                                                                this._request.forceRemoveField(string);
                                                            }
                                                        }
                                                        if (this._dotVersion == 1) {
                                                            this.verifyHTTP_1_1();
                                                        } else if (this._dotVersion == 0) {
                                                            this.verifyHTTP_1_0();
                                                        } else if (this._dotVersion != -1) {
                                                            throw new HttpException(505);
                                                        }
                                                        if (log.isDebugEnabled()) {
                                                            log.debug((Object)("REQUEST from " + this._listener + ":\n" + this._request));
                                                        }
                                                        if (!this._request.isHandled() && this._listener.getHttpHandler() != null) {
                                                            this._listener.getHttpHandler().handle("", null, this._request, this._response);
                                                        }
                                                        if (this._request.isHandled()) break block178;
                                                        httpContext = this.service(this._request, this._response);
                                                    }
                                                    Object var6_10 = null;
                                                    int n16 = 0;
                                                    int n17 = n11 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                    if (this._persistent) {
                                                        boolean bl9 = false;
                                                        try {
                                                            if (this._inputStream.getExpectContinues() != null) {
                                                                this._inputStream.setExpectContinues(null);
                                                                bl9 = true;
                                                            } else {
                                                                int n18 = this._inputStream.getContentLength();
                                                                if (n18 != 0) {
                                                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        catch (IOException iOException) {
                                                            if (this._inputStream.getContentLength() > 0) {
                                                                this._inputStream.setContentLength(0);
                                                            }
                                                            this._persistent = false;
                                                            LogSupport.ignore(log, iOException);
                                                            this.exception(new HttpException(400, "Missing Content"));
                                                        }
                                                        if (!bl9 && this._inputStream.getContentLength() > 0) {
                                                            this._inputStream.setContentLength(0);
                                                            this._persistent = false;
                                                            this.exception(new HttpException(400, "Missing Content"));
                                                        }
                                                        try {
                                                            this._outputStream.close();
                                                            n16 = this._outputStream.getBytesWritten();
                                                            this._outputStream.resetStream();
                                                            this._outputStream.addObserver(this);
                                                            this._inputStream.resetStream();
                                                        }
                                                        catch (IOException iOException) {
                                                            this.exception(iOException);
                                                        }
                                                    } else if (this._response != null) {
                                                        try {
                                                            if (this._inputStream.getContentLength() > 0) {
                                                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                }
                                                            }
                                                            this._inputStream.resetStream();
                                                        }
                                                        catch (IOException iOException) {
                                                            LogSupport.ignore(log, iOException);
                                                        }
                                                        try {
                                                            this._outputStream.flush();
                                                            this._response.commit();
                                                            n16 = this._outputStream.getBytesWritten();
                                                            this._outputStream.close();
                                                            this._outputStream.resetStream();
                                                        }
                                                        catch (IOException iOException) {
                                                            this.exception(iOException);
                                                        }
                                                    }
                                                    if (this._response != null) {
                                                        if (log.isDebugEnabled()) {
                                                            log.debug((Object)("RESPONSE:\n" + this._response));
                                                        }
                                                        if (this._persistent && n11 >= 0 && n16 > 0 && n11 != n16) {
                                                            log.warn((Object)("Invalid length: Content-Length=" + n11 + " written=" + n16 + " for " + this._request.getRequestURL()));
                                                            this._persistent = false;
                                                            try {
                                                                this._outputStream.close();
                                                            }
                                                            catch (IOException iOException) {
                                                                log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                                                            }
                                                        }
                                                    }
                                                    if (bl) {
                                                        this.statsRequestEnd();
                                                    }
                                                    if (httpContext != null) {
                                                        httpContext.log(this._request, this._response, n16);
                                                    }
                                                    break block204;
                                                    {
                                                        catch (HttpException httpException) {
                                                            this.exception(httpException);
                                                            Object var6_11 = null;
                                                            n10 = 0;
                                                            int n19 = n9 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                            if (!this._persistent) break block183;
                                                            bl6 = false;
                                                            try {
                                                                if (this._inputStream.getExpectContinues() != null) {
                                                                    this._inputStream.setExpectContinues(null);
                                                                    bl6 = true;
                                                                } else {
                                                                    int n20 = this._inputStream.getContentLength();
                                                                    if (n20 != 0) {
                                                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            catch (IOException iOException) {
                                                                if (this._inputStream.getContentLength() > 0) {
                                                                    this._inputStream.setContentLength(0);
                                                                }
                                                                this._persistent = false;
                                                                LogSupport.ignore(log, iOException);
                                                                this.exception(new HttpException(400, "Missing Content"));
                                                            }
                                                        }
                                                    }
                                                    if (!bl6 && this._inputStream.getContentLength() > 0) {
                                                        this._inputStream.setContentLength(0);
                                                        this._persistent = false;
                                                        this.exception(new HttpException(400, "Missing Content"));
                                                    }
                                                    try {
                                                        this._outputStream.close();
                                                        n10 = this._outputStream.getBytesWritten();
                                                        this._outputStream.resetStream();
                                                        this._outputStream.addObserver(this);
                                                        this._inputStream.resetStream();
                                                    }
                                                    catch (IOException iOException) {
                                                        this.exception(iOException);
                                                    }
                                                    break block186;
                                                }
                                                if (this._response != null) {
                                                    try {
                                                        if (this._inputStream.getContentLength() > 0) {
                                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                            }
                                                        }
                                                        this._inputStream.resetStream();
                                                    }
                                                    catch (IOException iOException) {
                                                        LogSupport.ignore(log, iOException);
                                                    }
                                                    try {
                                                        this._outputStream.flush();
                                                        this._response.commit();
                                                        n10 = this._outputStream.getBytesWritten();
                                                        this._outputStream.close();
                                                        this._outputStream.resetStream();
                                                    }
                                                    catch (IOException iOException) {
                                                        this.exception(iOException);
                                                    }
                                                }
                                            }
                                            if (this._response != null) {
                                                if (log.isDebugEnabled()) {
                                                    log.debug((Object)("RESPONSE:\n" + this._response));
                                                }
                                                if (this._persistent && n9 >= 0 && n10 > 0 && n9 != n10) {
                                                    log.warn((Object)("Invalid length: Content-Length=" + n9 + " written=" + n10 + " for " + this._request.getRequestURL()));
                                                    this._persistent = false;
                                                    try {
                                                        this._outputStream.close();
                                                    }
                                                    catch (IOException iOException) {
                                                        log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                                                    }
                                                }
                                            }
                                            if (bl) {
                                                this.statsRequestEnd();
                                            }
                                            if (httpContext != null) {
                                                httpContext.log(this._request, this._response, n10);
                                            }
                                            break block204;
                                            {
                                                catch (IOException iOException) {
                                                    if (this._request.getState() != 2) {
                                                        if (log.isDebugEnabled()) {
                                                            if (log.isTraceEnabled()) {
                                                                log.trace((Object)"EXCEPTION ", (Throwable)iOException);
                                                            } else if (log.isDebugEnabled()) {
                                                                log.debug((Object)iOException.toString());
                                                            }
                                                        }
                                                        this._response.destroy();
                                                        this._response = null;
                                                    } else {
                                                        this.exception(iOException);
                                                    }
                                                    Object var6_12 = null;
                                                    n8 = 0;
                                                    int n21 = n7 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                    if (!this._persistent) break block188;
                                                    bl5 = false;
                                                    try {
                                                        if (this._inputStream.getExpectContinues() != null) {
                                                            this._inputStream.setExpectContinues(null);
                                                            bl5 = true;
                                                        } else {
                                                            int n22 = this._inputStream.getContentLength();
                                                            if (n22 != 0) {
                                                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                }
                                                            }
                                                        }
                                                    }
                                                    catch (IOException iOException2) {
                                                        if (this._inputStream.getContentLength() > 0) {
                                                            this._inputStream.setContentLength(0);
                                                        }
                                                        this._persistent = false;
                                                        LogSupport.ignore(log, iOException2);
                                                        this.exception(new HttpException(400, "Missing Content"));
                                                    }
                                                }
                                            }
                                            if (!bl5 && this._inputStream.getContentLength() > 0) {
                                                this._inputStream.setContentLength(0);
                                                this._persistent = false;
                                                this.exception(new HttpException(400, "Missing Content"));
                                            }
                                            try {
                                                this._outputStream.close();
                                                n8 = this._outputStream.getBytesWritten();
                                                this._outputStream.resetStream();
                                                this._outputStream.addObserver(this);
                                                this._inputStream.resetStream();
                                            }
                                            catch (IOException iOException) {
                                                this.exception(iOException);
                                            }
                                            break block191;
                                        }
                                        if (this._response != null) {
                                            try {
                                                if (this._inputStream.getContentLength() > 0) {
                                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                    }
                                                }
                                                this._inputStream.resetStream();
                                            }
                                            catch (IOException iOException) {
                                                LogSupport.ignore(log, iOException);
                                            }
                                            try {
                                                this._outputStream.flush();
                                                this._response.commit();
                                                n8 = this._outputStream.getBytesWritten();
                                                this._outputStream.close();
                                                this._outputStream.resetStream();
                                            }
                                            catch (IOException iOException) {
                                                this.exception(iOException);
                                            }
                                        }
                                    }
                                    if (this._response != null) {
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("RESPONSE:\n" + this._response));
                                        }
                                        if (this._persistent && n7 >= 0 && n8 > 0 && n7 != n8) {
                                            log.warn((Object)("Invalid length: Content-Length=" + n7 + " written=" + n8 + " for " + this._request.getRequestURL()));
                                            this._persistent = false;
                                            try {
                                                this._outputStream.close();
                                            }
                                            catch (IOException iOException) {
                                                log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                                            }
                                        }
                                    }
                                    if (bl) {
                                        this.statsRequestEnd();
                                    }
                                    if (httpContext != null) {
                                        httpContext.log(this._request, this._response, n8);
                                    }
                                    break block204;
                                    {
                                        catch (Exception exception) {
                                            this.exception(exception);
                                            Object var6_13 = null;
                                            n6 = 0;
                                            int n23 = n5 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                            if (!this._persistent) break block193;
                                            bl4 = false;
                                            try {
                                                if (this._inputStream.getExpectContinues() != null) {
                                                    this._inputStream.setExpectContinues(null);
                                                    bl4 = true;
                                                } else {
                                                    int n24 = this._inputStream.getContentLength();
                                                    if (n24 != 0) {
                                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                        }
                                                    }
                                                }
                                            }
                                            catch (IOException iOException) {
                                                if (this._inputStream.getContentLength() > 0) {
                                                    this._inputStream.setContentLength(0);
                                                }
                                                this._persistent = false;
                                                LogSupport.ignore(log, iOException);
                                                this.exception(new HttpException(400, "Missing Content"));
                                            }
                                        }
                                    }
                                    if (!bl4 && this._inputStream.getContentLength() > 0) {
                                        this._inputStream.setContentLength(0);
                                        this._persistent = false;
                                        this.exception(new HttpException(400, "Missing Content"));
                                    }
                                    try {
                                        this._outputStream.close();
                                        n6 = this._outputStream.getBytesWritten();
                                        this._outputStream.resetStream();
                                        this._outputStream.addObserver(this);
                                        this._inputStream.resetStream();
                                    }
                                    catch (IOException iOException) {
                                        this.exception(iOException);
                                    }
                                    break block196;
                                }
                                if (this._response != null) {
                                    try {
                                        if (this._inputStream.getContentLength() > 0) {
                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                            }
                                        }
                                        this._inputStream.resetStream();
                                    }
                                    catch (IOException iOException) {
                                        LogSupport.ignore(log, iOException);
                                    }
                                    try {
                                        this._outputStream.flush();
                                        this._response.commit();
                                        n6 = this._outputStream.getBytesWritten();
                                        this._outputStream.close();
                                        this._outputStream.resetStream();
                                    }
                                    catch (IOException iOException) {
                                        this.exception(iOException);
                                    }
                                }
                            }
                            if (this._response != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("RESPONSE:\n" + this._response));
                                }
                                if (this._persistent && n5 >= 0 && n6 > 0 && n5 != n6) {
                                    log.warn((Object)("Invalid length: Content-Length=" + n5 + " written=" + n6 + " for " + this._request.getRequestURL()));
                                    this._persistent = false;
                                    try {
                                        this._outputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                                    }
                                }
                            }
                            if (bl) {
                                this.statsRequestEnd();
                            }
                            if (httpContext != null) {
                                httpContext.log(this._request, this._response, n6);
                            }
                            break block204;
                            {
                                catch (Error error) {
                                    this.exception(error);
                                    Object var6_14 = null;
                                    n4 = 0;
                                    int n25 = n3 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                    if (!this._persistent) break block198;
                                    bl3 = false;
                                    try {
                                        if (this._inputStream.getExpectContinues() != null) {
                                            this._inputStream.setExpectContinues(null);
                                            bl3 = true;
                                        } else {
                                            int n26 = this._inputStream.getContentLength();
                                            if (n26 != 0) {
                                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                }
                                            }
                                        }
                                    }
                                    catch (IOException iOException) {
                                        if (this._inputStream.getContentLength() > 0) {
                                            this._inputStream.setContentLength(0);
                                        }
                                        this._persistent = false;
                                        LogSupport.ignore(log, iOException);
                                        this.exception(new HttpException(400, "Missing Content"));
                                    }
                                }
                            }
                            if (!bl3 && this._inputStream.getContentLength() > 0) {
                                this._inputStream.setContentLength(0);
                                this._persistent = false;
                                this.exception(new HttpException(400, "Missing Content"));
                            }
                            try {
                                this._outputStream.close();
                                n4 = this._outputStream.getBytesWritten();
                                this._outputStream.resetStream();
                                this._outputStream.addObserver(this);
                                this._inputStream.resetStream();
                            }
                            catch (IOException iOException) {
                                this.exception(iOException);
                            }
                            break block201;
                        }
                        if (this._response != null) {
                            try {
                                if (this._inputStream.getContentLength() > 0) {
                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                    }
                                }
                                this._inputStream.resetStream();
                            }
                            catch (IOException iOException) {
                                LogSupport.ignore(log, iOException);
                            }
                            try {
                                this._outputStream.flush();
                                this._response.commit();
                                n4 = this._outputStream.getBytesWritten();
                                this._outputStream.close();
                                this._outputStream.resetStream();
                            }
                            catch (IOException iOException) {
                                this.exception(iOException);
                            }
                        }
                    }
                    if (this._response != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RESPONSE:\n" + this._response));
                        }
                        if (this._persistent && n3 >= 0 && n4 > 0 && n3 != n4) {
                            log.warn((Object)("Invalid length: Content-Length=" + n3 + " written=" + n4 + " for " + this._request.getRequestURL()));
                            this._persistent = false;
                            try {
                                this._outputStream.close();
                            }
                            catch (IOException iOException) {
                                log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                            }
                        }
                    }
                    if (bl) {
                        this.statsRequestEnd();
                    }
                    if (httpContext != null) {
                        httpContext.log(this._request, this._response, n4);
                    }
                    break block204;
                    catch (Throwable throwable222) {
                        Object var6_15 = null;
                        n2 = 0;
                        int n27 = n = this._response == null ? -1 : this._response.getIntField("Content-Length");
                        if (!this._persistent) break block203;
                        bl2 = false;
                        try {
                            if (this._inputStream.getExpectContinues() != null) {
                                this._inputStream.setExpectContinues(null);
                                bl2 = true;
                            } else {
                                int n28 = this._inputStream.getContentLength();
                                if (n28 != 0) {
                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                    }
                                }
                            }
                        }
                        catch (IOException iOException) {
                            if (this._inputStream.getContentLength() > 0) {
                                this._inputStream.setContentLength(0);
                            }
                            this._persistent = false;
                            LogSupport.ignore(log, iOException);
                            this.exception(new HttpException(400, "Missing Content"));
                        }
                    }
                    if (!bl2 && this._inputStream.getContentLength() > 0) {
                        this._inputStream.setContentLength(0);
                        this._persistent = false;
                        this.exception(new HttpException(400, "Missing Content"));
                    }
                    try {
                        this._outputStream.close();
                        n2 = this._outputStream.getBytesWritten();
                        this._outputStream.resetStream();
                        this._outputStream.addObserver(this);
                        this._inputStream.resetStream();
                    }
                    catch (IOException iOException) {
                        this.exception(iOException);
                    }
                    break block205;
                }
                if (this._response != null) {
                    try {
                        if (this._inputStream.getContentLength() > 0) {
                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                            }
                        }
                        this._inputStream.resetStream();
                    }
                    catch (IOException iOException) {
                        LogSupport.ignore(log, iOException);
                    }
                    try {
                        this._outputStream.flush();
                        this._response.commit();
                        n2 = this._outputStream.getBytesWritten();
                        this._outputStream.close();
                        this._outputStream.resetStream();
                    }
                    catch (IOException iOException) {
                        this.exception(iOException);
                    }
                }
            }
            if (this._response != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RESPONSE:\n" + this._response));
                }
                if (this._persistent && n >= 0 && n2 > 0 && n != n2) {
                    log.warn((Object)("Invalid length: Content-Length=" + n + " written=" + n2 + " for " + this._request.getRequestURL()));
                    this._persistent = false;
                    try {
                        this._outputStream.close();
                    }
                    catch (IOException iOException) {
                        log.warn((Object)"EXCEPTION ", (Throwable)iOException);
                    }
                }
            }
            if (bl) {
                this.statsRequestEnd();
            }
            if (httpContext != null) {
                httpContext.log(this._request, this._response, n2);
            }
            throw throwable222;
        }
        return this._tunnel != null || this._persistent;
    }

    protected void statsRequestStart() {
        if (this._statsOn) {
            if (this._reqTime > 0L) {
                this.statsRequestEnd();
            }
            ++this._requests;
            this._reqTime = this._tmpTime = this._request.getTimeStamp();
            this._httpServer.statsGotRequest();
        }
    }

    protected void statsRequestEnd() {
        if (this._statsOn && this._reqTime > 0L) {
            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
            this._reqTime = 0L;
        }
    }

    protected void recycle() {
        this._listener.persistConnection(this);
        if (this._request != null) {
            this._request.recycle(this);
        }
        if (this._response != null) {
            this._response.recycle(this);
        }
    }

    protected void destroy() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
        if (this._request != null) {
            this._request.destroy();
        }
        if (this._response != null) {
            this._response.destroy();
        }
        if (this._inputStream != null) {
            this._inputStream.destroy();
        }
        if (this._outputStream != null) {
            this._outputStream.destroy();
        }
        this._inputStream = null;
        this._outputStream = null;
        this._request = null;
        this._response = null;
        this._handlingThread = null;
        if (this._statsOn) {
            this._tmpTime = System.currentTimeMillis();
            if (this._reqTime > 0L) {
                this._httpServer.statsEndRequest(this._tmpTime - this._reqTime, false);
            }
            this._httpServer.statsCloseConnection(this._tmpTime - this._openTime, this._requests);
        }
    }
}

