/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.OutputStream;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpMessage;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.ByteBufferOutputStream;
import org.mortbay.util.OutputObserver;

public class BufferedOutputStream
extends ByteBufferOutputStream
implements HttpMessage.HeaderWriter {
    protected OutputStream _out;
    protected ByteArrayISO8859Writer _httpMessageWriter;
    private OutputObserver _commitObserver;
    private boolean _commited;
    private int _preReserve;
    private boolean _bypassBuffer;

    public BufferedOutputStream(OutputStream outputStream, int n, int n2, int n3, int n4) {
        super(n, n2, n4);
        this._out = outputStream;
        this._preReserve = n3;
        this._httpMessageWriter = new ByteArrayISO8859Writer(n2);
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public OutputObserver getCommitObserver() {
        return this._commitObserver;
    }

    public void setCommitObserver(OutputObserver outputObserver) {
        this._commitObserver = outputObserver;
    }

    public boolean isCommitted() {
        return this._commited;
    }

    public boolean getBypassBuffer() {
        return this._bypassBuffer;
    }

    public void setBypassBuffer(boolean bl) {
        this._bypassBuffer = bl;
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        httpMessage.writeHeader(this._httpMessageWriter);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            int n5 = this.capacity();
            if (this._bypassBuffer && this.isCommitted() && this.size() == 0 && n4 > n5) {
                this.bypassWrite(byArray, n3, n4);
                break;
            }
            if (n4 < n5 || !this.isFixed()) {
                super.write(byArray, n3, n4);
                break;
            }
            super.write(byArray, n3, n5);
            this.flush();
            n4 -= n5;
            n3 += n5;
        }
    }

    protected void bypassWrite(byte[] byArray, int n, int n2) throws IOException {
        try {
            this._out.write(byArray, n, n2);
            this._out.flush();
        }
        catch (IOException iOException) {
            throw new EOFException(iOException);
        }
    }

    public void flush() throws IOException {
        try {
            if (!this._commited) {
                this._commited = true;
                if (this._commitObserver != null) {
                    this._commitObserver.outputNotify(this, 2, null);
                }
            }
            this.wrapBuffer();
            if (this._httpMessageWriter.size() > 0) {
                this.prewrite(this._httpMessageWriter.getBuf(), 0, this._httpMessageWriter.size());
                this._httpMessageWriter.resetWriter();
            }
            if (this.size() > 0) {
                this.writeTo(this._out);
            }
        }
        catch (IOException iOException) {
            throw new EOFException(iOException);
        }
        finally {
            this.reset(this._preReserve);
        }
    }

    protected void wrapBuffer() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
        this._out.close();
    }

    public void resetStream() {
        super.reset(this._httpMessageWriter.capacity());
        this._commited = false;
    }

    public void destroy() {
        super.destroy();
        if (this._httpMessageWriter != null) {
            this._httpMessageWriter.destroy();
        }
        this._httpMessageWriter = null;
        this._out = null;
    }
}

