{
  - Master Cluster's Library -

  Copyright  1996-2002 Leonid Belousov (aka Master Cluster)
  mailto: mc@bramc.ru
  www.bramc.ru/soft/

  - Description: Demo for Extended Stored Procedures component
}

{
exec master..xp_Comp 15
exec master..xp_PureAPI 15
}

library xprocdemo;

uses
  Windows, SysUtils, MSODSAPI, XProc;

{$R *.res}

// Listing #1: Using the TXtendedProc component
function xp_Comp(ProcHandle: TXProcHandle): Integer; cdecl;
var
  i, iStart: Integer;
begin
  with TXtendedProc.Create(ProcHandle) do	// This also creates collection of the input
  try						// parameters if they are present.
    if Params.Count > 0 then			// Check if input parameters are present...
      iStart := Params[0].AsInteger		// Let's use 1st input parameter!
    else
      iStart := 0;				// No input parameters? Use default value instead.

    Fields[0].Name := 'Line Number';		// OPTIONAL: Give names to recordset columns.
    Fields[1].Name := 'Value';			//           But we're not required to do that.
    for i := 1 to 20 do				// Begin output...
    begin
      Fields[0].AsInteger := i;			// Put data into the row
      Fields[1].AsInteger := i + iStart;
      Fields.Next;				// Send the row
    end;
  finally
    Free;					// Finally send data back to SQL Server
  end;
  result := 1; 					// Report success (1 = SUCCEED, 0 = FAIL)
end; // xp_Comp


// Listing #2: Using pure Open Data Services API
function xp_PureAPI(pSrvProc: SRV_PROC): Integer; cdecl;
var
  i, iStart, n: Integer;
  bType: Byte;
  fNull: Bool;
  cbMaxLen, cbActualLen: ULONG;
begin
  if srv_rpcparams(pSrvProc) = 1 then		// Check if input parameters are present...
    srv_paraminfo(pSrvProc, 1, @bType,	 	// Let's use 1st input parameter!
       @cbMaxLen, @cbActualLen, 		// NOTE: We assume here what only one parameter
       @iStart, @fNull)				//       of type INT can be passed!!!
						//       INT is easy case: we have no need
						//       to allocate memory buffers.
  else
    iStart := 0;				// No input parameters? Use default value instead.

  // Describe one row with two columns of type INT and give names to them
  // (Actually, you are doing that for every datatype and every column you want to return).
  srv_describe(pSrvProc, 1, 'Line Number', SRV_NULLTERM,
               SRVINTN, SizeOf(Integer),
               SRVINTN, SizeOf(Integer), nil);

  srv_describe(pSrvProc, 2, 'Value', SRV_NULLTERM,
               SRVINTN, SizeOf(Integer),
               SRVINTN, SizeOf(Integer), nil);

  for i := 1 to 20 do				// Begin output...
  begin
    srv_setcoldata(pSrvProc, 1, @i);		// Put data into the row
    n := i + iStart;
    srv_setcoldata(pSrvProc, 2, @n);
    srv_sendrow(pSrvProc);			// Send the row.
  end;
						// Let return output parameter (just for example).
  if (srv_rpcparams(pSrvProc) = 1) and (srv_paramstatus(pSrvProc, 1) and SRV_PARAMRETURN <> 0) then
    srv_paramsetoutput(pSrvProc, 1, @n, SizeOf(n), FALSE);

  srv_senddone(pSrvProc,                        // Finally send data back to SQL Server:
    (SRV_DONE_COUNT or SRV_DONE_MORE), 0, 20);  // send results completion message.
  result := 1;					// Report success (1 = SUCCEED, 0 = FAIL)
end; // xp_PureAPI

exports
  xp_Comp,
  xp_PureAPI;

begin
end.
