//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <ShellApi.h>
#pragma hdrstop

#include "Demo5Frm.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TfrmDemo5 *frmDemo5;
//---------------------------------------------------------------------------
__fastcall TfrmDemo5::TfrmDemo5(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
bool IsAddress(AnsiString s)
{
  // Checks for prefix.
  // For better results, it should check for lengths...
  s = UpperCase(s);
  return
        (s.Pos("HTTP://")  ==1) ||
        (s.Pos("FTP://")   ==1) ||
        (s.Pos("FILE://")  ==1) ||
        (s.Pos("GOPHER://")==1) ||
        (s.Pos("MAILTO://")==1) ||
        (s.Pos("HTTPS://") ==1) ||
        (s.Pos("MAILTO:")  ==1) ||
        (s.Pos("NEWS:")    ==1) ||
        (s.Pos("TELNET:")  ==1) ||
        (s.Pos("WAIS:")    ==1) ||
        (s.Pos("WWW.")     ==1) ||
        (s.Pos("FTP.")     ==1);
}
//---------------------------------------------------------------------------
bool IsEmail(const AnsiString s)
{
  //'@' must exist and '.' must be after it. This is not comprehensive test,
  //but I think that it's ok
  int p1 = s.Pos("@");
  if (!p1)
    return false;
  char * pchr = StrRScan(s.c_str(),'.');
  if (!pchr)
    return false;
  int p2 = pchr-s.c_str()+1;
  return p1<=p2;
}
//---------------------------------------------------------------------------
void AddWithURLs(AnsiString s, TRichView* rv, int DefStyle, int UrlStyle)
{
  AnsiString Before = "";
  int ParaNo = 0;
  if (s=="")
  {
    rv->AddNL("", DefStyle, ParaNo);
    return;
  }
  while (s!="")
  {
    int p = s.Pos(" ");
    if (!p)
      p = s.Length()+1;
    AnsiString CurrentWord = s.SubString(1, p-1);
    AnsiString Space = s.SubString(p, 1);
    s = s.SubString(p+1, s.Length());
    if (IsAddress(CurrentWord) || IsEmail(CurrentWord))
    {
      if (Before!="")
      {
        rv->AddNL(Before, DefStyle, ParaNo);
        ParaNo = -1;
        Before = "";
      }
      rv->AddNL(CurrentWord, UrlStyle, ParaNo);
      ParaNo = -1;
      if (Space!="")
        rv->Add(Space, DefStyle);
    }
    else
      Before += CurrentWord+Space;
   }
   if (Before!="")
     rv->AddNL(Before, DefStyle, ParaNo);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::FormCreate(TObject *Sender)
{
  pan->ClientHeight = edit->Height;
  edit->SetBounds(0,0,pan->ClientWidth,pan->ClientHeight);
  rv->AddNL("Use right-click menu to freeze scrolling when appending text", 2, 0);
  rv->AddNL("Try quick-copy: selection is copied automatically when done", 2, 0);
  AddWithURLs("You can use URLs and e-mail ( like www.trichview.com )",
              rv, 2, 1);
  rv->Format();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::FormResize(TObject *Sender)
{
   edit->Width = pan->ClientWidth;    
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::editKeyPress(TObject *Sender, char &Key)
{
  if (Key=='\r')
  {
    AddWithURLs(edit->Text,rv,0,1);
    rv->FormatTail();
    Key = 0;
    edit->Text = "";
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::rvSelect(TObject *Sender)
{
  // Quick-copy
  if (rv->SelectionExists())
  {
    rv->CopyDef();
    rv->Deselect();
    rv->Invalidate();
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::pmPopup(TObject *Sender)
{
  mitFreezescrolling->Checked = ! rv->Options.Contains(rvoScrollToEnd);    
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::mitFreezescrollingClick(TObject *Sender)
{
  if (rv->Options.Contains(rvoScrollToEnd))
    rv->Options >> rvoScrollToEnd;
  else
    rv->Options << rvoScrollToEnd;
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::rvJump(TObject *Sender, int id)
{
  int ItemNo = rv->GetJumpPointItemNo(id);
  AnsiString s = rv->GetItemText(ItemNo);
  if (!IsAddress(s) && IsEmail(s))
    s = "mailto:"+s;
  ShellExecute(Application->Handle, "open", s.c_str(), NULL, NULL, SW_NORMAL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDemo5::FormKeyDown(TObject *Sender, WORD &Key,
    TShiftState Shift)
{
  if (Key==VK_ESCAPE)
     Close();    
}
//---------------------------------------------------------------------------
