unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtDlgs, ExtCtrls, StdCtrls, Mask, Buttons, Grids,
  DB, DBTables, DBCtrls, DBGrids,
  DXFImage, DXFConv,
  {$IFNDEF sgDXFONLY}
  DWG, HPGL2, SVG, CGM,
  {$ENDIF}
  frxClass, frxExportXLS,
  frxDesgn, frxDBSet;

const
  sFRForm = 'CADfrDemo.fr3';

type
  TfmMain = class(TForm)
    tblData: TTable;
    tblDataID: TAutoIncField;
    tblDataFILE_NAME: TStringField;
    tblDataBMP: TBlobField;
    dsSource: TDataSource;
    OpenPictureDialog: TOpenPictureDialog;
    dbgdGrid: TDBGrid;
    pnPanel: TPanel;
    dbNavigator: TDBNavigator;
    btOpen: TSpeedButton;
    btDesign: TSpeedButton;
    dbedFileName: TDBEdit;
    Splitter1: TSplitter;
    tbExportExcel: TSpeedButton;
    sbBox: TScrollBox;
    dbiImage: TDBImage;
    frxReport: TfrxReport;
    frxDesigner: TfrxDesigner;
    frxXLSExport: TfrxXLSExport;
    frxDBDataset: TfrxDBDataset;
    procedure FormCreate(Sender: TObject);
    procedure btOpenClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btDesignClick(Sender: TObject);
    procedure tbExportExcelClick(Sender: TObject);
  private
    FDXFImage: TsgDXFImage;
  public
  end;

var
  fmMain: TfmMain;

implementation

{$R *.dfm}

procedure TfmMain.FormCreate(Sender: TObject);
begin
  OpenPictureDialog.Filter := GraphicFilter(TGraphic);
  tblData.Open;
end;

procedure TfmMain.btOpenClick(Sender: TObject);
const
  Exts: array[0..17] of string = ( '.dxf', '.dwg', '.plt', '.hgl', '.rtl',
    '.hg', '.plo', '.hp', '.hp1', '.hp2', '.hpg', '.hpgl', '.hpgl2', '.gl2',
    '.prn', '.spl', '.svg', '.cgm');
var
  Img: TsgDXFImage;
  BM: TBitmap;
  Max: Double;
  W,H,BSize: Integer;
  MS: TMemoryStream;
  vFS: Integer;
  S: TMemoryStream;
  vFileExt: string;

begin
  if OpenPictureDialog.Execute then
  begin
    if (tblData.State <> dsEdit) or (tblData.State <> dsInsert) then
      tblData.Edit;
    tblData.Insert;
    vFileExt := LowerCase(ExtractFileExt(OpenPictureDialog.FileName));
    case StrIndex(vFileExt, Exts) of
      0:	Img := TsgDXFImage.Create;
      {$IFNDEF sgDXFONLY}
      1:	Img := TsgDWGImage.Create;
      2..15:	Img := TsgHPGLImage.Create;
      16:     Img := TsgSVGImage.Create;
      17:     Img := TsgCGMImage.Create;
      {$ENDIF}
    else
      Img := nil;
    end;
    if Img = nil then
      raise EXception.Create('Unsupported file format');
    try
      try
        Img.LoadFromFile(OpenPictureDialog.FileName);
        Img.CurrentLayout := Img.Layouts[Img.Converter.DefaultLayoutIndex];
        if Img.AbsWidth > Img.AbsHeight then
          Max := Img.AbsWidth
        else
          Max := Img.AbsHeight;
        BSize := 640;
        W := Round(BSize * Img.AbsWidth / Max);
        H := Round(BSize * Img.AbsHeight / Max);
        if W=0 then W := 1;
        if H=0 then H := 1;
        BM := TBitmap.Create;
        try
          BM.PixelFormat := pf8bit;
          BM.Width := W;
          BM.Height := H;
          BM.Canvas.StretchDraw(Rect(0,0,W,H), Img);
          S := TMemoryStream.Create;
          try
            BM.SaveToStream(S);
            tblDataBMP.LoadFromStream(S);
            tblDataFILE_NAME.Value := ExtractFileName(OpenPictureDialog.FileName);
          finally
            S.Free;
          end;
        finally
          BM.Free;
        end;
      finally
        Img.Free;
      end;
    except
      on E: Exception do
      begin
        E.Create(E.Message);
      end;
    end;
    tblData.Post;
  end;
end;

procedure TfmMain.FormDestroy(Sender: TObject);
begin
  FDXFImage.Free;
end;

procedure TfmMain.btDesignClick(Sender: TObject);
begin
  frxReport.LoadFromFile(sFRForm);
  frxReport.DesignReport;
end;

procedure TfmMain.tbExportExcelClick(Sender: TObject);
var
  vRecNo: Integer;
  vXLSFileName: string;
begin
  frxReport.FileName := ExtractFileName(sFRForm);
  frxXLSExport.Report := frxReport;
  vRecNo := tblData.RecNo;
  dbiImage.DataSource := nil;
  frxXLSExport.Report.LoadFromFile(frxXLSExport.Report.FileName);
  frxXLSExport.Report.PrepareReport;
  frxXLSExport.OpenExcelAfterExport := True;
  vXLSFileName := ExtractFilePath(Application.ExeName);
  vXLSFileName := vXLSFileName + ChangeFileExt(ExtractFileName(sFRForm),'.xls');
  frxXLSExport.FileName := vXLSFileName;
  frxXLSExport.ShowProgress := False;
  frxXLSExport.Report.Export(frxXLSExport);
  tblData.RecNo := vRecNo;
  dbiImage.DataSource := dsSource;
end;

end.
