//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fEntity.h"
#include <sgConsts.hpp>
#include <DXFConv.hpp>
#include <Classes.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CSPIN"
#pragma resource "*.dfm"
TfmCreateEntity *fmCreateEntity;
//---------------------------------------------------------------------------
__fastcall TfmCreateEntity::TfmCreateEntity(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//void GetEntity(TsgDXFEntity *Ent)
TsgDXFEntity * GetEntity(TsgDXFImage * AImage)
{
  TsgDXFEntity *Ent = NULL;
  TfmCreateEntity *fmCreateEntity;
  char Dc;
  TStrings *St;
  int I;
  AnsiString S;

  fmCreateEntity = new TfmCreateEntity(Application);
  Dc = DecimalSeparator;
  try
  {
    DecimalSeparator = '.';
    fmCreateEntity->cbEntityChange(NULL);
    fmCreateEntity->ShowModal();
    if (fmCreateEntity->ModalResult == mrOk)
    {
      St = fmCreateEntity->mmCoordinates->Lines;
      switch (fmCreateEntity->cbEntity->ItemIndex)
      {
      case
        0:
          {
            TsgDXFLine *vLine = new TsgDXFLine;
            vLine->Point = MakeFPoint(ConvToFloatDef(St->Values["X1"],
              0.0), ConvToFloatDef(St->Values["Y1"], 0.0),
              ConvToFloatDef(St->Values["Z1"], 0.0));
            vLine->Point1 = MakeFPoint(ConvToFloatDef(St->Values["X2"],
              0.0), ConvToFloatDef(St->Values["Y2"], 0.0),
              ConvToFloatDef(St->Values["Z2"], 0.0));
            Ent = vLine;
            break;
          }
      case
        1:
          {
            I = 1;
            S = St->Values["X" + IntToStr(I)];
            TsgDXFPolyline *vPolyLine = new TsgDXFPolyline;
            do
            {
              TsgDXFVertex *vVertex = new TsgDXFVertex;
              vVertex->Point = MakeFPoint(ConvToFloatDef(St->Values["X" + IntToStr(I)],
              0.0), ConvToFloatDef(St->Values["Y" + IntToStr(I)], 0.0),
              ConvToFloatDef(St->Values["Z" + IntToStr(I)], 0.0));
              I++;
              S = St->Values["X" + IntToStr(I)];
              vPolyLine->AddEntity(vVertex);
            }
            while (S != "");
            Ent = vPolyLine;
            break;
          }
      case
        2:
          {
            TsgDXFCircle *vCircle = new TsgDXFCircle;
            vCircle->Radius = ConvToFloatDef(St->Values["Radius"],
              100.0);
            vCircle->Point = MakeFPoint(ConvToFloatDef(St->Values["X"],
              0.0), ConvToFloatDef(St->Values["Y"], 0.0),
              ConvToFloatDef(St->Values["Z"], 0.0));
            Ent = vCircle;
            break;
          }
      case
        3:
          {
            // Adding the grid using TsgDXFPolyline
            TsgDXFPolyline *vPolyLine = NULL;
            int ColCount = int(ConvToFloatDef(St->Values["Collumns count"], -1.0));
            if (ColCount > 0)
            {
              vPolyLine = new TsgDXFPolyline();
              TsgDXFVertex *vVertex;
              double d = AImage->AbsWidth() / ColCount;
              double X, Y, H, EndX, EndY;
              int I, J, RowCount;
              TFRect vExt = AImage->Extents;

              RowCount = 0;
              Y = vExt.Bottom;
              while ((Y = (vExt.Bottom + ++RowCount * d)) <= vExt.Top);
              for(I = 0; I < ColCount; I++)
              {
                vVertex = new TsgDXFVertex;
                X = vExt.Left + I * d;
                Y = vExt.Bottom;
                vVertex->Point = MakeFPoint(X, Y, 0);//
                vPolyLine->AddEntity(vVertex);

                vVertex = new TsgDXFVertex;
                X = vExt.Left + I * d;
                Y = vExt.Top;
                vVertex->Point = MakeFPoint(X, Y, 0);//
                vPolyLine->AddEntity(vVertex);

                vVertex = new TsgDXFVertex;
                X = vExt.Left + (I+1) * d;
                Y = vExt.Top;
                vVertex->Point = MakeFPoint(X, Y, 0);//
                vPolyLine->AddEntity(vVertex);
              }
              EndX = X;
              EndY = Y;
              J = 0;
              do
              {
                vVertex = new TsgDXFVertex;
                X = EndX;
                Y = EndY - J * d;
                vVertex->Point = MakeFPoint(X, Y, 0);//
                vPolyLine->AddEntity(vVertex);

                Y = EndY - (J+1) * d;
                if (Y >= vExt.Bottom)
                {
                  vVertex = new TsgDXFVertex;
                  vVertex->Point = MakeFPoint(X, Y, 0);//
                  vPolyLine->AddEntity(vVertex);

                  X = vExt.Left;
                  vVertex = new TsgDXFVertex;
                  vVertex->Point = MakeFPoint(X, Y, 0);//
                  vPolyLine->AddEntity(vVertex);
                }
                J++;
              }
              while (--RowCount);
              vPolyLine->Layer = AImage->Converter->LayerByName(St->Values["Name"]);
              vPolyLine->SetLType(AImage->Converter->LTypeByName(St->Values["LTypeName"]));
            }
            Ent = vPolyLine;
            break;
          }
      }
      if (Ent)
      {
        Ent->SetColor(fmCreateEntity->pnlColor->Color);
        Ent->SetLWeight(fmCreateEntity->seWeight->Value);
      }
    }
  }
  __finally
  {
    DecimalSeparator = Dc;
    delete fmCreateEntity;
    return Ent;
  }
}


void __fastcall TfmCreateEntity::FormCreate(TObject *Sender)
{
  cbEntity->ItemIndex = 0;
}
//---------------------------------------------------------------------------

void __fastcall TfmCreateEntity::cbEntityChange(TObject *Sender)
{
  mmCoordinates->Clear();
  switch (cbEntity->ItemIndex)
  {
  case
    0:
      {
        mmCoordinates->Lines->Add("First point");
        mmCoordinates->Lines->Add("X1=0.0");
        mmCoordinates->Lines->Add("Y1=0.0");
        mmCoordinates->Lines->Add("Z1=0.0");
        mmCoordinates->Lines->Add("Second point");
        mmCoordinates->Lines->Add("X2=1000.0");
        mmCoordinates->Lines->Add("Y2=1000.0");
        mmCoordinates->Lines->Add("Z2=0.0");
      }
  case
    1:
      {
        mmCoordinates->Lines->Add("Firs point");
        mmCoordinates->Lines->Add("X1=0.0");
        mmCoordinates->Lines->Add("Y1=0.0");
        mmCoordinates->Lines->Add("Z1=0.0");
        mmCoordinates->Lines->Add("Second point");
        mmCoordinates->Lines->Add("X2=500.0");
        mmCoordinates->Lines->Add("Y2=400.0");
        mmCoordinates->Lines->Add("Z2=0.0");
        mmCoordinates->Lines->Add("Third point");
        mmCoordinates->Lines->Add("X3=800.0");
        mmCoordinates->Lines->Add("Y3=1000.0");
        mmCoordinates->Lines->Add("Z3=0.0");
        mmCoordinates->Lines->Add("Fourth point");
        mmCoordinates->Lines->Add("X4=1500.0");
        mmCoordinates->Lines->Add("Y4=3000.0");
        mmCoordinates->Lines->Add("Z4=0.0");
        mmCoordinates->Lines->Add("");
      }
  case
    2:
      {
        mmCoordinates->Lines->Add("Radius=100.0");
        mmCoordinates->Lines->Add("Center");
        mmCoordinates->Lines->Add("X=300.0");
        mmCoordinates->Lines->Add("Y=300.0");
        mmCoordinates->Lines->Add("Z=0.0");
      }
  case
    3:
      {
        mmCoordinates->Lines->Add("Name=L1");
        mmCoordinates->Lines->Add("LTypeName=HIDDEN");
        mmCoordinates->Lines->Add("Collumns count=10");
      }
  }

}
//---------------------------------------------------------------------------

void __fastcall TfmCreateEntity::bntColorClick(TObject *Sender)
{
  if (ColorDialog->Execute())
    pnlColor->Color = ColorDialog->Color;
}
//---------------------------------------------------------------------------


