//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fAddScaledFile.h"
#include "fMain.h"
#include <Graphics.hpp>

#include <DXFConv.hpp>
#include <sgConsts.hpp>
#include <DXFImage.hpp>
#ifndef sgDXFONLY
#include <DWG.hpp>
#include <HPGL2.hpp>
#include <SVG.hpp>
#include <CGM.hpp>
#endif

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CSPIN"
#pragma link "cspin"
#pragma resource "*.dfm"
TfmAddScaledFile *fmAddScaledFile;
//---------------------------------------------------------------------------
__fastcall TfmAddScaledFile::TfmAddScaledFile(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TfmAddScaledFile::SetImage(TsgDXFImage * value)
{
  FCADFile = value;
}

TsgDXFImage * __fastcall TfmAddScaledFile::GetImage()
{
  return FCADFile;
}

void __fastcall TfmAddScaledFile::SetFilesCount(int Value)
{
  FFilesCount = Value;
}

int __fastcall TfmAddScaledFile::GetFilesCount()
{
  return FFilesCount;
}

void __fastcall TfmAddScaledFile::ShowProp(TInsertProp * Prop)
{
  int I;
  FIsInternalChanging = true;
  AnsiString S;
  sePosX->Value = Ceil((double)(Prop->Position).X);
  sePosY->Value = Ceil((double)(Prop->Position).Y);
  sePosZ->Value = Ceil((double)(Prop->Position).Z);
  seScaleX->Value = Ceil((double)(Prop->Scale).X * 100.0);
  seScaleY->Value = Ceil((double)(Prop->Scale).Y * 100.0);
  seScaleZ->Value = Ceil((double)(Prop->Scale).Z * 100.0);
  seRotation->Value = Ceil(Prop->Rotation);
  if ((cbAddedFiles->Items->Count > 0)&&(cbAddedFiles->ItemIndex != -1))
  {
    I = cbAddedFiles->ItemIndex;
    S = IntToStr(cbAddedFiles->ItemIndex) + ". " + ExtractFileName(Prop->FileName);
    cbAddedFiles->Items->Strings[cbAddedFiles->ItemIndex] = S;
    cbAddedFiles->Text = S;
    cbAddedFiles->ItemIndex = I;
  }
  FIsInternalChanging = false;
}

void __fastcall TfmAddScaledFile::PropToStruct(TInsertProp* P)
{
  PInsertProp Prop;
  P->Position.X = sePosX->Value*1.0;
  P->Position.Y = sePosY->Value*1.0;
  P->Position.Z = sePosZ->Value*1.0;
  P->Scale.X = seScaleX->Value / 100.0;
  P->Scale.Y = seScaleY->Value / 100.0;
  P->Scale.Z = seScaleZ->Value / 100.0;
  P->Rotation = seRotation->Value*1.0;
  if ((cbAddedFiles->Items->Count > 0) && (cbAddedFiles->ItemIndex != -1))
  {
    Prop = (TInsertProp *)(cbAddedFiles->Items->Objects[cbAddedFiles->ItemIndex]);
    P->FileName = Prop->FileName;
  }
}

void __fastcall TfmAddScaledFile::btnApplyDefaultClick(TObject *Sender)
{
  sePosX->Value = 0;
  sePosY->Value = 0;
  sePosZ->Value = 0;
  seScaleX->Value = 100;
  seScaleY->Value = 100;
  seScaleZ->Value = 100;
	seRotation->Value = 0;
}

void __fastcall TfmAddScaledFile::btnOkClick(TObject *Sender)
{
	AnsiString ExtsLine = "1.dxf2.dwg3.plt3.hg3.hgl3.rtl3.plo2.hp3.hp13.hp23.hpg3.hpgl3.hpgl23.gl23.prn3.spl4.svg4.svgz5.cgm";

	int I, vPos;
	PInsertProp P;
	AnsiString S;
	TsgDXFImage *vCADFile;

	try
	{
		FCADFile->ColorToLineWeight->Assign(fmMain->memColorToLineWeight->Lines);
		if (cbAddedFiles->Items->Count > 0)
		{
			FCADFile->IsWithoutBorder = cbWithoutBorder->Checked;
			for(I = 0; I <= cbAddedFiles->Items->Count - 1; I++)
			{
				P = (TInsertProp *)(cbAddedFiles->Items->Objects[I]);
				vCADFile = NULL;
				vPos = AnsiPos(ExtractFileExt(P->FileName), ExtsLine);
				if (vPos > 1)
				{
					switch (ExtsLine[vPos-1]){
						case '1':
							vCADFile = new TsgDXFImage;
							break;
						case '2':
							vCADFile = new TsgDWGImage;
							break;
						case '3':
							vCADFile = new TsgHPGLImage;
							break;
						case '4':
							vCADFile = new TsgSVGImage;
							break;
						case '5':
							vCADFile = new TsgCGMImage;
							break;
					}
					if (vCADFile)
					{
						vCADFile->LoadFromFile(P->FileName);
						vCADFile->IsWithoutBorder = true;
						vCADFile->GetExtents();
						S = ChangeFileExt(ExtractFileName(P->FileName), "");
						FCADFile->AddScaledDXF(vCADFile, S, P->Position, P->Scale,
							P->Rotation);
					}
				}
			}
		}
	}
  __finally
  {
    FCADFile->GetExtents();
    Close();
  }
}

void __fastcall TfmAddScaledFile::sePropsChange(TObject *Sender)
{
  TInsertProp *P;
  TCSpinEdit *se;
  se = (TCSpinEdit *)Sender;
  if ((!FIsInternalChanging)&&(cbAddedFiles->ItemIndex >= 0)
     &&(se->Text != "")&&(cbAddedFiles->Items->Count > 0))
  {
    P = (PInsertProp)(cbAddedFiles->Items->Objects[cbAddedFiles->ItemIndex]);
    PropToStruct(P);
  }
}

void __fastcall TfmAddScaledFile::btnOpenFileClick(TObject *Sender)
{
  AnsiString S;

  OpenDialog->FileName = "";
  if (!OpenDialog->Execute()) return;
  TInsertProp *P = new TInsertProp;
  PropToStruct(P);
  P->FileName = OpenDialog->FileName;
  S = IntToStr(FFilesCount)+". "+ExtractFileName(P->FileName);
  cbAddedFiles->Items->Add(S);
  cbAddedFiles->Items->Objects[cbAddedFiles->Items->Count - 1] = (TObject *)P;
  cbAddedFiles->ItemIndex = cbAddedFiles->Items->Count - 1;
  cbAddedFilesChange(Sender);
  FFilesCount++;
  lblCountWasAdded->Caption = IntToStr(FFilesCount);
  cbWithoutBorder->Enabled = false;
}

void __fastcall TfmAddScaledFile::cbAddedFilesChange(TObject *Sender)
{
  PInsertProp P;
  if ((cbAddedFiles->ItemIndex >= 0)&&(cbAddedFiles->Items->Count > 0))
  {
    P = (PInsertProp)(cbAddedFiles->Items->Objects[cbAddedFiles->ItemIndex]);
    ShowProp(P);
  }
}

void __fastcall TfmAddScaledFile::FormCreate(TObject *Sender)
{
  FCADFile = new TsgDXFImage;
  OpenDialog->Filter = GraphicFilter(__classid(TGraphic));
  FFilesCount = 0;
  FIsInternalChanging = false;
}

void __fastcall TfmAddScaledFile::FormDestroy(TObject *Sender)
{
  int I;
  PInsertProp P;
  for(I=0;I<=cbAddedFiles->Items->Count - 1;I++)
  {
    P = (TInsertProp *)(cbAddedFiles->Items->Objects[I]);
    if (!(P)) delete P;
  }
  FCADFile->Free();  
}
//---------------------------------------------------------------------------
