// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'DXFImage.pas' rev: 5.00

#ifndef DXFImageHPP
#define DXFImageHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <sgSelection.hpp>	// Pascal unit
#include <sgBitmap.hpp>	// Pascal unit
#include <TTF.hpp>	// Pascal unit
#include <sgConsts.hpp>	// Pascal unit
#include <SGLines.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <SHX.hpp>	// Pascal unit
#include <Extrusion.hpp>	// Pascal unit
#include <DXFConv.hpp>	// Pascal unit
#include <MVFont.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Dxfimage
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TsgDXFDrawMode { dmNormal, dmBlack, dmGray };
#pragma option pop

#pragma option push -b-
enum TsgDXFViewDirection { vdDefault, vdTop, vdBottom, vdLeft, vdRight, vdFront, vdBack, vdSWIsometric, 
	vdSEIsometric, vdNWIsometric, vdNEIsometric };
#pragma option pop

typedef Shx::TsgSHXFontList* __fastcall (__closure *TsgSHXFontsProc)(void);

typedef Sgselection::TsgSelectionMode __fastcall (__closure *TsgGetSelectionMatrixModeProc)(void);

typedef void __fastcall (__closure *TsgSetSelectionMatrixModeProc)(const Sgselection::TsgSelectionMode 
	AMode);

struct TScaling
{
	Sgconsts::TFPoint Offset;
	Sgconsts::TFPoint Scale;
	int DX;
	int DY;
} ;

struct TsgCanvasParams;
typedef TsgCanvasParams *PsgCanvasParams;

struct TsgCanvasParams
{
	Graphics::TBrush* Brush;
	Graphics::TFont* Font;
	Graphics::TPen* Pen;
} ;

struct TsgViewPortCanvasParams;
typedef TsgViewPortCanvasParams *PsgViewPortCanvasParams;

struct TsgViewPortCanvasParams
{
	HDC HDC;
	TsgCanvasParams CanvasParams;
} ;

struct TsgCalcCoordsStruct
{
	Extended XScaled;
	Extended YScaled;
	double X;
	double Y;
	double Rot[4][3];
	Sgconsts::TFPoint RealLayoutCenter;
	int NullCoord;
} ;

struct TSnapData;
typedef TSnapData *PSnapData;

struct TSnapData
{
	bool IsSnapPoint;
	Dxfconv::TsgDXFEntity* Entity;
	Sgconsts::TObjectSnapMode SnapMode;
	Sgconsts::TFPoint CADPoint;
	Sgconsts::TFPoint CADPointInUCS;
} ;

#pragma option push -b-
enum TsgDistanceUnits { duNone, duInch, duMM };
#pragma option pop

#pragma option push -b-
enum TsgAngularUnits { auNone };
#pragma option pop

#pragma pack(push, 1)
struct TsgMeasurement
{
	TsgDistanceUnits DistanceUnits;
	TsgAngularUnits AngularUnits;
} ;
#pragma pack(pop)

typedef TMetaClass*TsgDXFImageClass;

typedef DynamicArray<void * >  DXFImage__2;

typedef DynamicArray<DynamicArray<void * > >  DXFImage__3;

class DELPHICLASS TsgDXFImage;
class PASCALIMPLEMENTATION TsgDXFImage : public Graphics::TGraphic 
{
	typedef Graphics::TGraphic inherited;
	
private:
	float FAngleDefault;
	Graphics::TColor FBackgroundColor;
	double FBorderSize;
	Sgconsts::TsgBorderType FBorderType;
	TsgCanvasParams FCanvasParams;
	Word FCBFormat;
	Sgconsts::TFPoint FCenter;
	Graphics::TFontCharset FCharset;
	Sgconsts::TFRect *FClippingRect;
	Classes::TStringList* FColorToLineWeight;
	Dxfconv::TsgDXFConverter* FConverter;
	bool FConverting;
	Dxfconv::TsgDXFLayout* FCurrentLayout;
	Classes::TList* FCounts;
	Graphics::TColor FDefaultColor;
	bool FDimensionsVisible;
	Sgconsts::TFRect FDrawingBox;
	TsgDXFDrawMode FDrawMode;
	double FDX;
	double FDY;
	bool FExportToDXFMode;
	Sgconsts::TFRect FExtents;
	AnsiString FFileInfo;
	int FIndex;
	Classes::TList* FIntPoints;
	Windows::TPoint FIPoints[8];
	Windows::TRect FIRect;
	bool FIsDraw3DAxes;
	bool FIsPlotting;
	bool FIsProcessMessages;
	bool FIsShowBackground;
	bool FIsShowLineWeight;
	bool FIsWithoutBorder;
	int FLast;
	bool FLineScaled;
	bool FLibraryGDIPlusExists;
	double FLScale;
	int FMillimetres;
	double FmmToPixelX;
	AnsiString FMsg;
	int FNullWidth;
	Classes::TNotifyEvent FOnLayoutChange;
	Classes::TNotifyEvent FOnLayoutBeforeChange;
	Dxfconv::TsgDXFInsert* FOnInsert;
	bool FOnInsertMode;
	Classes::TList* FPoly;
	Sgconsts::TFRect FPureExtents;
	bool FReady;
	double FZRotate;
	Sgselection::TsgSelectionMode FSelectionMatrixMode;
	Sgconsts::TFPoint FScale;
	Sgconsts::TObjectSnapMode FCurrSnapMode;
	Sgconsts::TObjectSnapMode FObjectSnapMode;
	Dxfconv::TsgDXFEntity* FSnapEntity;
	DynamicArray<DynamicArray<void * > >  FSnapMatrix;
	bool FSnapOnlyIterate;
	bool FStoreSnapOnlyIterate;
	Dxfconv::TsgDXFInsert* FStoreInsert;
	bool FStretch;
	bool FUseWinEllipse;
	bool FShowImages;
	TsgViewPortCanvasParams *FViewPortCanvasParams;
	HRGN FViewPortRegion;
	HRGN FClipRegion;
	Windows::TPoint FVisibleArea;
	Sgconsts::TFPoint FVPortDefault;
	double FXMax;
	double FXMin;
	double FYMax;
	double FYMin;
	double FZMax;
	double FZMin;
	double FZoom;
	Sgconsts::TFRect FViewRectangle;
	double FLineWeightScale;
	bool FResizeDisproportionateDrawing;
	bool FTextVisible;
	double FXDisproportionateShift;
	double FYDisproportionateShift;
	TsgSHXFontsProc FSHXFontsProc;
	TsgGetSelectionMatrixModeProc FGetSelectionMatrixModeProc;
	TsgSetSelectionMatrixModeProc FSetSelectionMatrixModeProc;
	void __fastcall ApplyBrush(void);
	void __fastcall ApplyPen(System::TObject* Sender);
	void __fastcall ApplyScale(int AWidth, int AHeight);
	void __fastcall ApplyText(void);
	void __fastcall BeginRead(System::TObject* Sender);
	void __fastcall BoxPoint(const Sgconsts::TFPoint &P);
	bool __fastcall CalcCADCoordsParameters(TsgCalcCoordsStruct &AStruct);
	bool __fastcall CoordinateBorderCorrect(Extended &AXScaled, Extended &AYScaled);
	void __fastcall DoProgress(Graphics::TProgressStage Stage);
	void __fastcall DoRead(System::TObject* Sender);
	void __fastcall DrawArc(System::TObject* Sender);
	void __fastcall DrawCircle(System::TObject* Sender);
	void __fastcall DrawFace(System::TObject* Sender);
	void __fastcall DrawHatch(System::TObject* Sender);
	int __fastcall DrawInsert(System::TObject* Sender);
	int __fastcall DrawDimension(System::TObject* Sender);
	void __fastcall DrawLeader(System::TObject* Sender);
	void __fastcall DrawLine(System::TObject* Sender);
	void __fastcall DrawPoint(System::TObject* Sender);
	void __fastcall DrawPoly(System::TObject* Sender);
	void __fastcall DrawACISEntity(System::TObject* Sender);
	void __fastcall DrawSpline(System::TObject* Sender);
	void __fastcall DrawSolid(System::TObject* Sender);
	void __fastcall DrawText(System::TObject* Sender);
	void __fastcall DrawViewPort(System::TObject* Sender);
	void __fastcall DrawImage(System::TObject* Sender);
	void __fastcall DrawFlatPoly(System::TObject* Sender);
	void __fastcall DrawFlatHatch(System::TObject* Sender);
	void __fastcall DrawOle2Frame(System::TObject* Sender);
	void __fastcall DrawPointsListByPolyline(const System::TObject* AObj, const Classes::TList* DottedSingPts
		);
	void __fastcall DrawPointsListByPolyPolyline(const System::TObject* AObj, const Classes::TList* DottedSingPts
		);
	void __fastcall DrawXRef(System::TObject* Sender);
	void __fastcall EndRead(System::TObject* Sender);
	void __fastcall EnterInsert(System::TObject* Sender);
	void __fastcall EnterViewport(System::TObject* Sender);
	void __fastcall EnterXRef(System::TObject* Sender);
	void __fastcall FillFromFlat(Dxfconv::TsgFlatEntity* FP);
	Dxfconv::TsgDXFBlock* __fastcall GetBlock(int Index);
	Dxfconv::TsgDXFEntity* __fastcall GetEntity(int Index);
	bool __fastcall GetIs3D(void);
	bool __fastcall GetIsLoading(void);
	bool __fastcall GetIsDrawingRotated(void);
	Dxfconv::TsgDXFLayout* __fastcall GetLayout(int Index);
	int __fastcall GetLayoutsCount(void);
	double __fastcall GetLineWeightScale(void);
	Sgconsts::TFPoint __fastcall GetScale(void);
	bool __fastcall GetOwnSource(void);
	Shx::TsgSHXFontList* __fastcall GetSHXFontsProc(void);
	Sgselection::TsgSelectionMode __fastcall GetSelectionMatrixProc(void);
	void __fastcall ResetExtents(void);
	void __fastcall SetBackgroundColor(Graphics::TColor Value);
	void __fastcall SetCharset(Graphics::TFontCharset Value);
	void __fastcall SetDefaultColor(Graphics::TColor Value);
	void __fastcall SetDrawingBox(const Sgconsts::TFRect &ABox);
	void __fastcall SetDrawMode(TsgDXFDrawMode Value);
	void __fastcall SetIs3D(bool Value);
	void __fastcall SetIsShowBackground(bool Value);
	void __fastcall SetIsShowLineWeight(bool Value);
	void __fastcall SetIsWithoutBorder(bool Value);
	void __fastcall SetLineScaled(bool Value);
	void __fastcall SetSelectionMatrixProc(const Sgselection::TsgSelectionMode AMode);
	void __fastcall SetStretch(bool Value);
	void __fastcall SetLineWeightScale(const double Value);
	void __fastcall SetUseWinEllipse(bool Value);
	void __fastcall SetShowImages(bool Value);
	void __fastcall SetDimensionsVisible(bool AVisible);
	void __fastcall SetTextVisible(bool AVisible);
	void __fastcall SetOwnSource(bool Value);
	void __fastcall SetClip(Dxfconv::TsgCADClipInsert* AInsert);
	void __fastcall DrawEntityOnSnapMatrix(Dxfconv::TsgDXFEntity* Entity);
	bool __fastcall IsIndexInArray(const Windows::TPoint &Pt);
	void __fastcall SetupSnapMatrix(void);
	void __fastcall SetPixelSnap(const Sgconsts::TFPoint &APt);
	
protected:
	Graphics::TCanvas* FCanvas;
	Dxfconv::TsgCADIterate FDraw;
	Byte FExtPenFlag;
	void __fastcall AddSelectionMatrix(const void * APointer);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall ClearMatrices(const Windows::TRect &ARect);
	virtual Dxfconv::TsgDXFConverter* __fastcall CreateConverter(void);
	virtual int __fastcall DoDraw(Dxfconv::TsgDXFEntity* Entity);
	virtual int __fastcall DoFinish(Dxfconv::TsgDXFEntity* Entity);
	void __fastcall Draw3DAxes(void);
	virtual void __fastcall Draw(Graphics::TCanvas* Canvas, const Windows::TRect &Rect);
	int __fastcall DrawEntity(Dxfconv::TsgDXFEntity* Entity);
	void __fastcall EntityCreated(System::TObject* Sender);
	virtual void __fastcall FillBoxForCoordsCalc(int ACoord, Sgconsts::TFRect &ABox);
	bool __fastcall IsDrawOnBitMap(void);
	bool __fastcall IsDrawOnCanvas(void);
	virtual bool __fastcall GetEmpty(void);
	Sgconsts::TFPoint __fastcall GetFPoint(const Sgconsts::TFPoint &P);
	virtual int __fastcall GetHeight(void);
	virtual double __fastcall GetLineScale(void);
	int __fastcall GetLineWeight(const double AWeight);
	virtual bool __fastcall GetMillimetres(void);
	virtual HPALETTE __fastcall GetPalette(void);
	Windows::TRect __fastcall GetRect(const Sgconsts::TFRect &ARect);
	double __fastcall GetRealImageMatrix(void);
	virtual int __fastcall GetWidth(void);
	DYNAMIC void __fastcall Progress(System::TObject* Sender, Graphics::TProgressStage Stage, Byte PercentDone
		, bool RedrawNow, const Windows::TRect &R, const AnsiString Msg);
	void __fastcall SetCurrentLayout(const Dxfconv::TsgDXFLayout* ALayout);
	void __fastcall SetDefaultViewPort(Dxfconv::TsgDXFConverter* AConverter);
	void __fastcall SetEntityVisibility(System::TObject* ACADFile);
	virtual void __fastcall SetExtentsParameters(const Sgconsts::TFRect &ARect, const bool AIs3DExtents
		);
	void __fastcall SetOnInsertMode(const Dxfconv::TsgDXFInsert* AIns);
	virtual void __fastcall SetHeight(int Value);
	virtual void __fastcall SetMatrix(void);
	virtual void __fastcall SetMillimetres(bool Value);
	virtual void __fastcall SetWidth(int Value);
	void __fastcall TransformToUCS(Sgconsts::TFPoint &APoint);
	void __fastcall TransformToWorldCS(Sgconsts::TFPoint &APoint);
	__property Graphics::TColor FColor = {read=FDraw.Color, write=FDraw.Color, nodefault};
	__property float FHCoef = {read=FDraw.YScale, write=FDraw.YScale};
	__property float FAngle = {read=FDraw.Angle, write=FDraw.Angle};
	__property AnsiString FileInfo = {read=FFileInfo, write=FFileInfo};
	__property Classes::TNotifyEvent OnLayoutBeforeChange = {read=FOnLayoutBeforeChange, write=FOnLayoutBeforeChange
		};
	__property bool LibraryGDIPlusExists = {read=FLibraryGDIPlusExists, write=FLibraryGDIPlusExists, nodefault
		};
	__property TsgSHXFontsProc SHXFontsProc = {read=FSHXFontsProc};
	__property TsgGetSelectionMatrixModeProc GetMatrixMode = {read=FGetSelectionMatrixModeProc};
	__property TsgSetSelectionMatrixModeProc SetMatrixMode = {read=FSetSelectionMatrixModeProc};
	
public:
	__fastcall virtual TsgDXFImage(void);
	__fastcall virtual ~TsgDXFImage(void);
	Extended __fastcall AbsHeight(void);
	Extended __fastcall AbsWidth(void);
	void __fastcall AddScaledDXF(System::TObject* ACADFile, AnsiString AName, const Sgconsts::TFPoint &
		APos, const Sgconsts::TFPoint &AScale, float Rotation);
	Dxfconv::TsgDXFInsert* __fastcall AddScaledDXFEx(System::TObject* ACADFile, AnsiString AName, const 
		Sgconsts::TFPoint &APos, const Sgconsts::TFPoint &AScale, float Rotation);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual Sgconsts::TFPoint __fastcall CommonToInternalUnits(const Sgconsts::TFPoint &Pt);
	void __fastcall ExportToMetafile(const AnsiString FileName, int AWidth, int AHeight)/* overload */;
		
	Graphics::TMetafile* __fastcall ExportToMetafile(int AWidth, int AHeight)/* overload */;
	Graphics::TMetafile* __fastcall ExportToMetafile(int MaxDim)/* overload */;
	Graphics::TMetafile* __fastcall ExportToMetafile(double &OffsetX, double &OffsetY, double &UnitSize
		)/* overload */;
	void __fastcall DrawRect(HDC DC, const Sgconsts::TFRect &SourceRect, const Windows::TRect &DestRect
		);
	void __fastcall GetExtents(void);
	Sgconsts::TFPoint __fastcall GetCADCoords(const Extended AXScaled, const Extended AYScaled)/* overload */
		;
	Sgconsts::TFPoint __fastcall GetCADCoords(const Extended AXScaled, const Extended AYScaled, Sgconsts::TFPoint 
		&CoordsInUCS)/* overload */;
	virtual Graphics::TColor __fastcall GetEntityColor(Dxfconv::TsgDXFEntity* AEntity, Dxfconv::TsgDXFInsert* 
		AInsert);
	Windows::TPoint __fastcall GetPoint(const Sgconsts::TFPoint &P);
	Windows::TPoint __fastcall GetPointUCS(const Sgconsts::TFPoint &P);
	Sgconsts::TFPoint __fastcall GetRealImagePoint(const Sgconsts::TFPoint &P);
	PSnapData __fastcall GetSnapData(const Windows::TPoint &P);
	Sgconsts::TObjectSnapMode __fastcall GetObjectSnapMode(void);
	void __fastcall SetObjectSnapMode(Sgconsts::TObjectSnapMode AValue);
	int __fastcall HeadVarAsInteger(const AnsiString AName, int ACode);
	Extended __fastcall HeadVarAsFloat(const AnsiString AName, int ACode);
	AnsiString __fastcall HeadVarAsstring(const AnsiString AName, int ACode);
	virtual Sgconsts::TFPoint __fastcall InternalToCommonUnits(const Sgconsts::TFPoint &Pt);
	virtual void __fastcall LoadFromClipboardFormat(Word Fmt, unsigned Data, HPALETTE Pal);
	virtual void __fastcall LoadFromFile(const AnsiString FileName);
	virtual void __fastcall LoadFromStream(Classes::TStream* S);
	virtual TsgMeasurement __fastcall Measurement(void);
	void __fastcall RefreshCurrentLayout(void);
	void __fastcall ResetDrawingBox(void);
	void __fastcall Rotate(Sgconsts::TsgAxes Axis, Extended Angle);
	void __fastcall RotDefault(void);
	void __fastcall RotToView(const TsgDXFViewDirection A3DView);
	virtual void __fastcall SaveToClipboardFormat(Word &Fmt, unsigned &Data, HPALETTE &Pal);
	virtual void __fastcall SaveToFile(const AnsiString FileName);
	virtual void __fastcall SaveToStream(Classes::TStream* S);
	void __fastcall SetClippingRect(Sgconsts::PFRect Value);
	void __fastcall SetVisibleArea(const Windows::TPoint &Data);
	virtual void __fastcall StopLoading(void);
	__property Graphics::TColor BackgroundColor = {read=FBackgroundColor, write=SetBackgroundColor, nodefault
		};
	__property Dxfconv::TsgDXFBlock* Blocks[int Index] = {read=GetBlock};
	__property double BorderSize = {read=FBorderSize, write=FBorderSize};
	__property Sgconsts::TsgBorderType BorderType = {read=FBorderType, write=FBorderType, nodefault};
	__property Word CBFormat = {read=FCBFormat, write=FCBFormat, nodefault};
	__property Graphics::TFontCharset Charset = {read=FCharset, write=SetCharset, nodefault};
	__property Sgconsts::PFRect ClippingRect = {read=FClippingRect, write=SetClippingRect};
	__property Classes::TStringList* ColorToLineWeight = {read=FColorToLineWeight};
	__property Dxfconv::TsgDXFConverter* Converter = {read=FConverter};
	__property Dxfconv::TsgDXFLayout* CurrentLayout = {read=FCurrentLayout, write=SetCurrentLayout};
	__property Graphics::TColor DefaultColor = {read=FDefaultColor, write=SetDefaultColor, nodefault};
	__property Sgconsts::TFRect DrawingBox = {read=FDrawingBox, write=SetDrawingBox};
	__property TsgDXFDrawMode DrawMode = {read=FDrawMode, write=SetDrawMode, nodefault};
	__property Dxfconv::TsgDXFEntity* Entities[int Index] = {read=GetEntity};
	__property Sgconsts::TFRect Extents = {read=FExtents, write=FExtents};
	__property bool Is3D = {read=GetIs3D, write=SetIs3D, nodefault};
	__property bool IsDraw3DAxes = {read=FIsDraw3DAxes, write=FIsDraw3DAxes, nodefault};
	__property bool IsLoading = {read=GetIsLoading, nodefault};
	__property bool IsPlotting = {read=FIsPlotting, write=FIsPlotting, nodefault};
	__property bool IsProcessMessages = {read=FIsProcessMessages, write=FIsProcessMessages, nodefault};
		
	__property bool IsDrawingRotated = {read=GetIsDrawingRotated, nodefault};
	__property bool IsShowBackground = {read=FIsShowBackground, write=SetIsShowBackground, nodefault};
	__property bool IsShowLineWeight = {read=FIsShowLineWeight, write=SetIsShowLineWeight, nodefault};
	__property bool IsWithoutBorder = {read=FIsWithoutBorder, write=SetIsWithoutBorder, nodefault};
	__property Dxfconv::TsgDXFLayout* Layouts[int Index] = {read=GetLayout};
	__property int LayoutsCount = {read=GetLayoutsCount, nodefault};
	__property bool LineScaled = {read=FLineScaled, write=SetLineScaled, nodefault};
	__property double LineWeightScale = {read=GetLineWeightScale, write=SetLineWeightScale};
	__property bool Millimetres = {read=GetMillimetres, write=SetMillimetres, nodefault};
	__property int NullWidth = {read=FNullWidth, write=FNullWidth, nodefault};
	__property Classes::TNotifyEvent OnLayoutChange = {read=FOnLayoutChange, write=FOnLayoutChange};
	__property Sgconsts::TFRect PureExtents = {read=FPureExtents};
	__property bool ResizeDisproportionateDrawing = {read=FResizeDisproportionateDrawing, write=FResizeDisproportionateDrawing
		, nodefault};
	__property bool ShowImages = {read=FShowImages, write=SetShowImages, nodefault};
	__property Sgconsts::TFPoint Scale = {read=GetScale};
	__property bool Stretch = {read=FStretch, write=SetStretch, nodefault};
	__property bool UseWinEllipse = {read=FUseWinEllipse, write=SetUseWinEllipse, nodefault};
	__property Sgconsts::TFRect ViewRectangle = {read=FViewRectangle, write=FViewRectangle};
	__property bool DimensionsVisible = {read=FDimensionsVisible, write=SetDimensionsVisible, nodefault
		};
	__property bool TextVisible = {read=FTextVisible, write=SetTextVisible, nodefault};
	__property bool OwnSource = {read=GetOwnSource, write=SetOwnSource, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE Word CF_DXF;
extern PACKAGE TsgDXFImage* Drawing;
extern PACKAGE int MinDXFSize;
extern PACKAGE TsgDXFImage* Loading;
extern PACKAGE void __fastcall RotatePicture(Graphics::TPicture* Picture, double Angle, Graphics::TColor 
	BackColor);
extern PACKAGE void __fastcall RotateBitmap(Graphics::TBitmap* Bitmap, double Angle, Graphics::TColor 
	BackColor);

}	/* namespace Dxfimage */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Dxfimage;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// DXFImage
