// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'DXFExport.pas' rev: 5.00

#ifndef DXFExportHPP
#define DXFExportHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Dialogs.hpp>	// Pascal unit
#include <sgConsts.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Dxfexport
{
//-- type declarations -------------------------------------------------------
typedef Sgconsts::TFPoint *PexpPoint;

typedef Sgconsts::TFPoint  TexpPoint;

struct TLine;
typedef TLine *PLine;

struct TLine
{
	int x1;
	int y1;
	int x2;
	int y2;
} ;

struct TRectangle;
typedef TRectangle *PRectangle;

struct TRectangle
{
	int X1;
	int Y1;
	int X2;
	int Y2;
} ;

#pragma option push -b-
enum TsgArcType { atCircle, atEllipse };
#pragma option pop

#pragma option push -b-
enum TsgAutoCADVersion { R14, R2000 };
#pragma option pop

#pragma option push -b-
enum TsgDimensionArrowType { datClosedFilled, datClosedBlank, datClosed, datDot, datArchitecturalTick, 
	datOblique, datOpen, datOrigin, datOrigin2, datRightAngle, datOpen30, datDotSmall, datDotBlank, datDotSmallBlank, 
	datBox, datBoxFilled, datDatumTriangle, datIntegral, datUserArrow, datNone };
#pragma option pop

#pragma option push -b-
enum TsgDimensionType { dtRotated, dtAligned, dtAngular, dtDiameter, dtRadius, dtAngular3Point, dtOrdinate 
	};
#pragma option pop

struct TsgDimensionStyle;
typedef TsgDimensionStyle *PsgDimensionStyle;

struct TsgDimensionStyle
{
	TsgDimensionArrowType Arrow1;
	TsgDimensionArrowType Arrow2;
	int ArrowBlock1;
	int ArrowBlock2;
	float ArrowSize;
	float ExtLineExt;
	float ExtLineOffset;
	float TextHeight;
	float TextOffset;
} ;

#pragma option push -b-
enum TsgHatchBoundaryType { hbtPolyPolyline, hbtSpline, hbtCircle, hbtEllipse };
#pragma option pop

#pragma option push -b-
enum TsgHatchIslandDetectionStyle { hidsNormal, hidsOuter, hidsIgnore };
#pragma option pop

#pragma option push -b-
enum TsgHatchPatternType { hptUserDefined, hptPredefined, hptCustom };
#pragma option pop

struct TdxfHatchPatternData;
typedef TdxfHatchPatternData *PdxfHatchPatternData;

struct TdxfHatchPatternData
{
	float Angle;
	float BasePointX;
	float BasePointY;
	float OffsetX;
	float OffsetY;
	int NumOfDashLengts;
	Classes::TList* DashLengths;
} ;

typedef Set<Graphics::TPenStyle, psSolid, psInsideFrame>  TPenStyles;

struct TdxfExportData;
typedef TdxfExportData *PdxfExportData;

#pragma pack(push, 1)
struct TdxfExportData
{
	Word Tag;
	Word Count;
	Byte Flags;
	Byte Style;
	Byte SelfType;
	int Color;
	void *StyleObject;
	float Thickness;
	float Rotation;
	float GlobalWidth;
	AnsiString Text;
	Sgconsts::TFPoint Point;
	Sgconsts::TFPoint Point1;
	Sgconsts::TFPoint Point2;
	Sgconsts::TFPoint Point3;
	union
	{
		struct 
		{
			Byte Bold;
			Byte Italic;
			char *FName;
			
		};
		struct 
		{
			Classes::TList* Points;
			
		};
		struct 
		{
			Byte HAlign;
			Byte VAlign;
			float RWidth;
			float RHeight;
			float FHeight;
			float FScale;
			
		};
		struct 
		{
			unsigned Block;
			Sgconsts::TFPoint Scale;
			
		};
		struct 
		{
			float Radius;
			float StartAngle;
			float EndAngle;
			
		};
		
	};
} ;
#pragma pack(pop)

class DELPHICLASS TsgGDI;
class PASCALIMPLEMENTATION TsgGDI : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	__fastcall virtual TsgGDI(void * P);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgGDI(void) { }
	#pragma option pop
	
};


typedef TMetaClass*TsgGDIClass;

class DELPHICLASS TsgFont;
class PASCALIMPLEMENTATION TsgFont : public TsgGDI 
{
	typedef TsgGDI inherited;
	
private:
	AnsiString FName;
	int FHeight;
	int FWidth;
	int FEscapement;
	bool FBold;
	bool FItalic;
	bool FUnderline;
	double __fastcall GetOffsetX(void);
	double __fastcall GetOffsetY(void);
	
public:
	__fastcall virtual TsgFont(void * P);
	__property double OffsetX = {read=GetOffsetX};
	__property double OffsetY = {read=GetOffsetY};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgFont(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgPen;
class PASCALIMPLEMENTATION TsgPen : public TsgGDI 
{
	typedef TsgGDI inherited;
	
private:
	int FColor;
	int FWidth;
	Graphics::TPenStyle FStyle;
	
public:
	__fastcall virtual TsgPen(void * P);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgPen(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExtPen;
class PASCALIMPLEMENTATION TsgExtPen : public TsgPen 
{
	typedef TsgPen inherited;
	
public:
	__fastcall virtual TsgExtPen(void * P);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExtPen(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgBrush;
class PASCALIMPLEMENTATION TsgBrush : public TsgGDI 
{
	typedef TsgGDI inherited;
	
private:
	int FColor;
	Sgconsts::TsgHatchStyle FHatchStyle;
	
public:
	__fastcall virtual TsgBrush(void * P);
	__property Sgconsts::TsgHatchStyle HatchStyle = {read=FHatchStyle, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgBrush(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFFigure;
class DELPHICLASS TsgDXFExport;
class PASCALIMPLEMENTATION TsgExpDXFFigure : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FLayer;
	int __fastcall GetColor(void);
	void __fastcall SetLayer(const AnsiString Value);
	
protected:
	#pragma pack(push, 1)
	TdxfExportData FData;
	#pragma pack(pop)
	
	virtual void __fastcall ParseToLines(Classes::TList* NewElemes);
	virtual bool __fastcall IntersecRect(const TRectangle &ARect);
	
public:
	virtual void __fastcall ExportBlockAsDXF(TsgDXFExport* ADXFExport);
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport) = 0 ;
	__fastcall virtual TsgExpDXFFigure(const TdxfExportData &AData);
	__property int Color = {read=GetColor, nodefault};
	__property AnsiString Layer = {read=FLayer, write=SetLayer};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFFigure(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgRegion;
class DELPHICLASS TsgMetafile;
class PASCALIMPLEMENTATION TsgMetafile : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	HDC FHDC;
	unsigned FAlign;
	TsgBrush* FBrush;
	Graphics::TCanvas* FCanvas;
	TsgRegion* FClipRgn;
	#pragma pack(push, 1)
	TdxfExportData FData;
	#pragma pack(pop)
	
	TsgPen* FDfltPen;
	TsgBrush* FDfltBrush;
	#pragma pack(push, 1)
	tagXFORM FEXForm;
	#pragma pack(pop)
	
	TsgFont* FFont;
	unsigned FMapMode;
	float FMapModeKoef;
	Classes::TList* FObjects;
	TsgDXFExport* FOwner;
	TsgPen* FPen;
	Windows::TPoint FPenPos;
	double FMetafileXRatio;
	Classes::TList* FSavedDCStatus;
	TPenStyles FStyles;
	AnsiString FText;
	int FTextColor;
	tagSIZE FViewExt;
	Windows::TPoint FViewOrg;
	tagSIZE FWinExt;
	Windows::TPoint FWinOrg;
	#pragma pack(push, 1)
	tagXFORM FXForm;
	#pragma pack(pop)
	
	bool __fastcall FUpdateCP(void);
	Windows::TPoint __fastcall GetPoint(const Windows::TPoint &APt);
	Windows::TRect __fastcall GetRect(const Windows::TRect &ARct);
	int __fastcall GetSignYExt(void);
	bool __fastcall SetCircle(const Windows::TRect &R);
	void __fastcall Arc(Windows::PEMRArc P, bool Move);
	void __fastcall AngleArc(Windows::PEMRAngleArc P);
	void __fastcall ClearData(void);
	void __fastcall CloseFigure(Windows::PAbortPath P);
	void __fastcall DeleteObject(void * P);
	void __fastcall DoInvertYPts(void);
	void __fastcall FillRGN(void * P);
	void __fastcall Ellipse(Windows::PEMREllipse P);
	void __fastcall ExtSelectClipRGN(void * P);
	void __fastcall IntersectClipRect(Windows::PEMRExcludeClipRect P);
	void __fastcall LineTo(Windows::PEMRLineTo P);
	void __fastcall ModifyWorldTransform(Windows::PEMRModifyWorldTransform P);
	void __fastcall MoveCP(void);
	void __fastcall MoveTo(Windows::PEMRLineTo P);
	void __fastcall NewGDI(TMetaClass* AClass, void * P);
	void __fastcall Pie(Windows::PEMRArc P);
	void __fastcall Polyline(void * P, const bool Is16, const bool IsBezier, const bool Move, const bool 
		Close);
	void __fastcall PolyPolyline(Windows::PEMRPolyPolyline16 P, bool Close);
	void __fastcall PtToDXF(const Windows::TPoint &P, Sgconsts::TFPoint &ADXFPt);
	void __fastcall Rectangle(Windows::PEMREllipse P);
	void __fastcall RestoreDC(Windows::PEMRRestoreDC P);
	void __fastcall RoundRect(Windows::PEMRRoundRect P);
	void __fastcall SaveDC(Windows::PAbortPath P);
	void __fastcall SelectObject(void * P);
	void __fastcall SetDataPts(void);
	void __fastcall SetDPtoLP(Windows::TPoint &ADevicePt);
	void __fastcall SetLPtoDP(Windows::TPoint &ALogPt);
	void __fastcall SetLType(Graphics::TPenStyle Style);
	void __fastcall SetMapMode(unsigned AMode);
	void __fastcall SetPen(void);
	void __fastcall SetPixel(Windows::PEMRSetPixelV P);
	void __fastcall SetPt(Sgconsts::TFPoint &APt);
	void __fastcall SetOnlyPt(Sgconsts::TFPoint &APt);
	void __fastcall SetTextAlign(Windows::PEMRSelectclippath P);
	void __fastcall SetWinExt(const tagSIZE &AExtent);
	void __fastcall SetViewExt(const tagSIZE &AExtent);
	void __fastcall SetWorldTransform(Windows::PEMRSetWorldTransform P);
	void __fastcall TextOut(Windows::PEMRExtTextOut P);
	
public:
	__fastcall TsgMetafile(TsgDXFExport* AOwner);
	__fastcall virtual ~TsgMetafile(void);
	void __fastcall ProcessMetafile(Graphics::TMetafile* Metafile);
	__property TsgDXFExport* Owner = {read=FOwner};
	__property tagXFORM XForm = {read=FXForm};
};


class PASCALIMPLEMENTATION TsgRegion : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Windows::TRect FBoundsRect;
	bool FIsClipping;
	HRGN FHRGN;
	TsgMetafile* FParentMetaFile;
	Classes::TList* FPoints;
	unsigned FRectCount;
	bool __fastcall GetIsRect(void);
	
public:
	__fastcall TsgRegion(TsgMetafile* AParentMetaFile);
	__fastcall virtual ~TsgRegion(void);
	void __fastcall Assign(TsgRegion* ASource);
	void __fastcall InitFromData(Windows::PRgnData APRgnData);
	void __fastcall InitFromRect(const Windows::TRect &ARect, TsgRegion* AOther);
	void __fastcall Clear(void);
	__property bool IsClipping = {read=FIsClipping, write=FIsClipping, nodefault};
	__property bool IsRect = {read=GetIsRect, nodefault};
	__property Classes::TList* Points = {read=FPoints};
};


class DELPHICLASS TsgExpDXFArc;
class PASCALIMPLEMENTATION TsgExpDXFArc : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
private:
	TsgArcType FType;
	float __fastcall GetEndAngle(void);
	Sgconsts::TFPoint __fastcall GetPoint(void);
	float __fastcall GetRadius(void);
	float __fastcall GetStartAngle(void);
	void __fastcall SetEndAngle(const float Value);
	void __fastcall SetPoint(const Sgconsts::TFPoint &Value);
	void __fastcall SetRadius(const float Value);
	void __fastcall SetStartAngle(const float Value);
	
protected:
	virtual bool __fastcall IntersecRect(const TRectangle &ARect);
	virtual void __fastcall ParseToLines(Classes::TList* NewElemes);
	
public:
	__fastcall virtual TsgExpDXFArc(const TdxfExportData &AData);
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
	__property Sgconsts::TFPoint Point = {read=GetPoint, write=SetPoint};
	__property float Radius = {read=GetRadius, write=SetRadius};
	__property float StartAngle = {read=GetStartAngle, write=SetStartAngle};
	__property float EndAngle = {read=GetEndAngle, write=SetEndAngle};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFArc(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFDimension;
class PASCALIMPLEMENTATION TsgExpDXFDimension : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
private:
	TsgDimensionType FType;
	TsgDimensionStyle FStyle;
	
public:
	__fastcall virtual TsgExpDXFDimension(const TdxfExportData &AData);
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFDimension(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFEllipse;
class PASCALIMPLEMENTATION TsgExpDXFEllipse : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
private:
	bool FEllipse;
	Sgconsts::TFPoint __fastcall GetLeftTop(void);
	Sgconsts::TFPoint __fastcall GetRightBottom(void);
	
protected:
	virtual bool __fastcall IntersecRect(const TRectangle &ARect);
	virtual void __fastcall ParseToLines(Classes::TList* NewElemes);
	
public:
	virtual void __fastcall ExportBlockAsDXF(TsgDXFExport* ADXFExport);
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
	__property Sgconsts::TFPoint LeftTop = {read=GetLeftTop};
	__fastcall TsgExpDXFEllipse(const TdxfExportData &AData, bool AEllipse);
	__property Sgconsts::TFPoint RightBottom = {read=GetRightBottom};
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFEllipse(const TdxfExportData &AData
		) : TsgExpDXFFigure(AData) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFEllipse(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFLine;
class PASCALIMPLEMENTATION TsgExpDXFLine : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
private:
	Sgconsts::TFPoint __fastcall GetEndPoint(void);
	Sgconsts::TFPoint __fastcall GetStartPoint(void);
	void __fastcall SetEndPoint(const Sgconsts::TFPoint &Value);
	void __fastcall SetStartPoint(const Sgconsts::TFPoint &Value);
	
public:
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
	__property Sgconsts::TFPoint StartPoint = {read=GetStartPoint, write=SetStartPoint};
	__property Sgconsts::TFPoint EndPoint = {read=GetEndPoint, write=SetEndPoint};
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFLine(const TdxfExportData &AData) : 
		TsgExpDXFFigure(AData) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFLine(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFBlock;
class PASCALIMPLEMENTATION TsgExpDXFBlock : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FName;
	int FBlockRecordHandle;
	Classes::TStringList* FContent;
	
public:
	__fastcall TsgExpDXFBlock(AnsiString AName, int ABlockRecordHandle);
	__fastcall virtual ~TsgExpDXFBlock(void);
};


class DELPHICLASS TsgExpDXFLayer;
class PASCALIMPLEMENTATION TsgExpDXFLayer : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	void __fastcall SetColor(const int Value);
	void __fastcall SetFlags(const Byte Value);
	void __fastcall SetLinetypeName(const AnsiString Value);
	void __fastcall SetLineWeight(const int Value);
	void __fastcall SetName(const AnsiString Value);
	
protected:
	AnsiString FName;
	AnsiString FLinetypeName;
	Byte FFlags;
	int FColor;
	int FLineWeight;
	
public:
	__fastcall TsgExpDXFLayer(AnsiString AName);
	void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
	__property AnsiString Name = {read=FName, write=SetName};
	__property Byte Flags = {read=FFlags, write=SetFlags, nodefault};
	__property int Color = {read=FColor, write=SetColor, nodefault};
	__property AnsiString LinetypeName = {read=FLinetypeName, write=SetLinetypeName};
	__property int LineWeight = {read=FLineWeight, write=SetLineWeight, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFLayer(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFTextStyle;
class PASCALIMPLEMENTATION TsgExpDXFTextStyle : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FName;
	int FFlag;
	float FFixedHeight;
	float FWidthFactor;
	float FObliqueAngle;
	int FGenerationFlags;
	float FLastHeightUsed;
	AnsiString FPrimaryFontName;
	AnsiString FBigFontName;
	
public:
	__fastcall TsgExpDXFTextStyle(AnsiString AName);
	void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
	__property AnsiString Name = {read=FName, write=FName};
	__property float WidthFactor = {read=FWidthFactor, write=FWidthFactor};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFTextStyle(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFPolyline;
class PASCALIMPLEMENTATION TsgExpDXFPolyline : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
private:
	Classes::TList* FList;
	int __fastcall GetPointCount(void);
	Sgconsts::TFPoint __fastcall GetPoint(int AIndex);
	
protected:
	Classes::TList* FPoints;
	virtual bool __fastcall IntersecRect(const TRectangle &ARect);
	virtual void __fastcall ParseToLines(Classes::TList* NewElemes);
	
public:
	void __fastcall Clear(void);
	void __fastcall ClearPoints(void);
	void __fastcall BeginPolygonFromRect(void);
	void __fastcall EndPolygonFromRect(void);
	void __fastcall AddRect(const Windows::TRect &ARect);
	__fastcall TsgExpDXFPolyline(const TdxfExportData &AData, int AIndex);
	__fastcall virtual ~TsgExpDXFPolyline(void);
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
	__property int PointCount = {read=GetPointCount, nodefault};
	__property Sgconsts::TFPoint Point[int AIndex] = {read=GetPoint};
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFPolyline(const TdxfExportData &AData
		) : TsgExpDXFFigure(AData) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFLeader;
class PASCALIMPLEMENTATION TsgExpDXFLeader : public TsgExpDXFPolyline 
{
	typedef TsgExpDXFPolyline inherited;
	
public:
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
public:
	#pragma option push -w-inl
	/* TsgExpDXFPolyline.CreateEx */ inline __fastcall TsgExpDXFLeader(const TdxfExportData &AData, int 
		AIndex) : TsgExpDXFPolyline(AData, AIndex) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgExpDXFPolyline.Destroy */ inline __fastcall virtual ~TsgExpDXFLeader(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFLeader(const TdxfExportData &AData)
		 : TsgExpDXFPolyline(AData) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFPolyBezier;
class PASCALIMPLEMENTATION TsgExpDXFPolyBezier : public TsgExpDXFPolyline 
{
	typedef TsgExpDXFPolyline inherited;
	
public:
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
public:
	#pragma option push -w-inl
	/* TsgExpDXFPolyline.CreateEx */ inline __fastcall TsgExpDXFPolyBezier(const TdxfExportData &AData, 
		int AIndex) : TsgExpDXFPolyline(AData, AIndex) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TsgExpDXFPolyline.Destroy */ inline __fastcall virtual ~TsgExpDXFPolyBezier(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFPolyBezier(const TdxfExportData &AData
		) : TsgExpDXFPolyline(AData) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFPixel;
class PASCALIMPLEMENTATION TsgExpDXFPixel : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
public:
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFPixel(const TdxfExportData &AData) : 
		TsgExpDXFFigure(AData) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFPixel(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFRectangle;
class PASCALIMPLEMENTATION TsgExpDXFRectangle : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
private:
	Sgconsts::TFPoint __fastcall GetLeftTop(void);
	void __fastcall SetLeftTop(const Sgconsts::TFPoint &Value);
	Sgconsts::TFPoint __fastcall GetRightBottom(void);
	void __fastcall SetRightBottom(const Sgconsts::TFPoint &Value);
	
protected:
	virtual bool __fastcall IntersecRect(const TRectangle &ARect);
	virtual void __fastcall ParseToLines(Classes::TList* NewElemes);
	
public:
	void __fastcall AddRect(const Windows::TRect &ARect);
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
	__property Sgconsts::TFPoint LeftTop = {read=GetLeftTop, write=SetLeftTop};
	__property Sgconsts::TFPoint RightBottom = {read=GetRightBottom, write=SetRightBottom};
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFRectangle(const TdxfExportData &AData
		) : TsgExpDXFFigure(AData) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFRectangle(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFText;
class PASCALIMPLEMENTATION TsgExpDXFText : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
public:
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFText(const TdxfExportData &AData) : 
		TsgExpDXFFigure(AData) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFText(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFMText;
class PASCALIMPLEMENTATION TsgExpDXFMText : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
protected:
	virtual bool __fastcall IntersecRect(const TRectangle &ARect);
	virtual void __fastcall ParseToLines(Classes::TList* NewElemes);
	void __fastcall ParseToTexts(const TRectangle &ARect, Classes::TList* NewElemes);
	
public:
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFMText(const TdxfExportData &AData) : 
		TsgExpDXFFigure(AData) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFMText(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgExpDXFHatch;
class PASCALIMPLEMENTATION TsgExpDXFHatch : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
private:
	TsgHatchIslandDetectionStyle FIslandDetectionStyle;
	float FPatternAngle;
	Classes::TList* FPatternData;
	float FPatternScale;
	TsgHatchPatternType FPatternType;
	Sgconsts::TsgHatchStyle FStyle;
	TsgHatchBoundaryType FBoundaryType;
	Sgconsts::TFPoint __fastcall GetPoint(int BndIndex, int AIndex);
	int __fastcall GetBndAmount(void);
	void __fastcall SetPatternName(const AnsiString Value);
	void __fastcall SetStyle(const TdxfExportData &AData);
	void __fastcall FreeBoundaries(void);
	void __fastcall FreePatternData(void);
	void __fastcall SetPatternData(const Classes::TList* Value);
	
protected:
	Classes::TList* FBoundaries;
	int FBndAmount;
	AnsiString FPatternName;
	
public:
	__fastcall virtual TsgExpDXFHatch(const TdxfExportData &AData);
	__fastcall virtual ~TsgExpDXFHatch(void);
	int __fastcall GetPointsNumber(int BndIndex);
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
	__property TsgHatchBoundaryType BoundaryType = {read=FBoundaryType, nodefault};
	__property TsgHatchIslandDetectionStyle IslandDetectionStyle = {read=FIslandDetectionStyle, write=FIslandDetectionStyle
		, nodefault};
	__property float PatternAngle = {read=FPatternAngle, write=FPatternAngle};
	__property Classes::TList* PatternData = {read=FPatternData, write=SetPatternData};
	__property AnsiString PatternName = {read=FPatternName, write=SetPatternName};
	__property float PatternScale = {read=FPatternScale, write=FPatternScale};
	__property TsgHatchPatternType PatternType = {read=FPatternType, write=FPatternType, nodefault};
	__property Sgconsts::TFPoint Points[int BndIndex][int AIndex] = {read=GetPoint};
	__property int BndAmount = {read=GetBndAmount, nodefault};
	__property Sgconsts::TsgHatchStyle Style = {read=FStyle, nodefault};
};


class DELPHICLASS TsgExpDXFSolid;
class PASCALIMPLEMENTATION TsgExpDXFSolid : public TsgExpDXFFigure 
{
	typedef TsgExpDXFFigure inherited;
	
public:
	virtual void __fastcall ExportAsDXF(TsgDXFExport* ADXFExport);
public:
	#pragma option push -w-inl
	/* TsgExpDXFFigure.Create */ inline __fastcall virtual TsgExpDXFSolid(const TdxfExportData &AData) : 
		TsgExpDXFFigure(AData) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgExpDXFSolid(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TsgDXFExport : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FAdditionalEntitiesIndex;
	TsgAutoCADVersion FAutoCADVer;
	Classes::TStringList* FBlkRecs;
	AnsiString FBlock;
	bool FBlockMode;
	Classes::TList* FBlocks;
	Classes::TStringList* FCurrent;
	TsgExpDXFLayer* FCurrentLayer;
	Graphics::TCanvas* FCanvas;
	float FDefaultHatchPatternScale;
	float FDefaultLTypeScale;
	int FDimensionCounter;
	Classes::TStringList* FEntities;
	Classes::TList* FFiguresList;
	int FHandle;
	bool FIsParseWhite;
	Classes::TList* FLayers;
	Sgconsts::TFPoint FLimMin;
	Sgconsts::TFPoint FLimMax;
	Classes::TStringList* FLTypes;
	TsgMetafile* FMetafile;
	bool FMillimetres;
	AnsiString FNameCurrentLayer;
	float FOffset;
	Extended FPenWidthRatio;
	Classes::TList* FTextStyles;
	Graphics::TMetafile* FTmp;
	Classes::TStringList* FUndefinedInserts;
	double FUnitSize;
	bool FUse01MM;
	bool FUseMetafileFontName;
	bool FUseMetafileRatio;
	bool FUseUnicode;
	Graphics::TCanvas* __fastcall GetCanvas(void);
	TsgExpDXFBlock* __fastcall GetBlockByName(AnsiString AName);
	AnsiString __fastcall GetTextStyleNameByWidthfactor(float AWidthfactor);
	Extended __fastcall MM(Extended Value);
	int __fastcall AddName(const AnsiString AName, const AnsiString ASub);
	int __fastcall AddHandle(void);
	void __fastcall AddDimensionStyle(const AnsiString AppName, const TsgDimensionStyle &ADimStyle);
	void __fastcall AddInt(int Code, int Value);
	void __fastcall AddFloat(int Code, Extended Value);
	void __fastcall AddEntity(TsgExpDXFFigure* AEntity);
	void __fastcall AddString(int Code, const AnsiString Str);
	void __fastcall Add3DPoint(int Code, const Sgconsts::TFPoint &P);
	void __fastcall AddPoint(int Code, const Sgconsts::TFPoint &P);
	void __fastcall AddVertex(const Sgconsts::TFPoint &P);
	void __fastcall AddColor(const TdxfExportData &Data);
	void __fastcall AddLTypeScale(void);
	void __fastcall AddThickness(const TdxfExportData &Data);
	void __fastcall BeginPoly(const TdxfExportData &Data, int ACount);
	void __fastcall BeginLeader(const TdxfExportData &Data, int ACount);
	AnsiString __fastcall GetStrAutoCADVer(void);
	void __fastcall SetIsParseWhite(const bool Value);
	void __fastcall SetUse01MM(const bool Value);
	void __fastcall SetAutoCADVer(const TsgAutoCADVersion Value);
	void __fastcall SetCurrentLayer(const TsgExpDXFLayer* Value);
	int __fastcall GetFiguresCount(void);
	
protected:
	__property int AdditionalEntitiesIndex = {read=FAdditionalEntitiesIndex, write=FAdditionalEntitiesIndex
		, nodefault};
	__property int FiguresCount = {read=GetFiguresCount, nodefault};
	
public:
	__fastcall TsgDXFExport(void);
	__fastcall virtual ~TsgDXFExport(void);
	void __fastcall AddDimension(TdxfExportData &Data);
	void __fastcall AddPixel(TdxfExportData &Data);
	void __fastcall AddLine(TdxfExportData &Data);
	void __fastcall AddRectangle(TdxfExportData &Data);
	void __fastcall AddPolyLine(TdxfExportData &AData, int AIndex);
	void __fastcall AddLeader(TdxfExportData &AData, int AIndex);
	void __fastcall AddPolyBezier(TdxfExportData &AData, int AIndex);
	void __fastcall AddCircle(TdxfExportData &Data);
	void __fastcall AddArc(TdxfExportData &Data);
	void __fastcall AddEllipse(TdxfExportData &Data);
	void __fastcall AddHatch(TdxfExportData &Data);
	void __fastcall AddHatchEx(TdxfExportData &Data, Classes::TList* APatternData, AnsiString APatternName
		, TsgHatchIslandDetectionStyle AIslandDetectionStyle, TsgHatchPatternType APatternType);
	void __fastcall AddText(TdxfExportData &Data);
	void __fastcall AddLType(const AnsiString Name, const float * Parts, const int Parts_Size);
	void __fastcall AddMText(TdxfExportData &Data);
	void __fastcall AddSolid(TdxfExportData &Data);
	void __fastcall AddXRef(const TdxfExportData &Data);
	void __fastcall BeginBlock(const AnsiString Name);
	void __fastcall BeginBlockWithXref(const AnsiString Name, const AnsiString XrefPath);
	void __fastcall Clear(void);
	void __fastcall EndBlock(void);
	void __fastcall EndDraw(void);
	void __fastcall Insert(const TdxfExportData &Data);
	void __fastcall LoadFromMetafile(Graphics::TMetafile* Metafile);
	void __fastcall LoadFromFile(const AnsiString AFileName);
	void __fastcall SaveToStream(Classes::TStream* S);
	void __fastcall SaveToFile(const AnsiString FileName);
	void __fastcall SetLayerByString(AnsiString Name);
	__property TsgAutoCADVersion AutoCADVer = {read=FAutoCADVer, write=SetAutoCADVer, nodefault};
	__property AnsiString Block = {read=FBlock};
	__property Graphics::TCanvas* Canvas = {read=GetCanvas};
	__property TsgExpDXFLayer* CurrentLayer = {read=FCurrentLayer, write=SetCurrentLayer};
	__property float DefaultLTypeScale = {read=FDefaultLTypeScale, write=FDefaultLTypeScale};
	__property float DefaultHatchPatternScale = {read=FDefaultHatchPatternScale, write=FDefaultHatchPatternScale
		};
	__property bool IsParseWhite = {read=FIsParseWhite, write=SetIsParseWhite, nodefault};
	__property Classes::TList* Layers = {read=FLayers, write=FLayers};
	__property bool Millimetres = {read=FMillimetres, write=FMillimetres, nodefault};
	__property float Offset = {read=FOffset, write=FOffset};
	__property Extended PenWidthRatio = {read=FPenWidthRatio, write=FPenWidthRatio};
	__property Classes::TStringList* UndefinedInserts = {read=FUndefinedInserts};
	__property double UnitSize = {read=FUnitSize, write=FUnitSize};
	__property bool Use01MM = {read=FUse01MM, write=SetUse01MM, nodefault};
	__property bool UseMetafileFontName = {read=FUseMetafileFontName, write=FUseMetafileFontName, nodefault
		};
	__property bool UseMetafileRatio = {read=FUseMetafileRatio, write=FUseMetafileRatio, nodefault};
	__property bool UseUnicode = {read=FUseUnicode, write=FUseUnicode, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE BOOL AlternativeBlack;
extern PACKAGE float OffsetX;
extern PACKAGE float OffsetY;
static const Shortint DXF_BYBLOCK = 0x0;
static const Shortint DXF_RED = 0x1;
static const Shortint DXF_YELLOW = 0x2;
static const Shortint DXF_LIME = 0x3;
static const Shortint DXF_AQUA = 0x4;
static const Shortint DXF_BLUE = 0x5;
static const Shortint DXF_FUCHSIA = 0x6;
static const Shortint DXF_BLACK = 0x7;
static const Shortint DXF_GRAY = 0x8;
static const Shortint DXF_SILVER = 0x9;
static const Shortint DXF_OLIVE = 0x2c;
static const Shortint DXF_GREEN = 0x4a;
static const Byte DXF_TEAL = 0x87;
static const Byte DXF_NAVY = 0x9a;
static const Byte DXF_PURPLE = 0xe0;
static const Shortint DXF_MAROON = 0xe;
static const Byte DXF_WHITE = 0xff;
static const Word DXF_BYLAYER = 0x100;
static const Byte DXF_ALTERNATIVEBLACK = 0xfa;
static const Byte DXF_DKGRAY = 0xfb;
static const Byte DXF_LTGRAY = 0xfe;
extern PACKAGE int __fastcall ColorToDXF(unsigned Value);
extern PACKAGE Sgconsts::TFPoint __fastcall MakeExpPoint(const double X, const double Y, const double 
	Z);
extern PACKAGE AnsiString __fastcall GetPourStr(const AnsiString S);
extern PACKAGE AnsiString __fastcall FontToStr(Graphics::TFont* Font, const AnsiString S);

}	/* namespace Dxfexport */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Dxfexport;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// DXFExport
