class WINDOW
{
  protected:
    HWND hWnd;
    int nCmdShow;
    LPPAINTSTRUCT lpPaint;
    WORD wParam;
    LONG lParam;

    virtual void DefineCreate
        ( CREATESTRUCT &CreateStruct );
    virtual void DefineWClass ( WNDCLASS &WndClass );
    virtual LPSTR GetClassName() {return "Generic";};
    virtual LPSTR GetWindowName()
        {return GetClassName();};
    BOOL Show()
        { return ShowWindow( hWnd, nCmdShow ); }
    void Update() { UpdateWindow( hWnd ); }
    virtual void CallPaint ();
    int getx() { return LOWORD(lParam); };
    int gety() { return HIWORD(lParam); };

    virtual void Create() {};
    virtual void InitDialog() {};
    virtual void Paint() {};
    virtual long Command () {return TRUE;};
    virtual void Timer () {};
    virtual void Size () {};
    virtual void MouseMove () {};
    virtual void LButtonDown () {};
    virtual void LButtonUp () {};
    virtual void Destroy ();
    virtual long DefaultProc(WORD iMessage)
      {return DefWindowProc( hWnd, iMessage,
                             wParam, lParam );};

  public:
    WINDOW();
    HWND GetHandle() { return hWnd; }
    void PutHandle ( HWND hWndPrm ) { hWnd = hWndPrm; }
    virtual BOOL Make ();
    ~WINDOW() { if (hWnd) DestroyWindow (hWnd); };
    long WndProc( WORD iMessage, WORD wParamPrm,
                  LONG lParamPrm );
};
typedef WINDOW * PWINDOW;

class MAINWINDOW : public WINDOW
{
  void Destroy() { WINDOW::Destroy();
                   PostQuitMessage( 0 ); };
};
typedef MAINWINDOW * PMAINWINDOW;

class DIALOG : public WINDOW
{
  public:
    virtual LPSTR GetTemplateName()
         {return "GenericDlg";};
    int Make (HWND hParent);
    long DefaultProc(WORD iMessage);
    void Destroy();
};
typedef DIALOG * PDIALOG;

typedef BOOL (*BOOLPROC) ();
void RegisterInstance ( BOOLPROC InitInstance );
void RegisterApplication ( BOOLPROC InitApplication );
