/*

    PROGRAM  : bit.c

    AUTHOR   : John Gray 

    DATE     : January 1988

    FUNCTION : Demonstrates the use of 'bit strings' in C.

 

*/

 

#include <stdio.h> 



#define HEX1           ((unsigned) (0x1))          /* hexadecimal 1          */

#define BITSperBYTE    (8)                         /* # of bits per byte     */

#define SIZE           (sizeof(unsigned) * BITSperBYTE)

                                                   /* element size in bits   */  



#define SCRNsize       (80)                        /* # of char on 1 line    */

#define LIMIT          (SCRNsize / SIZE)           /* max # of elements      */



#define BITrangeERR    printf("\n\7Bit out of range 1 - %d \n",value)



int value;                                         /* # of bits needed      */



main(){

  int i,j,                                         /* indicies              */

      max,                                         /* maximum array index   */

      ch;                                          /* character input       */



  void Clear(), PrintBit(), ResetBit(), SetBit(), exit();



  printf("\nPlease enter number of bits [1 - %d] needed: ",LIMIT * SIZE);

  scanf("%d", &value);

  ch = getchar();                                  /* discard remaining \n  */

  max = (value - 1) / SIZE;                        /* find max array index  */ 

  if ( value > 0 && max < LIMIT )                  /* if within limits do   */

    {

    unsigned BitString[LIMIT];                     /* array of bits         */

    Clear(BitString, max);                         /* reset all bits to 0   */ 

    printf("\n\nCMD> ");

    while ( (ch = getchar()) != EOF )              /* obtain user input     */

      {

      switch( ch | 32 )                                 

        { 

        case 'c':                                  /* call Clear            */

          Clear(BitString, max);

          break;



        case 'e':

          exit(0);                                 /* exit to system        */



        case 'p':                                  /* call PrintBit         */

          putchar('\n');

          for ( i = max; i >= 0; i-- )

            PrintBit(BitString[i], i);

          putchar('\n');

          break;



        case 's':                                  /* call SetBit           */

          if ( GetBit(&i, &j) ) SetBit(&BitString[i], j);

          else BITrangeERR;

          break;



        case 'r':                                  /* call ResetBit         */

          if ( GetBit(&i, &j) ) ResetBit(&BitString[i], j);

          else BITrangeERR;

          break;



        case 't':                                   /* call TestBit         */

          if ( GetBit(&i, &j) )

            printf("\nBit set is %c\n",(TestBit(BitString[i], j)) ? 'T' : 'F');

          else BITrangeERR;

          break;                              



        default:

          printf("\nUsage C - clear, E - exit, P - print, R - reset, S - set, T - test\n");

        }

      ch = getchar();                               /*   clear remaining \n   */

      printf("\nCMD> ");

      }

    }

  else printf("\nValue entered is out of range.\n");

}





/*  Clear working bit string array to all 0's                                */



static void Clear(bs, m)

  unsigned *bs;                                     /* array of bits         */ 

  int      m;                                       /* max array index       */

{

  register int i;

  for (i = 0; i <= m; i++, bs++)                    /* exclusive OR elmnts   */

    *bs ^= *bs;                                     /* to set to all 0's     */

}





/* Obtain bit number from user, return elmnt index, and off set within elmnt */



static int GetBit(index, offset)

  int *index,                                       /* index of array        */

      *offset;                                      /* offset within elmnt   */

{

  int bit,                                          /* bit number to use     */

      ok = 0;                                       /* assume false          */



  printf("\nPlease enter the bit # [1 - %d] ",value);

  if ((ok = scanf("%d", &bit) &&

       bit <= value && bit > 0)) {                  /* int and within range? */

         *index = (bit - 1)/SIZE;                   /* find index            */

         *offset = (bit % SIZE == 0) ? SIZE : bit % SIZE;

  }                                                 /* find offset           */

  return(ok);                                       /* return validity       */

} 





/*  Print valid bits of a given array element                                */ 



static void PrintBit(element, index)

  unsigned element;                                 /* array element         */

  int      index;                                   /* index of array elmnt  */ 

{

   register int i;



   for (i = SIZE; i > 0; i--)                       /* for each bit          */ 

     if (index * SIZE + i <= value)                 /* if within range       */

       putchar((element & (HEX1 << (i - 1))) ? '1' : '0');

}





/*  Set specified bit                                                        */



static void SetBit(element, offset)

  unsigned *element;                                /* array element         */

  int      offset;                                  /* offset within elmnt   */

{                                                   /* OR original with 1    */

  *element |= (HEX1 << offset - 1);                 /* shifted to crct pos   */

}





/*  Reset a specified bit                                                    */



static void ResetBit(element, offset)

  unsigned *element;                                /* array element         */

  int      offset;                                  /* offset within elmnt   */

{

  static unsigned mask = HEX1;                      /* 000...1               */



  mask <<= SIZE - 1;                                /* shift left  100...0   */

  mask = ~(mask >> SIZE - offset);                  /* shift rt to crct pos  */ 

  *element &= mask;                                 /* AND with original     */

}





/* Test specified bit, return non-zero if set else return zero               */



static int TestBit(element, offset)

  unsigned element;                                 /* array element         */

  int      offset;                                  /* offset within elmnt   */ 

{

  element <<= SIZE - offset;                        /* remove left portion   */

  return(element >>= SIZE - 1);                     /* shift right           */

}

