#ifndef STDDEFS.H
#include "stddefs.h"
#endif

#include <fstream.h>
#include <string.h>
#include <stdlib.h>
#include "yaksound.h"

#include <stdio.h>
#include <io.h>

#include "sb.h"

byte * yakSample::load(char * filename)
{
  long miscNumber = 0;
  if (sampleData)
    delete sampleData;
  ifstream myInStream(filename, ios::binary | ios::in);
  if (myInStream)
  {
    myInStream.seekg(0, ios::end);
    long sl = (myInStream.tellg() > 64000) ? 64000 : myInStream.tellg();
    sampleData = new byte[sl];
    myInStream.seekg(0);
    for (long bytesLeft = sl; bytesLeft > 0;)
      {
	miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
	myInStream.read(sampleData, (int)miscNumber);
	bytesLeft -= miscNumber;
      }
    sampleLength = sl;
    myInStream.close();
    return(sampleData);
  }
  else
  {
    sampleData = NULL;
    sampleLength = 0;
    return NULL;
  }
}

void yakSample::play(word sampleRate, word stereo, word voice, unsigned long length)
{
  if (length > sampleLength)
    length = sampleLength;
  if (length == 0)
    length = sampleLength;
  Sb_Init_Voice_DMA(NULL);   /* Use default interrupt handler */
  Sb_Sample_Rate(sampleRate);
  Sb_Voice(voice);
  Sb_OutVoice_DMA(sampleData,length,stereo);
}

static char far * driverMemory = NULL;
static void far (*driver)() = NULL;

void CTLoad(void)
{
  long length;
  char *sp;
  char sn[129];
  ifstream myInStream;
  strcpy(sn, "");
  sp = getenv("SOUND");
  if (sp)
  {
     strcpy(sn,sp);
     if(sn[strlen(sn)-1] != '\\')
       strcat(sn, "\\");
  }
  strcat(sn, "drv\\CT-VOICE.DRV");
  myInStream.open(sn, ios::binary);
  if (!myInStream) return;
  myInStream.seekg(0,ios::end);
  length = myInStream.tellg(); //get length of file
  myInStream.seekg(0, ios::beg);
  driverMemory = new far char[(int)length + 16];
  if (FP_SEG(driverMemory) != 0)
    driver = (void (*)())MK_FP(FP_SEG(driverMemory) + 1, 0);
  else
    driver = (void (*)())driverMemory;
  myInStream.read((char *)driver, (int)length);
  myInStream.close();
}


int CTGetVersion(void) {_BX = 0; (*driver)(); return _AX;};
void CTSetIOAddr(int base) {_BX=1; _AX=base; (*driver)();};
void CTSetIRQ(int irq) {_BX=2; _AX=irq; (*driver)();};
int CTInitialize(void) {_BX=3; (*driver)(); return _AX;};
void CTUninstall(void) {_BX=9; (*driver)();};
void CTSpeakerOn(void) {_BX=4; _AX=1; (*driver)();};
void CTSpeakerOff(void){_BX=4; _AX=0; (*driver)();};
void CTSetStatusWord(word * address) {_BX=5; _ES=FP_SEG(address); _DI=FP_OFF(address); (*driver)();};
void CTOutputVoice(char * buffer) {_BX=6; _ES=FP_SEG(buffer); _DI=FP_OFF(buffer); (*driver)();};
void CTStopVoiceProcess(void) {_BX=8; (*driver)();};
int CTPauseOutputVoice(void) {_BX=10; (*driver)(); return _AX;};
int CTContinueOutputVoice(void) {_BX=11; (*driver)(); return _AX;};


//yakVoc definitions follow------------------------------------------->

void yakVoc::load(char * filename, yakLib * myYakLib)
{
  sampleData = (myYakLib) ? myYakLib->loadToMem(filename) : loadDosToMem(filename);
}

void yakVoc::play(void)
{
  CTOutputVoice(sampleData + 0x1a);
}