#include "stddefs.h"
#include "yaklib.h"
#include <string.h>
#include <stdio.h>
#include <ctype.h>

int tolower(char * theString)
{
  for(int counter = 0; counter < strlen(theString); ++counter)
    theString[counter] = tolower(theString[counter]);
  return(0);
}

void yakLib::open(char * filename)
{
  int temp;
  char fullFilename[15];
  strcpy(fullFilename, filename);
  if(strncmp(fullFilename + strlen(fullFilename) - 4, ".yar", 4))
     strcat(fullFilename, ".yar");
  strcpy(libFilename, fullFilename);
  myDataFile.open(fullFilename, ios::binary | ios::in | ios::out);
  myDataFile.seekg(0, ios::end);
  if (myDataFile.tellg() == 0)
    numberOfEntries = 0;
  else
  {
    myDataFile.seekg(-(int)sizeof(numberOfEntries), ios::end);
    temp = myDataFile.tellg();
    if(temp == 0);
    byte tempByte = myDataFile.peek();
    if(tempByte);
    myDataFile.read((byte *) &numberOfEntries, (int)sizeof(numberOfEntries));
  }
  getDirectoryIndex();
}

yakLib::yakLib(char * filename)
{
  open(filename);
}

void yakLib::getDirectoryIndex(void)
{
  long temp = myDataFile.tellg();
  myDataFile.seekg(0);
  long temp2 = myDataFile.tellg();
  if (temp2);

  myDataFile.seekg(0, ios::end);
  temp2 = myDataFile.tellg();
  if (temp2);
  if (myDataFile.tellg() == 0)
  {
    directoryIndex = 0;
    return;
  }
  myDataFile.seekg(-((int)sizeof(numberOfEntries) + numberOfEntries*(int)sizeof(directoryEntry)), ios::end);
  directoryIndex = myDataFile.tellg();
  myDataFile.seekg(temp);
}

directoryEntry yakLib::getIndex(char * filename)
{
  directoryEntry myDirectoryEntry;
  myDataFile.seekg(directoryIndex);
  tolower(filename);
  for (int counter = 0; counter < numberOfEntries; ++counter)
  {
    myDataFile.read((char *)&myDirectoryEntry, (int)sizeof(directoryEntry));
    if (strcmp(myDirectoryEntry.filename, filename) == 0)
      return(myDirectoryEntry);
  }
  strcpy(myDirectoryEntry.filename, "");
  myDirectoryEntry.size = 0;
  myDirectoryEntry.index = 0;
  return myDirectoryEntry;
}

unsigned long yakLib::fileSize(char * filename)
{
  return getIndex(filename).size;
}

void yakLib::listFiles(void)
{
  directoryEntry myDirectoryEntry;
  myDataFile.seekg(directoryIndex);
  cout << "\n\n";
  for (int counter = 0; counter < numberOfEntries; ++counter)
  {
    myDataFile.read((char *)&myDirectoryEntry, (int)sizeof(directoryEntry));
    cout << myDirectoryEntry.filename << "\t" << myDirectoryEntry.size << "\t";
    cout << myDirectoryEntry.index << "\n";
  }
}

void yakLib::addFile(char * filename)
{
  fstream myInputFile(filename, ios::in | ios::binary);
  char tempName[15];
  tmpnam(tempName);
  fstream myTempFile(tempName, ios::out | ios::binary);
  directoryEntry newDirectoryEntry;
  byte * myBuffer = new byte[33000];
  long miscNumber = 0, counter = 0;
  tolower(filename);
  if (myInputFile)
  {
    newDirectoryEntry = getIndex(filename);
    if (newDirectoryEntry.size != 0)
      deleteFile(filename);
    myDataFile.seekg(0);
    if (myBuffer == NULL)
    {
      while(myTempFile.tellg() < directoryIndex)
	myTempFile.put(myDataFile.get());          //copy datafile to temp
    }
    else
    {
      for (long bytesLeft = directoryIndex; bytesLeft > 0;)
      {
	miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
	myDataFile.read(myBuffer, (int)miscNumber);
	myTempFile.write(myBuffer, (int)miscNumber);
	bytesLeft -= miscNumber;
      }
    }
    myInputFile.seekg(0, ios::end);		 //go to end of infile
    newDirectoryEntry.size = myInputFile.tellg(); //find out how big our file is
    newDirectoryEntry.index = myTempFile.tellp(); //and where it'll be
    strncpy(newDirectoryEntry.filename, filename, 15); //and its filename
    myInputFile.seekg(0);
    if (myBuffer == NULL)
    {
      for(counter = 0; counter < newDirectoryEntry.size; ++counter)
	myTempFile.put(myInputFile.get());          //copy datafile to temp
    }
    else
    {
      for (long bytesLeft = newDirectoryEntry.size; bytesLeft > 0;)
      {
	miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
	myInputFile.read(myBuffer, (int)miscNumber);
	myTempFile.write(myBuffer, (int)miscNumber);
	bytesLeft -= miscNumber;
      }
    }
    for (counter = 0; counter <  numberOfEntries*(int)sizeof(directoryEntry); ++counter)
      myTempFile.put(myDataFile.get());          //copy datafile to temp

    myTempFile.write((byte *) &newDirectoryEntry, (int)sizeof(directoryEntry));
    ++numberOfEntries;
    int temp = myTempFile.tellp();
    if (temp);
    myTempFile.write((byte *) &numberOfEntries, (int)sizeof(numberOfEntries));
    myTempFile.close();
    myDataFile.close();
    remove(libFilename);
    rename(tempName, libFilename);
    open(libFilename);
  }
  delete(myBuffer);
}

void yakLib::extractFile(char * filename)
{
  fstream myOutputFile;
  byte * myBuffer = new byte[33000];
  long miscNumber;
  tolower(filename);
  directoryEntry myDirectoryEntry = getIndex(filename);
  if (myDirectoryEntry.size != 0)
  {
    myOutputFile.open(filename, ios::out | ios::binary);
    myDataFile.seekg(myDirectoryEntry.index);
    if (myBuffer == NULL)
    {
      for (long counter = 0; counter < myDirectoryEntry.size; ++counter)
	myOutputFile.put(myDataFile.get());
    }
    else
    {
      for (long bytesLeft = myDirectoryEntry.size; bytesLeft > 0;)
      {
	miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
	myDataFile.read(myBuffer, (int)miscNumber);
	myOutputFile.write(myBuffer, (int)miscNumber);
	bytesLeft -= miscNumber;
      }
    }
  }
  delete myBuffer;
}

int yakLib::deleteFile(char * filename)
{
  tolower(filename);
  char tempName[15];
  tmpnam(tempName);
  fstream myTempFile(tempName, ios::out | ios::binary);
  char * myBuffer = new char[33000];
  long miscNumber;
  directoryEntry newDirectoryEntry = getIndex(filename), tempDirectoryEntry;
  myDataFile.seekg(0);
  if (newDirectoryEntry.size == 0)
  {
    delete myBuffer;
    return(1);
  }
  if (myBuffer == NULL)
  {
    for (int counter = 0; counter < newDirectoryEntry.index; ++counter)
      myTempFile.put(myDataFile.get());  //copy everything up to the deleted file
  }
  else
  {
    for (long bytesLeft = newDirectoryEntry.index; bytesLeft > 0;)
    {
      miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
      myDataFile.read(myBuffer, (int)miscNumber);
      myTempFile.write(myBuffer, (int)miscNumber);
      bytesLeft -= miscNumber;
    }
  }
  myDataFile.seekg(newDirectoryEntry.size, ios::cur);
  if (myBuffer == NULL)
  {
    while(myDataFile.tellg() < directoryIndex)
    myTempFile.put(myDataFile.get());    //copy everything after the deleted file
  }
  else
  {
    for (long bytesLeft = directoryIndex - myDataFile.tellg(); bytesLeft > 0;)
    {
      miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
      myDataFile.read(myBuffer, (int)miscNumber);
      myTempFile.write(myBuffer, (int)miscNumber);
      bytesLeft -= miscNumber;
    }
  }
  for (int counter = 0; counter < numberOfEntries; ++counter)
  {
    myDataFile.read((byte *) &tempDirectoryEntry, sizeof(directoryEntry));
    if (tempDirectoryEntry.index != newDirectoryEntry.index)
    {
      if (tempDirectoryEntry.index > newDirectoryEntry.index)
	tempDirectoryEntry.index -= newDirectoryEntry.size;
      myTempFile.write((byte *) &tempDirectoryEntry, sizeof(directoryEntry));
    }
  }
  --numberOfEntries;
  myTempFile.write((byte *) &numberOfEntries, sizeof(numberOfEntries));
  myTempFile.close();
  myDataFile.close();
  remove(libFilename);
  rename(tempName, libFilename);
  open(libFilename);
  delete myBuffer;
  return(0);
}

byte * yakLib::loadToMem(char * filename)
{
  byte * loadBuffer = NULL;
  long loadBufferIndex = 0;
  long miscNumber;
  tolower(filename);
  directoryEntry myDirectoryEntry = getIndex(filename);
  if (myDirectoryEntry.size != 0)
  {
    loadBuffer = new char[myDirectoryEntry.size + 1];
    myDataFile.seekg(myDirectoryEntry.index);
    if (loadBuffer)
    {
      for (long bytesLeft = myDirectoryEntry.size; bytesLeft > 0;)
      {
	miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
	myDataFile.read(loadBuffer + loadBufferIndex, (int)miscNumber);
	bytesLeft -= miscNumber;
	loadBufferIndex += miscNumber;
      }
    }
  }
  *(loadBuffer + loadBufferIndex) = 0;
  return(loadBuffer);
}

byte * loadDosToMem(char * filename)
{
  byte * loadBuffer = NULL;
  long loadBufferIndex = 0;
  long miscNumber;
  ifstream myInStream(filename, ios::binary);
  if (!myInStream)
    return NULL;
  myInStream.seekg(0, ios::end);
  long size = myInStream.tellg();
  loadBuffer = new char[size];
  myInStream.seekg(0, ios::beg);
  if (!loadBuffer)
    return NULL;
  for (long bytesLeft = size; bytesLeft > 0;)
  {
    miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
    myInStream.read(loadBuffer + loadBufferIndex, (int)miscNumber);
    bytesLeft -= miscNumber;
    loadBufferIndex += miscNumber;
  }
  return loadBuffer;
}