#include "factor.h"


directionTable * factor::ficonTable = new directionTable[MAX_ICONS];

void factor::spawn(animactor * spawnactor)
{
  animactor::spawn(spawnactor);
  spawnactor->turn(direction);
}

void factor::advance(void)
{
  lastMapX = mapX;
  lastMapY = mapY;
  if (spawnedActor != NULL)
  {
    spawnedActor->advance();
    return;
  }
  char newdirection = direction;
  thisFrame = thisFrame->nextFrame;
  if (thisLine == NULL)
    return;
  if (thisLine != NULL)
  {
    switch (thisLine->command)
    {
      case scriptNode::doNothing	: turn(direction); break;//newdirection = center; break;
      case scriptNode::turn		: newdirection = thisLine->mapX; break;
      case scriptNode::fineMoveRel	: fineMoveRel(thisLine->squareX, thisLine->squareY);
			  if ((thisLine->squareX < 0) && (thisLine->squareY > 0))
			    newdirection = southwest;
			  if ((thisLine->squareX == 0) && (thisLine->squareY > 0))
			    newdirection = south;
			  if ((thisLine->squareX > 0) && (thisLine->squareY > 0))
			    newdirection = southeast;
			  if ((thisLine->squareX < 0) && (thisLine->squareY == 0))
			    newdirection = west;
			  if ((thisLine->squareX == 0) && (thisLine->squareY == 0))
			    newdirection = center;
			  if ((thisLine->squareX > 0) && (thisLine->squareY == 0))
			    newdirection = east;
			  if ((thisLine->squareX < 0) && (thisLine->squareY < 0))
			    newdirection = northwest;
			  if ((thisLine->squareX == 0) && (thisLine->squareY < 0))
			    newdirection = north;
			  if ((thisLine->squareX > 0) && (thisLine->squareY < 0))
			    newdirection = northeast;
			  break;
    }
    scriptNode * oldLine = thisLine;
    advanceLine();
    if (thisLine == NULL)
      firstLine = NULL;
    delete (oldLine); // free up our script now!
  }
  if (newdirection != direction)
    turn(newdirection);
}


void factor::turn(byte idirection)
{
  direction = idirection;
  thisFrame = directionIcons[direction];
};

void factor::assignIcon(int iconNumber, type mode, char identity)
{
  myIdentity = identity;
  if (myIdentity == 255)
    myIdentity = iconNumber;
  myIconNumber = iconNumber;
  for (int counter = 0; counter < 10; ++counter)
    directionIcons[counter] = ficonTable[iconNumber][counter].firstFrame;
  switch (mode)
  {
    case eightFace:	break;
    case oneFace:	for (counter = 1; counter < 10; ++counter)
			  directionIcons[counter] = ficonTable[iconNumber][center].firstFrame;
			break;
    case twoFace:	directionIcons[north] = ficonTable[iconNumber][center].firstFrame;
			directionIcons[south] = ficonTable[iconNumber][center].firstFrame;
    case fourFace:	directionIcons[northwest] = ficonTable[iconNumber][west].firstFrame;
			directionIcons[southwest] = ficonTable[iconNumber][west].firstFrame;
			directionIcons[northeast] = ficonTable[iconNumber][east].firstFrame;
			directionIcons[southeast] = ficonTable[iconNumber][east].firstFrame;
			break;
  }
  for (counter = 0; counter < 10; ++counter)
    if (directionIcons[counter] == NULL)  // if it's not loaded, look @ center
      directionIcons[counter] = ficonTable[iconNumber][center].firstFrame;
  if (direction > 10)
    direction = 5;
  thisFrame = directionIcons[direction];
}

void factor::loadFactor(int position, char * special, char * sw, char * s,
			char * se, char * w, char * center, char * e,
			char * nw, char * n, char * ne, yakLib * myYakLib, icon::flagType flags)
{
  ficonTable[position][factor::special].addAll(special, flags, myYakLib);
  ficonTable[position][southwest].addAll(sw, flags, myYakLib);
  ficonTable[position][south].addAll(s, flags, myYakLib);
  ficonTable[position][southeast].addAll(se, flags, myYakLib);
  ficonTable[position][west].addAll(w, flags, myYakLib);
  ficonTable[position][factor::center].addAll(center, flags, myYakLib);
  ficonTable[position][east].addAll(e, flags, myYakLib);
  ficonTable[position][northwest].addAll(nw, flags, myYakLib);
  ficonTable[position][north].addAll(n, flags, myYakLib);
  ficonTable[position][northeast].addAll(ne, flags, myYakLib);
}

void factor::clearFactor(int position)
{
  for (int directionCounter = 0; directionCounter < 10; ++directionCounter)
  {
    ficonTable[position][directionCounter].animicon::~animicon();
  }
}

