#ifndef SCRIPT.H
#include "script.h"
#endif
#ifndef ACTOR.H
#include "actor.h"
#endif

animicon * animactor::actorIcons = new animicon[MAX_ICONS];

void animactor::loadActor(int position, char far * filename, yakLib * myYakLib)
{
  animactor::actorIcons[position].addAll(filename, icon::normal, myYakLib);
}

void animactor::draw(int x, int y, word pagebase)
{
  if (spawnedActor != NULL)
    spawnedActor->draw(x, y, pagebase);
  else
    thisFrame->picture.showMasked(x, y, pagebase);
}

void animactor::show(int x, int y, word pagebase)
{
  if (spawnedActor != NULL)
    spawnedActor->show(x, y, pagebase);
  else
    {
    thisFrame->picture.showMasked(x, y, pagebase);
    advance();
    }
}


void animactor::advance()
{
  lastMapX = mapX;
  lastMapY = mapY;
  if (spawnedActor != NULL)
    spawnedActor->advance();
  else {
  thisFrame = thisFrame->nextFrame;
  if (thisLine != NULL)
  {
    switch (thisLine->command)
    {
      case scriptNode::doNothing	: break;
      case scriptNode::fineMoveRel	: fineMoveRel(thisLine->squareX, thisLine->squareY); break;
    }
    scriptNode * oldLine = thisLine;
    advanceLine();
    if (thisLine == NULL)
      firstLine = NULL;
    delete (oldLine); // free up our script now!
  }}
}

void animactor::put(int x, int y)
{
  mapX = x % (int) mymap->width;
  mapY = y % (int) mymap->height;
  if (mymap->mapData[x][y].nextActor == NULL)
    mymap->mapData[x][y].nextActor = this;
  else
    {
    animactor * newpointer = mymap->mapData[x][y].nextActor;
    animactor * oldpointer = NULL;
    while ((newpointer != NULL))
      {
      if (newpointer->squareY >= squareY) //if there's an object past this...
      {
	if (newpointer == mymap->mapData[x][y].nextActor) //if it's the first one
	{
	  nextActor = mymap->mapData[x][y].nextActor; //add it to map
	  mymap->mapData[x][y].nextActor = this;
	  return;
	}
	else // if it's not the first one...
	{
	  oldpointer->nextActor = this; //insert this into the list @ the
	  nextActor = newpointer;	//appropriate z-point
	  return;
	}
      }
      oldpointer = newpointer;
      newpointer = newpointer->nextActor;
      }
    oldpointer->nextActor = this; //or at the end.
    nextActor = NULL;
    }
}


void animactor::remove(void)
{
  animactor * thisActor = mymap->mapData[mapX][mapY].nextActor;
  if (thisActor == this) // we are the first object in the list
    {
    mymap->mapData[mapX][mapY].nextActor = nextActor; // object after this one
    nextActor = NULL; //so we don't point to the rest of the list
    }
  else
    {
    while (thisActor->nextActor != this)  //find the actor before this one
      thisActor = thisActor->nextActor;
    thisActor->nextActor = nextActor; // skip this image in the list
    nextActor = NULL;
    }
  mymap->mapData[mapX][mapY].refresh = 3;
}

void animactor::assignIcon(byte iconNumber, byte identity)
{
  myIconNumber = iconNumber;
  thisFrame = actorIcons[iconNumber].firstFrame;
  if (identity == 255)
    identity = iconNumber;
  myIdentity = identity;
}


void * animactor::isInSquare(byte searchIdentity)
{
  animactor * thisActor = mymap->mapData[mapX][mapY].nextActor;
  while (thisActor != NULL)
  {
    if ((thisActor->myIdentity == searchIdentity) && (thisActor != this))
      return(thisActor);
    thisActor = thisActor->nextActor;
  }
  return NULL;
}

void animactor::moveTo(int x, int y)
{
  remove();
  mapX = (x % mymap->width);
  mapY = (y % mymap->height);
  put(mapX, mapY);
}

int animactor::hit(animactor * target)
{
  return(thisFrame->picture.hitXY(mapX*mymap->squareWidth+squareX-thisFrame->picture.width,
         mapY*mymap->squareWidth+squareY - thisFrame->picture.height, &target->thisFrame->picture,
         target->mapX*target->mymap->squareWidth + target->squareX - target->thisFrame->picture.width,
         target->mapY*target->mymap->squareWidth + target->squareY - target->thisFrame->picture.height));
}

void animactor::spawn(animactor * spawnactor)
{
  spawnedActor = spawnactor;
  spawnedActor->spawningActor = this;
  spawnedActor->mapX = mapX;
  spawnedActor->mapY = mapY;
  spawnedActor->squareX = squareX;
  spawnedActor->squareY = squareY;
  spawnedActor->mymap = mymap;
//spawnedActor->firstLine = firstLine;
//spawnedActor->lastLine = lastLine;
//spawnedActor->thisLine = thisLine;
}

void animactor::fineMoveRel(int x, int y)
{
  remove();
  int totalX = mapX*(int)mymap->squareWidth + (int)squareX + x;
  int totalY = mapY*(int)mymap->squareWidth + (int)squareY + y;
  int totalWidth = (int)mymap->squareWidth * (int)mymap->width;
  int totalHeight = (int)mymap->squareWidth * (int)mymap->height;
  totalX += (totalX < 0) ? (totalWidth) : 0;
  totalY += (totalY < 0) ? (totalHeight) : 0;
  totalX %= totalWidth;
  totalY %= totalHeight;
  squareX = totalX % (int)mymap->squareWidth;
  squareY = totalY % (int)mymap->squareWidth;
  mapX = totalX / (int)mymap->squareWidth;
  mapY = totalY / (int)mymap->squareWidth;
  put(mapX, mapY);
}
