/* Output to SB DAC using DMA mode */

#include "stddefs.h"

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <io.h>
#include <alloc.h>
#include <dos.h>
#include <stdlib.h>
#include <alloc.h>
#include <fstream.h>
#include "yaksound.h"
#include "sb.h"

extern int optind;    /* index of which argument is next      */
extern char *optarg;  /* pointer to argument of current option */
extern int opterr;    /* allow error message  */
extern "C" int getopt(int argc, char *argv[], char *optionS);

void main(int argc, char *argv[])
{
    FILE *f;
    signed char far *raw, far *aligned;
    long sample_len;
    register int j, i;
    unsigned sl, tmp, nr, sr=11000;
    unsigned char tm;
    unsigned long physical, aligned_physical;
    char ch;
    int stereo = 0, error = 0;

    while((ch = getopt(argc,argv,"sr:")) != EOF)
    {
	switch(ch)
	{
	    case 's':
		stereo = 1;
		break;
	    case 'r':
		sr = atoi(optarg);
		break;
	    case '?':
		error++;
		break;
	}
    }
    if(error || optind == argc)
    {
	puts("Usage: dacdma [-r rate] [-s] sample");
	exit(1);
    }

    if(Sb_Get_Params())
    {
        puts("BLASTER environment variable not set.");
        exit(1);
    }

    if(Sb_Init())
    {
	printf("Could not find Soundblaster!\n");
	exit(1);
    }
    printf("Found Soundblaster at address %xh, IRQ %d, DMA %d.\n",
	SbIOaddr,SbIRQ,SbDMAchan);

    printf("Sample rate = %d Hz\n",sr);
    printf("Output is %s.\n",(stereo) ? "stereo" : "mono");
    yakSample myYakSample(argv[optind]);
    myYakSample.play(sr, stereo);
    while(!kbhit() && !Sb_DMA_Complete())
	;
    if(!Sb_DMA_Complete())
    {
	Sb_Halt_DMA();
	getch();
    }

    Sb_Voice(0);

    printf("Done.\n");

    Sb_DeInit_Voice_DMA();

    farfree(raw);

    exit(0);
}
