/* Output to SB DAC in single sample mode */

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <io.h>
#include <alloc.h>
#include <dos.h>

#include "sb.h"

/* Read first 64000 bytes of a raw sample file and play the sample */
void main(int argc, char *argv[])
{
    FILE *f;
    signed char *raw;
    unsigned sample_len;
    register int j, i;
    int tmp;

    if(argc != 2)
    {
	puts("Usage: dacdir sample_file");
	exit(1);
    }

    if(Sb_Get_Params())
    {
        puts("BLASTER environment variable not set.");
        exit(1);
    }

    if(Sb_Init())
    {
	printf("Could not find Soundblaster!\n");
	exit(1);
    }
    printf("Found Soundblaster at %xh.\n",SbIOaddr);

    f = fopen(argv[1],"rb");
    if(f == NULL)
    {
	printf("Could not open sample file %s\n",argv[1]);
    }
    sample_len = (unsigned)filelength(fileno(f));

    raw = (signed char *)malloc(sample_len);
    fread(raw,1,sample_len,f);

    fclose(f);

    Sb_Voice(1);

    for(i = 0; i < sample_len; i++)
    {
        writedac(0x10);
        writedac(raw[i]);

        while(inportb(SbIOaddr+DSP_DATA_AVAIL) & 0x80)
	    ;
    }

    Sb_Voice(0);

    free(raw);

    Sb_Init();

    exit(0);
}
