#include "stddefs.h"
#include "yakLib.h"
#include "yakwin.h"
#include "xlib.h"
#include "xtext.h"

class yakScroller : public yakWindow
{
public:
  int position; //position is the line # at top.
  enum direction {up, down};
  char * myText;
  yakScroller(word x1, word y1, word x2, word y2, char * imyText, int iposition = 0) :
    yakWindow(x1, y1, x2, y2)
    {myText = imyText; position = iposition;};
  ~yakScroller() {delete myText;};
  virtual void draw(word offset = VisiblePageOffs);
  virtual word interpretKeyStroke(char myChar);
  virtual word interpretMouseClick(void);
  char * getLine(word lineNumber);
  int lineLength(word lineNumber);
  void drawLine(int lineNumber, int x, int y, word offset);
  void activate(int x, int y, word offset = VisiblePageOffs);
  void drawText(int lineNumber, int ix, int iy, word offset = VisiblePageOffs);
  void drawText(int lineNumber, word offset = VisiblePageOffs);
  void drawText(word offset = VisiblePageOffs);
  void newText(byte * theNewText);
  void activate(int x1, int y1, int x2, int y2, word offset, char * theNewText);
  void pageMove(direction pageDirection, word offset = VisiblePageOffs);
  void lineMove(direction lineDirection, word offset = VisiblePageOffs);
};