#ifndef ANIMICON.H

#define ANIMICON.H

#include <stddef.h>
#include "stddefs.h"
#include "icon.h"

class animiconNode
{
public:
  animiconNode * nextFrame;
  animiconNode * prevFrame;
  icon picture;
  animiconNode() {nextFrame = NULL; prevFrame = NULL;}
  animiconNode(byte * iconData, animiconNode * nextIcon)
    {picture.useData(iconData); nextFrame = nextIcon; prevFrame = NULL;};
};

class animicon
{
public:
  animiconNode * firstFrame;
  animiconNode * lastFrame;
  animiconNode * thisFrame;
  byte numberOfFrames;
  animicon() {firstFrame = lastFrame = thisFrame = NULL; numberOfFrames = 0;}
  animicon(char * filename, icon::flagType flags = icon::normal, yakLib * myYakLib = NULL);
  ~animicon();
  char far * add(animiconNode * thisNode);
  char far * add(char far *filename, icon::flagType flags = icon::normal, yakLib * myYakLib = NULL);
  inline void show(int x, int y, word pagebase);//virt
  inline void draw(int x, int y, word pagebase);//virt
  inline void showZoomed(int x, int y, word offset, int newWidth);
  inline void drawZoomed(int x, int y, word offset, int newWidth);
  inline void advance(void); //virt
  void removeTail(void);
  void addAll(char * filename, icon::flagType flags = icon::normal, yakLib * myYakLib = NULL);
  void hide(int x, int y, word toOffset, word fromOffset);
};


class animslave
{
public:
  animiconNode * thisFrame;
  animslave() {thisFrame = NULL;}
  virtual void advance(void);
  virtual void advance(int numFrames);
  inline void draw(int x, int y, word pagebase);//virt
  inline void show(int x, int y, word pagebase);//virt
  inline void showZoomed(int x, int y, word offset, int newWidth);
  inline void drawZoomed(int x, int y, word offset, int newWidth);
};

#endif