/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 50                        
                                                                            
 Proper joystick detection and initialization is demostrated within this    
 file. The commands wcalibratejoystick, wcheckjoystick, winitjoystick, and  
 wreadjoystick are used.                                                    
                                                                            
  PROJECT                                                             
 This program requires the WGT4.LIB and WGTJOY.LIB files to be linked.      
                                                                            
  DATA FILES                                                          
 None.                                                                      
                                                                            
ͼ
*/

#include <stdlib.h>
#include <conio.h>
#include <wgt4.h>
#include <wgtjoy.h>

void main (void)
{
  joystick joya;			/* Structure for joystick A */
  joystick joyb;			/* Structure for joystick B */
  int display_row;			/* Row for status display */
  int result;				/* Result of joystick detection */
  int joya_found = 0;			/* 1 if joystick is found */
  int joyb_found = 0;			/* 1 if joystick is found */

  if ( !vgadetected() )
  {
    printf ("Error - VGA card required for any WGT program.\n");
    exit (0);
  }

  clrscr ();
  if (!( result = wcheckjoystick () ))
  {
    printf ("Joysticks not found. Program aborted.\n");
    exit (0);
  }

  if (result & 1)
  {
    joya_found = 1;				/* It's there */
    printf ("Joystick A detected.\n\n");
    winitjoystick (&joya, 0);			/* Initialize it */
    printf ("Calibrate joystick A by swirling it and then pressing ENTER.\n");
    wcalibratejoystick (&joya);
    printf ("Joystick A calibrated.\n\n\n");
  }

  if (result & 2)
  {
    joyb_found = 1;				/* It's there */
    printf ("Joystick B detected.\n\n");
    winitjoystick (&joya, 1);			/* Initialize it */
    printf ("Calibrate joystick B by swirling it and then pressing ENTER.\n");
    wcalibratejoystick (&joyb);
    printf ("Joystick B calibrated.\n\n\n");
  }

  printf ("Now reading joystick values. Press any key to end program.\n\n");
  display_row = wherey ();

  while (!kbhit ())
  {
    gotoxy (1, display_row);
    if (joya_found)
    {
      wreadjoystick (&joya);		/* Read values into structures */
      printf ("Joystick A       x: %5d    y: %5d    Buttons: %5d\n", joya.x, joya.y, joya.buttons);
    }
    if (joyb_found)
    {
      wreadjoystick (&joyb);
      printf ("Joystick B       x: %5d    y: %5d    Buttons: %5d\n", joyb.x, joyb.y, joyb.buttons);
    }
  }
  getch ();
}