/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 38                        
                                                                            
 Uses the 3D library to create a rotating sphere of points.                 
                                                                            
  PROJECT                                                             
 This program requires the WGT4.LIB and WGT3D.LIB files to be linked.       
                                                                            
  DATA FILES                                                          
 None.                                                                      
                                                                            
ͼ
*/

#include <stdlib.h>
#include <math.h>
#include <wgt4.h>
#include <wgt3d.h>

#define ZRAD 150        /* Radius of the circle in each direction. */   
#define XRAD 150        /* Change these to make ellipsoids. */
#define YRAD 150

#define MAXPOINT 600

color pal[256];

point3d pts[MAXPOINT];
point3d drawpts[MAXPOINT];
int maxpt;
int oldmode;

int xdir=1,ydir=1,zdir=1;
int xpos=0,ypos=0,zpos=0;

void set_pal (void)
{
int i;

 wsetrgb (0, 0, 0, 0, pal);

 for (i = 0; i <  64; i++)
  {
   wsetrgb(i+1, 0, i, 63, pal);
   wsetrgb(i+65, 0, i, 63, pal);
  }
 wsetpalette (0, 255, pal);
 
}


void create_object (void)
{
int x, y, z;
int pt;

 pt = 0;

 /* Creates one half of the sphere. */
 for (z = 5; z <= 49; z += 7)
   for (x = 0; x <= 360; x += 36)
       {
        pts[pt].z = ZRAD * sin(3.1415*((double)(z*1.8)/180.0));
        pts[pt].x = XRAD * sin(3.1415*((double)(z*1.8+90)/180.0)) * cos(3.1415*((double)x/180.0));
        pts[pt].y = YRAD * sin(3.1415*((double)(z*1.8+90)/180.0)) * sin(3.1415*((double)x/180.0));
        pt++;
        if (pt > MAXPOINT-1)    /* Make sure we don't overflow the array */
           pt = MAXPOINT-1;
       }

 /* Creates other half of the sphere. */
 for (z = 49; z <= 105; z += 7)
   for (x = 0; x <= 360; x += 36)
       {
        pts[pt].z = ZRAD - ZRAD * sin(3.1415*((double)(z*1.8)/180.0))-ZRAD;
        pts[pt].x = XRAD * sin(3.1415*((double)(z*1.8+90)/180.0)) * cos(3.1415*((double)x/180.0));
        pts[pt].y = YRAD * sin(3.1415*((double)(z*1.8+90)/180.0)) * sin(3.1415*((double)x/180.0));
        pt++;
        if (pt > MAXPOINT-1)    /* Make sure we don't overflow the array */
           pt = MAXPOINT-1;
       }
maxpt = pt;
}


void bounce_object(void)
{
xpos+=xdir;
ypos+=ydir;
zpos+=zdir;

if (xpos>400) 
    xdir=-(random(12)+5);
else if (xpos<-400) 
    xdir=random(12)+5;

if (ypos>200) 
    ydir=-(random(12)+5);
else if (ypos<-200)
    ydir=random(12)+5;

if (zpos>-100)
    zdir=-(random(12)+5);
else if (zpos<-900)
    zdir=random(12)+5;

move_x=xpos;
move_y=ypos;
move_z=zpos;
}


void spin_object (void)
{
int x=0,y=0,z=0;
int xdir=0, ydir=0, zdir=0;
int ctr;
int drawpixel = 1;
unsigned char col;
int i;

int ox,oy;

 wrotatepoints(pts, drawpts, maxpt);
 /* Rotate the points once for initial positions to erase */

 ctr = 0;
 origin_z += 100;

 do 
  {
  bounce_object();
  if (ctr <= 0)
   {
    ctr = 300;
    xdir = random(8)-4;
    ydir = random(8)-4;
    zdir = random(8)-4;
   }

  x += xdir;
  if (x>359) x-=360;
  else if (x<0) x+=360;

  y += ydir;
  if (y>359) y-=360;
  else if (y<0) y+=360;

  z += zdir;
  if (z>359) z-=360;
  else if (z<0) z+=360;

  wsetrotation(x,y,z);

  /* Loop through all points.  We rotate, erase, and draw each point
     individually. */
     
  for (i = 0; i < maxpt; i++)
   {
    ox = drawpts[i].x;  /* Old placement */
    oy = drawpts[i].y;
    wsetcolor(0);
    col = wgetpixel(ox,oy);    
    if (!((col > drawpixel*64) && (col < drawpixel*64+64)))
       wputpixel(ox,oy);
    /* Erase the pixel if it was from the last frame */
    /* We use drawpixel to tell which frame it was from.
       drawpixel alternates from 0 to 1.  0 uses color 0-63.
       1 uses colors 64 - 127.  This way we can tell if the pixel was
       from the previous frame and erase it. */

    wrotatepoints(&pts[i], &drawpts[i], 1);
    /* Rotate one point */

    wsetcolor(drawpts[i].y/4 + drawpixel*64+1);
    /* Changes color depending on y coordinate */
    wputpixel(drawpts[i].x,drawpts[i].y);

   }

  drawpixel++;
  if (drawpixel > 1)
    drawpixel = 0;
  ctr --;
  } while (!kbhit());
}


void main(void)
{
     
 oldmode = wgetmode ();
 vga256 ();
 winit3d ();
 randomize();

 set_pal ();
 create_object ();
 spin_object ();

 wsetmode (oldmode);
}

