/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 28                        
                                                                            
  Shows wpan.                                                               
  Since 320x200x256 doesn't support multiple pages, the vertical            
  lines you might see when the screen scrolls down is just what is          
  in memory after the VGA screen buffer. Do not be alarmed.		     
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <conio.h>
#include <wgt4.h>

void main(void)
{
  int i;
  int oldmode;

  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }

  oldmode = wgetmode();		/* Gets the current mode */
  vga256();			/* Initialize graphics mode */

  for (i=1; i<200; i++)		/* Draw a background for screen */
  {
    wsetcolor(i);
    wline(0,0,319,i);
    wsetcolor(200-i);
    wline(319,199,0,i);
  }

  do
  {
    for (i=0; i<100; i++)	/* Pan down a row at a time */
    {
      wpan(i*320);
      delay(20);
    }
    for (i=0; i<50; i++)	/* Make the screen shake */
    {
      wpan(rand() % 10);
      delay(40);
    }
  } while (!kbhit());

  getch();
  wsetmode(oldmode);		/* Restore initial video mode */
}